/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;

public class ConnectionPropertyUtilities {
    private static final String PROPERTIES_FILE_NAME_DIR = "rolap.cube.properties.file.dir";
    private static File propertiesFileDir;
    private static final String PROPERTIES_FILE_NAME_GLOBAL = "global.properties";
    private static final String PROPERTIES_FILE_NAME_LOCAL = "local.properties";
    public static final String PROPERTY_SCHEMA = "schema";
    public static final String PROPERTY_DRIVER = "driver";
    public static final String PROPERTY_URL = "url";
    public static final String PROPERTY_USER = "user";
    public static final String PROPERTY_PASSWORD = "password";
    public static final String DOT = ".";
    private static Properties properties;

    public static String getPropertyValue(String cubeName, String propertyName) throws IOException {
        if (properties == null) {
            ConnectionPropertyUtilities.setUpProperties();
        }
        String value = properties.getProperty(cubeName.toLowerCase() + DOT + propertyName);
        return value;
    }

    private static synchronized void setUpProperties() throws IOException {
        if (properties == null) {
            Properties props = new Properties();
            String propertiesFileDirPath = propertiesFileDir.getCanonicalPath() + File.separator;
            File propertiesFile = new File(propertiesFileDirPath + PROPERTIES_FILE_NAME_GLOBAL);
            props.load(new FileInputStream(propertiesFile));
            propertiesFile = new File(propertiesFileDirPath + PROPERTIES_FILE_NAME_LOCAL);
            if (propertiesFile.exists()) {
                props.load(new FileInputStream(propertiesFile));
            }
            properties = props;
        }
    }

    static {
        String propertiesFileDirStr = System.getProperty(PROPERTIES_FILE_NAME_DIR);
        propertiesFileDir = propertiesFileDirStr != null ? new File(propertiesFileDirStr) : new File("../configuration/xqe/rolap/");
        properties = null;
    }
}

