/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.util;

import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class CopyOnWriteIntegerSet
implements Cloneable {
    private int[] data = new int[0];

    public int[] getData() {
        return this.data;
    }

    public void add(int element) {
        this.updateAndInsert(0, element);
    }

    private void updateAndInsert(int startIndex, int newElement) {
        int oldInsertIndex = Arrays.binarySearch(this.data, newElement);
        if (oldInsertIndex < 0) {
            int len = this.data.length - startIndex;
            int[] newData = new int[len + 1];
            oldInsertIndex = -oldInsertIndex - 1;
            int newInsertIndex = oldInsertIndex - startIndex;
            System.arraycopy(this.data, startIndex, newData, 0, newInsertIndex);
            newData[newInsertIndex] = newElement;
            System.arraycopy(this.data, oldInsertIndex, newData, newInsertIndex + 1, this.data.length - oldInsertIndex);
            this.data = newData;
        } else if (startIndex > 0) {
            int len = this.data.length - startIndex;
            int[] newData = new int[len];
            System.arraycopy(this.data, startIndex, newData, 0, len);
            this.data = newData;
        }
    }

    public void remove(int element) {
        int len = this.data.length;
        int elementCount = 0;
        for (int i = 0; i < len; ++i) {
            if (this.data[i] != element) continue;
            ++elementCount;
        }
        int[] newData = null;
        if (elementCount > 0) {
            newData = new int[len - elementCount];
            int j = 0;
            for (int i = 0; i < len; ++i) {
                if (this.data[i] == element) continue;
                newData[j] = this.data[i];
                ++j;
            }
        }
        this.data = newData;
    }

    public void clean(int earliestElementToKeep) {
        int[] newData;
        int startIndex = Arrays.binarySearch(this.data, earliestElementToKeep);
        if (-startIndex > this.data.length) {
            newData = new int[]{};
        } else {
            if (startIndex < 0) {
                startIndex = 0;
            }
            int len = this.data.length - startIndex;
            newData = new int[len];
            System.arraycopy(this.data, startIndex, newData, 0, len);
        }
        this.data = newData;
    }

    public void update(int earliestElementToKeep, int newElement) {
        int startIndex = Arrays.binarySearch(this.data, earliestElementToKeep);
        if (-startIndex > this.data.length) {
            int[] newData = new int[]{newElement};
            this.data = newData;
        } else {
            if (startIndex < 0) {
                startIndex = 0;
            }
            this.updateAndInsert(startIndex, newElement);
        }
    }

    public Object copy() {
        return new CopyOnWriteIntegerSet(this.getData(), false);
    }

    public CopyOnWriteIntegerSet() {
    }

    public CopyOnWriteIntegerSet(int[] items, boolean sort) {
        if (sort) {
            Arrays.sort(items);
        }
        this.data = items;
    }

    public static CopyOnWriteIntegerSet fromArrays(int[][] inputs, boolean sort) {
        int[] indexes = new int[inputs.length];
        int[] lengths = new int[inputs.length];
        int outSize = 0;
        for (int i = 0; i < inputs.length; ++i) {
            outSize += inputs[i].length;
            lengths[i] = inputs[i].length;
            if (!sort) continue;
            Arrays.sort(inputs[i]);
        }
        int[] output = new int[outSize];
        int outIdx = 0;
        int duplicates = 0;
        while (outIdx + duplicates < outSize) {
            int leastValue = Integer.MAX_VALUE;
            int leastValueArrayIdx = -1;
            for (int i = 0; i < inputs.length; ++i) {
                int v;
                if (indexes[i] >= lengths[i] || (v = inputs[i][indexes[i]]) >= leastValue) continue;
                leastValue = v;
                leastValueArrayIdx = i;
            }
            if (outIdx > 0 && output[outIdx - 1] == leastValue) {
                ++duplicates;
            } else {
                output[outIdx] = leastValue;
                ++outIdx;
            }
            int n = leastValueArrayIdx;
            indexes[n] = indexes[n] + 1;
        }
        if (duplicates > 0) {
            int[] current = output;
            output = new int[outIdx];
            for (int i = 0; i < outIdx; ++i) {
                output[i] = current[i];
            }
        }
        return new CopyOnWriteIntegerSet(output, false);
    }

    public CopyOnWriteIntegerSet union2(CopyOnWriteIntegerSet subject) {
        int[] data1 = this.getData();
        int[] data2 = subject.getData();
        int[][] input = new int[][]{data1, data2};
        return CopyOnWriteIntegerSet.fromArrays(input, false);
    }

    public CopyOnWriteIntegerSet union(CopyOnWriteIntegerSet subject) {
        int i1 = 0;
        int i2 = 0;
        int outIndex = 0;
        int[] data1 = this.getData();
        int[] data2 = subject.getData();
        int maxSize = data1.length + data2.length;
        int[] out = new int[maxSize];
        while (i1 < data1.length || i2 < data2.length) {
            if (i1 == data1.length) {
                out[outIndex] = data2[i2];
                ++outIndex;
                ++i2;
                continue;
            }
            if (i2 == data2.length) {
                out[outIndex] = data1[i1];
                ++outIndex;
                ++i1;
                continue;
            }
            if (data1[i1] == data2[i2]) {
                int value = data1[i1];
                while (i1 < data1.length && data1[i1] == value) {
                    ++i1;
                }
                while (i2 < data2.length && data2[i2] == value) {
                    ++i2;
                }
                out[outIndex] = value;
                ++outIndex;
                continue;
            }
            if (data1[i1] > data2[i2]) {
                out[outIndex] = data2[i2];
                ++outIndex;
                ++i2;
                continue;
            }
            out[outIndex] = data1[i1];
            ++outIndex;
            ++i1;
        }
        int[] result = new int[outIndex];
        for (int i = 0; i < result.length; ++i) {
            result[i] = out[i];
        }
        return new CopyOnWriteIntegerSet(result, false);
    }

    public final CopyOnWriteIntegerSet intersect(CopyOnWriteIntegerSet subject) {
        int i1 = 0;
        int i2 = 0;
        int outIndex = 0;
        int[] data1 = this.getData();
        int[] data2 = subject.getData();
        int d1Len = data1.length;
        int d2Len = data2.length;
        if (d1Len == 0 || d2Len == 0 || data1[d1Len - 1] < data2[0] || data2[d2Len - 1] < data1[0]) {
            return new CopyOnWriteIntegerSet(new int[0], false);
        }
        int maxSize = d1Len;
        if (d2Len < maxSize) {
            maxSize = d2Len;
        }
        int[] out = new int[maxSize];
        while (i1 < d1Len && i2 < d2Len) {
            if (data1[i1] == data2[i2]) {
                out[outIndex++] = this.data[i1++];
                ++i2;
                continue;
            }
            if (data1[i1] > data2[i2]) {
                ++i2;
                continue;
            }
            ++i1;
        }
        int[] result = new int[outIndex];
        for (int i = 0; i < result.length; ++i) {
            result[i] = out[i];
        }
        return new CopyOnWriteIntegerSet(result, false);
    }

    public int size() {
        return this.data.length;
    }

    public Iterator<Integer> iterator() {
        return new Iterator<Integer>(){
            private final int[] snapshot;
            private int cursor;
            {
                this.snapshot = CopyOnWriteIntegerSet.this.getData();
                this.cursor = 0;
            }

            @Override
            public boolean hasNext() {
                return this.cursor < this.snapshot.length;
            }

            @Override
            public Integer next() {
                try {
                    return new Integer(this.snapshot[this.cursor++]);
                }
                catch (IndexOutOfBoundsException ex) {
                    throw new NoSuchElementException();
                }
            }

            @Override
            public void remove() {
            }
        };
    }

    public String toString() {
        String result = "IntegerSet (";
        int[] thisData = this.getData();
        for (int i = 0; i < thisData.length; ++i) {
            int v = thisData[i];
            result = result + v;
            if (i >= thisData.length - 1) continue;
            result = result + ",";
        }
        result = result + ")";
        return result;
    }
}

