/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.util;

import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.util.pool.XQEBigIntegerPool;
import com.cognos.xqe.util.pool.XQELongPool;
import java.math.BigInteger;

public class NumberOp {
    public static final BigInteger LONG_MAX_VALUE_AS_BIGINT = BigInteger.valueOf(Long.MAX_VALUE);
    public static final int LONG_MAX_VALUE_BITLENGTH = 63;
    public static final long NEGATIVE_ORDINAL = Long.MIN_VALUE;
    private static final String OVERFLOW_MSG = "Long operation overflow: ";

    public static long noOverflowMultiply(long a, long b) throws XQERuntimeException {
        if (b == 0L || a <= Long.MAX_VALUE / b) {
            return a * b;
        }
        throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, OVERFLOW_MSG + a + " * " + b);
    }

    public static long multiplyQuantities(long a, long b) {
        if (b == 0L || a <= Long.MAX_VALUE / b) {
            return a * b;
        }
        return Long.MIN_VALUE;
    }

    public static Number convertNumberToLong(Number n) {
        if (n instanceof Long) {
            return n;
        }
        if (((BigInteger)n).compareTo(LONG_MAX_VALUE_AS_BIGINT) < 0) {
            return XQELongPool.getLong(n.longValue());
        }
        return n;
    }

    public static long addQuantities(long a, long b) {
        if (a < 0L || b < 0L) {
            return Long.MIN_VALUE;
        }
        if (a <= Long.MAX_VALUE - b) {
            return a + b;
        }
        return Long.MIN_VALUE;
    }

    public static Number multiply(Number a, Number b) {
        boolean aLong = false;
        boolean bLong = false;
        if (a instanceof Long) {
            aLong = true;
        }
        if (b instanceof Long) {
            bLong = true;
        }
        if (aLong && bLong) {
            return NumberOp.multiply(a.longValue(), b.longValue());
        }
        BigInteger result = null;
        result = aLong ? ((BigInteger)b).multiply(BigInteger.valueOf((Long)a)) : (bLong ? ((BigInteger)a).multiply(BigInteger.valueOf((Long)b)) : ((BigInteger)a).multiply((BigInteger)b));
        if (result.bitLength() <= 63) {
            return XQELongPool.getLong(result.longValue());
        }
        return result;
    }

    public static Number multiply(long a, long b) {
        long result = NumberOp.multiplyQuantities(a, b);
        if (result >= 0L) {
            return XQELongPool.getLong(result);
        }
        return BigInteger.valueOf(a).multiply(BigInteger.valueOf(b));
    }

    public static Number add(Number a, Number b) {
        boolean aLong = false;
        boolean bLong = false;
        if (a instanceof Long) {
            aLong = true;
        }
        if (b instanceof Long) {
            bLong = true;
        }
        if (aLong && bLong) {
            return NumberOp.add(a.longValue(), b.longValue());
        }
        BigInteger result = null;
        result = aLong ? ((BigInteger)b).add(BigInteger.valueOf((Long)a)) : (bLong ? ((BigInteger)a).add(BigInteger.valueOf((Long)b)) : ((BigInteger)a).add((BigInteger)b));
        if (result.bitLength() <= 63) {
            return XQELongPool.getLong(result.longValue());
        }
        return result;
    }

    public static Number add(long a, long b) {
        long result = NumberOp.addQuantities(a, b);
        if (result >= 0L) {
            return XQELongPool.getLong(result);
        }
        if (a < 0L && b > 0L || a > 0L && b < 0L) {
            return XQELongPool.getLong(a + b);
        }
        return BigInteger.valueOf(a).add(BigInteger.valueOf(b));
    }

    public static Number divide(Number a, Number b) {
        boolean aLong = false;
        boolean bLong = false;
        if (a instanceof Long) {
            aLong = true;
        }
        if (b instanceof Long) {
            bLong = true;
        }
        if (aLong && bLong) {
            return XQELongPool.getLong(a.longValue() / b.longValue());
        }
        BigInteger result = null;
        result = aLong ? BigInteger.valueOf(a.longValue()).divide((BigInteger)b) : (bLong ? ((BigInteger)a).divide(BigInteger.valueOf(b.longValue())) : ((BigInteger)a).divide((BigInteger)b));
        if (result.bitLength() <= 63) {
            return XQELongPool.getLong(result.longValue());
        }
        return result;
    }

    public static Number divide(long a, long b) {
        return XQELongPool.getLong(a / b);
    }

    public static Number mod(long a, long b) {
        return XQELongPool.getLong(a % b);
    }

    public static Number mod(Number a, Number b) {
        boolean aLong = false;
        boolean bLong = false;
        if (a instanceof Long) {
            aLong = true;
        }
        if (b instanceof Long) {
            bLong = true;
        }
        if (aLong && bLong) {
            return XQELongPool.getLong(a.longValue() % b.longValue());
        }
        BigInteger result = null;
        result = aLong ? BigInteger.valueOf(a.longValue()).mod((BigInteger)b) : (bLong ? ((BigInteger)a).mod(BigInteger.valueOf(b.longValue())) : ((BigInteger)a).mod((BigInteger)b));
        if (result.bitLength() <= 63) {
            return XQELongPool.getLong(result.longValue());
        }
        return result;
    }

    public static int compareWithNull(Number a, Number b) {
        if (a == null && b == null) {
            return 0;
        }
        if (a == null) {
            a = XQELongPool.getLong(0L);
        } else if (b == null) {
            b = XQELongPool.getLong(0L);
        }
        return NumberOp.compare(a, b);
    }

    public static int compare(Number a, Number b) {
        boolean aLong = false;
        boolean bLong = false;
        if (a instanceof Long) {
            aLong = true;
        }
        if (b instanceof Long) {
            bLong = true;
        }
        if (aLong && bLong) {
            return ((Long)a).compareTo((Long)b);
        }
        if (aLong) {
            return XQEBigIntegerPool.getBigInteger(a.longValue()).compareTo((BigInteger)b);
        }
        if (bLong) {
            return ((BigInteger)a).compareTo(XQEBigIntegerPool.getBigInteger(b.longValue()));
        }
        return ((BigInteger)a).compareTo((BigInteger)b);
    }

    public static long noOverflowPlus(long a, long b) throws XQERuntimeException {
        if (a <= Long.MAX_VALUE - b) {
            return a + b;
        }
        throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, OVERFLOW_MSG + a + " + " + b);
    }

    public static Number subtract(long a, long b) {
        return XQELongPool.getLong(NumberOp.subtractQuantities(a, b));
    }

    public static Number subtract(Number a, Number b) {
        boolean aLong = false;
        boolean bLong = false;
        if (a instanceof Long) {
            aLong = true;
        }
        if (b instanceof Long) {
            bLong = true;
        }
        if (aLong && bLong) {
            return NumberOp.subtract(a.longValue(), b.longValue());
        }
        BigInteger result = null;
        result = aLong ? BigInteger.valueOf((Long)a).subtract((BigInteger)b) : (bLong ? ((BigInteger)a).subtract(BigInteger.valueOf((Long)b)) : ((BigInteger)a).subtract((BigInteger)b));
        if (result.bitLength() <= 63) {
            return XQELongPool.getLong(result.longValue());
        }
        return result;
    }

    public static long subtractQuantities(long a, long b) {
        if (a < 0L || b < 0L) {
            return Long.MIN_VALUE;
        }
        if (a < b) {
            return Long.MIN_VALUE;
        }
        return a - b;
    }
}

