/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.util;

import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.resultset.interfaces.ISet;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Set;
import com.cognos.xqe.runtree.olap.mdx.util.NumberOp;
import com.cognos.xqe.util.pool.XQEBigIntegerPool;
import com.cognos.xqe.util.pool.XQELongPool;
import com.cognos.xqe.util.primitive.HashMapObjectLong;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;

public class OrdinalMath {
    private static final String FIRST_ARGUMENT_MUST_BE_GREATER_THAN_THE_SECOND = " First argument must be greater than the second.";
    private static final String INVALID_ARGUMENTS_TO_SUBTRACT = "Invalid arguments to subtract(";
    private static final String END_PAREN_PERIOD = ").";
    private static final String COMMA_SPACE = ", ";
    private static final int SURROGATE_MAP_NULL_VALUE = Integer.MAX_VALUE;
    private List<BigInteger> bigIntegerSurrogates = new ArrayList<BigInteger>();
    private HashMapObjectLong<BigInteger> bigIntegerToSurrogateIdMap = new HashMapObjectLong(Integer.MAX_VALUE);
    private static final long MAX_INDEX = 0x7FFFFFFEL;
    private static final long MIN_SURROGATE_ID = OrdinalMath.getSurrogateId(0x7FFFFFFEL);

    public static boolean isSurrogateId(long surrogateId, boolean acceptNegatives) {
        if (surrogateId >= 0L) {
            return false;
        }
        if (surrogateId >= MIN_SURROGATE_ID) {
            return true;
        }
        if (!acceptNegatives) {
            throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "Negative number is not a valid surrogateId: " + surrogateId);
        }
        return false;
    }

    public static boolean isSurrogateId(long surrogateId) {
        return OrdinalMath.isSurrogateId(surrogateId, false);
    }

    public BigInteger getBigInteger(long surrogateId) {
        return this.getBigIntegerImpl(surrogateId, OrdinalMath.getIndex(surrogateId, true));
    }

    private BigInteger getBigInteger(long surrogateId, boolean isValidSurrogateId) {
        if (isValidSurrogateId) {
            long index = OrdinalMath.getIndex(surrogateId, false);
            return this.getBigIntegerImpl(surrogateId, index);
        }
        return this.getBigIntegerImpl(surrogateId, Long.MIN_VALUE);
    }

    private BigInteger getBigIntegerImpl(long surrogateId, long index) {
        if (index == Long.MIN_VALUE) {
            return XQEBigIntegerPool.getBigInteger(surrogateId);
        }
        BigInteger bigInt = this.bigIntegerSurrogates.get((int)index);
        return bigInt;
    }

    private static long getSurrogateId(long index) {
        return -1L - index;
    }

    private static long getIndex(long surrogateId, boolean checkSurrogateIdValidity) {
        if (!checkSurrogateIdValidity || OrdinalMath.isSurrogateId(surrogateId)) {
            long lIndex = -1L - surrogateId;
            return (int)lIndex;
        }
        return Long.MIN_VALUE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long createSurrogateId(BigInteger value) {
        long theSurrogateId;
        List<BigInteger> list = this.bigIntegerSurrogates;
        synchronized (list) {
            long surrogateId = this.bigIntegerToSurrogateIdMap.get(value);
            if (surrogateId != Integer.MAX_VALUE) {
                theSurrogateId = surrogateId;
            } else {
                int size = this.bigIntegerSurrogates.size();
                if (size == Integer.MAX_VALUE) {
                    throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "Reached the maximum number of BigIntegers for this query.");
                }
                theSurrogateId = OrdinalMath.getSurrogateId(size);
                this.bigIntegerSurrogates.add(value);
                this.bigIntegerToSurrogateIdMap.put(value, theSurrogateId);
            }
        }
        return theSurrogateId;
    }

    public long add(long a, long b) {
        long finalResult;
        if (a >= 0L && b >= 0L) {
            if (a <= Long.MAX_VALUE - b) {
                finalResult = a + b;
            } else {
                long surrogateId;
                BigInteger bigResult = BigInteger.valueOf(a).add(BigInteger.valueOf(b));
                finalResult = surrogateId = this.createSurrogateId(bigResult);
            }
        } else {
            long surrogateId;
            boolean aIsValidSurrogateId = OrdinalMath.isSurrogateId(a);
            boolean bIsValidSurrogateId = OrdinalMath.isSurrogateId(b);
            if (a == 0L) {
                return b;
            }
            if (b == 0L) {
                return a;
            }
            BigInteger bigA = this.getBigInteger(a, aIsValidSurrogateId);
            BigInteger bigB = this.getBigInteger(b, bIsValidSurrogateId);
            BigInteger bigResult = bigA.add(bigB);
            finalResult = surrogateId = this.createSurrogateId(bigResult);
        }
        return finalResult;
    }

    public long subtract(long a, long b) {
        long finalResult;
        if (a >= 0L && b >= 0L) {
            if (a < b) {
                throw new IllegalArgumentException(INVALID_ARGUMENTS_TO_SUBTRACT + a + COMMA_SPACE + b + END_PAREN_PERIOD + FIRST_ARGUMENT_MUST_BE_GREATER_THAN_THE_SECOND);
            }
            finalResult = a - b;
        } else {
            long surrogateId;
            BigInteger bigB;
            boolean aIsValidSurrogateId = OrdinalMath.isSurrogateId(a);
            boolean bIsValidSurrogateId = OrdinalMath.isSurrogateId(b);
            if (a == 0L) {
                return b;
            }
            if (b == 0L) {
                return a;
            }
            BigInteger bigA = this.getBigInteger(a, aIsValidSurrogateId);
            if (bigA.compareTo(bigB = this.getBigInteger(b, bIsValidSurrogateId)) < 0) {
                throw new IllegalArgumentException(INVALID_ARGUMENTS_TO_SUBTRACT + bigA + COMMA_SPACE + bigB + END_PAREN_PERIOD + FIRST_ARGUMENT_MUST_BE_GREATER_THAN_THE_SECOND);
            }
            BigInteger bigResult = bigA.subtract(bigB);
            finalResult = bigResult.compareTo(NumberOp.LONG_MAX_VALUE_AS_BIGINT) < 0 ? bigResult.longValue() : (surrogateId = this.createSurrogateId(bigResult));
        }
        return finalResult;
    }

    public int compare(long a, long b) {
        if (a >= 0L && b >= 0L) {
            if (a < b) {
                return -1;
            }
            if (a > b) {
                return 1;
            }
            return 0;
        }
        boolean aIsValidSurrogateId = OrdinalMath.isSurrogateId(a);
        boolean bIsValidSurrogateId = OrdinalMath.isSurrogateId(b);
        BigInteger bigA = this.getBigInteger(a, aIsValidSurrogateId);
        BigInteger bigB = this.getBigInteger(b, bIsValidSurrogateId);
        return bigA.compareTo(bigB);
    }

    public long multiply(long a, long b) {
        long finalResult;
        if (a >= 0L && b >= 0L) {
            if (a == 0L || b == 0L) {
                return 0L;
            }
            if (a <= Long.MAX_VALUE / b) {
                finalResult = a * b;
            } else {
                long surrogateId;
                BigInteger bigResult = BigInteger.valueOf(a).multiply(BigInteger.valueOf(b));
                finalResult = surrogateId = this.createSurrogateId(bigResult);
            }
        } else {
            long surrogateId;
            boolean aIsValidSurrogateId = OrdinalMath.isSurrogateId(a);
            boolean bIsValidSurrogateId = OrdinalMath.isSurrogateId(b);
            if (a == 1L) {
                return b;
            }
            if (b == 1L) {
                return a;
            }
            if (a == 0L || b == 0L) {
                return 0L;
            }
            BigInteger bigA = this.getBigInteger(a, aIsValidSurrogateId);
            BigInteger bigB = this.getBigInteger(b, bIsValidSurrogateId);
            BigInteger bigResult = bigA.multiply(bigB);
            finalResult = surrogateId = this.createSurrogateId(bigResult);
        }
        return finalResult;
    }

    public long divide(long a, long b) {
        long finalResult;
        if (a >= 0L && b >= 0L) {
            finalResult = a / b;
        } else {
            long surrogateId;
            BigInteger bigB;
            boolean aIsValidSurrogateId = OrdinalMath.isSurrogateId(a);
            boolean bIsValidSurrogateId = OrdinalMath.isSurrogateId(b);
            if (a == 0L && b != 0L) {
                return 0L;
            }
            if (b == 1L) {
                return a;
            }
            BigInteger bigA = this.getBigInteger(a, aIsValidSurrogateId);
            BigInteger bigResult = bigA.divide(bigB = this.getBigInteger(b, bIsValidSurrogateId));
            finalResult = bigResult.compareTo(NumberOp.LONG_MAX_VALUE_AS_BIGINT) <= 0 ? bigResult.longValue() : (surrogateId = this.createSurrogateId(bigResult));
        }
        return finalResult;
    }

    public long mod(long a, long b) {
        long finalResult;
        if (a >= 0L && b >= 0L) {
            finalResult = a % b;
        } else {
            long surrogateId;
            BigInteger bigB;
            boolean aIsValidSurrogateId = OrdinalMath.isSurrogateId(a);
            boolean bIsValidSurrogateId = OrdinalMath.isSurrogateId(b);
            if (a == 0L && b != 0L) {
                return 0L;
            }
            if (b == 1L) {
                return 0L;
            }
            BigInteger bigA = this.getBigInteger(a, aIsValidSurrogateId);
            BigInteger bigResult = bigA.mod(bigB = this.getBigInteger(b, bIsValidSurrogateId));
            finalResult = bigResult.compareTo(NumberOp.LONG_MAX_VALUE_AS_BIGINT) <= 0 ? bigResult.longValue() : (surrogateId = this.createSurrogateId(bigResult));
        }
        return finalResult;
    }

    public Number getNumber(long value) {
        if (value >= 0L) {
            return XQELongPool.getLong(value);
        }
        if (OrdinalMath.isSurrogateId(value, true)) {
            return this.getBigInteger(value, true);
        }
        if (value == Long.MIN_VALUE) {
            return XQELongPool.MIN_VALUE;
        }
        return value;
    }

    private long populateSetInfo(ISet[] sets, long[] setSizes, long[] setWeights) {
        if (sets.length == 0) {
            return 0L;
        }
        long setWeight = 1L;
        for (int i = sets.length - 1; i >= 0; --i) {
            setWeights[i] = setWeight;
            setSizes[i] = sets[i].size();
            if (setSizes[i] < 0L) {
                setSizes[i] = this.createSurrogateId(((Set)sets[i]).noOverflowSize());
            }
            setWeight = this.multiply(setWeights[i], setSizes[i]);
        }
        return setWeight;
    }

    private long populateSetInfo(ArrayList<Set> sets, long[] setSizes, long[] setWeights) {
        if (sets.size() == 0) {
            return 0L;
        }
        long setWeight = 1L;
        for (int i = sets.size() - 1; i >= 0; --i) {
            setWeights[i] = setWeight;
            setSizes[i] = sets.get(i).size();
            if (setSizes[i] < 0L) {
                setSizes[i] = this.createSurrogateId(sets.get(i).noOverflowSize());
            }
            setWeight = this.multiply(setWeights[i], setSizes[i]);
        }
        return setWeight;
    }

    public SetArrayInfo getSetArrayInfo(ISet[] sets) {
        return new SetArrayInfo(sets);
    }

    public SetArrayInfo getSetArrayInfo(ArrayList<Set> sets) {
        return new SetArrayInfo(sets);
    }

    private long getBlockOrdinalOverflow(long[] setOrdinals, long[] setSizes, long[] setWeights) {
        long runningBlockOrd = 0L;
        for (int i = setSizes.length - 1; i >= 0; --i) {
            long mult = this.multiply(setWeights[i], setOrdinals[i]);
            runningBlockOrd = this.add(runningBlockOrd, mult);
        }
        return runningBlockOrd;
    }

    private long getBlockOrdinalUnderflow(long[] setOrdinals, long[] setSizes, long[] setWeights) {
        long runningBlockOrd = 0L;
        for (int i = setSizes.length - 1; i >= 0; --i) {
            long mult = setWeights[i] * setOrdinals[i];
            runningBlockOrd += mult;
        }
        return runningBlockOrd;
    }

    private long getBlockOrdinal(long[] setOrdinals, long[] setSizes, long[] setWeights, long totalSize) {
        if (OrdinalMath.isSurrogateId(totalSize)) {
            return this.getBlockOrdinalOverflow(setOrdinals, setSizes, setWeights);
        }
        return this.getBlockOrdinalUnderflow(setOrdinals, setSizes, setWeights);
    }

    public long getBlockOrdinal(long[] setOrdinals, SetArrayInfo setArrayInfo) {
        return this.getBlockOrdinal(setOrdinals, setArrayInfo.getSizes(), setArrayInfo.getWeights(), setArrayInfo.getSize());
    }

    private long[] getSetOrdinals(long blockOrdinal, long[] setSizes, long[] setWeights, long totalSize) {
        if (OrdinalMath.isSurrogateId(totalSize)) {
            return this.getSetOrdinalsOverflow(blockOrdinal, setSizes, setWeights);
        }
        return this.getSetOrdinalsUnderflow(blockOrdinal, setSizes, setWeights);
    }

    public long[] getSetOrdinals(long blockOrdinal, SetArrayInfo setArrayInfo) {
        return this.getSetOrdinals(blockOrdinal, setArrayInfo.getSizes(), setArrayInfo.getWeights(), setArrayInfo.getSize());
    }

    private long[] getSetOrdinalsOverflow(long blockOrdinal, long[] setSizes, long[] setWeights) {
        long[] setOrd = new long[setSizes.length];
        for (int i = setSizes.length - 1; i >= 0; --i) {
            long div = this.divide(blockOrdinal, setWeights[i]);
            setOrd[i] = this.mod(div, setSizes[i]);
        }
        return setOrd;
    }

    private long[] getSetOrdinalsUnderflow(long blockOrdinal, long[] setSizes, long[] setWeights) {
        long[] setOrd = new long[setSizes.length];
        for (int i = setSizes.length - 1; i >= 0; --i) {
            long div = blockOrdinal / setWeights[i];
            setOrd[i] = div % setSizes[i];
        }
        return setOrd;
    }

    public class SetArrayInfo {
        private final long[] setSizes;
        private final long[] setWeights;
        private final long setSize;

        public SetArrayInfo(ISet[] theSets) {
            this.setSizes = new long[theSets.length];
            this.setWeights = new long[theSets.length];
            this.setSize = OrdinalMath.this.populateSetInfo(theSets, this.setSizes, this.setWeights);
        }

        public SetArrayInfo(ArrayList<Set> theSets) {
            this.setSizes = new long[theSets.size()];
            this.setWeights = new long[theSets.size()];
            this.setSize = OrdinalMath.this.populateSetInfo(theSets, this.setSizes, this.setWeights);
        }

        public long[] getSizes() {
            return this.setSizes;
        }

        public long[] getWeights() {
            return this.setWeights;
        }

        public long getSize() {
            return this.setSize;
        }

        public long getSize(int index) {
            return this.setSizes[index];
        }

        public long getWeight(int index) {
            return this.setWeights[index];
        }

        public int getLength() {
            return this.setWeights.length;
        }
    }
}

