/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.util;

import java.util.Arrays;
import java.util.Iterator;

public class QuickIntersectSet {
    private int[] data;
    private int[] pending;
    private int pendingCount;
    private boolean needSort;
    private static final int INITIAL_SET_SIZE = 100;

    public QuickIntersectSet(int[] items) {
        Arrays.sort(items);
        this.pendingCount = 0;
        this.needSort = false;
        this.pending = null;
        this.data = items;
    }

    public int[] getData() {
        this.addPending();
        if (this.needSort) {
            Arrays.sort(this.data);
            this.needSort = false;
        }
        return this.data;
    }

    public QuickIntersectSet(int[] items, boolean sortIt) {
        this.pendingCount = 0;
        this.needSort = false;
        if (sortIt) {
            Arrays.sort(items);
        }
        this.data = items;
    }

    public QuickIntersectSet() {
        this.data = null;
        this.pending = null;
        this.pendingCount = 0;
    }

    public void add(int i) {
        this.needSort = true;
        if (this.pending == null) {
            this.pending = new int[100];
        }
        this.pending[this.pendingCount] = i;
        ++this.pendingCount;
        if (this.pendingCount == this.pending.length) {
            this.addPending();
        }
    }

    private void addPending() {
        if (this.pending != null && this.pendingCount > 0) {
            int currentDataSize = 0;
            if (this.data != null && this.data.length > 0) {
                currentDataSize = this.data.length;
            }
            int[] temp = new int[this.pendingCount + currentDataSize];
            for (int i = 0; i < currentDataSize; ++i) {
                temp[i] = this.data[i];
            }
            int count = 0;
            for (int j = currentDataSize; j < temp.length; ++j) {
                temp[j] = this.pending[count];
                ++count;
            }
            this.data = temp;
            if (this.pendingCount != 100) {
                this.pending = null;
                Arrays.sort(this.data);
                this.needSort = false;
            }
            this.pendingCount = 0;
        }
    }

    public QuickIntersectSet intersect(QuickIntersectSet subject) {
        if (this.pending != null && this.pendingCount > 0) {
            this.addPending();
        }
        if (this.needSort) {
            Arrays.sort(this.data);
            this.needSort = false;
        }
        int i1 = 0;
        int i2 = 0;
        int outIndex = 0;
        int[] data1 = this.data;
        int[] data2 = subject.getData();
        if (data1 == null || data2 == null || data1.length == 0 || data2.length == 0) {
            return new QuickIntersectSet(new int[0], false);
        }
        int maxSize = data1.length;
        if (data2.length < maxSize) {
            maxSize = data2.length;
        }
        int[] out = new int[maxSize];
        while (i1 < data1.length && i2 < data2.length) {
            if (data1[i1] == data2[i2]) {
                out[outIndex] = this.data[i1];
                ++outIndex;
                ++i1;
                ++i2;
                continue;
            }
            if (data1[i1] > data2[i2]) {
                ++i2;
                continue;
            }
            ++i1;
        }
        int[] result = new int[outIndex];
        for (int i = 0; i < result.length; ++i) {
            result[i] = out[i];
        }
        return new QuickIntersectSet(result, false);
    }

    public int size() {
        if (this.pendingCount > 0) {
            this.addPending();
        }
        if (this.data != null) {
            return this.data.length;
        }
        return 0;
    }

    public Iterator<Integer> iterator() {
        if (this.pendingCount > 0) {
            this.addPending();
        }
        return new QuickIntersectSetIterator(this.data);
    }

    class QuickIntersectSetIterator
    implements Iterator<Integer> {
        int idx = 0;
        int[] subject;
        int size;

        QuickIntersectSetIterator(int[] theData) {
            this.subject = theData;
            this.size = theData.length;
        }

        @Override
        public boolean hasNext() {
            return this.idx < this.size;
        }

        @Override
        public Integer next() {
            Integer result = new Integer(this.subject[this.idx]);
            ++this.idx;
            return result;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

