/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.util;

import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.resultset.interfaces.ITuple;
import com.cognos.xqe.runtree.olap.mdx.interpreter.CrossJoinedSet;
import com.cognos.xqe.runtree.olap.mdx.interpreter.InterpreterException;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Set;
import com.cognos.xqe.runtree.olap.mdx.util.SymmetricQueryBuilder;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqe.trace.XQELogger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class SymmetricSubqueryIterator
implements Iterator<CrossJoinedSet> {
    protected static final String NEWLINE = System.getProperty("line.separator");
    public static final String SYMMETRIC_SUBQUERY_ITERATOR = "SymmetricSubqueryIterator";
    List<CrossJoinedSet> cjsList;
    Iterator<CrossJoinedSet> iterator;
    int subsetIndex;
    double excessTupleRatio;
    private boolean bMergeByLevel = false;

    public SymmetricSubqueryIterator(CrossJoinedSet cjs, int minExcessTuplesForSplitQuery, double excessTuplesRatioForSplitQuery, boolean mergeByLevel, StringBuilder strBldr) {
        this.bMergeByLevel = mergeByLevel;
        XQELogger symmetricSubqueryLogger = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", SYMMETRIC_SUBQUERY_ITERATOR, LogLevel.INFO);
        double ratio = -1.0;
        if (minExcessTuplesForSplitQuery >= 0 && excessTuplesRatioForSplitQuery >= 0.0) {
            long requiredTuples = cjs.size();
            long symmetricTuples = 1L;
            IMember[][] members = cjs.getMembers(cjs.getHierarchies());
            for (int i = 0; i < members.length; ++i) {
                symmetricTuples *= (long)members[i].length;
            }
            double cjsRatio = symmetricTuples / requiredTuples;
            if (strBldr != null) {
                strBldr.append("Original CJS | RequiredTuples:" + requiredTuples + " SymmetricTuples: " + symmetricTuples + " ratio: " + cjsRatio).append(NEWLINE);
                symmetricSubqueryLogger.log(strBldr.toString());
            }
            if (symmetricTuples - requiredTuples > (long)minExcessTuplesForSplitQuery && cjsRatio >= excessTuplesRatioForSplitQuery) {
                ratio = cjsRatio;
            } else if (symmetricTuples - requiredTuples > (long)minExcessTuplesForSplitQuery) {
                ratio = 0.0;
            } else if (symmetricTuples < requiredTuples) {
                ratio = 2.0;
            }
        }
        this.cjsList = new ArrayList<CrossJoinedSet>();
        if (ratio > -1.0) {
            this.init(cjs, ratio);
            this.iterator = this.cjsList.iterator();
            this.subsetIndex = 0;
        } else {
            symmetricSubqueryLogger.log("Original CJS is returned");
            this.cjsList.add(cjs);
            this.iterator = this.cjsList.iterator();
            this.subsetIndex = 0;
        }
    }

    private void init(CrossJoinedSet cjSet, double ratio) {
        XQELogger symmetricSubqueryLogger = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", SYMMETRIC_SUBQUERY_ITERATOR, LogLevel.INFO);
        List<Set> symmetricSets = null;
        symmetricSets = cjSet.getTupleList().getSymmetricSets(ratio > 0.0);
        if (symmetricSets == null) {
            symmetricSubqueryLogger.log("Skipping symmetric set creation.");
            this.cjsList.add(cjSet);
            return;
        }
        symmetricSubqueryLogger.log("Found " + symmetricSets.size() + " basic symmetric sets.");
        SymmetricQueryBuilder builder = new SymmetricQueryBuilder(this.isMergeByLevel());
        for (Set set : symmetricSets) {
            builder.addSet(set);
        }
        this.cjsList = builder.getConsolidatedSets(ratio);
        int ten = 10;
        if (ratio == 0.0 && this.cjsList.size() > 10) {
            symmetricSubqueryLogger.log("Ratio for splitting was not met and too many symmetric sets were found (" + this.cjsList.size() + "), reverting back to using just the original set.");
            this.cjsList = new ArrayList<CrossJoinedSet>();
            this.cjsList.add(cjSet);
            return;
        }
        symmetricSubqueryLogger.log("Consolidated sets: " + this.cjsList.size());
    }

    public static boolean isAsymmetric(Set set) {
        IMember[][] members = set.getMembers(set.getHierarchies());
        long size = set.size();
        long symmetricSize = 1L;
        for (int i = 0; i < members.length; ++i) {
            symmetricSize *= (long)members[i].length;
        }
        return symmetricSize > 2L * size;
    }

    public static List<Set> getSymmetricSubsets(Set set, HashSet<IHierarchy> processedDimensions) {
        ArrayList<Set> setList = new ArrayList<Set>();
        HashSet<IHierarchy> processedDims = new HashSet<IHierarchy>(processedDimensions);
        IHierarchy[] dimensions = set.getHierarchies();
        if (processedDims.size() >= dimensions.length - 1) {
            setList.add(set);
            return setList;
        }
        long requiredTuples = set.size();
        long symmetricTuples = 1L;
        IMember[][] membersCard = set.getMembers(set.getHierarchies());
        for (int i = 0; i < membersCard.length; ++i) {
            symmetricTuples *= (long)membersCard[i].length;
        }
        if (symmetricTuples < 2L * requiredTuples) {
            setList.add(set);
            return setList;
        }
        int[] cardinality = new int[membersCard.length];
        for (int i = 0; i < membersCard.length; ++i) {
            cardinality[i] = membersCard[i].length;
        }
        IHierarchy[] dimSorted = new IHierarchy[dimensions.length];
        for (int i = 0; i < dimensions.length; ++i) {
            int maxIndex = SymmetricSubqueryIterator.getMaxIndex(cardinality);
            dimSorted[i] = dimensions[maxIndex];
            cardinality[maxIndex] = -1;
        }
        IMember[][] members = set.getMembers(dimSorted);
        IHierarchy dim = null;
        int index = -1;
        for (int i = 0; i < dimSorted.length; ++i) {
            if (processedDims.contains(dimSorted[i])) continue;
            dim = dimSorted[i];
            index = i;
            break;
        }
        processedDims.add(dim);
        if (members[index].length < 2) {
            setList.add(set);
            return setList;
        }
        HashMap map = new HashMap();
        for (IMember member : members[index]) {
            ArrayList list = new ArrayList();
            map.put(member, list);
        }
        for (ITuple tuple : set.getTupleList()) {
            IMember member = tuple.getMember(dim);
            ((List)map.get(member)).add(tuple);
        }
        HashMap setMap = new HashMap();
        for (Map.Entry entry : map.entrySet()) {
            setMap.put(entry.getKey(), new Set(((List)entry.getValue()).toArray(new ITuple[0])));
        }
        HashSet<IMember> taken = new HashSet<IMember>();
        ArrayList groups = new ArrayList();
        List<IMember> memberList = Arrays.asList(members[index]);
        for (int k = 0; k < memberList.size(); ++k) {
            IMember iMember = memberList.get(k);
            if (taken.contains(iMember)) continue;
            taken.add(iMember);
            HashSet<IMember> memberGroup = new HashSet<IMember>();
            memberGroup.add(iMember);
            groups.add(memberGroup);
            Set memberSet = (Set)((Set)setMap.get(iMember)).removeHierarchy(dim, true);
            for (int j = k + 1; j < memberList.size(); ++j) {
                IMember memberTwo = memberList.get(j);
                if (taken.contains(memberTwo)) continue;
                Set memberTwoSet = (Set)((Set)setMap.get(memberTwo)).removeHierarchy(dim, true);
                try {
                    if (memberSet.size() != memberTwoSet.size() || memberSet.intersect(memberTwoSet, false).size() != memberSet.size()) continue;
                    memberGroup.add(memberTwo);
                    taken.add(memberTwo);
                    continue;
                }
                catch (InterpreterException e) {
                    throw new XQERuntimeException(e);
                }
            }
        }
        for (HashSet hashSet : groups) {
            ArrayList tupleList = new ArrayList();
            for (IMember member : hashSet) {
                tupleList.addAll((Collection)map.get(member));
            }
            setList.addAll(SymmetricSubqueryIterator.getSymmetricSubsets(new Set(tupleList.toArray(new ITuple[0])), processedDims));
        }
        return setList;
    }

    private static int getMaxIndex(int[] cardinality) {
        int maxIndex = -1;
        int maxValue = -1;
        for (int i = 0; i < cardinality.length; ++i) {
            if (cardinality[i] <= maxValue) continue;
            maxValue = cardinality[i];
            maxIndex = i;
        }
        return maxIndex;
    }

    @Override
    public boolean hasNext() {
        return this.iterator.hasNext();
    }

    @Override
    public CrossJoinedSet next() {
        ++this.subsetIndex;
        return this.iterator.next();
    }

    @Override
    public void remove() {
        this.iterator.remove();
    }

    public boolean isMergeByLevel() {
        return this.bMergeByLevel;
    }
}

