/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.util;

import com.cognos.xqe.runtree.olap.mdx.util.UniqueNameParserException;
import java.util.ArrayList;

public class UniqueNameParser {
    private String uniqueName;
    private int pointer;
    private static String ampersandSeparator = "].&[";
    private static String bracketSeparator = "].[";

    public static String parseLastIdentifier(String uniqueName) {
        if (uniqueName == null) {
            return uniqueName;
        }
        int beginIndex = uniqueName.lastIndexOf(ampersandSeparator);
        int lengthSeparator = ampersandSeparator.length();
        if (beginIndex < 0) {
            beginIndex = uniqueName.lastIndexOf(bracketSeparator);
            lengthSeparator = bracketSeparator.length();
        }
        beginIndex = beginIndex < 0 ? ((beginIndex = uniqueName.lastIndexOf("[")) >= 0 ? ++beginIndex : 0) : (beginIndex += lengthSeparator);
        int endIndex = uniqueName.length();
        if (uniqueName.endsWith("]")) {
            --endIndex;
        }
        return uniqueName.substring(beginIndex, endIndex);
    }

    public String[] parse(String theUniqueName) throws UniqueNameParserException {
        StringBuilder str = null;
        this.pointer = 0;
        this.uniqueName = theUniqueName.trim();
        ArrayList<String> names = new ArrayList<String>();
        char ch = this.nextChar();
        if (ch == '\u0000') {
            this.throwException("X01512");
        }
        boolean delimitedIdent = false;
        while (ch != '\u0000') {
            if (str == null) {
                str = new StringBuilder("");
                if (ch == '[') {
                    delimitedIdent = true;
                } else if (ch == '&' && this.peekChar() == '[') {
                    str = null;
                } else {
                    str.append(ch);
                    delimitedIdent = false;
                }
            } else if (ch == ']') {
                if (delimitedIdent) {
                    ch = this.nextChar();
                    if (ch == '\u0000') {
                        names.add(str.toString());
                        str = null;
                        delimitedIdent = false;
                    } else if (ch == ']') {
                        str.append(ch);
                    } else if (ch == '.') {
                        names.add(str.toString());
                        str = null;
                        delimitedIdent = false;
                    } else {
                        this.throwException("X01513", ch);
                    }
                } else {
                    str.append(ch);
                }
            } else if (ch == '.') {
                if (delimitedIdent) {
                    str.append(ch);
                } else {
                    names.add(str.toString());
                    str = null;
                }
            } else {
                str.append(ch);
            }
            if ((ch = this.nextChar()) != '\u0000' || str == null) continue;
            if (delimitedIdent) {
                this.throwException("X01512");
            }
            names.add(str.toString());
            str = null;
            delimitedIdent = false;
        }
        if (str != null) {
            this.throwException("X01512");
        }
        String[] result = names.toArray(new String[0]);
        return result;
    }

    private char nextChar() {
        if (this.pointer == this.uniqueName.length()) {
            return '\u0000';
        }
        return this.uniqueName.charAt(this.pointer++);
    }

    private char peekChar() {
        if (this.pointer == this.uniqueName.length()) {
            return '\u0000';
        }
        return this.uniqueName.charAt(this.pointer);
    }

    private void throwException(String msg) throws UniqueNameParserException {
        this.throwException(msg, 'a');
    }

    private void throwException(String msg, char ch) throws UniqueNameParserException {
        if (msg == "X01513") {
            throw new UniqueNameParserException(msg, new String[]{ch + ""});
        }
        throw new UniqueNameParserException(msg);
    }
}

