/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.util.math;

import com.cognos.xqe.runtree.olap.mdx.util.math.DataPoint;
import com.cognos.xqe.trace.XQEDebugLog;

public class RegressionCalculator {
    private double sumX;
    private double sumY;
    private double sumXX;
    private double sumXY;
    private double a0;
    private double a1;
    private int n;
    private boolean coefsValid;

    public RegressionCalculator(DataPoint[] data) {
        for (int i = 0; i < data.length; ++i) {
            this.addDataPoint(data[i]);
        }
    }

    public int getDataPointCount() {
        return this.n;
    }

    public double getA0() {
        this.validateCoefficients();
        return this.a0;
    }

    public double getA1() {
        this.validateCoefficients();
        return this.a1;
    }

    public double getSumX() {
        return this.sumX;
    }

    public double getSumY() {
        return this.sumY;
    }

    public double getSumXX() {
        return this.sumXX;
    }

    public double getSumXY() {
        return this.sumXY;
    }

    public void addDataPoint(DataPoint dataPoint) {
        XQEDebugLog.out.println("adding dp: " + dataPoint.x + ", " + dataPoint.y);
        this.sumX += dataPoint.x;
        this.sumY += dataPoint.y;
        this.sumXX += dataPoint.x * dataPoint.x;
        this.sumXY += dataPoint.x * dataPoint.y;
        ++this.n;
        this.coefsValid = false;
    }

    public double at(double x) {
        if (this.n < 2) {
            return Double.NaN;
        }
        this.validateCoefficients();
        return this.a0 + this.a1 * x;
    }

    public void reset() {
        this.n = 0;
        this.sumX = 0.0;
        this.sumY = 0.0;
        this.sumXX = 0.0;
        this.sumXY = 0.0;
        this.coefsValid = false;
    }

    private void validateCoefficients() {
        if (this.coefsValid) {
            return;
        }
        if (this.n >= 2) {
            float xBar = (float)this.sumX / (float)this.n;
            float yBar = (float)this.sumY / (float)this.n;
            this.a1 = (float)(((double)this.n * this.sumXY - this.sumX * this.sumY) / ((double)this.n * this.sumXX - this.sumX * this.sumX));
            this.a0 = (float)((double)yBar - this.a1 * (double)xBar);
        } else {
            this.a1 = this.a0 = Double.NaN;
        }
        this.coefsValid = true;
    }
}

