/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.v5provider;

import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.runtree.olap.mdx.v5provider.V5ProviderAggregateCombinationRule;
import com.cognos.xqe.util.ArrayCast;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class V5ProviderSelection {
    protected Object members;

    public V5ProviderSelection(List<IMember> mems) {
        this.members = mems.size() == 1 ? mems.get(0) : mems;
    }

    public V5ProviderSelection(Object mems) {
        this.members = mems instanceof List ? (((List)mems).size() == 1 ? ((List)mems).get(0) : mems) : (IMember)mems;
    }

    public V5ProviderSelection(IMember member) {
        this.members = member;
    }

    int size() {
        if (this.members instanceof List) {
            return ((List)this.members).size();
        }
        if (this.members instanceof IMember) {
            return 1;
        }
        return 0;
    }

    public List<IMember> getMembersList() {
        if (this.members instanceof List) {
            return (List)this.members;
        }
        ArrayList<IMember> memsList = new ArrayList<IMember>(1);
        memsList.add((IMember)this.members);
        return memsList;
    }

    public IMember getFirstMember() {
        if (this.members instanceof List) {
            return (IMember)((List)this.members).get(0);
        }
        return (IMember)this.members;
    }

    Object getMembers() {
        if (this.members instanceof List) {
            return (List)this.members;
        }
        return this.members;
    }

    public String toString() {
        String closingBracket = "]";
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        if (this.members instanceof List) {
            for (Object o : (List)this.members) {
                sb.append(o);
                sb.append(", ");
            }
            sb.deleteCharAt(sb.length() - 1);
            sb.deleteCharAt(sb.length() - 1);
        } else {
            sb.append(this.members);
        }
        sb.append(closingBracket);
        return sb.toString();
    }

    public List<V5ProviderSelection> decomposeSelection() {
        ArrayList<V5ProviderSelection> selections = new ArrayList<V5ProviderSelection>(1);
        selections.add(this);
        return selections;
    }

    public List<V5ProviderSelection> decomposeSelection(V5ProviderAggregateCombinationRule rule) {
        return this.decomposeSelection();
    }

    public List<V5ProviderSelection> decomposeMeasureSelection(V5ProviderAggregateCombinationRule rule) {
        ArrayList<V5ProviderSelection> selection = new ArrayList<V5ProviderSelection>(this.size());
        for (IMember m : this.getMembersList()) {
            if (rule.getMeasure() != m) continue;
            selection.add(new V5ProviderSelection(m));
        }
        return selection;
    }

    public static Collection<IMember>[] getSelectionsFromCombination(List<V5ProviderSelection> selections) {
        Collection[] modifiedSelections = (Collection[])ArrayCast.uncheckedCast(new Collection[selections.size()]);
        int i = 0;
        for (V5ProviderSelection selection : selections) {
            List<IMember> members;
            modifiedSelections[i] = members = selection.getMembersList();
            ++i;
        }
        return modifiedSelections;
    }
}

