/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.v5provider;

import com.cognos.xqe.ast.IXQENodeFactory;
import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.runtree.olap.mdx.v5provider.XProfileInfoCollector;
import com.cognos.xqe.trace.XQETrace;
import java.util.concurrent.atomic.AtomicInteger;

public class XQueryStrategy
extends XProfileInfoCollector {
    private static final long serialVersionUID = 1L;
    private final AtomicInteger invocationCount = new AtomicInteger();
    private XProfileInfoCollector mDataCacheRetrieval;
    private XProfileInfoCollector mAggregateCacheRetrieval;
    private XProfileInfoCollector mAggregateCubeRetrieval;
    private XProfileInfoCollector mCubeRetrieval;

    @Override
    public int getType() {
        return 501149;
    }

    @Override
    public synchronized void begin() {
        XQETrace trace = this.getTrace();
        if (trace != null) {
            this.startTimer(trace);
            switch (this.getMode()) {
                case SERIAL: {
                    this.invocationCount.set(1);
                    break;
                }
                default: {
                    this.invocationCount.incrementAndGet();
                }
            }
        }
    }

    @Override
    public synchronized void end() {
        XQETrace trace = this.getTrace();
        if (trace != null) {
            this.stopTimer(trace);
            switch (this.getMode()) {
                case SERIAL: {
                    this.commitToSeries();
                    break;
                }
            }
        }
    }

    public void notifyOperationStart(Operation op) {
        XProfileInfoCollector node = this.getOpNode(op);
        if (node != null) {
            node.begin();
        }
    }

    public void notifyOperationEnd(Operation op) {
        XProfileInfoCollector node = this.getOpNode(op);
        if (node != null) {
            node.end();
        }
    }

    public void notifyOperationEnd(Operation op, int rowCount) {
        XProfileInfoCollector node = this.getOpNode(op);
        if (node != null) {
            node.end();
            node.setRowCount(rowCount);
        }
    }

    public void addOperation(Operation op, IXQENodeFactory nodeFactory) {
        XProfileInfoCollector node = this.getOpNode(op);
        if (node == null) {
            node = (XProfileInfoCollector)nodeFactory.createNode(this.getOpType(op));
            this.addChild(node);
            switch (op) {
                case DATA_CACHE_RETRIEVAL: {
                    this.mDataCacheRetrieval = node;
                    break;
                }
                case AGGREGATE_CACHE_RETRIEVAL: {
                    this.mAggregateCacheRetrieval = node;
                    break;
                }
                case AGGREGATE_CUBE_RETRIEVAL: {
                    this.mAggregateCubeRetrieval = node;
                    break;
                }
                case CUBE_RETRIEVAL: {
                    this.mCubeRetrieval = node;
                    break;
                }
            }
        }
    }

    private int getOpType(Operation op) {
        int type = -1;
        switch (op) {
            case DATA_CACHE_RETRIEVAL: {
                type = 501150;
                break;
            }
            case AGGREGATE_CACHE_RETRIEVAL: {
                type = 501151;
                break;
            }
            case AGGREGATE_CUBE_RETRIEVAL: {
                type = 501152;
                break;
            }
            case CUBE_RETRIEVAL: {
                type = 501153;
                break;
            }
        }
        return type;
    }

    public XProfileInfoCollector getOpNode(Operation op) {
        XProfileInfoCollector node = null;
        switch (op) {
            case DATA_CACHE_RETRIEVAL: {
                node = this.mDataCacheRetrieval;
                break;
            }
            case AGGREGATE_CACHE_RETRIEVAL: {
                node = this.mAggregateCacheRetrieval;
                break;
            }
            case AGGREGATE_CUBE_RETRIEVAL: {
                node = this.mAggregateCubeRetrieval;
                break;
            }
            case CUBE_RETRIEVAL: {
                node = this.mCubeRetrieval;
                break;
            }
        }
        return node;
    }

    @Override
    protected void commitToSeries() {
        int count = this.getQueryStrategy().getQueryStrategyCount();
        if (count > 0) {
            super.commitToSeries();
            for (IXQEQueryNode node : this.getChildren()) {
                ((XProfileInfoCollector)node).commitToSeries();
            }
        }
        this.invocationCount.set(0);
    }

    @Override
    protected XQueryStrategy getQueryStrategy() {
        return this;
    }

    protected int getQueryStrategyCount() {
        return this.invocationCount.get();
    }

    public static enum Operation {
        DATA_CACHE_RETRIEVAL,
        AGGREGATE_CACHE_RETRIEVAL,
        AGGREGATE_CUBE_RETRIEVAL,
        CUBE_RETRIEVAL;

    }
}

