/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.v5provider.pushdown;

import com.cognos.xqe.bibushandler.datasource.ProviderCapabilites;
import com.cognos.xqe.data.model.IDataSource;
import com.cognos.xqe.data.model.IDataSourceCapabilities;
import com.cognos.xqe.metadata.ILevel;
import com.cognos.xqe.runtree.olap.mdx.interpreter.InterpreterContext;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Set;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.util.AggregationUtils;
import com.cognos.xqe.runtree.olap.mdx.v5provider.pushdown.PushdownManager;
import java.util.HashSet;

public class CalculationPushdownUtility {
    public static final String PARAM_AGGREGATELEVEL = "AggregateLevel";
    public static final String PARAM_AGGREGATESETSIZE = "AggregateSetSize";

    public static boolean configurePushdown(InterpreterContext interpreterContext, Set aggregateSet, int aggregateType) {
        PushdownManager pushdownManager = PushdownManager.getPushdownManager(interpreterContext);
        if (pushdownManager != null) {
            if (CalculationPushdownUtility.isPushdownSupportedByDatasource(interpreterContext)) {
                if (aggregateSet.getTupleList().containsNullMembers() || aggregateSet.getTupleList().containsCalculatedMembers()) {
                    pushdownManager.cancel(interpreterContext, "Calculated Members in context are not supported by filter pushdown.");
                    return false;
                }
                if (aggregateType != 0) {
                    pushdownManager.cancel(interpreterContext, "Aggregate type of the measure in context is not supported by filter pushdown.");
                    return false;
                }
                HashSet<ILevel> aggregateLevel = AggregationUtils.getAggregateLevels(aggregateSet);
                long aggregateSetSize = aggregateSet.size();
                pushdownManager.addPushdownFunction("Aggregate");
                pushdownManager.setParameter("Aggregate", PARAM_AGGREGATELEVEL, aggregateLevel);
                pushdownManager.setParameter("Aggregate", PARAM_AGGREGATESETSIZE, aggregateSetSize);
                return true;
            }
            pushdownManager.cancel(interpreterContext, "Calculated Members in filte pushdown context are not supported.");
            return false;
        }
        return false;
    }

    public static boolean isPushdownSupportedByDatasource(InterpreterContext interpreterContext) {
        IDataSource dataSource = interpreterContext.getXDataContext().getEnvironment().getDataSource();
        if (dataSource == null) {
            return false;
        }
        boolean pushdown = false;
        String key = null;
        if (dataSource.isROLAP()) {
            key = "RO";
        } else if (dataSource.isRelational()) {
            key = "DMR";
        }
        if (key != null) {
            IDataSourceCapabilities providerCapabilities = ProviderCapabilites.getInstance().getOrAddProviderCapabilities(key);
            pushdown = providerCapabilities.isSupported("pushdownCalculationsInFilterPushdownToRelational");
        } else {
            pushdown = dataSource.getCapabilities().getStringValue("pushdownCalculationsInFilterPushdownToRelational", "false").equalsIgnoreCase("true");
        }
        return pushdown;
    }
}

