/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.v5provider.pushdown;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.v5.query.V5DetailFilter;
import com.cognos.xqe.ast.v5.query.V5Query;
import com.cognos.xqe.ast.v5.query.V5Selection;
import com.cognos.xqe.bibushandler.datasource.ProviderCapabilites;
import com.cognos.xqe.data.model.IDataSource;
import com.cognos.xqe.data.model.IDataSourceCapabilities;
import com.cognos.xqe.data.values.BooleanValue;
import com.cognos.xqe.data.values.DataValueFactory;
import com.cognos.xqe.data.values.DoubleValue;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.data.values.NullValue;
import com.cognos.xqe.data.values.NumericValue;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.resultset.interfaces.ITuple;
import com.cognos.xqe.runtree.olap.mdx.XMdxCalculatedMember;
import com.cognos.xqe.runtree.olap.mdx.XMdxElement;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Block;
import com.cognos.xqe.runtree.olap.mdx.interpreter.InterpreterContext;
import com.cognos.xqe.runtree.olap.mdx.interpreter.InterpreterException;
import com.cognos.xqe.runtree.olap.mdx.interpreter.NullBehavior;
import com.cognos.xqe.runtree.olap.mdx.interpreter.ResultSetProcessor;
import com.cognos.xqe.runtree.olap.mdx.metadata.CalculatedMember;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.util.AggregationUtils;
import com.cognos.xqe.runtree.olap.mdx.v5provider.pushdown.CalculationPushdownUtility;
import com.cognos.xqe.runtree.olap.mdx.v5provider.pushdown.PushdownManager;
import com.cognos.xqe.runtree.olap.mdx.v5provider.pushdown.PushdownUtility;
import com.cognos.xqe.util.Pair;
import com.cognos.xqe.util.UniqueNameGenerator;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public class FilterPushdownUtility {
    private static final String STR_UNSUPPORTED_NUMERIC_EXPRESSION = "Unsupported numeric expression.";
    private static final String STR_SPACE = " ";
    private static final String STR_REQUIRED = "required";
    static final String STR_TRUE = "true";
    public static final String STR_FALSE = "false";

    public static void generateFilterExpression(String key, V5Query query, XQENodeFactory nodeFactory, String dataItemName, List<Pair> comparisonExpressions, Integer booleanOperatorCode) {
        String booleanOperatorString = "and";
        if (booleanOperatorCode != null && 3 == booleanOperatorCode) {
            booleanOperatorString = "or";
        }
        IDataSourceCapabilities providerCapabilities = ProviderCapabilites.getInstance().getOrAddProviderCapabilities(key);
        boolean useCoalesce = providerCapabilities.isSupported("enableCoalesceFilterInPushDownMode");
        String nullComparison = providerCapabilities.getStringValue("null.comparison.operator", null);
        if (useCoalesce && nullComparison != null && nullComparison.equals("null")) {
            useCoalesce = false;
        }
        V5Selection selection = (V5Selection)query.getFirstChildByType(101009);
        String filterItemName = dataItemName;
        if (useCoalesce) {
            filterItemName = PushdownUtility.addCoalesceDataItem(selection, nodeFactory, dataItemName);
        }
        V5DetailFilter detailFilter = (V5DetailFilter)nodeFactory.createNode(101008);
        detailFilter.setPostAutoAggregation(true);
        detailFilter.setStringPropertyValue("use", STR_REQUIRED);
        query.addChild(detailFilter);
        IXQEQueryNode filterExpression = nodeFactory.createNode(101013);
        String uniqueName = UniqueNameGenerator.createUniqueName(filterItemName);
        StringBuilder filterExpressionString = null;
        for (Pair aComparison : comparisonExpressions) {
            if (filterExpressionString == null) {
                filterExpressionString = new StringBuilder();
            } else {
                filterExpressionString.append(STR_SPACE);
                filterExpressionString.append(booleanOperatorString);
                filterExpressionString.append(STR_SPACE);
            }
            filterExpressionString.append(uniqueName);
            filterExpressionString.append(FilterPushdownUtility.getOperatorString(null, null, (Integer)aComparison.getFirst()));
            filterExpressionString.append(STR_SPACE);
            filterExpressionString.append(FilterPushdownUtility.getConstantOperand(null, null, aComparison.getSecond()));
        }
        filterExpression.setPropertyValue("expression", filterExpressionString.toString());
        detailFilter.addChild(filterExpression);
    }

    private static int getFilterOperator(PushdownManager pushdownManager, InterpreterContext interpreterContext, int opCode, Object constantOperand, ResultSetProcessor rsp, NullBehavior[] nullHandling) throws InterpreterException {
        DoubleValue smaller;
        DoubleValue larger;
        DoubleValue nll;
        DoubleValue zero = DataValueFactory.createDoubleValue();
        Object zeroGreaterThanNull = rsp.performOp(interpreterContext, zero, nll = DoubleValue.NULL_VALUE, null, 13, nullHandling);
        if (FilterPushdownUtility.isBooleanTrue(zeroGreaterThanNull)) {
            larger = zero;
            smaller = nll;
        } else {
            larger = nll;
            smaller = zero;
        }
        int opCodeBackup = opCode;
        Object val = null;
        boolean negativeLogic = false;
        switch (opCode) {
            case 17: {
                val = rsp.performOp(interpreterContext, constantOperand, larger, null, 13, nullHandling);
                if (FilterPushdownUtility.isBooleanTrue(val) || FilterPushdownUtility.isNullValue(val)) break;
                opCode = 15;
                negativeLogic = true;
                break;
            }
            case 13: {
                val = rsp.performOp(interpreterContext, constantOperand, larger, null, 17, nullHandling);
                if (FilterPushdownUtility.isBooleanTrue(val) || FilterPushdownUtility.isNullValue(val)) break;
                opCode = 19;
                negativeLogic = true;
                break;
            }
            case 19: {
                val = rsp.performOp(interpreterContext, constantOperand, smaller, null, 15, nullHandling);
                if (FilterPushdownUtility.isBooleanTrue(val) || FilterPushdownUtility.isNullValue(val)) break;
                opCode = 13;
                negativeLogic = true;
                break;
            }
            case 15: {
                val = rsp.performOp(interpreterContext, constantOperand, smaller, null, 19, nullHandling);
                if (FilterPushdownUtility.isBooleanTrue(val) || FilterPushdownUtility.isNullValue(val)) break;
                opCode = 17;
                negativeLogic = true;
                break;
            }
            case 9: {
                val = rsp.performOp(interpreterContext, constantOperand, null, null, 9, nullHandling);
                if (!FilterPushdownUtility.isBooleanTrue(val) || FilterPushdownUtility.isNullValue(val)) break;
                opCode = 11;
                negativeLogic = true;
                break;
            }
            case 11: {
                val = rsp.performOp(interpreterContext, constantOperand, null, null, 11, nullHandling);
                if (!FilterPushdownUtility.isBooleanTrue(val) || FilterPushdownUtility.isNullValue(val)) break;
                opCode = 9;
                negativeLogic = true;
                break;
            }
            default: {
                pushdownManager.cancel(interpreterContext, STR_UNSUPPORTED_NUMERIC_EXPRESSION);
                return Integer.MAX_VALUE;
            }
        }
        if (!(val instanceof BooleanValue || val instanceof Boolean || FilterPushdownUtility.isNullValue(val))) {
            pushdownManager.cancel(interpreterContext, "Unable to distinguish nulls.");
            return Integer.MAX_VALUE;
        }
        BooleanValue currentDefaultValue = (BooleanValue)pushdownManager.getParameter("Filter", "defaultValue");
        if (currentDefaultValue != null) {
            negativeLogic = negativeLogic && currentDefaultValue.getBoolean();
        }
        List originalComparisonExpressionList = (List)pushdownManager.getParameter("Filter", "originalComparisonExpression");
        if (negativeLogic) {
            pushdownManager.setParameter("Filter", "defaultValue", BooleanValue.TRUE);
            if (originalComparisonExpressionList != null && !originalComparisonExpressionList.isEmpty()) {
                pushdownManager.setParameter("Filter", "booleanOperator", 3);
            }
        } else {
            pushdownManager.setParameter("Filter", "defaultValue", BooleanValue.FALSE);
            opCode = opCodeBackup;
            List comparisonExpressionList = (List)pushdownManager.getParameter("Filter", "comparisonExpression");
            if (comparisonExpressionList != null && originalComparisonExpressionList != null) {
                comparisonExpressionList.clear();
                comparisonExpressionList.addAll(originalComparisonExpressionList);
            }
        }
        return opCode;
    }

    private static String getOperatorString(PushdownManager pushdownManager, InterpreterContext interpreterContext, int opCode) {
        String operator = null;
        switch (opCode) {
            case 9: {
                operator = "=";
                break;
            }
            case 15: {
                operator = "<";
                break;
            }
            case 19: {
                operator = "<=";
                break;
            }
            case 13: {
                operator = ">";
                break;
            }
            case 17: {
                operator = ">=";
                break;
            }
            case 11: {
                operator = "<>";
                break;
            }
        }
        if (operator == null && pushdownManager != null) {
            pushdownManager.cancel(interpreterContext, STR_UNSUPPORTED_NUMERIC_EXPRESSION);
        }
        return operator;
    }

    public static boolean isSupportedOperator(int opCode) {
        return opCode == 9 || opCode == 15 || opCode == 19 || opCode == 13 || opCode == 17 || opCode == 11;
    }

    private static boolean isBooleanTrue(Object val) {
        return val instanceof BooleanValue && ((BooleanValue)val).getBoolean() || val instanceof Boolean && (Boolean)val != false;
    }

    private static boolean isNullValue(Object val) {
        return val instanceof IValue && ((IValue)val).isNull();
    }

    public static void configurePushdown(InterpreterContext interpreterContext, Block b1, Block b2, int operation, NullBehavior[] nullHandling, ResultSetProcessor rsp) throws InterpreterException {
        PushdownManager pushdownManager = PushdownManager.getPushdownManager(interpreterContext);
        if (pushdownManager != null && pushdownManager.isPushdownExecutionFinished()) {
            pushdownManager.setPushdownExecutionFinished(false);
            pushdownManager.clearParameter("Filter");
        }
        if (pushdownManager != null && pushdownManager.isFilter()) {
            Object blockObject = b2.first();
            String constandOperand = FilterPushdownUtility.getConstantOperand(pushdownManager, interpreterContext, blockObject);
            if (constandOperand == null) {
                pushdownManager.cancel(interpreterContext, "No constant operand found.");
                return;
            }
            int filterOperator = FilterPushdownUtility.getFilterOperator(pushdownManager, interpreterContext, operation, blockObject, rsp, nullHandling);
            if (filterOperator == Integer.MAX_VALUE) {
                pushdownManager.cancel(interpreterContext, "Operator not supported.");
                return;
            }
            ArrayList<Pair> originalComparisonExpressionList = (ArrayList<Pair>)pushdownManager.getParameter("Filter", "originalComparisonExpression");
            if (originalComparisonExpressionList == null) {
                originalComparisonExpressionList = new ArrayList<Pair>();
            }
            Pair originalFilterCondition = new Pair(operation, blockObject);
            originalComparisonExpressionList.add(originalFilterCondition);
            pushdownManager.setParameter("Filter", "originalComparisonExpression", originalComparisonExpressionList);
            ArrayList<Pair> comparisonExpressionList = (ArrayList<Pair>)pushdownManager.getParameter("Filter", "comparisonExpression");
            if (comparisonExpressionList == null) {
                comparisonExpressionList = new ArrayList<Pair>();
            }
            Pair filterCondition = new Pair(filterOperator, blockObject);
            comparisonExpressionList.add(filterCondition);
            pushdownManager.setParameter("Filter", "comparisonExpression", comparisonExpressionList);
            Object obj = b1.first();
            if (!(obj instanceof IMember) && !(obj instanceof ITuple)) {
                pushdownManager.cancel(interpreterContext, "Only simple (base) numeric expressions are supported.");
                return;
            }
            HashSet<IMember> calculations = PushdownUtility.collectCalculationsInContext(interpreterContext, b1);
            if (!calculations.isEmpty() && !CalculationPushdownUtility.isPushdownSupportedByDatasource(interpreterContext)) {
                pushdownManager.cancel(interpreterContext, "Calculated members in filter pushdown context are not supported.");
                return;
            }
            for (IMember cm : calculations) {
                if (FilterPushdownUtility.isCalculatedMemberValidForPushdown(interpreterContext, (CalculatedMember)cm)) continue;
                pushdownManager.cancel(interpreterContext, "Unsupported calculated members in filter pushdown context.");
                return;
            }
            if (!pushdownManager.isConfigureOnly()) {
                pushdownManager.setEnabled(true);
            }
        }
    }

    private static boolean isCalculatedMemberValidForPushdown(InterpreterContext interpreterContext, CalculatedMember cm) {
        boolean isSupported = false;
        if (cm.isMeasure()) {
            isSupported = PushdownUtility.evaluateAsMemberOrMeasure(cm, interpreterContext);
        } else {
            XMdxCalculatedMember x = cm.getRuntreeCalculatedMember();
            if (AggregationUtils.isSimpleTupleNode(x, interpreterContext, XMdxElement.METAFUNCTIONS)) {
                isSupported = true;
            } else {
                IXQEQueryNode element;
                List<IXQEQueryNode> elementNodes = x.getFirstDescendantsOfTypeOrdered(501059, true);
                if (elementNodes.size() > 0 && ((XMdxElement)(element = elementNodes.get(0))).getValue().equalsIgnoreCase("Aggregate")) {
                    elementNodes = element.getFirstDescendantsOfTypeOrdered(501060, true);
                    for (int i = 0; i < elementNodes.size(); ++i) {
                        isSupported = AggregationUtils.isSimpleTupleNode(elementNodes.get(i), interpreterContext, XMdxElement.METAFUNCTIONS);
                        if (isSupported) continue;
                        return false;
                    }
                }
            }
        }
        return isSupported;
    }

    private static String getConstantOperand(PushdownManager pushdownManager, InterpreterContext interpreterContext, Object constantOperand) {
        String strConstantOperand = null;
        if (constantOperand instanceof NumericValue) {
            strConstantOperand = ((NumericValue)constantOperand).getString();
        } else if (constantOperand instanceof Integer) {
            strConstantOperand = constantOperand.toString();
        } else if (constantOperand instanceof Double) {
            strConstantOperand = constantOperand.toString();
        } else if (constantOperand instanceof NullValue) {
            strConstantOperand = ((NullValue)constantOperand).getString();
        } else if (pushdownManager != null) {
            pushdownManager.cancel(interpreterContext, "Unsupported expression operand, " + constantOperand);
        }
        return strConstantOperand;
    }

    public static void configurePushdown(InterpreterContext interpreterContext) {
        if (!PushdownUtility.doesProviderSupportPushdown(interpreterContext.getProvider())) {
            return;
        }
        PushdownManager pushdownManager = PushdownManager.getPushdownManager(interpreterContext);
        if (!FilterPushdownUtility.isPushdownSupportedByDatasource(interpreterContext)) {
            if (pushdownManager != null && pushdownManager.peekPushdownFunction() != null) {
                pushdownManager.cancel(interpreterContext, "Filter pushdown is not enabled.");
            }
            return;
        }
        if (PushdownUtility.getPushdownEnabled(interpreterContext)) {
            if (pushdownManager != null && pushdownManager.peekPushdownFunction() != null) {
                if (pushdownManager.peekPushdownFunction().getFirst().equals("Head") || pushdownManager.peekPushdownFunction().getFirst().equals("Tail")) {
                    pushdownManager.addPushdownFunction("Filter");
                }
            } else {
                pushdownManager = PushdownManager.initializePushdownManager(interpreterContext, false);
                if (pushdownManager != null) {
                    pushdownManager.addPushdownFunction("Filter");
                }
            }
        }
    }

    public static boolean isPushdownSupportedByDatasource(InterpreterContext interpreterContext) {
        IDataSource dataSource = interpreterContext.getXDataContext().getEnvironment().getDataSource();
        if (dataSource == null) {
            return false;
        }
        boolean pushdown = false;
        String key = null;
        if (dataSource.isROLAP()) {
            key = "RO";
        } else if (dataSource.isRelational()) {
            key = "DMR";
        }
        if (key != null) {
            IDataSourceCapabilities providerCapabilities = ProviderCapabilites.getInstance().getOrAddProviderCapabilities(key);
            pushdown = providerCapabilities.isSupported("pushdownFilterToRelational");
        } else {
            pushdown = dataSource.getCapabilities().getStringValue("pushdownFilterToRelational", STR_FALSE).equalsIgnoreCase(STR_TRUE);
        }
        return pushdown;
    }
}

