/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.v5provider.pushdown;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.v5.query.V5DetailFilter;
import com.cognos.xqe.ast.v5.query.V5Query;
import com.cognos.xqe.ast.v5.query.V5Selection;
import com.cognos.xqe.ast.v5.result.V5GroupBody;
import com.cognos.xqe.data.model.CapabilitiesKey;
import com.cognos.xqe.data.values.NumericValue;
import com.cognos.xqe.data.values.StringValue;
import com.cognos.xqe.runtree.olap.mdx.MDXEngineException;
import com.cognos.xqe.runtree.olap.mdx.XMdxExpression;
import com.cognos.xqe.runtree.olap.mdx.functions.manager.ParameterFetcher;
import com.cognos.xqe.runtree.olap.mdx.functions.manager.RuntreeParameterFetcher;
import com.cognos.xqe.runtree.olap.mdx.functions.set.CellValueComparatorFactory;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Block;
import com.cognos.xqe.runtree.olap.mdx.interpreter.InterpreterContext;
import com.cognos.xqe.runtree.olap.mdx.interpreter.InterpreterException;
import com.cognos.xqe.runtree.olap.mdx.v5provider.pushdown.PushdownManager;
import com.cognos.xqe.runtree.olap.mdx.v5provider.pushdown.PushdownUtility;
import com.cognos.xqe.util.UniqueNameGenerator;
import java.util.TreeMap;

public class HeadTailPushdownUtility {
    private static final String STR_SPACE = " ";
    private static final String STR_REQUIRED = "required";
    private static final String STR_LESS_THAN_EQUAL = "<=";
    private static final String STR_RANK = "rank";
    private static final String CLOSE_PARENTHESIS_STR = ")";
    private static final String OPEN_PARENTHESIS_STR = "(";
    private static final String STR_TRUE = "true";
    private static final String OPEN_SQUARE = "[";
    private static final int MAGIC_2 = 2;
    private static final String RANK_DATAITEM = "rank_";

    public static boolean configurePushdown(ParameterFetcher parameterFetcher, String functionName) throws InterpreterException {
        if (!PushdownUtility.getPushdownEnabled(parameterFetcher.getInterpreterContext())) {
            return false;
        }
        if (!functionName.equals("Head") && !functionName.endsWith("Tail") && parameterFetcher.getParameterCount() < 1) {
            return false;
        }
        InterpreterContext interpreterContext = parameterFetcher.getInterpreterContext();
        PushdownManager pushdownManager = PushdownManager.initializePushdownManager(interpreterContext, false);
        if (pushdownManager == null) {
            return false;
        }
        int numberOfParameters = parameterFetcher.getParameterCount();
        if (!PushdownUtility.evaluateContext(interpreterContext)) {
            pushdownManager.cancel(interpreterContext, "context contains calculated members.");
            return false;
        }
        if (!HeadTailPushdownUtility.isNamedSetValidForPushdown((RuntreeParameterFetcher)parameterFetcher)) {
            pushdownManager.cancel(interpreterContext, "InlineSet is referend by the count parameter. Cannot pushdown.");
            return false;
        }
        Object countVal = null;
        if (numberOfParameters == 2) {
            Block countParam = null;
            try {
                interpreterContext.getCalculationEngine().getNamedSets();
                countParam = (Block)parameterFetcher.getParameter(1);
            }
            catch (MDXEngineException e) {
                pushdownManager.cancel(interpreterContext, "Head count parameter depends on the head set expression.");
                return false;
            }
            countVal = countParam.first();
        }
        double count = 0.0;
        if (countVal instanceof NumericValue) {
            count = ((NumericValue)countVal).getDouble();
        } else if (countVal instanceof StringValue) {
            count = ((StringValue)countVal).getDouble();
        } else if (countVal == null) {
            count = 1.0;
        }
        pushdownManager.addPushdownFunction(functionName);
        if (pushdownManager.isTail()) {
            count = -count;
        }
        pushdownManager.setParameter(functionName, "count", count);
        pushdownManager.setParameter(functionName, "nullHandling", CellValueComparatorFactory.getComparator(interpreterContext, false));
        pushdownManager.setEnabled(true);
        return true;
    }

    public static void generateRankExpression(CapabilitiesKey key, V5Query query, V5GroupBody groupBody, XQENodeFactory nodeFactory, PushdownManager pushdownManager) {
        double value = (Double)pushdownManager.getParameter(pushdownManager.getTopPushdownFunctionName(), "count");
        V5Selection selection = (V5Selection)query.getFirstChildByType(101009);
        HeadTailPushdownUtility.addRankDataItem(nodeFactory, selection, groupBody, pushdownManager);
        V5DetailFilter detailFilter = (V5DetailFilter)nodeFactory.createNode(101008);
        detailFilter.setPostAutoAggregation(true);
        detailFilter.setStringPropertyValue("use", STR_REQUIRED);
        query.addChild(detailFilter);
        IXQEQueryNode filterExpression = nodeFactory.createNode(101013);
        String filterExpressionString = UniqueNameGenerator.createUniqueName(RANK_DATAITEM) + STR_SPACE + STR_LESS_THAN_EQUAL + STR_SPACE + value;
        filterExpression.setPropertyValue("expression", filterExpressionString);
        detailFilter.addChild(filterExpression);
        detailFilter.setOriginalExpression(filterExpressionString);
    }

    private static void addRankDataItem(XQENodeFactory nodeFactory, V5Selection selection, V5GroupBody groupBody, PushdownManager pushdownManager) {
        TreeMap dataItems;
        IXQEQueryNode dataItem = nodeFactory.createNode(101003);
        dataItem.setPropertyValue("name", RANK_DATAITEM);
        selection.addChild(dataItem);
        String rank = "";
        IXQEQueryNode expression = nodeFactory.createNode(101004);
        if (pushdownManager != null && (dataItems = (TreeMap)pushdownManager.getParameter(pushdownManager.getTopPushdownFunctionName(), "dataItemNameWithSort")) != null) {
            rank = HeadTailPushdownUtility.createRankSelection(dataItems, pushdownManager.isTail());
        }
        StringBuilder sb = new StringBuilder(STR_RANK);
        sb.append(OPEN_PARENTHESIS_STR);
        sb.append(rank);
        sb.append(CLOSE_PARENTHESIS_STR);
        expression.setPropertyValue("expression", sb.toString());
        dataItem.addChild(expression);
        IXQEQueryNode dataItemRef = nodeFactory.createNode(101015);
        dataItemRef.setPropertyValue("refDataItem", RANK_DATAITEM);
        groupBody.addChild(dataItemRef);
    }

    private static String createRankSelection(TreeMap<String, Ordering> dataItems, boolean isTail) {
        StringBuilder sb = new StringBuilder();
        for (String dataItem : dataItems.keySet()) {
            Ordering ordering = dataItems.get(dataItem);
            if (isTail) {
                ordering = ordering.opposite();
            }
            sb.append(OPEN_SQUARE);
            sb.append(dataItem);
            sb.append("] ");
            sb.append(ordering.toString());
            sb.append(", ");
        }
        sb.delete(sb.length() - 2, sb.length());
        return sb.toString();
    }

    private static boolean isNamedSetValidForPushdown(RuntreeParameterFetcher parameterFetcher) {
        IXQEQueryNode fctNode = parameterFetcher.getFunctionNode();
        IXQEQueryNode expressionList = fctNode.getFirstChildByType(501061);
        IXQEQueryNode[] expressions = expressionList.getChildrenOfType(501060);
        XMdxExpression expressionSet = (XMdxExpression)expressions[0];
        if (!expressionSet.isInlineSet()) {
            return true;
        }
        XMdxExpression expressionCount = (XMdxExpression)expressions[1];
        return expressionCount.isInlineIdentifier(parameterFetcher.getInterpreterContext().getXDataContext());
    }

    public static enum Ordering {
        ASC,
        DESC;

        private static final String ORDER_ASC = "ASC";
        private static final String ORDER_DESC = "DESC";

        public String toString() {
            if (this == ASC) {
                return ORDER_ASC;
            }
            return ORDER_DESC;
        }

        Ordering opposite() {
            if (this == ASC) {
                return DESC;
            }
            return ASC;
        }

        public static Ordering getOrder(String order) {
            if (order.equals("ascending")) {
                return ASC;
            }
            if (order.equals("descending")) {
                return DESC;
            }
            return null;
        }
    }
}

