/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.v5provider.pushdown;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.ICube;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Block;
import com.cognos.xqe.runtree.olap.mdx.interpreter.IResultSet;
import com.cognos.xqe.runtree.olap.mdx.interpreter.InterpreterContext;
import com.cognos.xqe.runtree.olap.mdx.interpreter.InterpreterException;
import com.cognos.xqe.runtree.olap.mdx.interpreter.InterpreterRuntimeException;
import com.cognos.xqe.runtree.olap.mdx.interpreter.QueryStrategy;
import com.cognos.xqe.runtree.olap.mdx.metadata.Level;
import com.cognos.xqe.runtree.olap.mdx.metadata.Provider;
import com.cognos.xqe.runtree.olap.mdx.v5provider.pushdown.IPushdownAdapter;
import com.cognos.xqe.util.Pair;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PushdownManager {
    public static final String PARAM_COUNT = "count";
    public static final String PARAM_CONTEXTS = "contexts";
    public static final String PARAM_COMPARISON_EXPRESSION = "comparisonExpression";
    public static final String PARAM_ORIGINAL_COMPARISON_EXPRESSION = "originalComparisonExpression";
    public static final String PARAM_BOOLEAN_OPERATOR = "booleanOperator";
    public static final String PARAM_DEFAULT_VALUE = "defaultValue";
    public static final String PARAM_FILTERNULLS = "filterNulls";
    public static final String PARAM_CELLCOMPARATOR = "nullHandling";
    public static final String PARAM_SETSIZE = "setSize";
    public static final String PARAM_MEASURE_POS = "measurePos";
    public static final String PARAM_DATAITEM_NAME = "dataItemName";
    public static final String PARAM_PROJECTEDCOLSTODATAITEM = "projectedColumnsToDataItem";
    public static final String PARAM_IS_FETCHING_COMPLETE_TUPLE = "isFetchingCompleteTuple";
    public static final String PARAM_DATAITEMNAME_SORT = "dataItemNameWithSort";
    private final List<Pair> mPushdownFunctions = new ArrayList<Pair>();
    private int mStackPointer = -1;
    private final QueryStrategy mQueryStrategy;
    private boolean mEnabled = false;
    private boolean mConfigureOnly = false;
    private boolean mPushdownExecutionFinished = false;

    public static QueryStrategy getNewQueryStrategyForPushdown(InterpreterContext interpreterContext) {
        ICube cube = interpreterContext.getCube();
        Provider p = interpreterContext.getProvider();
        QueryStrategy qs = p.getQueryStrategy(cube);
        qs.setInfoData(interpreterContext.getQueryContext());
        qs.setCube(cube);
        return qs;
    }

    public static void resetPushdownContext(InterpreterContext interpreterContext) {
        interpreterContext.setQueryStrategy(null);
    }

    public static boolean isPushdownInProgress(InterpreterContext interpreterContext) {
        QueryStrategy queryStrategy = interpreterContext.getQueryStrategy();
        if (queryStrategy != null) {
            PushdownManager pm = queryStrategy.getPushdownManager();
            return queryStrategy.getPushDownMode() && pm != null && pm.isEnabled();
        }
        return false;
    }

    public static boolean isPushdownExecutionFinished(InterpreterContext interpreterContext) {
        PushdownManager pm = PushdownManager.getPushdownManager(interpreterContext);
        if (pm == null) {
            return false;
        }
        return pm.isPushdownExecutionFinished();
    }

    public static PushdownManager initializePushdownManager(InterpreterContext interpreterContext, boolean allowNesting) {
        PushdownManager pm = PushdownManager.getPushdownManager(interpreterContext);
        if (pm != null) {
            if (allowNesting) {
                return pm;
            }
            pm.getAdapter().logCancelExplanation("Nested pushdowns in the same context are not supported. Only the first pushdown will be executed.");
            return null;
        }
        QueryStrategy qs = PushdownManager.getNewQueryStrategyForPushdown(interpreterContext);
        PushdownManager pushdownManager = new PushdownManager(qs);
        qs.setPushdownManager(pushdownManager);
        interpreterContext.setQueryStrategy(qs);
        pushdownManager.handleEnabledCubes(interpreterContext.getCube().getName());
        return PushdownManager.getPushdownManager(interpreterContext);
    }

    public static PushdownManager getPushdownManager(InterpreterContext interpreterContext) {
        QueryStrategy qs = interpreterContext.getQueryStrategy();
        if (qs == null) {
            return null;
        }
        return qs.getPushdownManager();
    }

    public static boolean isNullFilteringNeeded(InterpreterContext interpreterContext, String functionName) {
        PushdownManager pm = PushdownManager.getPushdownManager(interpreterContext);
        return pm != null && pm.isNullFilteringNeeded(functionName);
    }

    public PushdownManager(QueryStrategy queryStrategy) {
        this.mQueryStrategy = queryStrategy;
    }

    public boolean executePushdown(Object setToFetch, IMember[] measuresMembers, IResultSet resultSet, Object blockStorage) throws InterpreterRuntimeException, InterpreterException {
        return this.getAdapter().executeImpl(this.mQueryStrategy, setToFetch, measuresMembers, resultSet, blockStorage);
    }

    public Block executePushdown(String queryString, String contextInfo, List<Level> levelList, InterpreterContext interpreterContext, boolean customValuePushdown) throws Exception {
        return this.getAdapter().executeImpl(queryString, contextInfo, levelList, interpreterContext, this, customValuePushdown);
    }

    public void generatePushdownV5Expression(List<IMember> measureSelections, PlanningEnvironment planEnv, IXQEQueryNode query, IXQEQueryNode selection, IXQEQueryNode groupBody) {
        this.getAdapter().generatePushdownV5Expression(measureSelections, planEnv, query, selection, groupBody, this);
    }

    public Object getParameter(String functionName, String parameterName) {
        Pair topPushdownFunctionInfo = this.peekPushdownFunction();
        if (topPushdownFunctionInfo == null) {
            return null;
        }
        if (functionName.equals(topPushdownFunctionInfo.getFirst())) {
            Map parameters = (Map)topPushdownFunctionInfo.getSecond();
            return parameters.get(parameterName);
        }
        throw new XQERuntimeException();
    }

    public void setParameter(String functionName, String parameterName, Object parameterValue) {
        Pair topPushdownFunctionInfo = this.peekPushdownFunction();
        if (topPushdownFunctionInfo == null || !functionName.equals(topPushdownFunctionInfo.getFirst())) {
            throw new XQERuntimeException();
        }
        Map parameters = (Map)topPushdownFunctionInfo.getSecond();
        parameters.put(parameterName, parameterValue);
    }

    public String getTopPushdownFunctionName() {
        Pair topPushdownFunctionInfo = this.peekPushdownFunction();
        if (topPushdownFunctionInfo != null) {
            return (String)topPushdownFunctionInfo.getFirst();
        }
        return null;
    }

    public void addPushdownFunction(String functionName) {
        Pair pushdownFunctionInfo = new Pair();
        pushdownFunctionInfo.setFirst(functionName);
        pushdownFunctionInfo.setSecond(new HashMap());
        this.mPushdownFunctions.add(pushdownFunctionInfo);
        ++this.mStackPointer;
    }

    public Pair popPushdownFunction() {
        if (this.mStackPointer < 0) {
            return null;
        }
        Pair pushdownFunctionInfo = this.mPushdownFunctions.get(this.mStackPointer);
        --this.mStackPointer;
        return pushdownFunctionInfo;
    }

    public Pair peekPushdownFunction() {
        if (this.mStackPointer < 0) {
            return null;
        }
        Pair pushdownFunctionInfo = this.mPushdownFunctions.get(this.mStackPointer);
        return pushdownFunctionInfo;
    }

    public void resetPushdownFunctionStackPointer() {
        this.mStackPointer = this.mPushdownFunctions.size() > 0 ? this.mPushdownFunctions.size() - 1 : -1;
    }

    public boolean isTopCount() {
        String function = this.getTopPushdownFunctionName();
        return "TopCount".equals(function);
    }

    public boolean isTopSum() {
        String function = this.getTopPushdownFunctionName();
        return "TopSum".equals(function);
    }

    public boolean isBottomCount() {
        String function = this.getTopPushdownFunctionName();
        return "BottomCount".equals(function);
    }

    public boolean isHead() {
        String function = this.getTopPushdownFunctionName();
        return "Head".equals(function);
    }

    public boolean isTail() {
        String function = this.getTopPushdownFunctionName();
        return "Tail".equals(function);
    }

    public boolean isFilter() {
        String function = this.getTopPushdownFunctionName();
        return "Filter".equals(function);
    }

    public boolean isAggregate() {
        String function = this.getTopPushdownFunctionName();
        return "Aggregate".equals(function);
    }

    public boolean isNullFilteringNeeded(String functionName) {
        Boolean filterNulls = (Boolean)this.getParameter(functionName, PARAM_FILTERNULLS);
        return filterNulls != null && filterNulls != false;
    }

    public boolean isOverfetchingAllowed() {
        return true;
    }

    public void handleMultipleDataQueries() {
        IPushdownAdapter adapter = this.getAdapter();
        if (!adapter.isMultipleDataQueriesSupported(this)) {
            adapter.logCancelExplanation("selections from multiple levels are unsupported for pushdown.");
            this.resetQsPushdownManager();
        }
    }

    public void handleParentChildHierarchies() {
        IPushdownAdapter adapter = this.getAdapter();
        if (!adapter.isParentChildHierarchiesSupported(this)) {
            adapter.logCancelExplanation("parent-child hierarchies are unsupported for pushdown.");
            this.resetQsPushdownManager();
        }
    }

    public void handleEnabledCubes(String cubeName) {
        IPushdownAdapter adapter = this.getAdapter();
        if (!adapter.isCubeEnabledForPushdown(cubeName)) {
            adapter.logCancelExplanation("pushdown not enabled for this cube.");
            this.resetQsPushdownManager();
        }
    }

    public void cancel(InterpreterContext ic, String reason) {
        this.getAdapter().logCancelExplanation(reason);
        PushdownManager.resetPushdownContext(ic);
        this.resetQsPushdownManager();
    }

    private IPushdownAdapter getAdapter() {
        return this.mQueryStrategy.getPushdownAdapter();
    }

    public void resetQsPushdownManager() {
        this.mQueryStrategy.resetPushdownManager();
    }

    public void logCancelExplanation(String explanation) {
        this.getAdapter().logCancelExplanation(explanation);
    }

    public boolean isEnabled() {
        return this.mEnabled;
    }

    public void setEnabled(boolean enabled) {
        this.mEnabled = enabled;
    }

    public boolean isPushdownAborted(InterpreterContext ic) {
        return this.mQueryStrategy.getPushdownManager() == null;
    }

    public boolean isConfigureOnly() {
        return this.mConfigureOnly;
    }

    public void setConfigureOnly(boolean value) {
        this.mConfigureOnly = value;
    }

    public boolean isPushdownExecutionFinished() {
        return this.mPushdownExecutionFinished;
    }

    public void setPushdownExecutionFinished(boolean value) {
        this.mPushdownExecutionFinished = value;
    }

    public void clearParameter(String functionName) {
        Pair topPushdownFunctionInfo = this.peekPushdownFunction();
        if (topPushdownFunctionInfo == null || !functionName.equals(topPushdownFunctionInfo.getFirst())) {
            throw new XQERuntimeException();
        }
        topPushdownFunctionInfo.setSecond(new HashMap());
    }

    public int getAggregateSetSize(String function) {
        int totalAggregateSetSize = 0;
        Pair peek = null;
        boolean functionFound = false;
        for (int i = 0; i < this.mPushdownFunctions.size(); ++i) {
            peek = this.mPushdownFunctions.get(i);
            if (functionFound && peek.getFirst().equals("Aggregate")) {
                totalAggregateSetSize *= ((Long)((Map)peek.getSecond()).get("AggregateSetSize")).intValue();
            }
            ++i;
            if (!peek.getFirst().equals(function)) continue;
            functionFound = true;
        }
        if (!functionFound) {
            throw new XQERuntimeException();
        }
        return totalAggregateSetSize;
    }

    public double getHeadTailCount() {
        Pair peek = null;
        String currentFunction = "";
        Double lowestCount = null;
        for (int i = this.mStackPointer; i >= 0; --i) {
            peek = this.mPushdownFunctions.get(i);
            currentFunction = (String)peek.getFirst();
            if (!currentFunction.equals("Head") && !currentFunction.equals("Tail")) continue;
            Double currentCount = (Double)((Map)peek.getSecond()).get(PARAM_COUNT);
            lowestCount = lowestCount == null ? currentCount : Double.valueOf(Math.min(currentCount, lowestCount));
        }
        if (lowestCount == null) {
            throw new XQERuntimeException();
        }
        return lowestCount;
    }

    public boolean isHeadTailInPushdownContext() {
        int i = this.mStackPointer;
        Pair peek = null;
        String function = "";
        boolean headTailFound = false;
        for (i = this.mStackPointer; i >= 0; --i) {
            peek = this.mPushdownFunctions.get(i);
            function = (String)peek.getFirst();
            if (!function.equals("Head") && !function.equals("Tail")) continue;
            if (headTailFound) {
                return false;
            }
            headTailFound = true;
        }
        return headTailFound;
    }

    public boolean isPushdownResultCachable() {
        String[] cachableFunctionName = new String[]{"Filter", "Aggregate"};
        for (Pair aFunction : this.mPushdownFunctions) {
            boolean isCachable = false;
            for (int i = 0; i < cachableFunctionName.length; ++i) {
                if (!((String)aFunction.getFirst()).equalsIgnoreCase(cachableFunctionName[i])) continue;
                isCachable = true;
                break;
            }
            if (isCachable) continue;
            return false;
        }
        return true;
    }
}

