/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.v5provider.pushdown;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.v5.query.V5Query;
import com.cognos.xqe.ast.v5.result.V5GroupBody;
import com.cognos.xqe.data.values.DoubleValue;
import com.cognos.xqe.metadata.AggregateTypeEnum;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.IMeasure;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.resultset.interfaces.ISet;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Block;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Cell;
import com.cognos.xqe.runtree.olap.mdx.interpreter.CrossJoinedSet;
import com.cognos.xqe.runtree.olap.mdx.interpreter.IResultSet;
import com.cognos.xqe.runtree.olap.mdx.interpreter.InterpreterContext;
import com.cognos.xqe.runtree.olap.mdx.interpreter.InterpreterException;
import com.cognos.xqe.runtree.olap.mdx.interpreter.QueryStrategy;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Set;
import com.cognos.xqe.runtree.olap.mdx.interpreter.SetSelections;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Tuple;
import com.cognos.xqe.runtree.olap.mdx.interpreter.TupleValue;
import com.cognos.xqe.runtree.olap.mdx.metadata.Cube;
import com.cognos.xqe.runtree.olap.mdx.metadata.Hierarchy;
import com.cognos.xqe.runtree.olap.mdx.metadata.Level;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPLog;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPMeasure;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPQueryExecuteMetrics;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPQueryStrategy;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.admin.ROLAPCube;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.log.QueryType;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaMeasure;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.util.AggregationUtils;
import com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.BlockTupleStorageUtil;
import com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.IBlockTupleStorage;
import com.cognos.xqe.runtree.olap.mdx.v5provider.pushdown.FilterPushdownUtility;
import com.cognos.xqe.runtree.olap.mdx.v5provider.pushdown.IPushdownAdapter;
import com.cognos.xqe.runtree.olap.mdx.v5provider.pushdown.PushdownManager;
import com.cognos.xqe.runtree.olap.mdx.v5provider.pushdown.PushdownUtility;
import com.cognos.xqe.runtree.olap.mdx.v5provider.pushdown.TopBottomCountPushdownUtility;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQEDebugLog;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;

public class ROLAPPushdownAdapter
implements IPushdownAdapter {
    @Override
    public boolean isMultipleDataQueriesSupported(PushdownManager pushdownManager) {
        return pushdownManager.isFilter();
    }

    @Override
    public boolean isParentChildHierarchiesSupported(PushdownManager pushdownManager) {
        return false;
    }

    @Override
    public boolean isCubeEnabledForPushdown(String cubeName) {
        return PushdownUtility.getPushdownEnabledForCube(cubeName);
    }

    @Override
    public void logCancelExplanation(String explanation) {
        if (explanation != null && ROLAPLog.isOn("ROLAPQuery.Performance", LogLevel.TRACE)) {
            ROLAPLog.log("ROLAPQuery.Performance", "Pushdown not applicable: " + explanation);
        }
    }

    @Override
    public boolean executeImpl(QueryStrategy qs, Object oSetToFetch, IMember[] measuresMembers, IResultSet resultSet, Object blockStorage) throws InterpreterException {
        ISet setToFetch = (ISet)oSetToFetch;
        ROLAPQueryStrategy rqs = (ROLAPQueryStrategy)qs;
        PushdownManager pushdownManager = rqs.getPushdownManager();
        String functionName = pushdownManager.getTopPushdownFunctionName();
        ROLAPQueryExecuteMetrics queryMetrics = rqs.getLastQueryMetrics();
        if (this.isSetValidForPushdown(pushdownManager, setToFetch.size(), measuresMembers)) {
            int i;
            if (setToFetch.isEmpty()) {
                return true;
            }
            ISet contexts = (ISet)pushdownManager.getParameter(functionName, "contexts");
            long numContexts = 1L;
            if (contexts != null && !contexts.isEmpty()) {
                numContexts = contexts.size();
            }
            pushdownManager.setParameter(functionName, "setSize", setToFetch.size() / numContexts);
            ROLAPCube cube = (ROLAPCube)rqs.getCube();
            IBlockTupleStorage aggCache = cube.getAggregateCache();
            setToFetch = rqs.populateResultSetFromCache(setToFetch, resultSet, (IBlockTupleStorage)blockStorage, aggCache, queryMetrics, cube);
            if (setToFetch == null || setToFetch.isEmpty()) {
                return true;
            }
            ISet[] partitionedSets = PushdownUtility.partitionMultiContextSetByContext(setToFetch, contexts);
            SetSelections[] partitionedSelSets = new SetSelections[partitionedSets.length];
            for (i = 0; i < partitionedSets.length; ++i) {
                SetSelections partitionedSelSet;
                partitionedSelSets[i] = partitionedSelSet = new SetSelections(partitionedSets[i]);
                this.checkForMultipleDataQueries(qs, pushdownManager, partitionedSelSet);
                if (!qs.getPushDownMode()) break;
            }
            if (qs.getPushDownMode()) {
                if (resultSet.isPipelining()) {
                    pushdownManager.setPushdownExecutionFinished(true);
                }
                for (i = 0; i < partitionedSelSets.length; ++i) {
                    rqs.executeColdCacheToTupleStorage(partitionedSelSets[i], resultSet, (IBlockTupleStorage)blockStorage, queryMetrics, QueryType.USER_REPORT_QUERY);
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public Block executeImpl(String queryString, String contextInfo, List<Level> levelList, InterpreterContext interpreterContext, PushdownManager pushdownManager, boolean customValuePushdown) throws Exception {
        return null;
    }

    private void checkForMultipleDataQueries(QueryStrategy qs, PushdownManager pushdownManager, SetSelections partitionedSelSet) {
        Hierarchy[] hierarchies = ((Cube)qs.getCube()).getHierarchies().toArray(new Hierarchy[0]);
        Collection<IMember>[] selectionsByHierarchy = partitionedSelSet.getSelections(hierarchies);
        for (int j = 0; j < hierarchies.length && qs.getPushDownMode(); ++j) {
            IMember[] hierSels;
            int selectionsSize = selectionsByHierarchy[j].size();
            if (selectionsSize <= 1) continue;
            if (hierarchies[j].isParentChild()) {
                pushdownManager.handleParentChildHierarchies();
                continue;
            }
            if (this.isMultipleDataQueriesSupported(pushdownManager) || AggregationUtils.sameLevel(hierSels = selectionsByHierarchy[j].toArray(new IMember[selectionsSize]))) continue;
            pushdownManager.handleMultipleDataQueries();
        }
    }

    private boolean isSetValidForPushdown(PushdownManager pushdownManager, long setSize, IMember[] measuresMembers) {
        String reason = null;
        if (setSize < PushdownUtility.getPushDownSizeThreshold()) {
            reason = "set size (" + setSize + ") is smaller than the threshold (" + PushdownUtility.getPushDownSizeThreshold() + ").";
        } else if (measuresMembers.length != 1) {
            reason = "only one measure may appear in the set. Measure count was " + measuresMembers.length + ".";
        } else if (((ROLAPMeasure)measuresMembers[0]).isSemiAggregate()) {
            reason = "semi-aggregate measures are unsupported for pushdown.";
        } else if (((IMeasure)measuresMembers[0]).getRegularAggregate() == AggregateTypeEnum.UNKNOWN) {
            reason = "pushdown not supported for measures with unknown aggregate type.";
        }
        if (reason != null) {
            this.logCancelExplanation(reason);
            pushdownManager.resetQsPushdownManager();
        }
        return reason == null;
    }

    @Override
    public void generatePushdownV5Expression(List<IMember> measureSelections, PlanningEnvironment planEnv, IXQEQueryNode query, IXQEQueryNode selection, IXQEQueryNode groupBody, PushdownManager pushdownManager) {
        XQENodeFactory nodeFactory = planEnv.getNodeFactory();
        String key = "RO";
        ROLAPMeasure measure = (ROLAPMeasure)measureSelections.get(0);
        ROLAPMetaMeasure metaMeasure = measure.getROLAPMetaMeasure();
        if (pushdownManager.isFilter()) {
            String functionName = pushdownManager.getTopPushdownFunctionName();
            FilterPushdownUtility.generateFilterExpression(key, (V5Query)query, nodeFactory, metaMeasure.getName(), (List)pushdownManager.getParameter(functionName, "comparisonExpression"), (Integer)pushdownManager.getParameter(functionName, "booleanOperator"));
        } else {
            TopBottomCountPushdownUtility.generateOrderExpression(key, (V5Query)query, (V5GroupBody)groupBody, nodeFactory, metaMeasure.getName(), !pushdownManager.isBottomCount());
        }
    }

    public void cachePushdownResult(IBlockTupleStorage blockTupleStorage, ROLAPQueryStrategy.TupleValueIterator result, SetSelections setToFetch, QueryStrategy qs) throws InterpreterException {
        Double tmpCount = null;
        Comparator c = null;
        PushdownManager pdm = qs.getPushdownManager();
        boolean topCount = pdm.isTopCount();
        boolean topSum = pdm.isTopSum();
        boolean bottomCount = pdm.isBottomCount();
        boolean filter = pdm.isFilter();
        String functionName = pdm.getTopPushdownFunctionName();
        tmpCount = (Double)pdm.getParameter(functionName, "count");
        c = (Comparator)pdm.getParameter(functionName, "nullHandling");
        long count = -1L;
        if (tmpCount != null) {
            count = tmpCount.intValue();
        }
        double totalSoFar = 0.0;
        boolean goalAchieved = false;
        boolean fetchall = filter;
        long prevCellCount = result.getNumResultSetCellsAdded();
        double prevVal = Double.NaN;
        Cell nll = new Cell(DoubleValue.NULL_VALUE);
        ArrayList<TupleValue> tupleValues = new ArrayList<TupleValue>();
        ArrayList<Tuple> tuples = new ArrayList<Tuple>();
        while (result.hasNext()) {
            TupleValue tv = result.next();
            if (!fetchall) {
                if (goalAchieved) {
                    if (prevVal != tv.getCellValue()) {
                        break;
                    }
                } else {
                    prevVal = tv.getCellValue();
                    if (topSum) {
                        if (result.getNumResultSetCellsAdded() != prevCellCount) {
                            prevCellCount = result.getNumResultSetCellsAdded();
                            if ((totalSoFar += prevVal) >= (double)count && totalSoFar != 0.0) {
                                goalAchieved = true;
                            }
                        }
                    } else if (topCount || bottomCount) {
                        boolean bl = goalAchieved = result.getNumResultSetCellsAdded() >= count;
                    }
                    fetchall = bottomCount ? c.compare(tv.getCell(), nll) <= 0 : c.compare(tv.getCell(), nll) >= 0;
                }
            }
            tupleValues.add(tv);
            tuples.add(tv.getTuple());
        }
        pdm.setParameter(functionName, "filterNulls", goalAchieved);
        if (blockTupleStorage != null) {
            boolean nonPushdownResultsFetched = !filter && !goalAchieved;
            List<IHierarchy> hiers = ((Cube)qs.getCube()).getHierarchies();
            IHierarchy[] cubeHiers = hiers.toArray(new IHierarchy[hiers.size()]);
            if (nonPushdownResultsFetched) {
                blockTupleStorage.putTupleValues(setToFetch.getSet(cubeHiers), tupleValues.iterator());
            } else if (!tuples.isEmpty()) {
                Set topCountSet = new Set(tuples.toArray(new Tuple[tuples.size()]));
                CrossJoinedSet cjSet = BlockTupleStorageUtil.createCjsFromMemberSelections(topCountSet.getMembers(cubeHiers));
                if (cjSet.size() == topCountSet.size()) {
                    blockTupleStorage.putTupleValues(topCountSet, tupleValues.iterator());
                } else {
                    XQEDebugLog.out.println("Unable to commit pushdown result to cache.");
                }
            }
        }
        if (count >= 0L && fetchall) {
            pdm.logCancelExplanation("Unable to infer null ordering. Fetched all non-null values.");
        }
    }
}

