/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.querytemplates;

import com.cognos.xqe.ast.olap.MDXDimensionProperties;
import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.config.XQEConfiguration;
import com.cognos.xqe.config.XQEConfigurationManager;
import com.cognos.xqe.data.providers.DataSourceTypeEnum;
import com.cognos.xqe.metadata.IAliasEntry;
import com.cognos.xqe.metadata.ICube;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.runtree.olap.querytemplates.CustomQuery;
import com.cognos.xqe.runtree.olap.querytemplates.MissingMemberValidateQuery;
import com.cognos.xqe.util.xml.XMLEscCharacter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.velocity.VelocityContext;
import org.dom4j.Element;

public class AncestorQuery
extends CustomQuery {
    private static final String MEMBER_LIST = "MEMBER_LIST";
    private static final String HIERARCHY_NAME = "HIERARCHY_NAME";
    private static final String MEASURE_HIERARCHY_NAME = "MEASURE_HIERARCHY_NAME";
    private static final String CUBE_NAME = "CUBE_NAME";
    private static final String DIMENSION_PROPERTIES = "DIMENSION_PROPERTIES";
    public static final String TYPE_NAME = "AncestorQuery";
    private static final String TEMPLATE_PATH = "com/cognos/xqe/runtree/olap/querytemplates/AncestorQuery";
    private String hierarchyName;
    private Set<String> memberNameSet;
    private static final String ALIAS_TABLE_MAP = "aliasTableMap";
    private static final String ALIAS_TABLE = "aliasTable";
    private static final String LANG = " lang=";
    private static final String NAME = " name=";
    private static final String GT_OPERATOR = ">";
    private static final String LT_OPERATOR = "<";
    private static final String QUOTE = "\"";
    private static final String SLASH = "/";
    private MDXDimensionProperties dimensionProperties = null;
    private List<IAliasEntry> aliasTable = null;

    protected AncestorQuery(ICube aCube) {
        super(aCube);
        this.setEscapeParameters(true);
    }

    @Override
    protected VelocityContext constructContext() {
        VelocityContext context = new VelocityContext();
        if (this.hierarchyName == null || this.hierarchyName.equals("")) {
            throw new IllegalStateException("hierarchyName == null || hierarchyName.equals('')");
        }
        if (this.memberNameSet == null) {
            throw new IllegalStateException("memberNameSet == null");
        }
        if (this.getReferencedCube() == null) {
            throw new IllegalStateException("getReferencedCube() == null");
        }
        if (this.dimensionProperties == null) {
            throw new IllegalStateException("dimensionProperties == null");
        }
        context.put(MEASURE_HIERARCHY_NAME, (Object)this.getReferencedCube().getMeasuresHierarchy().getUniqueName());
        boolean isTM1102Compatible = false;
        XQEConfiguration config = XQEConfigurationManager.getInstance().getConfiguration(ServiceEnumeration.XQE);
        if (config != null) {
            isTM1102Compatible = config.getBooleanProperty("TM1_102CompatibilityMode", false);
        }
        if (isTM1102Compatible || !DataSourceTypeEnum.isTM(this.getDataSourceType())) {
            context.put(HIERARCHY_NAME, (Object)this.hierarchyName);
        }
        context.put(CUBE_NAME, (Object)this.getReferencedCube().getUniqueName());
        int numMembers = this.memberNameSet.size();
        ArrayList<String> convertedList = new ArrayList<String>(numMembers);
        if (!(this.getDataSourceType().equals("PC") || this.getDataSourceType().equals("TM") || this.getDataSourceType().equals("TMR"))) {
            convertedList.addAll(this.memberNameSet);
            context.put(MEMBER_LIST, convertedList);
            context.put(DIMENSION_PROPERTIES, (Object)this.dimensionProperties.toString());
        } else {
            Iterator<String> iterator = this.memberNameSet.iterator();
            while (iterator.hasNext()) {
                String mun;
                String newMun = mun = iterator.next();
                if (this.isEscapeParameters()) {
                    newMun = XMLEscCharacter.escapeString(mun);
                    newMun = MissingMemberValidateQuery.escapeSquareBrackets(newMun);
                }
                if (DataSourceTypeEnum.isTM1(this.getDataSourceType()) || DataSourceTypeEnum.isTMR(this.getDataSourceType())) {
                    newMun = newMun.replaceAll("\\.\\[@MEMBER\\]", "");
                }
                convertedList.add(newMun);
            }
            context.put(MEMBER_LIST, convertedList);
            if (this.getDataSourceType().equals("TM") || DataSourceTypeEnum.isTMR(this.getDataSourceType())) {
                context.put(DIMENSION_PROPERTIES, (Object)this.dimensionProperties.toString());
            } else {
                context.put(DIMENSION_PROPERTIES, (Object)this.dimensionProperties.dumpFormattedXMLQueryString());
            }
        }
        if (this.aliasTable != null) {
            StringBuilder buffer = new StringBuilder();
            buffer.append(LT_OPERATOR);
            buffer.append(ALIAS_TABLE_MAP);
            buffer.append(GT_OPERATOR);
            for (IAliasEntry entry : this.aliasTable) {
                buffer.append(LT_OPERATOR);
                buffer.append(ALIAS_TABLE);
                buffer.append(LANG);
                buffer.append(QUOTE);
                buffer.append(entry.getKey());
                buffer.append(QUOTE);
                buffer.append(NAME);
                buffer.append(QUOTE);
                buffer.append(XMLEscCharacter.escapeString(entry.getValue()));
                buffer.append(QUOTE);
                buffer.append(SLASH);
                buffer.append(GT_OPERATOR);
            }
            buffer.append(LT_OPERATOR);
            buffer.append(SLASH);
            buffer.append(ALIAS_TABLE_MAP);
            buffer.append(GT_OPERATOR);
            context.put(ALIAS_TABLE_MAP, (Object)buffer);
        } else {
            context.put(ALIAS_TABLE_MAP, (Object)"");
        }
        return context;
    }

    @Override
    protected String getTemplateName() {
        return TEMPLATE_PATH;
    }

    @Override
    public void capture(PlanningEnvironment env, Element inputNode) {
        this.hierarchyName = inputNode.attributeValue("hierarchyName");
        this.memberNameSet = new HashSet<String>();
        List children = inputNode.elements("MemberName");
        for (int i = 0; i < children.size(); ++i) {
            String memberName = ((Element)children.get(i)).getText();
            if (memberName == null || memberName.equals("")) continue;
            this.memberNameSet.add(memberName);
        }
    }

    public void setHierarchyName(String aHierarchyName) {
        this.hierarchyName = aHierarchyName;
    }

    public void setMemberNameList(Set<String> set) {
        this.memberNameSet = new HashSet<String>();
        XQEConfiguration config = XQEConfigurationManager.getInstance().getConfiguration(ServiceEnumeration.XQE);
        boolean isTM1102Compatible = false;
        if (config != null) {
            isTM1102Compatible = config.getBooleanProperty("TM1_102CompatibilityMode", false);
        }
        if (isTM1102Compatible || !DataSourceTypeEnum.isTM(this.getDataSourceType())) {
            for (String memberName : set) {
                if (memberName == null || memberName.equals("")) continue;
                this.memberNameSet.add(memberName);
            }
        } else {
            for (String memberName : set) {
                if (memberName == null || memberName.equals("")) continue;
                StringBuilder sb = new StringBuilder(memberName);
                sb.append(".ANCESTORS");
                this.memberNameSet.add(sb.toString());
            }
        }
    }

    public void setDimensionProperties(MDXDimensionProperties aDimensionProperties) {
        this.dimensionProperties = aDimensionProperties;
    }

    @Override
    public void setAliasTable(List<IAliasEntry> aliasTableMap) {
        this.aliasTable = aliasTableMap;
    }
}

