/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.querytemplates;

import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.olap.MDXQuery;
import com.cognos.xqe.bibushandler.RequestEnvironment;
import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.config.XQEConfiguration;
import com.cognos.xqe.config.XQEConfigurationManager;
import com.cognos.xqe.data.model.IDataSource;
import com.cognos.xqe.data.providers.DataSourceTypeEnum;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.ICube;
import com.cognos.xqe.query.engine.ExecutionEnvironment;
import com.cognos.xqe.query.engine.MultiRequestContext;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.planner.QueryPlanner;
import com.cognos.xqe.resultset.interfaces.IHybridResultSet;
import com.cognos.xqe.resultsets.md.CacheHints;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.runtree.olap.XMdx;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqe.trace.XQELogger;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.util.FileUtil;
import com.cognos.xqe.util.StringSubstitutionEngine;
import com.cognos.xqe.util.context.ExecutionEnvironmentContext;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.Velocity;
import org.apache.velocity.context.Context;
import org.apache.velocity.runtime.log.LogSystem;
import org.dom4j.Element;

public abstract class CustomQuery
extends MDXQuery {
    public static final String TM1_102_COMPATIBILITY_MODE = "TM1_102CompatibilityMode";
    protected boolean escapeParameters = false;
    private static final String DOT_TEMPLATE = ".template";
    private String mdx;
    private final ICube cube;
    private final String dataSourceType;
    private static XQELogger mErrorLogger;

    public CustomQuery(ICube aCube) {
        this.cube = aCube;
        this.dataSourceType = aCube.getModelDataSource().getInterface();
    }

    protected final InputStream loadTemplate() {
        ClassLoader classLoader = this.getClass().getClassLoader();
        InputStream stream = classLoader.getResourceAsStream(this.getProviderTemplateFilename());
        if (null != stream) {
            return stream;
        }
        stream = classLoader.getResourceAsStream(this.getGenericTemplateFilename());
        if (null == stream) {
            throw new XQERuntimeException(XQEMessageKeys.EXE_MDXQueryTemplateNotFound, this.getGenericTemplateFilename());
        }
        return stream;
    }

    private String getProviderTemplateFilename() {
        StringBuilder buf = new StringBuilder();
        XQEConfiguration config = XQEConfigurationManager.getInstance().getConfiguration(ServiceEnumeration.XQE);
        boolean isTM1102Compatible = false;
        if (config != null) {
            isTM1102Compatible = config.getBooleanProperty(TM1_102_COMPATIBILITY_MODE, false);
        }
        buf.append(this.getTemplateName());
        buf.append('_');
        if (!isTM1102Compatible && DataSourceTypeEnum.isTM(this.getDataSourceType())) {
            buf.append("Native_");
        }
        buf.append(this.dataSourceType);
        buf.append(DOT_TEMPLATE);
        return buf.toString();
    }

    private String getGenericTemplateFilename() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.getTemplateName());
        buf.append(DOT_TEMPLATE);
        return buf.toString();
    }

    protected abstract String getTemplateName();

    protected abstract VelocityContext constructContext();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void compileTemplate() {
        InputStream inStream = this.loadTemplate();
        try {
            InputStreamReader reader = new InputStreamReader(inStream, "UTF-8");
            StringWriter writer = new StringWriter();
            Velocity.evaluate((Context)this.constructContext(), (Writer)writer, (String)"MDX template", (Reader)reader);
            writer.flush();
            this.mdx = StringSubstitutionEngine.removeCStyleComments(writer.toString());
            XQEConfiguration config = XQEConfigurationManager.getInstance().getConfiguration(ServiceEnumeration.XQE);
            boolean isTM1102Compatible = true;
            if (config != null) {
                isTM1102Compatible = config.getBooleanProperty(TM1_102_COMPATIBILITY_MODE, false);
            }
            if (!isTM1102Compatible && DataSourceTypeEnum.isTM(this.getDataSourceType())) {
                StringBuilder buf = new StringBuilder();
                buf.append("NativeTM1Query:");
                String mdxNoAtMember = this.mdx.replaceAll("\\.\\[@MEMBER\\]", "");
                buf.append(mdxNoAtMember);
                this.mdx = buf.toString();
            }
        }
        catch (IllegalStateException ise) {
            this.mdx = null;
        }
        catch (Exception ex) {
            mErrorLogger.log(ex);
            this.mdx = null;
        }
        finally {
            try {
                inStream.close();
            }
            catch (IOException ex) {
                mErrorLogger.log(ex);
            }
        }
    }

    @Override
    public final String getMDX() {
        if (this.mdx == null) {
            this.compileTemplate();
        }
        return this.mdx;
    }

    public boolean isEscapeParameters() {
        return this.escapeParameters;
    }

    public void setEscapeParameters(boolean value) {
        this.escapeParameters = value;
    }

    public void capture(PlanningEnvironment env, Element inputNode) {
    }

    @Override
    public ICube getReferencedCube() {
        if (null != this.cube) {
            return this.cube;
        }
        return super.getReferencedCube();
    }

    @Override
    public void dump(XQETrace trace, boolean includeRuntimeSpecifics) {
        String className = FileUtil.parseClassName(this.getClass().getName());
        trace.beginElement("subquery", -1);
        trace.attribute("classname", className);
        trace.endElement();
    }

    @Override
    public void dumpFormattedXMLQuery(XQETrace trace) {
        if (this.mdx == null) {
            this.compileTemplate();
        }
        if (this.mdx == null) {
            String className = FileUtil.parseClassName(this.getClass().getName());
            trace.beginElement(className, -1);
            trace.endElement();
        } else if ("PC".equals(this.dataSourceType) || "TM".equals(this.dataSourceType)) {
            trace.writeXML(this.mdx);
        } else {
            trace.beginElement("statement", -1);
            String catalogName = "";
            if (this.getReferencedCube().getCatalog() != null) {
                catalogName = this.getReferencedCube().getCatalog().getName();
            }
            trace.attribute("catalog", catalogName);
            trace.data(this.mdx);
            trace.endElement();
        }
    }

    @Override
    public String getDataSourceType() {
        return this.dataSourceType;
    }

    public IHybridResultSet execute(XDataContext dataContext) {
        ExecutionEnvironment execEnv = (ExecutionEnvironment)dataContext.getEnvironment();
        PlanningEnvironment planEnv = QueryPlanner.setupEnvironment(execEnv.getRequestEnvironment(), false);
        XQENodeFactory nodeFactory = planEnv.getNodeFactory();
        XMdx xMdxNode = (XMdx)nodeFactory.createNode(501017);
        return this.execute(dataContext, xMdxNode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IHybridResultSet execute(XDataContext dataContext, XMdx mdxNode) {
        ExecutionEnvironment execEnv = (ExecutionEnvironment)dataContext.getEnvironment();
        MultiRequestContext originalMultiReqCtx = execEnv.getMultiRequestContext();
        RequestEnvironment newReqEnv = ((RequestEnvironment)execEnv.getRequestEnvironment()).duplicate();
        ExecutionEnvironment newExecEnv = (ExecutionEnvironment)newReqEnv.getExecutionEnvironment();
        IDataSource dataSource = newExecEnv.getOrAddDataSource(this.getReferencedCube());
        mdxNode.setDataSource(dataSource);
        mdxNode.setMDXQuery(this);
        mdxNode.setCube(this.getReferencedCube().getName());
        if (this.getReferencedCube().getCatalog() != null) {
            mdxNode.setCatalog(this.getReferencedCube().getCatalog().getName());
        }
        this.compileTemplate();
        mdxNode.setCacheHints(CacheHints.cacheNone());
        ExecutionEnvironmentContext executionEnvironmentContext = ExecutionEnvironmentContext.enter(newExecEnv);
        originalMultiReqCtx.incrementRefCount();
        IHybridResultSet result = null;
        try {
            XDataContext newDataContext = newExecEnv.pushDataContext();
            try {
                result = (IHybridResultSet)mdxNode.execute(newDataContext);
            }
            finally {
                newExecEnv.popDataContext(newDataContext);
            }
        }
        finally {
            originalMultiReqCtx.decrementRefCount();
            executionEnvironmentContext.exit();
        }
        return result;
    }

    static {
        try {
            Velocity.setProperty((String)"runtime.log.logsystem", (Object)new MyVelocityLogger());
            Velocity.init();
        }
        catch (Exception ex) {
            throw XQERuntimeException.wrap(ex);
        }
        mErrorLogger = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "Exception", LogLevel.ERROR);
    }

    private static final class MyVelocityLogger
    implements LogSystem {
        private MyVelocityLogger() {
        }

        public void logVelocityMessage(int level, String message) {
            LogLevel logLevel = MyVelocityLogger.convertLevel(level);
            XQELogger logger = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "3rdParty", LogLevel.TRACE);
            if (logger.isOn(logLevel)) {
                logger.log(logLevel, message);
            }
        }

        private static LogLevel convertLevel(int level) {
            return LogLevel.valueOf(level);
        }
    }
}

