/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.relational;

import com.cognos.xqe.ast.XQEPersistContext;
import com.cognos.xqe.ast.XQERestoreContext;
import com.cognos.xqe.bibushandler.OperationCanceledException;
import com.cognos.xqe.data.values.DataValueFactory;
import com.cognos.xqe.data.values.IRow;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.data.values.RowValue;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.resultset.interfaces.IExecutable;
import com.cognos.xqe.resultset.interfaces.IRowsetInfo;
import com.cognos.xqe.resultset.interfaces.IScrollableIterator;
import com.cognos.xqe.resultset.interfaces.ITabularIterator;
import com.cognos.xqe.resultset.interfaces.ITabularResultSet;
import com.cognos.xqe.resultsets.tabular.ColumnInfo;
import com.cognos.xqe.resultsets.tabular.RowsetInfo;
import com.cognos.xqe.resultsets.tabular.TabularHybridResultSet;
import com.cognos.xqe.runtree.IXExpression;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.runtree.XNode;
import com.cognos.xqe.runtree.XNodeFactory;
import com.cognos.xqe.runtree.XResultSetBase;
import com.cognos.xqe.runtree.XTabularIterator;
import com.cognos.xqe.runtree.XTabularResultSet;
import com.cognos.xqe.runtree.relational.XExpression;
import com.cognos.xqe.runtree.relational.XSetFunction;
import com.cognos.xqe.runtree.relational.olapengine.ClassicColumnStorageFactory;
import com.cognos.xqe.runtree.relational.olapengine.IColumnStorage;
import com.cognos.xqe.runtree.relational.olapengine.IColumnStorageFactory;
import com.cognos.xqe.runtree.relational.olapengine.IWindowProcessor;
import com.cognos.xqe.runtree.relational.olapengine.IntermediateRowStorage;
import com.cognos.xqe.runtree.relational.olapengine.WindowDescriptor;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.util.IReleasable;
import java.util.Iterator;
import java.util.List;
import org.dom4j.Attribute;
import org.dom4j.Element;

public class XAggregate
extends XTabularResultSet {
    private static final long serialVersionUID = 1L;
    protected static final String ELEMENT_OUTPUTLIST = "OutputList";
    protected static final String ELEMENT_WINDOWLIST = "WindowList";
    protected static final String ELEMENT_WINDOWDESCRIPTOR = "WindowDescriptor";
    protected static final String ELEMENT_FUNCTIONLIST = "FunctionList";
    protected static final String ELEMENT_TEMPORARYROWLIST = "TemporaryRowList";
    protected static final String ELEMENT_DETAILLIST = "DetailList";
    protected static final String ELEMENT_COLUMN = "Column";
    protected static final String ATTRIBUTE_COLUMNNO = "columnNo";
    protected static final String ATTRIBUTE_KEYSETLENGTH = "KeySetLength";
    protected static final String ATTRIBUTE_PARTITIONBYLENGTH = "PartitionByLength";
    protected static final int MIN_PAGE_SIZE = 1024;
    protected static final int MIN_BUFFER_SIZE = 0x100000;
    protected IXExpression[] outputList;
    private XSetFunction[] functionList;
    private WindowDescriptor[] windowList;
    private int[] inputToIntermediateMap;
    private int keySetLength;

    @Override
    protected IValue executeImpl(XDataContext context) {
        return new TabularHybridResultSet(context, new XAggregateResultSet(context), this.getId());
    }

    @Override
    public int getType() {
        return 501093;
    }

    @Override
    public void dumpExtraInfo(XQETrace trace, boolean includeRuntimeSpecifics) {
        int i;
        super.dumpExtraInfo(trace, includeRuntimeSpecifics);
        trace.beginElement(ELEMENT_OUTPUTLIST, -1);
        for (i = 0; i < this.outputList.length; ++i) {
            this.outputList[i].dump(trace);
        }
        trace.endElement();
        trace.beginElement(ELEMENT_FUNCTIONLIST);
        for (i = 0; i < this.functionList.length; ++i) {
            this.functionList[i].dump(trace);
        }
        trace.endElement();
        trace.beginElement(ELEMENT_WINDOWLIST);
        for (i = 0; i < this.getWindowList().length; ++i) {
            trace.beginElement(ELEMENT_WINDOWDESCRIPTOR);
            this.getWindowList()[i].dumpExtraInfo(trace);
            trace.endElement();
        }
        trace.endElement();
        trace.beginElement(ELEMENT_TEMPORARYROWLIST);
        trace.attribute(ATTRIBUTE_KEYSETLENGTH, this.keySetLength);
        for (i = 0; i < this.inputToIntermediateMap.length; ++i) {
            trace.beginElement(ELEMENT_COLUMN);
            trace.attribute(ATTRIBUTE_COLUMNNO, this.inputToIntermediateMap[i]);
            trace.endElement();
        }
        trace.endElement();
    }

    @Override
    public void capture(PlanningEnvironment env, Element inputNode) {
        XNode xNode;
        int i;
        XNodeFactory nodeFactory = (XNodeFactory)env.getNodeFactory();
        Iterator it = inputNode.elements().iterator();
        Element child = (Element)it.next();
        List exprList = child.elements();
        this.outputList = new XExpression[exprList.size()];
        for (i = 0; i < exprList.size(); ++i) {
            child = (Element)exprList.get(i);
            xNode = (XExpression)nodeFactory.createNodeByName(child.getName());
            xNode.capture(env, child);
            this.outputList[i] = xNode;
        }
        child = (Element)it.next();
        exprList = child.elements();
        this.functionList = new XSetFunction[exprList.size()];
        for (i = 0; i < exprList.size(); ++i) {
            child = (Element)exprList.get(i);
            xNode = (XSetFunction)nodeFactory.createNodeByName(child.getName());
            ((XSetFunction)xNode).capture(env, child);
            this.functionList[i] = xNode;
        }
        child = (Element)it.next();
        exprList = child.elements();
        this.setWindowList(new WindowDescriptor[exprList.size()]);
        for (i = 0; i < exprList.size(); ++i) {
            child = (Element)exprList.get(i);
            WindowDescriptor node = new WindowDescriptor();
            node.capture(env, child);
            this.getWindowList()[i] = node;
        }
        child = (Element)it.next();
        Attribute tempAttr = child.attribute(ATTRIBUTE_KEYSETLENGTH);
        this.keySetLength = Integer.valueOf(tempAttr.getValue());
        exprList = child.elements();
        if (exprList != null) {
            this.inputToIntermediateMap = new int[exprList.size()];
            for (int i2 = 0; i2 < exprList.size(); ++i2) {
                child = (Element)exprList.get(i2);
                this.inputToIntermediateMap[i2] = Integer.valueOf(child.attributeValue(ATTRIBUTE_COLUMNNO));
            }
        } else {
            this.inputToIntermediateMap = new int[0];
        }
        child = (Element)it.next();
        XNode xChild = (XNode)nodeFactory.createNodeByName(child.getName());
        xChild.capture(env, child);
        this.addChild(xChild);
    }

    public void setOutputList(XExpression[] theOutputList) {
        this.outputList = theOutputList;
    }

    public void setWindowList(WindowDescriptor[] theWindowList) {
        this.windowList = theWindowList;
    }

    public WindowDescriptor[] getWindowList() {
        return this.windowList;
    }

    public void setFunctionList(XSetFunction[] theFunctionList) {
        this.functionList = theFunctionList;
    }

    public XSetFunction[] getFunctionList() {
        return this.functionList;
    }

    public void setInputToIntermediateMap(int[] theInputToIntermediateMap) {
        this.inputToIntermediateMap = theInputToIntermediateMap;
    }

    public int[] getInputToIntermediateMap() {
        return this.inputToIntermediateMap;
    }

    public void setKeySetLength(int theKeySetLength) {
        this.keySetLength = theKeySetLength;
    }

    public int getKeySetLength() {
        return this.keySetLength;
    }

    @Override
    protected void persistAttributeProperties(XQEPersistContext ctx) {
        super.persistAttributeProperties(ctx);
        ctx.property(ATTRIBUTE_KEYSETLENGTH, this.keySetLength);
    }

    @Override
    protected void persistElementProperties(XQEPersistContext ctx) {
        super.persistElementProperties(ctx);
        if (this.outputList != null) {
            ctx.elementProperty(ELEMENT_OUTPUTLIST, this.outputList);
        }
        if (this.functionList != null) {
            ctx.elementProperty(ELEMENT_FUNCTIONLIST, this.functionList);
        }
        if (this.windowList != null) {
            ctx.elementProperty(ELEMENT_WINDOWLIST, this.windowList);
        }
        if (this.inputToIntermediateMap != null) {
            ctx.elementProperty(ELEMENT_TEMPORARYROWLIST, this.inputToIntermediateMap);
        }
    }

    @Override
    protected void restoreAttributeProperty(XQERestoreContext ctx, Attribute att, Element inputNode) {
        String attname = att.getName();
        if (attname.equals(ATTRIBUTE_KEYSETLENGTH)) {
            Object val = ctx.attributeValue(att);
            this.keySetLength = (Integer)val;
        } else {
            super.restoreAttributeProperty(ctx, att, inputNode);
        }
    }

    @Override
    protected void restoreElementProperty(XQERestoreContext ctx, Element node, Element inputNode) {
        String pname = node.attributeValue("pname");
        if (pname.equals(ELEMENT_OUTPUTLIST)) {
            Object val = ctx.elementValue(node);
            this.outputList = (IXExpression[])val;
        } else if (pname.equals(ELEMENT_FUNCTIONLIST)) {
            Object val = ctx.elementValue(node);
            this.functionList = (XSetFunction[])val;
        } else if (pname.equals(ELEMENT_WINDOWLIST)) {
            Object val = ctx.elementValue(node);
            this.windowList = (WindowDescriptor[])val;
        } else if (pname.equals(ELEMENT_TEMPORARYROWLIST)) {
            Object val = ctx.elementValue(node);
            this.inputToIntermediateMap = (int[])val;
        } else {
            super.restoreElementProperty(ctx, node, inputNode);
        }
    }

    protected class XAggregateResultSet
    extends XResultSetBase
    implements ITabularResultSet {
        protected ITabularResultSet iResultSet;
        private RowsetInfo tRowsetInfo;

        public XAggregateResultSet(XDataContext context) {
            int i;
            super(context, XAggregate.this.getId());
            this.iResultSet = (ITabularResultSet)((IExecutable)((Object)XAggregate.this.getChild(0))).execute(this.getDataContext());
            RowsetInfo iRowsetInfo = (RowsetInfo)this.iResultSet.getTabularRowsetInfo();
            for (XSetFunction function : XAggregate.this.functionList) {
                function.open(context, iRowsetInfo);
            }
            this.tRowsetInfo = new RowsetInfo();
            for (i = 0; i < XAggregate.this.inputToIntermediateMap.length; ++i) {
                String name = i < XAggregate.this.keySetLength ? "CP" + i : "CD" + (i - XAggregate.this.keySetLength);
                this.tRowsetInfo.addColumnInfo(new ColumnInfo(name, iRowsetInfo.getColumnInfo(XAggregate.this.inputToIntermediateMap[i]).getDataType()));
            }
            for (i = 0; i < XAggregate.this.functionList.length; ++i) {
                this.tRowsetInfo.addColumnInfo(new ColumnInfo("CF" + i, XAggregate.this.functionList[i].getDataType()));
            }
            this.rowsetInfo = new RowsetInfo();
            for (i = 0; i < XAggregate.this.outputList.length; ++i) {
                IXExpression oNode = XAggregate.this.outputList[i];
                ColumnInfo columnInfo = new ColumnInfo(oNode.getName(this.tRowsetInfo, -1), oNode.getDataType(this.tRowsetInfo, -1));
                this.rowsetInfo.addColumnInfo(columnInfo);
            }
        }

        @Override
        public IScrollableIterator getScrollableTabularIterator() {
            throw new UnsupportedOperationException();
        }

        @Override
        public ITabularIterator getTabularIterator() {
            return new XAggregateIterator(this.getDataContext());
        }

        @Override
        public void releaseImpl() {
            if (this.iResultSet != null) {
                this.iResultSet.release();
                this.iResultSet = null;
            }
            for (XSetFunction function : XAggregate.this.functionList) {
                function.close(this.getDataContext());
            }
            this.rowsetInfo = null;
        }

        protected class XAggregateIterator
        extends XTabularIterator {
            private RowValue intermediateRow;
            private IteratorBuffer tabItBuf;
            private IRow result;
            private IWindowProcessor[] windowProcessors;
            private IColumnStorage[] columnStorage;
            private IColumnStorageFactory factory;

            protected XAggregateIterator(XDataContext context) {
                super(context, XAggregate.this.getId());
                try {
                    this.startTimer();
                    this.tabItBuf = new IteratorBuffer(context, XAggregateResultSet.this.iResultSet);
                    this.intermediateRow = DataValueFactory.createRowValue(context.getLocalCollator(), XAggregateResultSet.this.tRowsetInfo);
                    this.result = DataValueFactory.createRowValue(XAggregateResultSet.this.rowsetInfo);
                }
                catch (RuntimeException e) {
                    this.release();
                    throw e;
                }
                finally {
                    this.stopTimer();
                }
            }

            private void generateWindowProcessors() {
                this.windowProcessors = new IWindowProcessor[XAggregate.this.windowList.length];
                this.columnStorage = new IColumnStorage[XAggregate.this.windowList.length];
                for (int i = 0; i < XAggregate.this.windowList.length; ++i) {
                    this.windowProcessors[i] = XAggregate.this.windowList[i].createWindowProcessor(this.context, XAggregate.this.functionList);
                }
                int base = XAggregate.this.inputToIntermediateMap.length;
                for (int i = 0; i < XAggregate.this.windowList.length; ++i) {
                    this.columnStorage[i] = this.windowProcessors[i].createColumnStorage(this.factory);
                    this.columnStorage[i].setBuffer(this.intermediateRow.getColumn(base + i));
                }
            }

            @Override
            public Object nextImpl() {
                int i;
                block6: {
                    if (this.context.isCanceled()) {
                        throw new OperationCanceledException(this.context.getCancelSource());
                    }
                    if (this.windowProcessors == null) {
                        int pageSize = 0x100000 / (XAggregate.this.keySetLength + XAggregate.this.functionList.length + 1);
                        pageSize = Math.min(1024, pageSize);
                        this.factory = new ClassicColumnStorageFactory(this.context, pageSize);
                        this.generateWindowProcessors();
                        this.tabItBuf.initialize(this.factory, this.intermediateRow);
                        this.tabItBuf.registerWindowProcessors(this.windowProcessors);
                    }
                    do {
                        boolean hasRow = true;
                        for (int i2 = 0; i2 < this.columnStorage.length && hasRow; ++i2) {
                            hasRow = !this.columnStorage[i2].isEmpty();
                        }
                        if (hasRow && this.tabItBuf.hasRow()) break block6;
                    } while (this.tabItBuf.processInput());
                    return null;
                }
                this.tabItBuf.getCurrentRow(this.intermediateRow);
                for (i = 0; i < this.columnStorage.length; ++i) {
                    this.columnStorage[i].retrieve();
                }
                this.context.pushRow(XAggregate.this.contextNo, this.intermediateRow);
                for (i = 0; i < XAggregate.this.outputList.length; ++i) {
                    this.result.setColumn(i, XAggregate.this.outputList[i].execute(this.context));
                }
                this.context.popRow();
                ++this.nRows;
                return this.result;
            }

            @Override
            public long getIndex() {
                return 0L;
            }

            @Override
            public void release() {
                if (this.tabItBuf != null) {
                    try {
                        this.tabItBuf.release();
                    }
                    catch (Exception ex) {
                        mErrorLogger.log(ex);
                    }
                    finally {
                        this.tabItBuf = null;
                    }
                }
                if (this.factory != null) {
                    try {
                        this.factory.release();
                    }
                    catch (Exception ex) {
                        mErrorLogger.log(ex);
                    }
                }
                this.result = null;
                super.release();
            }
        }
    }

    protected class IteratorBuffer
    implements IReleasable {
        private State stateBreakPoint;
        private State stateEndOfStream;
        private State stateInitial;
        private State stateInputIterated;
        private IRow resultRow;
        private IValue[] keySet;
        private int controlBreak;
        private IWindowProcessor[] registeredWindows;
        private XDataContext context;
        private State state;
        private IntermediateRowStorage intermediateRowStorage;
        protected XTabularIterator inputIterator;
        protected IRow currentRow;

        public IteratorBuffer(XDataContext theContext, ITabularResultSet iResultSet) {
            try {
                this.inputIterator = (XTabularIterator)iResultSet.getTabularIterator();
                this.context = theContext;
                this.stateBreakPoint = new StateBreakPoint();
                this.stateEndOfStream = new StateEndOfStream();
                this.stateInitial = new StateInitial();
                this.stateInputIterated = new StateInputIterated();
                this.state = this.stateInitial;
                IRowsetInfo rowsetInfo = iResultSet.getTabularRowsetInfo();
                this.keySet = new IValue[XAggregate.this.keySetLength];
                for (int i = 0; i < XAggregate.this.keySetLength; ++i) {
                    this.keySet[i] = rowsetInfo.getColumnInfo(XAggregate.this.inputToIntermediateMap[i]).getDataType().createValue(this.context.getLocalCollator());
                }
            }
            catch (RuntimeException e) {
                this.release();
                throw e;
            }
        }

        public void initialize(IColumnStorageFactory factory, IRow theResultRow) {
            this.resultRow = theResultRow;
            this.intermediateRowStorage = new IntermediateRowStorage();
            this.intermediateRowStorage.initialize(factory, this.resultRow, XAggregate.this.keySetLength, XAggregate.this.inputToIntermediateMap);
        }

        public void registerWindowProcessors(IWindowProcessor[] processors) {
            this.registeredWindows = processors;
        }

        boolean processInput() {
            return this.state.processEvent();
        }

        boolean getCurrentRow(RowValue row) {
            return this.state.getCurrentRow(row);
        }

        @Override
        public void release() {
            if (this.inputIterator != null) {
                this.inputIterator.release();
                this.inputIterator = null;
            }
        }

        public boolean hasRow() {
            return this.intermediateRowStorage.hasRow();
        }

        protected IRow getNextRow() {
            return (IRow)this.inputIterator.next();
        }

        private final class StateEndOfStream
        extends State {
            private StateEndOfStream() {
            }

            @Override
            public boolean processEvent() {
                return false;
            }

            @Override
            public boolean getCurrentRow(RowValue row) {
                IteratorBuffer.this.intermediateRowStorage.retrieve();
                return true;
            }
        }

        private final class StateBreakPoint
        extends State {
            private StateBreakPoint() {
            }

            @Override
            public boolean processEvent() {
                int i;
                for (i = 0; i < XAggregate.this.keySetLength; ++i) {
                    IteratorBuffer.this.keySet[i].copyFrom(IteratorBuffer.this.currentRow.getColumn(XAggregate.this.inputToIntermediateMap[i]));
                }
                IteratorBuffer.this.context.pushRow(XAggregate.this.contextNo, IteratorBuffer.this.currentRow);
                for (i = 0; i < IteratorBuffer.this.registeredWindows.length; ++i) {
                    IteratorBuffer.this.registeredWindows[i].iterate();
                }
                IteratorBuffer.this.context.popRow();
                IteratorBuffer.this.intermediateRowStorage.store(IteratorBuffer.this.currentRow, IteratorBuffer.this.controlBreak);
                IteratorBuffer.this.state = IteratorBuffer.this.stateInputIterated;
                return true;
            }

            @Override
            public boolean getCurrentRow(RowValue row) {
                IteratorBuffer.this.intermediateRowStorage.retrieve();
                return true;
            }
        }

        private final class StateInputIterated
        extends State {
            private StateInputIterated() {
            }

            @Override
            public boolean processEvent() {
                IteratorBuffer.this.currentRow = (IRow)IteratorBuffer.this.inputIterator.next();
                if (IteratorBuffer.this.currentRow == null) {
                    for (int i = 0; i < IteratorBuffer.this.registeredWindows.length; ++i) {
                        IteratorBuffer.this.registeredWindows[i].processBreak(-1);
                    }
                    IteratorBuffer.this.state = IteratorBuffer.this.stateEndOfStream;
                } else {
                    int i;
                    IteratorBuffer.this.controlBreak = XAggregate.this.keySetLength;
                    for (i = 0; i < XAggregate.this.keySetLength; ++i) {
                        if (IteratorBuffer.this.keySet[i].compareTo(IteratorBuffer.this.currentRow.getColumn(XAggregate.this.inputToIntermediateMap[i])) == 0) continue;
                        IteratorBuffer.this.controlBreak = i;
                        break;
                    }
                    if (IteratorBuffer.this.controlBreak < XAggregate.this.keySetLength) {
                        for (i = 0; i < IteratorBuffer.this.registeredWindows.length; ++i) {
                            IteratorBuffer.this.registeredWindows[i].processBreak(IteratorBuffer.this.controlBreak);
                        }
                        IteratorBuffer.this.state = IteratorBuffer.this.stateBreakPoint;
                    } else {
                        IteratorBuffer.this.context.pushRow(XAggregate.this.contextNo, IteratorBuffer.this.currentRow);
                        for (i = 0; i < IteratorBuffer.this.registeredWindows.length; ++i) {
                            IteratorBuffer.this.registeredWindows[i].iterate();
                        }
                        IteratorBuffer.this.context.popRow();
                        IteratorBuffer.this.intermediateRowStorage.store(IteratorBuffer.this.currentRow, IteratorBuffer.this.controlBreak);
                        IteratorBuffer.this.state = IteratorBuffer.this.stateInputIterated;
                    }
                }
                return true;
            }

            @Override
            public boolean getCurrentRow(RowValue row) {
                IteratorBuffer.this.intermediateRowStorage.retrieve();
                return true;
            }
        }

        private final class StateInitial
        extends State {
            private StateInitial() {
            }

            @Override
            public boolean processEvent() {
                int i;
                IteratorBuffer.this.currentRow = (IRow)IteratorBuffer.this.inputIterator.next();
                if (IteratorBuffer.this.currentRow == null) {
                    IteratorBuffer.this.state = IteratorBuffer.this.stateEndOfStream;
                    return false;
                }
                for (i = 0; i < XAggregate.this.keySetLength; ++i) {
                    IteratorBuffer.this.keySet[i].copyFrom(IteratorBuffer.this.currentRow.getColumn(XAggregate.this.inputToIntermediateMap[i]));
                }
                IteratorBuffer.this.context.pushRow(XAggregate.this.contextNo, IteratorBuffer.this.currentRow);
                for (i = 0; i < IteratorBuffer.this.registeredWindows.length; ++i) {
                    IteratorBuffer.this.registeredWindows[i].iterate();
                }
                IteratorBuffer.this.context.popRow();
                IteratorBuffer.this.intermediateRowStorage.store(IteratorBuffer.this.currentRow, 0);
                IteratorBuffer.this.state = IteratorBuffer.this.stateInputIterated;
                return true;
            }

            @Override
            public boolean getCurrentRow(RowValue row) {
                throw new FeatureNotImplemented("programming error - XAggregate - no current row to ask for");
            }
        }

        private abstract class State {
            private State() {
            }

            public abstract boolean processEvent();

            public abstract boolean getCurrentRow(RowValue var1);
        }
    }

    public static class FeatureNotImplemented
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        FeatureNotImplemented(String message) {
            super(message);
        }
    }
}

