/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.relational;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.data.DataTypeComparator;
import com.cognos.xqe.data.types.ArrayType;
import com.cognos.xqe.data.types.DataTypeFactory;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.data.values.ArrayValue;
import com.cognos.xqe.data.values.DataValueFactory;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.resultset.interfaces.IExecutable;
import com.cognos.xqe.resultset.interfaces.IRowsetInfo;
import com.cognos.xqe.runtree.IXExpression;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.runtree.relational.XExpression;

public class XArrayValueConstructor
extends XExpression {
    private static final long serialVersionUID = 1L;

    @Override
    protected IValue executeImpl(XDataContext context) {
        int nColumns = this.getNumberChildren();
        ArrayValue value = (ArrayValue)context.getValue(this);
        if (value == null) {
            value = (ArrayValue)context.setValue(this, DataValueFactory.createArrayValue((ArrayType)this.getDataType()));
        }
        for (int i = 0; i < nColumns; ++i) {
            value.setValue(i, ((IExecutable)((Object)this.getChild(i))).execute(context));
        }
        if (nColumns == 0) {
            value.set(new IValue[0]);
        }
        return value;
    }

    @Override
    public IDataType getDataType() {
        return this.getDataType(null, -1);
    }

    @Override
    public IDataType getDataType(IRowsetInfo rowsetInfo, int index) {
        if (this.dataType != null) {
            return this.dataType;
        }
        int nElements = this.getNumberChildren();
        IDataType elementType = null;
        for (IXQEQueryNode child : this.getChildren()) {
            IDataType tmpDataType = ((IXExpression)((Object)child)).getDataType(rowsetInfo, index);
            elementType = elementType == null ? tmpDataType : DataTypeComparator.getCompatibleType(elementType, tmpDataType);
        }
        this.dataType = DataTypeFactory.getArrayType(elementType, nElements);
        return this.dataType;
    }

    @Override
    public int getType() {
        return 501139;
    }
}

