/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.relational;

import com.cognos.xqe.ast.XQEPersistContext;
import com.cognos.xqe.ast.XQERestoreContext;
import com.cognos.xqe.bibushandler.OperationCanceledException;
import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.data.values.IRow;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.resultset.interfaces.ITabularIterator;
import com.cognos.xqe.resultset.interfaces.ITabularResultSet;
import com.cognos.xqe.resultsets.tabular.TabularHybridResultSet;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.runtree.XResultSetBase;
import com.cognos.xqe.runtree.XTabularIterator;
import com.cognos.xqe.runtree.XTabularResultSet;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqe.trace.XQELogger;
import com.cognos.xqe.trace.XQETrace;
import java.util.concurrent.BlockingQueue;
import org.dom4j.Attribute;
import org.dom4j.Element;

public class XDequeue
extends XTabularResultSet {
    private static final long serialVersionUID = 1L;
    private static final String ATTRIBUTE_QUEUENAME = "queueName";
    private String queueName;
    private static XQELogger mErrorLogger = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "Exception", LogLevel.ERROR);

    @Override
    protected IValue executeImpl(XDataContext context) {
        return new TabularHybridResultSet(context, new XDequeueResultSet(context), this.getId());
    }

    @Override
    public int getType() {
        return 501036;
    }

    public void setQueueName(String name) {
        this.queueName = name;
    }

    public String getQueueName() {
        return this.queueName;
    }

    @Override
    public void dumpExtraInfo(XQETrace trace, boolean includeRuntimeSpecifics) {
        trace.attribute(ATTRIBUTE_QUEUENAME, this.queueName);
    }

    @Override
    public void capture(PlanningEnvironment env, Element inputNode) {
        this.queueName = inputNode.attributeValue(ATTRIBUTE_QUEUENAME);
    }

    @Override
    protected void persistAttributeProperties(XQEPersistContext ctx) {
        super.persistAttributeProperties(ctx);
        ctx.property(ATTRIBUTE_QUEUENAME, this.queueName);
    }

    @Override
    protected void restoreAttributeProperty(XQERestoreContext ctx, Attribute att, Element inputNode) {
        String attname = att.getName();
        if (attname.equals(ATTRIBUTE_QUEUENAME)) {
            Object val = ctx.attributeValue(att);
            this.queueName = (String)val;
        } else {
            super.restoreAttributeProperty(ctx, att, inputNode);
        }
    }

    private final class XDequeueResultSet
    extends XResultSetBase
    implements ITabularResultSet {
        XDequeueResultSet(XDataContext context) {
            super(context, XDequeue.this.getId());
            super.setTabularRowsetInfo(context.getRowsetInfo(XDequeue.this.queueName));
        }

        @Override
        public ITabularIterator getTabularIterator() {
            return new XDequeueIterator(this.getDataContext());
        }

        @Override
        public void releaseImpl() {
            this.rowsetInfo = null;
        }

        private final class XDequeueIterator
        extends XTabularIterator {
            private BlockingQueue<IRow> queue;

            private XDequeueIterator(XDataContext context) {
                super(context, XDequeue.this.getId());
                this.queue = context.getQueue(XDequeue.this.queueName);
            }

            @Override
            public long getIndex() {
                return this.nRows;
            }

            @Override
            public Object nextImpl() {
                if (this.context.isCanceled()) {
                    throw new OperationCanceledException(this.context.getCancelSource());
                }
                if (this.queue.size() == 0) {
                    return null;
                }
                IRow row = null;
                try {
                    row = this.queue.take();
                }
                catch (InterruptedException e) {
                    mErrorLogger.log(e);
                    row = null;
                }
                ++this.nRows;
                return row;
            }

            @Override
            public void release() {
                this.queue = null;
                super.release();
            }
        }
    }
}

