/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.relational;

import com.cognos.xqe.bibushandler.OperationCanceledException;
import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.resultset.interfaces.IExecutable;
import com.cognos.xqe.resultset.interfaces.IHybridResultSet;
import com.cognos.xqe.resultset.interfaces.ITabularIterator;
import com.cognos.xqe.resultset.interfaces.ITabularResultSet;
import com.cognos.xqe.resultsets.tabular.TabularHybridResultSet;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.runtree.XResultSetBase;
import com.cognos.xqe.runtree.XTabularIterator;
import com.cognos.xqe.runtree.XTabularResultSet;
import com.cognos.xqe.runtree.relational.util.DuplicateEliminator;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqe.trace.XQELogger;

public class XDistinct
extends XTabularResultSet {
    private static final long serialVersionUID = 1L;
    private static XQELogger mErrorLogger = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "Exception", LogLevel.ERROR);

    @Override
    protected IValue executeImpl(XDataContext context) {
        return new TabularHybridResultSet(context, new XDistinctResultSet(context), this.getId());
    }

    @Override
    public int getType() {
        return 501022;
    }

    private final class XDistinctResultSet
    extends XResultSetBase
    implements ITabularResultSet {
        private IHybridResultSet iResultSet;

        XDistinctResultSet(XDataContext context) {
            super(context, XDistinct.this.getId());
            this.iResultSet = (IHybridResultSet)((IExecutable)((Object)XDistinct.this.getChild(0))).execute(context);
            super.setTabularRowsetInfo(this.iResultSet.getTabularRowsetInfo());
        }

        @Override
        public ITabularIterator getTabularIterator() {
            return new XDistinctIterator(this.getDataContext());
        }

        @Override
        public void releaseImpl() {
            if (this.iResultSet != null) {
                this.iResultSet.release();
                this.iResultSet = null;
            }
            this.rowsetInfo = null;
        }

        public final class XDistinctIterator
        extends XTabularIterator {
            private DuplicateEliminator distinctIt;
            private ITabularIterator tabIt;

            private XDistinctIterator(XDataContext context) {
                super(context, XDistinct.this.getId());
                try {
                    this.startTimer();
                    this.tabIt = XDistinctResultSet.this.iResultSet.getTabularIterator();
                    this.distinctIt = new DuplicateEliminator(context, (XTabularIterator)this.tabIt, XDistinctResultSet.this.rowsetInfo);
                }
                catch (RuntimeException e) {
                    this.release();
                    throw e;
                }
                finally {
                    this.stopTimer();
                }
            }

            @Override
            public Object nextImpl() {
                if (this.context.isCanceled()) {
                    throw new OperationCanceledException(this.context.getCancelSource());
                }
                return this.distinctIt.next();
            }

            @Override
            public long getIndex() {
                return this.distinctIt.getIndex();
            }

            @Override
            public void release() {
                if (this.tabIt != null) {
                    try {
                        this.tabIt.release();
                    }
                    catch (Exception e) {
                        mErrorLogger.log(e);
                    }
                    finally {
                        this.tabIt = null;
                    }
                }
                if (this.distinctIt != null) {
                    try {
                        this.distinctIt.release();
                    }
                    catch (Exception e) {
                        mErrorLogger.log(e);
                    }
                    finally {
                        this.distinctIt = null;
                    }
                }
                super.release();
            }
        }
    }
}

