/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.relational;

import com.cognos.xqe.ast.XQEPersistContext;
import com.cognos.xqe.ast.XQERestoreContext;
import com.cognos.xqe.data.types.DataTypeFactory;
import com.cognos.xqe.function.FunctionManager;
import com.cognos.xqe.function.IFunction;
import com.cognos.xqe.function.IParameterEvaluator;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.runtree.relational.XExpression;
import com.cognos.xqe.trace.XQETrace;
import org.dom4j.Attribute;
import org.dom4j.Element;

public abstract class XFunction
extends XExpression
implements IParameterEvaluator {
    private static final long serialVersionUID = 1L;
    private static final String ATTRIBUTE_FUNCTION = "function";
    private static final String ATTRIBUTE_DATATYPE = "dataType";
    protected IFunction function;

    public void setFunction(IFunction theFunction) {
        this.function = theFunction;
    }

    public IFunction getFunction() {
        return this.function;
    }

    @Override
    public void dumpExtraInfo(XQETrace trace, boolean includeRuntimeSpecifics) {
        trace.attribute(ATTRIBUTE_FUNCTION, this.function.toString());
        trace.attribute(ATTRIBUTE_DATATYPE, this.dataType.toString());
    }

    @Override
    public void capture(PlanningEnvironment env, Element inputNode) {
        this.setFunction(FunctionManager.getBuiltinFunction(inputNode.attribute(ATTRIBUTE_FUNCTION).getStringValue()));
        this.setDataType(DataTypeFactory.getType(inputNode.attribute(ATTRIBUTE_DATATYPE).getValue()));
        super.capture(env, inputNode);
    }

    @Override
    protected void persistAttributeProperties(XQEPersistContext ctx) {
        super.persistAttributeProperties(ctx);
        ctx.property(ATTRIBUTE_FUNCTION, this.function.toString());
    }

    @Override
    protected void restoreAttributeProperty(XQERestoreContext ctx, Attribute att, Element inputNode) {
        String attname = att.getName();
        if (attname.equals(ATTRIBUTE_FUNCTION)) {
            Object val = ctx.attributeValue(att);
            this.setFunction(FunctionManager.getBuiltinFunction((String)val));
        } else {
            super.restoreAttributeProperty(ctx, att, inputNode);
        }
    }
}

