/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.relational;

import com.cognos.xqe.ast.XQEPersistContext;
import com.cognos.xqe.ast.XQERestoreContext;
import com.cognos.xqe.bibushandler.OperationCanceledException;
import com.cognos.xqe.data.values.DataValueFactory;
import com.cognos.xqe.data.values.IRow;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.function.ISetFunctionState;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.resultset.interfaces.IExecutable;
import com.cognos.xqe.resultset.interfaces.IRowsetInfo;
import com.cognos.xqe.resultset.interfaces.ITabularIterator;
import com.cognos.xqe.resultset.interfaces.ITabularResultSet;
import com.cognos.xqe.resultsets.tabular.ColumnInfo;
import com.cognos.xqe.resultsets.tabular.RowsetInfo;
import com.cognos.xqe.resultsets.tabular.TabularHybridResultSet;
import com.cognos.xqe.runtree.IXExpression;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.runtree.XNode;
import com.cognos.xqe.runtree.XNodeFactory;
import com.cognos.xqe.runtree.XResultSetBase;
import com.cognos.xqe.runtree.XTabularIterator;
import com.cognos.xqe.runtree.XTabularResultSet;
import com.cognos.xqe.runtree.relational.XExpression;
import com.cognos.xqe.runtree.relational.XSetFunction;
import com.cognos.xqe.trace.XQETrace;
import java.util.Iterator;
import java.util.List;
import org.dom4j.Element;

public class XGroupBy
extends XTabularResultSet {
    private static final long serialVersionUID = 1L;
    protected static final String ELEMENT_OUTPUTLIST = "OutputList";
    protected static final String ELEMENT_FUNCTIONLIST = "FunctionList";
    protected static final String ELEMENT_GROUPBYLIST = "GroupBy";
    protected static final String ELEMENT_NONGROUPBYLIST = "NonGroupBy";
    protected static final String ELEMENT_COLUMN = "Column";
    protected static final String ATTRIBUTE_COLUMNNO = "columnNo";
    protected IXExpression[] outputList;
    protected XSetFunction[] functionList;
    protected int[] groupByList;
    protected int[] nonGroupByList;

    @Override
    protected IValue executeImpl(XDataContext context) {
        return new TabularHybridResultSet(context, new XGroupByResultSet(context), this.getId());
    }

    @Override
    public int getType() {
        return 501023;
    }

    @Override
    public void dumpExtraInfo(XQETrace trace, boolean includeRuntimeSpecifics) {
        int i;
        super.dumpExtraInfo(trace, includeRuntimeSpecifics);
        trace.beginElement(ELEMENT_OUTPUTLIST);
        for (i = 0; i < this.outputList.length; ++i) {
            this.outputList[i].dump(trace);
        }
        trace.endElement();
        trace.beginElement(ELEMENT_FUNCTIONLIST);
        for (i = 0; i < this.functionList.length; ++i) {
            this.functionList[i].dump(trace);
        }
        trace.endElement();
        trace.beginElement(ELEMENT_GROUPBYLIST);
        for (i = 0; i < this.groupByList.length; ++i) {
            trace.beginElement(ELEMENT_COLUMN);
            trace.attribute(ATTRIBUTE_COLUMNNO, this.groupByList[i]);
            trace.endElement();
        }
        trace.endElement();
        trace.beginElement(ELEMENT_NONGROUPBYLIST);
        for (i = 0; i < this.nonGroupByList.length; ++i) {
            trace.beginElement(ELEMENT_COLUMN);
            trace.attribute(ATTRIBUTE_COLUMNNO, this.nonGroupByList[i]);
            trace.endElement();
        }
        trace.endElement();
    }

    @Override
    public void capture(PlanningEnvironment env, Element inputNode) {
        XNode xNode;
        int i;
        XNodeFactory nodeFactory = (XNodeFactory)env.getNodeFactory();
        Iterator it = inputNode.elements().iterator();
        Element child = (Element)it.next();
        List exprList = child.elements();
        this.outputList = new XExpression[exprList.size()];
        for (i = 0; i < exprList.size(); ++i) {
            child = (Element)exprList.get(i);
            xNode = (XExpression)nodeFactory.createNodeByName(child.getName());
            xNode.capture(env, child);
            this.outputList[i] = xNode;
        }
        child = (Element)it.next();
        exprList = child.elements();
        this.functionList = new XSetFunction[exprList.size()];
        for (i = 0; i < exprList.size(); ++i) {
            child = (Element)exprList.get(i);
            xNode = (XSetFunction)nodeFactory.createNodeByName(child.getName());
            ((XSetFunction)xNode).capture(env, child);
            this.functionList[i] = xNode;
        }
        child = (Element)it.next();
        exprList = child.elements();
        if (exprList != null) {
            this.groupByList = new int[exprList.size()];
            for (i = 0; i < exprList.size(); ++i) {
                child = (Element)exprList.get(i);
                this.groupByList[i] = Integer.valueOf(child.attributeValue(ATTRIBUTE_COLUMNNO));
            }
        } else {
            this.groupByList = new int[0];
        }
        if ((exprList = (child = (Element)it.next()).elements()) != null) {
            this.nonGroupByList = new int[exprList.size()];
            for (i = 0; i < exprList.size(); ++i) {
                child = (Element)exprList.get(i);
                this.nonGroupByList[i] = Integer.valueOf(child.attributeValue(ATTRIBUTE_COLUMNNO));
            }
        } else {
            this.nonGroupByList = new int[0];
        }
        child = (Element)it.next();
        XNode xChild = (XNode)nodeFactory.createNodeByName(child.getName());
        xChild.capture(env, child);
        this.addChild(xChild);
    }

    public void setOutputList(XExpression[] theOutputList) {
        this.outputList = theOutputList;
    }

    public void setFunctionList(XSetFunction[] theFunctionList) {
        this.functionList = theFunctionList;
    }

    public void setGroupByList(int[] theGroupByList) {
        this.groupByList = theGroupByList;
    }

    public void setNonGroupByList(int[] theNonGroupByList) {
        this.nonGroupByList = theNonGroupByList;
    }

    @Override
    protected void persistElementProperties(XQEPersistContext ctx) {
        super.persistElementProperties(ctx);
        if (this.outputList != null) {
            ctx.elementProperty(ELEMENT_OUTPUTLIST, this.outputList);
        }
        if (this.functionList != null) {
            ctx.elementProperty(ELEMENT_FUNCTIONLIST, this.functionList);
        }
        if (this.groupByList != null) {
            ctx.elementProperty(ELEMENT_GROUPBYLIST, this.groupByList);
        }
        if (this.nonGroupByList != null) {
            ctx.elementProperty(ELEMENT_NONGROUPBYLIST, this.nonGroupByList);
        }
    }

    @Override
    protected void restoreElementProperty(XQERestoreContext ctx, Element node, Element inputNode) {
        String pname = node.attributeValue("pname");
        if (pname.equals(ELEMENT_OUTPUTLIST)) {
            Object val = ctx.elementValue(node);
            this.outputList = (IXExpression[])val;
        } else if (pname.equals(ELEMENT_FUNCTIONLIST)) {
            Object val = ctx.elementValue(node);
            this.functionList = (XSetFunction[])val;
        } else if (pname.equals(ELEMENT_GROUPBYLIST)) {
            Object val = ctx.elementValue(node);
            this.groupByList = (int[])val;
        } else if (pname.equals(ELEMENT_NONGROUPBYLIST)) {
            Object val = ctx.elementValue(node);
            this.nonGroupByList = (int[])val;
        } else {
            super.restoreElementProperty(ctx, node, inputNode);
        }
    }

    protected class XGroupByResultSet
    extends XResultSetBase
    implements ITabularResultSet {
        private static final String C = "C";
        protected ITabularResultSet iResultSet;
        protected IRowsetInfo tRowsetInfo;

        public XGroupByResultSet(XDataContext context) {
            super(context, XGroupBy.this.getId());
            try {
                int i;
                this.iResultSet = (ITabularResultSet)((IExecutable)((Object)XGroupBy.this.getChild(0))).execute(this.getDataContext());
                IRowsetInfo iRowsetInfo = this.iResultSet.getTabularRowsetInfo();
                int nColumns = 0;
                this.tRowsetInfo = new RowsetInfo();
                for (i = 0; i < XGroupBy.this.groupByList.length; ++i) {
                    this.tRowsetInfo.addColumnInfo(new ColumnInfo(C + nColumns++, iRowsetInfo.getColumnInfo(XGroupBy.this.groupByList[i]).getDataType()));
                }
                for (i = 0; i < XGroupBy.this.nonGroupByList.length; ++i) {
                    this.tRowsetInfo.addColumnInfo(new ColumnInfo(C + nColumns++, iRowsetInfo.getColumnInfo(XGroupBy.this.nonGroupByList[i]).getDataType()));
                }
                for (i = 0; i < XGroupBy.this.functionList.length; ++i) {
                    this.tRowsetInfo.addColumnInfo(new ColumnInfo(C + nColumns++, XGroupBy.this.functionList[i].getDataType(iRowsetInfo, -1)));
                }
                for (XSetFunction xSetFunction : XGroupBy.this.functionList) {
                    xSetFunction.open(context, iRowsetInfo);
                }
                this.rowsetInfo = new RowsetInfo();
                for (int i2 = 0; i2 < XGroupBy.this.outputList.length; ++i2) {
                    IXExpression oNode = XGroupBy.this.outputList[i2];
                    this.rowsetInfo.addColumnInfo(new ColumnInfo(oNode.getName(this.tRowsetInfo, i2), oNode.getDataType(this.tRowsetInfo, i2)));
                }
                for (IXExpression iXExpression : XGroupBy.this.outputList) {
                    iXExpression.open(context, this.tRowsetInfo);
                }
            }
            catch (RuntimeException e) {
                this.release();
                throw e;
            }
        }

        @Override
        public ITabularIterator getTabularIterator() {
            return new XGroupByIterator(this.getDataContext());
        }

        @Override
        public void releaseImpl() {
            if (this.iResultSet != null) {
                this.iResultSet.release();
                this.iResultSet = null;
            }
        }

        private final class XGroupByIterator
        extends XTabularIterator {
            private ITabularIterator tabIt;
            private IRow result;
            private IRow inputRow;
            private IRow tempRow;
            private boolean eod;
            private ISetFunctionState[] state;

            private XGroupByIterator(XDataContext context) {
                super(context, XGroupBy.this.getId());
                try {
                    this.startTimer();
                    XGroupBy.this.contextNo = XGroupBy.this.getContextNo();
                    this.tabIt = XGroupByResultSet.this.iResultSet.getTabularIterator();
                    if (XGroupByResultSet.this.tRowsetInfo != null && XGroupByResultSet.this.tRowsetInfo.getNumColumns() > 0) {
                        this.tempRow = DataValueFactory.createRowValue(context.getLocalCollator(), XGroupByResultSet.this.tRowsetInfo);
                    } else {
                        this.tempRow = DataValueFactory.createRowValue(0);
                        this.tempRow.setNull();
                    }
                    this.result = DataValueFactory.createRowValue(context.getLocalCollator(), XGroupByResultSet.this.rowsetInfo);
                }
                catch (RuntimeException e) {
                    this.release();
                    throw e;
                }
                finally {
                    this.stopTimer();
                }
            }

            @Override
            public Object nextImpl() {
                int i;
                if (this.context.isCanceled()) {
                    throw new OperationCanceledException(this.context.getCancelSource());
                }
                boolean controlBreak = false;
                IRow row = null;
                if (this.state == null) {
                    this.state = new ISetFunctionState[XGroupBy.this.functionList.length];
                    this.inputRow = (IRow)this.tabIt.next();
                    if (this.inputRow == null) {
                        this.eod = true;
                        if (XGroupBy.this.groupByList.length != 0 || XGroupBy.this.nonGroupByList.length != 0) {
                            return null;
                        }
                    }
                } else if (this.eod) {
                    return null;
                }
                for (i = 0; i < XGroupBy.this.groupByList.length; ++i) {
                    this.tempRow.getColumn(i).copyFrom(this.inputRow.getColumn(XGroupBy.this.groupByList[i]));
                }
                for (i = 0; i < XGroupBy.this.nonGroupByList.length; ++i) {
                    this.tempRow.getColumn(i + XGroupBy.this.groupByList.length).copyFrom(this.inputRow.getColumn(XGroupBy.this.nonGroupByList[i]));
                }
                for (i = 0; i < XGroupBy.this.functionList.length; ++i) {
                    this.state[i] = XGroupBy.this.functionList[i].initialize(this.context);
                }
                while (!controlBreak && !this.eod) {
                    this.context.pushRow(XGroupBy.this.contextNo, this.inputRow);
                    for (i = 0; i < XGroupBy.this.functionList.length; ++i) {
                        XGroupBy.this.functionList[i].iterate(this.context, this.state[i]);
                    }
                    this.context.popRow();
                    this.inputRow = (IRow)this.tabIt.next();
                    if (this.inputRow == null) {
                        this.eod = true;
                        break;
                    }
                    row = this.inputRow;
                    for (i = 0; i < XGroupBy.this.groupByList.length && !controlBreak; ++i) {
                        controlBreak = this.tempRow.getColumn(i).compareTo(row.getColumn(XGroupBy.this.groupByList[i])) != 0;
                    }
                }
                for (i = 0; i < XGroupBy.this.functionList.length; ++i) {
                    IValue rValue = this.tempRow.getColumn(XGroupBy.this.groupByList.length + XGroupBy.this.nonGroupByList.length + i);
                    XGroupBy.this.functionList[i].getResult(this.context, this.state[i], rValue);
                    XGroupBy.this.functionList[i].terminate(this.context, this.state[i]);
                }
                this.context.pushRow(XGroupBy.this.contextNo, this.tempRow);
                IValue[] values = this.result.getColumns();
                for (int i2 = 0; i2 < XGroupBy.this.outputList.length; ++i2) {
                    values[i2].copyFrom(XGroupBy.this.outputList[i2].execute(this.context));
                }
                this.context.popRow();
                ++this.nRows;
                return this.result;
            }

            @Override
            public long getIndex() {
                return this.tabIt.getIndex();
            }

            @Override
            public void release() {
                if (this.tabIt != null) {
                    try {
                        this.tabIt.release();
                    }
                    catch (Exception ex) {
                        mErrorLogger.log(ex);
                    }
                    finally {
                        this.tabIt = null;
                    }
                }
                this.result = null;
                this.inputRow = null;
                this.tempRow = null;
                this.state = null;
                super.release();
            }
        }
    }
}

