/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.relational;

import com.cognos.xqe.bibushandler.OperationCanceledException;
import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.data.DataTypeComparator;
import com.cognos.xqe.data.values.DataValueFactory;
import com.cognos.xqe.data.values.IRow;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.data.values.ValueSizeInfo;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.function.ISetFunctionState;
import com.cognos.xqe.resultset.interfaces.ITabularIterator;
import com.cognos.xqe.resultsets.tabular.TabularHybridResultSet;
import com.cognos.xqe.runtree.MemoryBookKeeper;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.runtree.XTabularIterator;
import com.cognos.xqe.runtree.relational.XGroupBy;
import com.cognos.xqe.runtree.relational.util.FileBasedPersistedResultSet;
import com.cognos.xqe.runtree.relational.util.IPersistedResultSet;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqe.trace.XQELogger;
import gnu.trove.map.hash.THashMap;
import java.util.Iterator;
import java.util.Map;

public class XHashGroupBy
extends XGroupBy {
    private static final long serialVersionUID = 1L;
    private static final XQELogger MEMORY_TRACE_LOGGER = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "Memory", LogLevel.TRACE);

    @Override
    protected IValue executeImpl(XDataContext context) {
        return new TabularHybridResultSet(context, new XHashGroupByResultSet(context), this.getId());
    }

    @Override
    public int getType() {
        return 501033;
    }

    private final class XHashGroupByResultSet
    extends XGroupBy.XGroupByResultSet {
        XHashGroupByResultSet(XDataContext theContext) {
            super(theContext);
        }

        @Override
        public ITabularIterator getTabularIterator() {
            return new XHashGroupByIterator(this.getDataContext());
        }

        private final class XHashGroupByIterator
        extends XTabularIterator {
            private static final int INITIAL_CAPACITY = 1000;
            private static final int SET_FUNCTION_STATE_SIZE = 300;
            private static final String MEMORY_MESSAGE_FORMAT = "Total Java Memory: %d MB, Free Calc memory: %d MB, Free Java memory: %d MB";
            private Map<GroupingKeys, ISetFunctionState[]> hashMap;
            private long memory;
            private XTabularIterator tabIt;
            private IRow result;
            private IRow inputRow;
            private IRow tempRow;
            Iterator<Map.Entry<GroupingKeys, ISetFunctionState[]>> hashIterator;

            private XHashGroupByIterator(XDataContext context) {
                super(context, XHashGroupBy.this.getId());
                this.memory = 0L;
                this.tabIt = null;
                this.hashIterator = null;
                try {
                    this.startTimer();
                    XHashGroupBy.this.contextNo = XHashGroupBy.this.getContextNo();
                    this.hashMap = new THashMap(1000);
                    this.tabIt = (XTabularIterator)XHashGroupByResultSet.this.iResultSet.getTabularIterator();
                    this.result = DataValueFactory.createRowValue(XHashGroupByResultSet.this.rowsetInfo);
                    this.tempRow = DataValueFactory.createRowValue(context.getLocalCollator(), XHashGroupByResultSet.this.tRowsetInfo);
                }
                catch (RuntimeException e) {
                    if (this.tabIt != null) {
                        this.tabIt.release();
                    }
                    this.release();
                    throw e;
                }
                finally {
                    this.stopTimer();
                }
            }

            @Override
            public Object nextImpl() {
                int i;
                if (this.hashIterator == null) {
                    this.loadHash();
                    this.hashIterator = this.hashMap.entrySet().iterator();
                }
                if (!this.hashIterator.hasNext()) {
                    this.context.getMemoryManager().releaseMemory(this.memory);
                    this.hashMap.clear();
                    this.memory = 0L;
                    if (this.tabIt != null) {
                        this.loadHash();
                        this.hashIterator = this.hashMap.entrySet().iterator();
                    } else {
                        return null;
                    }
                }
                Map.Entry<GroupingKeys, ISetFunctionState[]> entry = this.hashIterator.next();
                IValue[] groupColumns = entry.getKey().getGroupColumns();
                IValue[] dependents = entry.getKey().getDependents();
                for (i = 0; i < groupColumns.length; ++i) {
                    this.tempRow.getColumn(i).copyFrom(groupColumns[i]);
                }
                for (i = 0; i < dependents.length; ++i) {
                    this.tempRow.getColumn(groupColumns.length + i).copyFrom(dependents[i]);
                }
                ISetFunctionState[] state = entry.getValue();
                for (int i2 = 0; i2 < XHashGroupBy.this.functionList.length; ++i2) {
                    IValue rValue = this.tempRow.getColumn(XHashGroupBy.this.groupByList.length + XHashGroupBy.this.nonGroupByList.length + i2);
                    XHashGroupBy.this.functionList[i2].getResult(this.context, state[i2], rValue);
                    XHashGroupBy.this.functionList[i2].terminate(this.context, state[i2]);
                }
                this.context.pushRow(XHashGroupBy.this.contextNo, this.tempRow);
                IValue[] values = this.result.getColumns();
                for (int i3 = 0; i3 < XHashGroupBy.this.outputList.length; ++i3) {
                    values[i3] = XHashGroupBy.this.outputList[i3].execute(this.context);
                }
                this.context.popRow();
                ++this.nRows;
                return this.result;
            }

            @Override
            public long getIndex() {
                return -1L;
            }

            @Override
            public void release() {
                try {
                    if (this.tabIt != null) {
                        this.tabIt.release();
                    }
                }
                catch (Exception ex) {
                    mErrorLogger.log(ex);
                }
                finally {
                    this.tabIt = null;
                }
                this.result = null;
                this.inputRow = null;
                this.tempRow = null;
                this.hashMap = null;
                this.hashIterator = null;
                if (this.memory > 0L) {
                    this.context.getMemoryManager().releaseMemory(this.memory);
                    this.memory = 0L;
                }
                super.release();
            }

            private void loadHash() {
                GroupingKeys currentHashKey = new GroupingKeys(XHashGroupBy.this.groupByList.length, XHashGroupBy.this.nonGroupByList.length);
                IPersistedResultSet scan = null;
                if (MEMORY_TRACE_LOGGER.isOn()) {
                    Runtime rt = Runtime.getRuntime();
                    MEMORY_TRACE_LOGGER.log(String.format("HashGroupBy - start building hash table. Total Java Memory: %d MB, Free Calc memory: %d MB, Free Java memory: %d MB", rt.totalMemory() / 0x100000L, MemoryBookKeeper.getAvailableMemory() / 0x100000L, (rt.maxMemory() - (rt.totalMemory() - rt.freeMemory())) / 0x100000L));
                }
                while (true) {
                    try {
                        this.inputRow = (IRow)this.tabIt.next();
                    }
                    catch (OperationCanceledException e) {
                        if (scan != null) {
                            scan.release();
                        }
                        this.release();
                        throw e;
                    }
                    if (this.inputRow == null) {
                        this.tabIt.release();
                        this.tabIt = null;
                        if (scan == null) break;
                        this.tabIt = scan.getIterator();
                        scan = null;
                        break;
                    }
                    this.context.pushRow(XHashGroupBy.this.contextNo, this.inputRow);
                    currentHashKey.set(this.inputRow, XHashGroupBy.this.groupByList, XHashGroupBy.this.nonGroupByList);
                    ISetFunctionState[] state = this.hashMap.get(currentHashKey);
                    if (state == null) {
                        if (scan == null) {
                            boolean forced;
                            long memRequired = currentHashKey.sizeOf() + 300 * XHashGroupBy.this.functionList.length;
                            boolean bl = forced = this.hashMap.size() == 0;
                            if (this.context.getMemoryManager().allocateMemory(memRequired, forced)) {
                                state = new ISetFunctionState[XHashGroupBy.this.functionList.length];
                                for (int i = 0; i < XHashGroupBy.this.functionList.length; ++i) {
                                    state[i] = XHashGroupBy.this.functionList[i].initialize(this.context);
                                    XHashGroupBy.this.functionList[i].iterate(this.context, state[i]);
                                }
                                GroupingKeys newKey = currentHashKey.copy();
                                this.hashMap.put(newKey, state);
                                this.memory += memRequired;
                            } else {
                                if (MEMORY_TRACE_LOGGER.isOn()) {
                                    Runtime rt = Runtime.getRuntime();
                                    MEMORY_TRACE_LOGGER.log(String.format("HashGroupBy - hash table full, reverting to scanner. Total Java Memory: %d MB, Free Calc memory: %d MB, Free Java memory: %d MB", rt.totalMemory() / 0x100000L, MemoryBookKeeper.getAvailableMemory() / 0x100000L, (rt.maxMemory() - (rt.totalMemory() - rt.freeMemory())) / 0x100000L));
                                }
                                scan = new FileBasedPersistedResultSet(XHashGroupByResultSet.this.iResultSet.getTabularRowsetInfo().getDataType(), this.context);
                                scan.write(this.inputRow);
                            }
                        } else {
                            scan.write(this.inputRow);
                        }
                    } else {
                        for (int i = 0; i < XHashGroupBy.this.functionList.length; ++i) {
                            XHashGroupBy.this.functionList[i].iterate(this.context, state[i]);
                        }
                    }
                    this.context.popRow();
                }
            }

            private class GroupingKeys {
                IValue[] hashKeys;
                IValue[] groupColumns;
                IValue[] dependents;
                private int hash = 0;

                GroupingKeys(int size, int dize) {
                    this.hashKeys = new IValue[size];
                    this.groupColumns = new IValue[size];
                    this.dependents = new IValue[dize];
                }

                GroupingKeys(IValue[] theKeys, IValue[] theGroupColumns, IValue[] theDependents) {
                    this.hashKeys = theKeys;
                    this.groupColumns = theGroupColumns;
                    this.dependents = theDependents;
                }

                public GroupingKeys copy() {
                    int i;
                    IValue[] newKeys = new IValue[this.hashKeys.length];
                    IValue[] newGroupColumns = new IValue[this.groupColumns.length];
                    IValue[] newDeps = new IValue[this.dependents.length];
                    for (i = 0; i < this.hashKeys.length; ++i) {
                        newKeys[i] = (IValue)this.hashKeys[i].copy();
                    }
                    for (i = 0; i < this.groupColumns.length; ++i) {
                        newGroupColumns[i] = (IValue)this.groupColumns[i].copy();
                    }
                    for (i = 0; i < this.dependents.length; ++i) {
                        newDeps[i] = (IValue)this.dependents[i].copy();
                    }
                    GroupingKeys keys = new GroupingKeys(newKeys, newGroupColumns, newDeps);
                    keys.hash = this.hash;
                    return keys;
                }

                public void set(IRow row, int[] keymap, int[] depmap) {
                    int i;
                    for (i = 0; i < this.hashKeys.length; ++i) {
                        this.hashKeys[i] = (IValue)row.getColumn(keymap[i]).hashKey(XHashGroupByIterator.this.getDataContext().getLocalCollator());
                        this.groupColumns[i] = row.getColumn(keymap[i]);
                    }
                    for (i = 0; i < this.dependents.length; ++i) {
                        this.dependents[i] = row.getColumn(depmap[i]);
                    }
                    this.hash = 0;
                }

                public IValue[] getGroupColumns() {
                    return this.groupColumns;
                }

                public IValue[] getDependents() {
                    return this.dependents;
                }

                public int hashCode() {
                    if (0 == this.hash) {
                        this.hash = DataTypeComparator.hashValueArray(this.hashKeys, true);
                        if (0 == this.hash) {
                            this.hash = 1;
                        }
                    }
                    return this.hash;
                }

                public int sizeOf() {
                    int i;
                    int size = ValueSizeInfo.getSizeOf(ValueSizeInfo.ValueEntry.OBJECTSIZE);
                    for (i = 0; i < this.hashKeys.length; ++i) {
                        size += this.hashKeys[i].sizeOf();
                    }
                    for (i = 0; i < this.groupColumns.length; ++i) {
                        size += this.groupColumns[i].sizeOf();
                    }
                    for (i = 0; i < this.dependents.length; ++i) {
                        size += this.dependents[i].sizeOf();
                    }
                    return size;
                }

                public boolean equals(Object obj) {
                    if (this == obj) {
                        return true;
                    }
                    if (!(obj instanceof GroupingKeys)) {
                        return false;
                    }
                    GroupingKeys h = (GroupingKeys)obj;
                    if (this.hashKeys.length != h.hashKeys.length) {
                        return false;
                    }
                    try {
                        for (int i = 0; i < this.hashKeys.length; ++i) {
                            if (this.hashKeys[i].compareTo(h.hashKeys[i]) == 0) continue;
                            return false;
                        }
                        return true;
                    }
                    catch (XQERuntimeException e) {
                        return false;
                    }
                }
            }
        }
    }
}

