/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.relational;

import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.data.values.DataValueFactory;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.data.values.RowValue;
import com.cognos.xqe.data.values.ValueSizeInfo;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.resultset.interfaces.IRowsetInfo;
import com.cognos.xqe.resultset.interfaces.ITabularIterator;
import com.cognos.xqe.resultset.interfaces.ITabularResultSet;
import com.cognos.xqe.resultsets.tabular.Join;
import com.cognos.xqe.resultsets.tabular.TabularHybridResultSet;
import com.cognos.xqe.runtree.MemoryBookKeeper;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.runtree.XTabularIterator;
import com.cognos.xqe.runtree.relational.XJoin;
import com.cognos.xqe.runtree.relational.util.FileBasedPersistedResultSet;
import com.cognos.xqe.runtree.relational.util.HashKeysSet;
import com.cognos.xqe.runtree.relational.util.IPersistedResultSet;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqe.trace.XQELogger;
import gnu.trove.map.hash.THashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;

public class XHashJoin
extends XJoin {
    private static final long serialVersionUID = 1L;

    @Override
    protected IValue executeImpl(XDataContext context) throws XQERuntimeException {
        return new TabularHybridResultSet(context, new XHashJoinResultSet(context), this.getId());
    }

    @Override
    public int getType() {
        return 501009;
    }

    private final class XHashJoinResultSet
    extends XJoin.ResultSet
    implements ITabularResultSet {
        XHashJoinResultSet(XDataContext theContext) {
            super(theContext, 2, XHashJoin.this.getId());
        }

        @Override
        public ITabularIterator getTabularIterator() {
            return new XHashJoinIterator(this.getDataContext());
        }

        private final class XHashJoinIterator
        extends XTabularIterator {
            private static final int BUILD_INDEX = 0;
            private static final int PROBE_INDEX = 1;
            private ITabularIterator probeIterator;
            private RowValue probeRow;
            private RowValue result;
            private IRowsetInfo probeRowsetInfo;
            private Iterator<RowValue> listIterator;
            private CompletableList<RowValue> currentList;
            private IPersistedResultSet probeScan;
            private BuildTable buildTable;
            private RowValue dummyBuildRow;

            private XHashJoinIterator(XDataContext context) {
                super(context, XHashJoin.this.getId());
                this.probeRowsetInfo = null;
                this.listIterator = null;
                this.currentList = null;
                this.probeScan = null;
                this.buildTable = null;
                this.dummyBuildRow = null;
                try {
                    this.startTimer();
                    this.result = DataValueFactory.createRowValue(XHashJoinResultSet.this.rowsetInfo);
                    this.probeRowsetInfo = XHashJoinResultSet.this.iResultSets[1].getTabularRowsetInfo();
                    this.probeIterator = XHashJoinResultSet.this.iResultSets[1].getTabularIterator();
                    this.buildTable = new BuildTable();
                    this.dummyBuildRow = DataValueFactory.createRowValue(XHashJoinResultSet.this.iResultSets[0].getTabularRowsetInfo());
                }
                catch (RuntimeException e) {
                    this.release();
                    throw e;
                }
                finally {
                    this.stopTimer();
                }
            }

            @Override
            public Object nextImpl() {
                while (true) {
                    block7: {
                        if (this.listIterator != null) {
                            if (this.listIterator.hasNext()) {
                                XHashJoinResultSet.this.combine(this.result, this.listIterator.next(), this.probeRow, XJoin.State.EQUAL);
                                ++this.nRows;
                                return this.result;
                            }
                            this.listIterator = null;
                            if (!this.currentList.isComplete()) {
                                this.writeProbeRow();
                            }
                            this.currentList = null;
                        }
                        while (true) {
                            this.getNextProbeRow();
                            if (this.probeRow == null) {
                                return null;
                            }
                            this.buildTable.matchProbeRow();
                            if (this.currentList != null) break block7;
                            if (!this.buildTable.lastPartition()) {
                                this.writeProbeRow();
                                continue;
                            }
                            if (XHashJoin.this.joinType == XJoin.JoinType.RIGHT_OUTER) break;
                        }
                        XHashJoinResultSet.this.combine(this.result, this.dummyBuildRow, this.probeRow, XJoin.State.GREATER_THAN);
                        ++this.nRows;
                        return this.result;
                    }
                    this.listIterator = this.currentList.iterator();
                }
            }

            private void writeProbeRow() {
                if (this.probeScan == null) {
                    this.probeScan = new FileBasedPersistedResultSet(this.probeRowsetInfo.getDataType(), this.context);
                }
                this.probeScan.write(this.probeRow);
            }

            private void getNextProbeRow() {
                while (true) {
                    this.probeRow = (RowValue)this.probeIterator.next();
                    if (this.probeRow != null) break;
                    this.probeIterator.release();
                    this.probeIterator = null;
                    if (this.probeScan == null) break;
                    this.probeIterator = this.probeScan.getIterator();
                    this.probeScan = null;
                    if (this.buildTable.lastPartition()) {
                        throw new RuntimeException("Incorrect state - build there is no more build partitions, but the probe table is saved");
                    }
                    this.buildTable.loadNextPartition();
                }
            }

            @Override
            public long getIndex() {
                return this.nRows;
            }

            @Override
            public void release() {
                this.buildTable.release();
                try {
                    if (this.probeIterator != null) {
                        this.probeIterator.release();
                    }
                }
                catch (Exception ex) {
                    mErrorLogger.log(ex);
                }
                finally {
                    this.probeIterator = null;
                }
                if (this.probeScan != null) {
                    this.probeScan.release();
                    this.probeScan = null;
                }
            }

            public class CompletableList<T>
            extends LinkedList<T> {
                private static final long serialVersionUID = 1L;
                private boolean complete = true;

                public void setComplete(boolean theComplete) {
                    this.complete = theComplete;
                }

                public boolean isComplete() {
                    return this.complete;
                }
            }

            private class BuildTable {
                private static final String MEMORY_MESSAGE_FORMAT = "Total Java Memory: %d MB, Free Calc memory: %d MB, Free Java memory: %d MB";
                private Map<HashKeysSet, CompletableList<RowValue>> hashMap = null;
                private ITabularIterator buildIterator = null;
                private RowValue buildRow;
                long memory = 0L;
                int[] buildJoinColumns = null;
                int[] probeJoinColumns = null;
                private boolean useFastHash = true;
                private IRowsetInfo buildRowsetInfo = null;
                private HashKeysSet probeKeys = null;
                private boolean first = true;

                BuildTable() {
                    int i;
                    int nJoins = XHashJoin.this.joins.size();
                    this.buildJoinColumns = new int[nJoins];
                    this.probeJoinColumns = new int[nJoins];
                    for (i = 0; i < nJoins; ++i) {
                        Join join = (Join)XHashJoin.this.joins.get(i);
                        this.buildJoinColumns[i] = join.getLeftJoin().getColumnNo();
                        this.probeJoinColumns[i] = join.getRightJoin().getColumnNo();
                    }
                    this.buildRowsetInfo = XHashJoinResultSet.this.iResultSets[0].getTabularRowsetInfo();
                    for (i = 0; i < nJoins; ++i) {
                        if (this.buildRowsetInfo.getColumnInfo(this.buildJoinColumns[i]).getDataType().getCCLTypeCode() == XHashJoinIterator.this.probeRowsetInfo.getColumnInfo(this.probeJoinColumns[i]).getDataType().getCCLTypeCode()) continue;
                        this.useFastHash = false;
                        break;
                    }
                    this.buildIterator = XHashJoinResultSet.this.iResultSets[0].getTabularIterator();
                    this.hashMap = new THashMap();
                    this.probeKeys = new HashKeysSet(nJoins, XHashJoinIterator.this.getDataContext().getLocalCollator(), this.useFastHash);
                }

                public void matchProbeRow() {
                    if (this.first) {
                        this.first = false;
                        this.loadNextPartition();
                    }
                    for (int i = 0; i < XHashJoin.this.joins.size(); ++i) {
                        if (!XHashJoinIterator.this.probeRow.getColumn(this.probeJoinColumns[i]).isNull() || ((Join)XHashJoin.this.joins.get(i)).isNotDistinctFrom()) continue;
                        XHashJoinIterator.this.currentList = null;
                        return;
                    }
                    this.probeKeys.set(XHashJoinIterator.this.probeRow, this.probeJoinColumns);
                    XHashJoinIterator.this.currentList = this.hashMap.get(this.probeKeys);
                }

                public boolean lastPartition() {
                    return this.buildIterator == null;
                }

                private void loadNextPartition() {
                    IPersistedResultSet scan = null;
                    this.hashMap.clear();
                    if (this.memory > 0L) {
                        XHashJoinIterator.this.context.getMemoryManager().releaseMemory(this.memory);
                        this.memory = 0L;
                    }
                    XQELogger logger = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "Memory", LogLevel.TRACE);
                    Runtime rt = Runtime.getRuntime();
                    logger.log(String.format("HashJoin - start building partition. Total Java Memory: %d MB, Free Calc memory: %d MB, Free Java memory: %d MB", rt.totalMemory() / 0x100000L, MemoryBookKeeper.getAvailableMemory() / 0x100000L, (rt.maxMemory() - (rt.totalMemory() - rt.freeMemory())) / 0x100000L));
                    HashKeysSet currentHashKey = new HashKeysSet(XHashJoin.this.joins.size(), XHashJoinIterator.this.getDataContext().getLocalCollator(), this.useFastHash);
                    while (true) {
                        long memRequired;
                        try {
                            this.buildRow = (RowValue)this.buildIterator.next();
                        }
                        catch (RuntimeException e) {
                            if (scan != null) {
                                scan.release();
                            }
                            this.release();
                            throw e;
                        }
                        if (this.buildRow == null) {
                            this.buildIterator.release();
                            this.buildIterator = null;
                            if (scan != null) {
                                this.buildIterator = scan.getIterator();
                                scan = null;
                            }
                            break;
                        }
                        boolean ignore = false;
                        for (int i = 0; i < XHashJoin.this.joins.size(); ++i) {
                            if (!this.buildRow.getColumn(this.buildJoinColumns[i]).isNull() || ((Join)XHashJoin.this.joins.get(i)).isNotDistinctFrom()) continue;
                            ignore = true;
                            break;
                        }
                        if (ignore) continue;
                        currentHashKey.set(this.buildRow, this.buildJoinColumns);
                        CompletableList<RowValue> list = this.hashMap.get(currentHashKey);
                        if (list == null) {
                            if (scan == null) {
                                boolean forced;
                                memRequired = currentHashKey.sizeOf() + ValueSizeInfo.getSizeOf(ValueSizeInfo.ValueEntry.OBJECTSIZE) + this.buildRow.sizeOf();
                                boolean bl = forced = this.hashMap.size() == 0;
                                if (XHashJoinIterator.this.context.getMemoryManager().allocateMemory(memRequired, forced)) {
                                    list = new CompletableList();
                                    if (this.buildRow instanceof RowValue) {
                                        list.add((RowValue)this.buildRow.copy(false));
                                    } else {
                                        list.add((RowValue)this.buildRow.copy());
                                    }
                                    HashKeysSet newKey = currentHashKey.copy();
                                    this.hashMap.put(newKey, list);
                                    this.memory += memRequired;
                                    continue;
                                }
                                logger.log(String.format("HashJoin - building partition, revert to scanner (new set). Total Java Memory: %d MB, Free Calc memory: %d MB, Free Java memory: %d MB", rt.totalMemory() / 0x100000L, MemoryBookKeeper.getAvailableMemory() / 0x100000L, (rt.maxMemory() - (rt.totalMemory() - rt.freeMemory())) / 0x100000L));
                                scan = new FileBasedPersistedResultSet(this.buildRowsetInfo.getDataType(), XHashJoinIterator.this.context);
                                scan.write(this.buildRow);
                                continue;
                            }
                            scan.write(this.buildRow);
                            continue;
                        }
                        if (scan == null) {
                            memRequired = this.buildRow.sizeOf();
                            if (XHashJoinIterator.this.context.getMemoryManager().allocateMemory(memRequired, false)) {
                                if (this.buildRow instanceof RowValue) {
                                    list.add((RowValue)this.buildRow.copy(false));
                                } else {
                                    list.add((RowValue)this.buildRow.copy());
                                }
                                this.memory += memRequired;
                                continue;
                            }
                            logger.log(String.format("HashJoin - building partition, revert to scanner (existing set). Total Java Memory: %d MB, Free Calc memory: %d MB, Free Java memory: %d MB", rt.totalMemory() / 0x100000L, MemoryBookKeeper.getAvailableMemory() / 0x100000L, (rt.maxMemory() - (rt.totalMemory() - rt.freeMemory())) / 0x100000L));
                            scan = new FileBasedPersistedResultSet(this.buildRowsetInfo.getDataType(), XHashJoinIterator.this.context);
                            list.setComplete(false);
                            scan.write(this.buildRow);
                            continue;
                        }
                        list.setComplete(false);
                        scan.write(this.buildRow);
                    }
                    logger.log(String.format("HashJoin - building partition, EOD. Total Java Memory: %d MB, Free Calc memory: %d MB, Free Java memory: %d MB", rt.totalMemory() / 0x100000L, MemoryBookKeeper.getAvailableMemory() / 0x100000L, (rt.maxMemory() - (rt.totalMemory() - rt.freeMemory())) / 0x100000L));
                }

                void release() {
                    try {
                        if (this.buildIterator != null) {
                            this.buildIterator.release();
                        }
                    }
                    catch (Exception ex) {
                        mErrorLogger.log(ex);
                    }
                    finally {
                        this.buildIterator = null;
                    }
                    this.hashMap.clear();
                    if (this.memory > 0L) {
                        XHashJoinIterator.this.context.getMemoryManager().releaseMemory(this.memory);
                        this.memory = 0L;
                    }
                }
            }
        }
    }
}

