/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.relational;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQEPersistContext;
import com.cognos.xqe.ast.XQERestoreContext;
import com.cognos.xqe.ast.sql.SQLSortKey;
import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.data.values.IRow;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.data.values.TextValue;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.resultset.interfaces.IExecutable;
import com.cognos.xqe.resultset.interfaces.IHybridResultSet;
import com.cognos.xqe.resultset.interfaces.IRowsetInfo;
import com.cognos.xqe.resultsets.tabular.Join;
import com.cognos.xqe.resultsets.tabular.RowsetInfo;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.runtree.XResultSetBase;
import com.cognos.xqe.runtree.XTabularResultSet;
import com.cognos.xqe.runtree.relational.XExpression;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqe.trace.XQELogger;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.util.IReleasable;
import com.ibm.icu.text.Collator;
import java.util.ArrayList;
import java.util.List;
import org.dom4j.Attribute;
import org.dom4j.Element;

public abstract class XJoin
extends XTabularResultSet {
    private static final long serialVersionUID = 1L;
    private static final int DEFAULT_PACKET_SIZE = 50;
    protected int packetSize = 50;
    protected static final String ATTRIBUTE_JOINTYPE = "joinType";
    protected static final String ATTRIBUTE_ISLATERAL = "isLateral";
    protected static final String ELEMENT_JOINS = "Joins";
    protected static final String ELEMENT_NULLORDERING = "nullOrdering";
    protected static XQELogger mErrorLogger = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "Exception", LogLevel.ERROR);
    protected JoinType joinType;
    protected List<Join> joins;
    protected boolean isLateral;
    private SQLSortKey.NullOrdering[] nullOrdering;

    public void setJoinType(JoinType theJoinType) {
        this.joinType = theJoinType;
    }

    public void setJoins(List<Join> pJoins) {
        this.joins = pJoins;
    }

    @Override
    public SQLSortKey.NullOrdering[] getNullOrdering() {
        return this.nullOrdering;
    }

    public void setNullOrdering(SQLSortKey.NullOrdering[] nullValueOrdering) {
        this.nullOrdering = nullValueOrdering;
    }

    public boolean isLateralJoin() {
        return this.isLateral;
    }

    public void setLateral(boolean lateralJoin) {
        this.isLateral = lateralJoin;
    }

    public IXQEQueryNode getPredicate() {
        int nChildren = this.getNumberChildren();
        if (nChildren == 2) {
            return null;
        }
        return this.getChild(nChildren - 1);
    }

    @Override
    public void dumpExtraInfo(XQETrace trace, boolean includeRuntimeSpecifics) {
        trace.attribute(ATTRIBUTE_JOINTYPE, this.joinType.getDescriptor());
        trace.attribute(ATTRIBUTE_ISLATERAL, this.isLateral);
        super.dumpExtraInfo(trace, includeRuntimeSpecifics);
        if (this.joins == null) {
            return;
        }
        trace.beginElement(ELEMENT_JOINS);
        for (int i = 0; i < this.joins.size(); ++i) {
            this.joins.get(i).dumpExtraInfo(trace);
        }
        trace.endElement();
    }

    @Override
    public void capture(PlanningEnvironment env, Element inputNode) {
        List children;
        Element child;
        String jType = inputNode.attributeValue(ATTRIBUTE_JOINTYPE);
        this.joinType = jType == null || jType.equals(JoinType.INNER.getDescriptor()) ? JoinType.INNER : (jType.equals(JoinType.LEFT_OUTER.getDescriptor()) ? JoinType.LEFT_OUTER : (jType.equals(JoinType.RIGHT_OUTER.getDescriptor()) ? JoinType.RIGHT_OUTER : JoinType.FULL_OUTER));
        String isLateralAttr = inputNode.attributeValue(ATTRIBUTE_ISLATERAL);
        if (isLateralAttr != null) {
            this.isLateral = Boolean.valueOf(isLateralAttr);
        }
        if ((child = (Element)(children = inputNode.elements()).get(0)).getName().equals(ELEMENT_JOINS)) {
            List joinList = ((Element)children.get(0)).elements();
            this.joins = new ArrayList<Join>(joinList.size());
            this.nullOrdering = new SQLSortKey.NullOrdering[joinList.size()];
            for (int i = 0; i < joinList.size(); ++i) {
                Join join = new Join();
                join.capture(env, (Element)joinList.get(i));
                this.joins.add(join);
                this.nullOrdering[i] = SQLSortKey.NullOrdering.NULLS_FIRST;
            }
            super.capture(env, inputNode, 1);
        } else {
            super.capture(env, inputNode, 0);
        }
    }

    @Override
    protected void persistAttributeProperties(XQEPersistContext ctx) {
        super.persistAttributeProperties(ctx);
        ctx.property(ATTRIBUTE_JOINTYPE, (Object)this.joinType);
        ctx.property(ATTRIBUTE_ISLATERAL, this.isLateral);
    }

    @Override
    protected void persistElementProperties(XQEPersistContext ctx) {
        super.persistElementProperties(ctx);
        if (this.joins != null) {
            ctx.elementProperty(ELEMENT_JOINS, this.joins);
        }
        if (this.nullOrdering != null) {
            ctx.elementProperty(ELEMENT_NULLORDERING, this.nullOrdering);
        }
    }

    @Override
    protected void restoreAttributeProperty(XQERestoreContext ctx, Attribute att, Element inputNode) {
        String name = att.getName();
        if (name.equals(ATTRIBUTE_JOINTYPE)) {
            Object val = ctx.attributeValue(att);
            this.joinType = (JoinType)((Object)val);
        } else if (name.equals(ATTRIBUTE_ISLATERAL)) {
            Object val = ctx.attributeValue(att);
            this.isLateral = (Boolean)val;
        } else {
            super.restoreAttributeProperty(ctx, att, inputNode);
        }
    }

    @Override
    protected void restoreElementProperty(XQERestoreContext ctx, Element node, Element inputNode) {
        String pname = node.attributeValue("pname");
        if (pname.equals(ELEMENT_JOINS)) {
            Object val = ctx.elementValue(node);
            this.joins = (List)val;
        } else if (pname.equals(ELEMENT_NULLORDERING)) {
            Object val = ctx.elementValue(node);
            this.nullOrdering = (SQLSortKey.NullOrdering[])val;
        } else {
            super.restoreElementProperty(ctx, node, inputNode);
        }
    }

    protected abstract class ResultSet
    extends XResultSetBase {
        protected IHybridResultSet[] iResultSets;
        protected IRowsetInfo[] iRowsetInfo;
        protected XExpression predicate;
        protected Collator collator;

        protected ResultSet(XDataContext theContext, Integer nodeId) {
            super(theContext, nodeId);
        }

        protected ResultSet(XDataContext theContext, int nChildren, Integer nodeId) {
            super(theContext, nodeId);
            try {
                int i;
                this.iResultSets = new IHybridResultSet[nChildren];
                this.iRowsetInfo = new IRowsetInfo[nChildren];
                for (i = 0; i < nChildren; ++i) {
                    this.iResultSets[i] = (IHybridResultSet)((IExecutable)((Object)XJoin.this.getChild(i))).execute(theContext);
                    this.iRowsetInfo[i] = this.iResultSets[i].getTabularRowsetInfo();
                }
                this.rowsetInfo = new RowsetInfo();
                for (i = 0; i < this.iResultSets.length; ++i) {
                    this.rowsetInfo.add(this.iRowsetInfo[i]);
                }
                this.predicate = (XExpression)XJoin.this.getPredicate();
                if (this.predicate != null) {
                    this.predicate.open(theContext, this.rowsetInfo);
                }
                this.collator = theContext.getLocalCollator();
            }
            catch (RuntimeException e) {
                this.release();
                throw e;
            }
        }

        protected void combine(IRow result, IRow leftRow, IRow rightRow, State state) {
            IValue[] values = result.getColumns();
            int nLeftValues = this.iRowsetInfo[0].getNumColumns();
            for (int i = 0; i < nLeftValues; ++i) {
                values[i] = state == State.GREATER_THAN ? this.iRowsetInfo[0].getColumnInfo(i).getDataType().createValue() : leftRow.getColumn(i);
            }
            int nRightValues = this.iRowsetInfo[1].getNumColumns();
            for (int i = 0; i < nRightValues; ++i) {
                values[i + nLeftValues] = state == State.LESS_THAN ? this.iRowsetInfo[1].getColumnInfo(i).getDataType().createValue() : rightRow.getColumn(i);
            }
        }

        protected void combine(IRow result, IRow[] rows, State state) {
            if (rows.length == 2 && state != State.EQUAL) {
                this.combine(result, rows[0], rows[1], state);
                return;
            }
            IValue[] values = result.getColumns();
            int k = 0;
            for (int i = 0; i < rows.length; ++i) {
                int nValues = this.iRowsetInfo[i].getNumColumns();
                for (int j = 0; j < nValues; ++j) {
                    values[k + j] = rows[i].getColumn(j);
                }
                k += nValues;
            }
        }

        protected State compareValues(IRow lRow, IRow rRow) {
            int v = 0;
            State state = State.EQUAL;
            for (int i = 0; i < XJoin.this.joins.size(); ++i) {
                Join join = XJoin.this.joins.get(i);
                IValue lValue = lRow.getColumn(join.getLeftJoin().getColumnNo());
                IValue rValue = rRow.getColumn(join.getRightJoin().getColumnNo());
                v = lValue.isNull() && rValue.isNull() ? (join.isNotDistinctFrom() ? 0 : -1) : (lValue.isNull() ? (XJoin.this.nullOrdering[i] == SQLSortKey.NullOrdering.NULLS_FIRST ? -1 : 1) : (rValue.isNull() ? (XJoin.this.nullOrdering[i] == SQLSortKey.NullOrdering.NULLS_FIRST ? 1 : -1) : (lValue instanceof TextValue && rValue instanceof TextValue ? ((TextValue)lValue).compareTo((Object)rValue, this.collator) : lValue.compareTo(rValue))));
                if (v != 0) break;
            }
            if (v != 0) {
                state = v < 0 ? State.LESS_THAN : State.GREATER_THAN;
            }
            return state;
        }

        @Override
        public void releaseImpl() {
            if (this.predicate != null) {
                this.predicate.close(this.getDataContext());
            }
            if (this.iResultSets != null) {
                ResultSet.releaseNonNullReleasables((IReleasable[])this.iResultSets);
                this.iResultSets = null;
            }
            this.iRowsetInfo = null;
            this.rowsetInfo = null;
        }
    }

    public static enum State {
        LESS_THAN,
        EQUAL,
        GREATER_THAN;

    }

    public static enum JoinType {
        CROSS("Cross"),
        INNER("Inner"),
        LEFT_OUTER("Left Outer"),
        RIGHT_OUTER("Right Outer"),
        FULL_OUTER("Full Outer"),
        SEMI("Semi"),
        ANTI("Anti");

        private String descriptor;

        private JoinType(String theDescriptor) {
            this.descriptor = theDescriptor;
        }

        public String getDescriptor() {
            return this.descriptor;
        }
    }
}

