/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.relational;

import com.cognos.xqe.ast.XQEPersistContext;
import com.cognos.xqe.ast.XQERestoreContext;
import com.cognos.xqe.data.types.DataTypeFactory;
import com.cognos.xqe.data.types.ObjectType;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.data.values.ObjectValue;
import com.cognos.xqe.data.values.TextValue;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.function.Cursor;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.runtree.relational.XExpression;
import com.cognos.xqe.runtree.relational.XTableFunction;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.util.IQueryReuseManager;
import java.util.List;
import org.dom4j.Element;

public class XLiteral
extends XExpression {
    private static final long serialVersionUID = 1L;
    private static final String ATTRIBUTE_DATATYPE = "dataType";
    private static final String ATTRIBUTE_VALUE = "value";
    private Value value;

    @Override
    protected IValue executeImpl(XDataContext context) {
        Value returnValue = this.value;
        if (this.value instanceof TextValue && ((TextValue)this.value).getCollator() == null) {
            returnValue = (Value)this.value.getDataType().createValue(context.getLocalCollator());
            returnValue.set(this.value.getString());
        }
        return returnValue;
    }

    public Value getValue() {
        return this.value;
    }

    public void setValue(Value theValue) {
        this.value = theValue;
    }

    @Override
    public int getType() {
        return 501019;
    }

    @Override
    public void dumpExtraInfo(XQETrace trace, boolean includeRuntimeSpecifics) {
        trace.attribute(ATTRIBUTE_DATATYPE, this.value.getDataType().toString());
        if (!this.value.isNull()) {
            trace.attribute(ATTRIBUTE_VALUE, this.value.toString());
        }
    }

    @Override
    public void capture(PlanningEnvironment env, Element inputNode) {
        this.dataType = DataTypeFactory.getType(inputNode.attributeValue(ATTRIBUTE_DATATYPE));
        this.value = (Value)this.dataType.createValue();
        String aValue = inputNode.attributeValue(ATTRIBUTE_VALUE);
        if (aValue != null) {
            this.value.set(aValue);
        } else {
            List children = inputNode.elements();
            if (children.size() > 0) {
                Element child = (Element)children.get(0);
                this.value.set(child.getStringValue());
            } else {
                this.value.setNull();
            }
        }
    }

    @Override
    protected void persistElementProperties(XQEPersistContext ctx) {
        super.persistElementProperties(ctx);
        if (this.value != null) {
            if (this.getDataType() == ObjectType.OBJECTTYPE && this.getParent().getType() == 501015 && ((XTableFunction)this.getParent()).getFunction() instanceof Cursor) {
                ObjectValue ovalue = (ObjectValue)this.getValue();
                IQueryReuseManager.CursorInfo info = (IQueryReuseManager.CursorInfo)ovalue.getObject();
                throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "Please, implement serialization of a cursor info ( query items and execution plan)");
            }
            ctx.elementProperty(ATTRIBUTE_VALUE, this.value);
        }
    }

    @Override
    protected void restoreElementProperty(XQERestoreContext ctx, Element node, Element inputNode) {
        String pname = node.attributeValue("pname");
        if (pname.equals(ATTRIBUTE_VALUE)) {
            Object val = ctx.elementValue(node);
            this.value = (Value)val;
        } else {
            super.restoreElementProperty(ctx, node, inputNode);
        }
    }
}

