/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.relational;

import com.cognos.xqe.bibushandler.OperationCanceledException;
import com.cognos.xqe.data.values.DataValueFactory;
import com.cognos.xqe.data.values.IRow;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.resultset.interfaces.ITabularIterator;
import com.cognos.xqe.resultset.interfaces.ITabularResultSet;
import com.cognos.xqe.resultsets.tabular.TabularHybridResultSet;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.runtree.XTabularIterator;
import com.cognos.xqe.runtree.relational.XJoin;
import java.util.ArrayList;

public class XMergeJoin
extends XJoin {
    private static final long serialVersionUID = 1L;

    @Override
    protected IValue executeImpl(XDataContext context) throws XQERuntimeException {
        return new TabularHybridResultSet(context, new XMergeJoinResultSet(context), this.getId());
    }

    @Override
    public int getType() {
        return 501034;
    }

    private final class XMergeJoinResultSet
    extends XJoin.ResultSet
    implements ITabularResultSet {
        XMergeJoinResultSet(XDataContext context) {
            super(context, 2, XMergeJoin.this.getId());
        }

        @Override
        public ITabularIterator getTabularIterator() {
            return new XMergeJoinIterator(this.getDataContext());
        }

        private final class XMergeJoinIterator
        extends XTabularIterator {
            private XTabularIterator lTabIt;
            private XTabularIterator rTabIt;
            private IRow result;
            private ArrayList<IRow> cachedRows;
            private int cachedRowNo;
            private XJoin.State state;
            private IRow leftRow;
            private IRow rightRow;
            boolean firstRow;
            private boolean leftEod;
            private boolean rightEod;

            private XMergeJoinIterator(XDataContext context) {
                super(context, XMergeJoin.this.getId());
                this.cachedRows = new ArrayList();
                try {
                    this.startTimer();
                    this.lTabIt = (XTabularIterator)XMergeJoinResultSet.this.iResultSets[0].getTabularIterator();
                    this.rTabIt = (XTabularIterator)XMergeJoinResultSet.this.iResultSets[1].getTabularIterator();
                    this.result = DataValueFactory.createRowValue(XMergeJoinResultSet.this.rowsetInfo);
                    this.firstRow = true;
                }
                catch (RuntimeException e) {
                    this.release();
                    throw e;
                }
                finally {
                    this.stopTimer();
                }
            }

            @Override
            public Object nextImpl() {
                block29: {
                    IRow inputRow;
                    if (this.context.isCanceled()) {
                        throw new OperationCanceledException(this.context.getCancelSource());
                    }
                    if (this.firstRow) {
                        this.firstRow = false;
                        this.cachedRowNo = -1;
                        inputRow = (IRow)this.lTabIt.next();
                        if (inputRow == null) {
                            if (XMergeJoin.this.joinType == XJoin.JoinType.INNER || XMergeJoin.this.joinType == XJoin.JoinType.LEFT_OUTER) {
                                return null;
                            }
                            this.leftEod = true;
                        } else {
                            this.leftRow = inputRow;
                        }
                        this.state = XJoin.State.EQUAL;
                    }
                    while (true) {
                        if (this.state == XJoin.State.LESS_THAN) {
                            if (this.cachedRows.size() > 0) {
                                IRow row;
                                if (this.cachedRowNo < 0 || this.cachedRowNo >= this.cachedRows.size()) {
                                    this.cachedRowNo = 0;
                                    inputRow = (IRow)this.lTabIt.next();
                                    if (inputRow == null) {
                                        this.leftEod = true;
                                    } else {
                                        this.leftRow = inputRow;
                                    }
                                }
                                if (!this.leftEod && XMergeJoinResultSet.this.compareValues(this.leftRow, row = this.cachedRows.get(this.cachedRowNo++)) == XJoin.State.EQUAL) {
                                    XMergeJoinResultSet.this.combine(this.result, this.leftRow, row, XJoin.State.EQUAL);
                                    ++this.nRows;
                                    break block29;
                                }
                                this.cachedRows.clear();
                                this.cachedRowNo = -1;
                            } else if (!this.leftEod) {
                                inputRow = (IRow)this.lTabIt.next();
                                if (inputRow == null) {
                                    this.leftEod = true;
                                } else {
                                    this.leftRow = inputRow;
                                }
                            }
                        } else if (!this.rightEod) {
                            inputRow = (IRow)this.rTabIt.next();
                            if (inputRow == null) {
                                this.rightEod = true;
                            } else {
                                this.rightRow = inputRow;
                            }
                        }
                        if (this.leftEod && this.rightEod) {
                            return null;
                        }
                        if (this.leftEod) {
                            if (XMergeJoin.this.joinType == XJoin.JoinType.INNER || XMergeJoin.this.joinType == XJoin.JoinType.LEFT_OUTER) {
                                return null;
                            }
                            this.state = XJoin.State.GREATER_THAN;
                        } else if (this.rightEod) {
                            if (XMergeJoin.this.joinType == XJoin.JoinType.INNER && this.cachedRows.size() == 0) {
                                return null;
                            }
                            this.state = XJoin.State.LESS_THAN;
                        } else {
                            this.state = XMergeJoinResultSet.this.compareValues(this.leftRow, this.rightRow);
                        }
                        if (this.state == XJoin.State.EQUAL) {
                            XMergeJoinResultSet.this.combine(this.result, this.leftRow, this.rightRow, this.state);
                            ++this.nRows;
                            this.cachedRows.add((IRow)this.rightRow.copy());
                            break block29;
                        }
                        if (this.state == XJoin.State.LESS_THAN) {
                            if (XMergeJoin.this.joinType != XJoin.JoinType.LEFT_OUTER && XMergeJoin.this.joinType != XJoin.JoinType.FULL_OUTER || this.cachedRows.size() != 0) continue;
                            XMergeJoinResultSet.this.combine(this.result, this.leftRow, this.rightRow, this.state);
                            ++this.nRows;
                            break block29;
                        }
                        if (this.state == XJoin.State.GREATER_THAN && (XMergeJoin.this.joinType == XJoin.JoinType.RIGHT_OUTER || XMergeJoin.this.joinType == XJoin.JoinType.FULL_OUTER)) break;
                    }
                    XMergeJoinResultSet.this.combine(this.result, this.leftRow, this.rightRow, this.state);
                    ++this.nRows;
                }
                return this.result;
            }

            @Override
            public long getIndex() {
                return this.nRows;
            }

            @Override
            public void release() {
                if (this.lTabIt != null) {
                    try {
                        this.lTabIt.release();
                    }
                    catch (Exception ex) {
                        mErrorLogger.log(ex);
                    }
                    finally {
                        this.lTabIt = null;
                    }
                }
                if (this.rTabIt != null) {
                    try {
                        this.rTabIt.release();
                    }
                    catch (Exception ex) {
                        mErrorLogger.log(ex);
                    }
                    finally {
                        this.rTabIt = null;
                    }
                }
                this.result = null;
                this.leftRow = null;
                this.rightRow = null;
                super.release();
            }
        }
    }
}

