/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.relational;

import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.data.types.MultisetType;
import com.cognos.xqe.data.types.RowType;
import com.cognos.xqe.data.values.DataValueFactory;
import com.cognos.xqe.data.values.DateTimeValue;
import com.cognos.xqe.data.values.IRow;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.data.values.MultisetValue;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.function.udf.sdk.Metadata;
import com.cognos.xqe.function.udf.sdk.Table;
import com.cognos.xqe.resultset.interfaces.IExecutable;
import com.cognos.xqe.resultset.interfaces.IRowsetInfo;
import com.cognos.xqe.resultset.interfaces.ITabularIterator;
import com.cognos.xqe.resultset.interfaces.ITabularResultSet;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.runtree.relational.XExpression;
import java.sql.Date;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;

public class XMultisetValueConstructor
extends XExpression {
    private static final long serialVersionUID = 1L;

    @Override
    protected IValue executeImpl(XDataContext context) {
        ITabularResultSet resultSet = (ITabularResultSet)context.getStateObject(this);
        MultisetValue msValue = DataValueFactory.createMultisetValue(resultSet.getDataType());
        msValue.set(new ResultSet(resultSet));
        return msValue;
    }

    @Override
    public int getType() {
        return 501165;
    }

    @Override
    public void open(XDataContext context, IRowsetInfo rowsetInfo) {
        context.setStateObject(this, (ITabularResultSet)((IExecutable)((Object)this.getChild(0))).execute(context));
    }

    @Override
    public void close(XDataContext context) {
        ((ITabularResultSet)context.getStateObject(this)).release();
    }

    private class ResultSet
    extends Table {
        public static final String METHOD_NOT_SUPPORTED = "Method not supported";
        private ITabularResultSet iResultSet;
        private IRow row;
        private ITabularIterator iterator;

        ResultSet(ITabularResultSet resultSet) {
            this.iResultSet = resultSet;
            this.iterator = this.iResultSet.getTabularIterator();
        }

        @Override
        public boolean next() throws SQLException {
            this.row = (IRow)this.iterator.next();
            return this.row != null;
        }

        @Override
        public void close() throws SQLException {
            this.iterator.release();
            this.iResultSet.release();
        }

        @Override
        public boolean isAfterLast() throws SQLException {
            return this.row == null;
        }

        @Override
        public boolean wasNull() throws SQLException {
            return false;
        }

        @Override
        public Date getDate(int columnIndex) throws SQLException {
            return ((DateTimeValue)this.row.getColumn(columnIndex - 1)).getJdbcDate();
        }

        @Override
        public double getDouble(int columnIndex) throws SQLException {
            return ((Value)this.row.getColumn(columnIndex - 1)).getDouble();
        }

        @Override
        public float getFloat(int columnIndex) throws SQLException {
            return ((Value)this.row.getColumn(columnIndex - 1)).getFloat();
        }

        @Override
        public int getInt(int columnIndex) throws SQLException {
            return ((Value)this.row.getColumn(columnIndex - 1)).getInteger();
        }

        @Override
        public Object getObject(int columnIndex) throws SQLException {
            return ((Value)this.row.getColumn(columnIndex - 1)).getObject();
        }

        @Override
        public short getShort(int columnIndex) throws SQLException {
            return ((Value)this.row.getColumn(columnIndex - 1)).getShort();
        }

        @Override
        public String getString(int columnIndex) throws SQLException {
            return ((Value)this.row.getColumn(columnIndex - 1)).getString();
        }

        @Override
        public ResultSetMetaData getMetaData() throws SQLException {
            return new MetaData(this.iResultSet.getDataType());
        }

        @Override
        public <T> T getObject(int columnIndex, Class<T> type) throws SQLException {
            throw new SQLException(METHOD_NOT_SUPPORTED);
        }

        @Override
        public <T> T getObject(String columnLabel, Class<T> type) throws SQLException {
            throw new SQLException(METHOD_NOT_SUPPORTED);
        }

        private class MetaData
        extends Metadata {
            private RowType dataType;

            MetaData(IDataType dType) {
                this.dataType = (RowType)((MultisetType)dType).getElementType();
            }

            @Override
            public int getColumnCount() throws SQLException {
                return this.dataType.getNumberColumns();
            }

            @Override
            public String getColumnName(int index) throws SQLException {
                return this.dataType.getFieldName(index - 1);
            }

            @Override
            public int getColumnType(int index) throws SQLException {
                return this.dataType.getFieldDataType(index - 1).getJDBCType();
            }

            @Override
            public String getColumnTypeName(int index) throws SQLException {
                return this.dataType.getFieldDataType(index - 1).getSQLTypeName();
            }

            @Override
            public int getPrecision(int index) throws SQLException {
                return this.dataType.getFieldDataType(index - 1).getPrecision();
            }

            @Override
            public int getScale(int index) throws SQLException {
                return this.dataType.getFieldDataType(index - 1).getScale();
            }
        }
    }
}

