/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.relational;

import com.cognos.xqe.bibushandler.OperationCanceledException;
import com.cognos.xqe.data.values.BooleanValue;
import com.cognos.xqe.data.values.DataValueFactory;
import com.cognos.xqe.data.values.IRow;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.resultset.interfaces.ITabularIterator;
import com.cognos.xqe.resultset.interfaces.ITabularResultSet;
import com.cognos.xqe.resultsets.tabular.TabularHybridResultSet;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.runtree.XTabularIterator;
import com.cognos.xqe.runtree.relational.XJoin;
import org.dom4j.Element;

public class XNestedLoopsJoin
extends XJoin {
    private static final long serialVersionUID = 1L;

    @Override
    protected IValue executeImpl(XDataContext context) {
        return new TabularHybridResultSet(context, new XNestedLoopsJoinResultSet(context), this.getId());
    }

    @Override
    public int getType() {
        return 501010;
    }

    @Override
    public void capture(PlanningEnvironment env, Element inputNode) {
        String jType = inputNode.attributeValue("joinType");
        this.joinType = jType == null || jType.equals(XJoin.JoinType.INNER.getDescriptor()) ? XJoin.JoinType.INNER : XJoin.JoinType.LEFT_OUTER;
        super.capture(env, inputNode);
    }

    private final class XNestedLoopsJoinResultSet
    extends XJoin.ResultSet
    implements ITabularResultSet {
        XNestedLoopsJoinResultSet(XDataContext context) {
            super(context, XNestedLoopsJoin.this.getNumberChildren() - 1, XNestedLoopsJoin.this.getId());
        }

        @Override
        public ITabularIterator getTabularIterator() {
            return new XNestedLoopsJoinIterator(this.getDataContext());
        }

        private final class XNestedLoopsJoinIterator
        extends XTabularIterator {
            private XTabularIterator[] tabIt;
            private IRow resultRow;
            private IRow tempRow;
            private IRow[] rowList;
            private int nChildren;
            private int current;
            private XJoin.State state;
            private BooleanValue result;

            private XNestedLoopsJoinIterator(XDataContext context) {
                super(context, XNestedLoopsJoin.this.getId());
                this.current = 0;
                this.result = DataValueFactory.createBooleanValue();
                try {
                    this.startTimer();
                    this.nChildren = XNestedLoopsJoinResultSet.this.iResultSets.length;
                    this.tabIt = new XTabularIterator[this.nChildren];
                    this.rowList = new IRow[this.nChildren];
                    for (int i = 0; i < this.nChildren; ++i) {
                        this.tabIt[i] = (XTabularIterator)XNestedLoopsJoinResultSet.this.iResultSets[i].getTabularIterator();
                    }
                    this.resultRow = DataValueFactory.createRowValue(XNestedLoopsJoinResultSet.this.rowsetInfo);
                    this.tempRow = DataValueFactory.createRowValue(XNestedLoopsJoinResultSet.this.rowsetInfo);
                }
                catch (RuntimeException e) {
                    this.release();
                    throw e;
                }
                finally {
                    this.stopTimer();
                }
            }

            @Override
            public Object nextImpl() {
                if (this.context.isCanceled()) {
                    throw new OperationCanceledException(this.context.getCancelSource());
                }
                while (this.current >= 0) {
                    IRow inputRow;
                    if (this.current == 0 && XNestedLoopsJoin.this.joinType == XJoin.JoinType.LEFT_OUTER) {
                        if (this.state == XJoin.State.LESS_THAN) break;
                        this.state = XJoin.State.LESS_THAN;
                    }
                    if ((inputRow = (IRow)this.tabIt[this.current].next()) == null) {
                        --this.current;
                        continue;
                    }
                    this.rowList[this.current] = inputRow;
                    if (this.current == this.nChildren - 1) {
                        int k = 0;
                        IValue[] tValues = this.tempRow.getColumns();
                        for (int i = 0; i < this.nChildren; ++i) {
                            for (int j = 0; j < this.rowList[i].getNumColumns(); ++j) {
                                tValues[k++] = this.rowList[i].getColumn(j);
                            }
                        }
                        this.context.pushRow(XNestedLoopsJoin.this.contextNo, this.tempRow);
                        this.result = (BooleanValue)XNestedLoopsJoinResultSet.this.predicate.execute(this.context);
                        this.context.popRow();
                        if (!this.result.getBoolean()) continue;
                        this.state = XJoin.State.EQUAL;
                        break;
                    }
                    ++this.current;
                }
                if (this.current < 0) {
                    return null;
                }
                XNestedLoopsJoinResultSet.this.combine(this.resultRow, this.rowList, this.state);
                this.state = XJoin.State.EQUAL;
                ++this.nRows;
                return this.resultRow;
            }

            @Override
            public long getIndex() {
                return this.nRows;
            }

            @Override
            public void release() {
                if (this.tabIt != null) {
                    for (int i = 0; i < this.tabIt.length; ++i) {
                        try {
                            this.tabIt[i].release();
                            continue;
                        }
                        catch (Exception ex) {
                            mErrorLogger.log(ex);
                            continue;
                        }
                        finally {
                            this.tabIt[i] = null;
                        }
                    }
                    this.tabIt = null;
                }
                this.rowList = null;
                this.resultRow = null;
                this.tempRow = null;
                super.release();
            }
        }
    }
}

