/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.relational;

import com.cognos.xqe.ast.XQEPersistContext;
import com.cognos.xqe.ast.XQERestoreContext;
import com.cognos.xqe.bibushandler.OperationCanceledException;
import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.data.types.DataTypeFactory;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.data.values.IRow;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.parameters.Parameter;
import com.cognos.xqe.resultset.interfaces.IExecutable;
import com.cognos.xqe.resultset.interfaces.IHybridResultSet;
import com.cognos.xqe.resultset.interfaces.ITabularIterator;
import com.cognos.xqe.resultset.interfaces.ITabularResultSet;
import com.cognos.xqe.resultsets.tabular.TabularHybridResultSet;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.runtree.XResultSetBase;
import com.cognos.xqe.runtree.XTabularIterator;
import com.cognos.xqe.runtree.XTabularResultSet;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqe.trace.XQELogger;
import com.cognos.xqe.trace.XQETrace;
import java.util.List;
import org.dom4j.Element;

public class XParameterMapper
extends XTabularResultSet {
    private static final long serialVersionUID = 1L;
    private static final String ELEMENT_PARAMETERS = "Parameters";
    private static final String ATTRIBUTE_NAME = "name";
    private static final String ATTRIBUTE_COLUMNNO = "columnNo";
    private static final String ATTRIBUTE_DATATYPE = "dataType";
    private Parameter[] parameters;
    private static XQELogger mErrorLogger = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "Exception", LogLevel.ERROR);

    @Override
    protected IValue executeImpl(XDataContext context) {
        return new TabularHybridResultSet(context, new XParameterMapperResultSet(context), this.getId());
    }

    @Override
    public void dumpExtraInfo(XQETrace trace, boolean includeRuntimeSpecifics) {
        super.dumpExtraInfo(trace, includeRuntimeSpecifics);
        trace.beginElement(ELEMENT_PARAMETERS);
        for (Parameter parameter : this.parameters) {
            trace.beginElement("Parameter");
            trace.attribute(ATTRIBUTE_NAME, parameter.getName());
            trace.attribute(ATTRIBUTE_COLUMNNO, parameter.getColumnNo());
            trace.attribute(ATTRIBUTE_DATATYPE, parameter.getDataType());
            trace.endElement();
        }
        trace.endElement();
    }

    @Override
    public int getType() {
        return 501167;
    }

    @Override
    public void capture(PlanningEnvironment env, Element inputNode) {
        List elements = inputNode.elements();
        Element params = (Element)elements.get(0);
        List parameterList = params.elements();
        this.parameters = new Parameter[parameterList.size()];
        int i = 0;
        for (Element parameter : parameterList) {
            String name = parameter.attributeValue(ATTRIBUTE_NAME);
            Integer columnNo = Integer.valueOf(parameter.attributeValue(ATTRIBUTE_COLUMNNO));
            IDataType dataType = DataTypeFactory.getType(parameter.attributeValue(ATTRIBUTE_DATATYPE));
            this.parameters[i] = new Parameter(name, columnNo, dataType);
        }
        super.capture(env, inputNode, 1);
    }

    public void setParameters(Parameter[] theParameters) {
        this.parameters = theParameters;
    }

    @Override
    protected void persistElementProperties(XQEPersistContext ctx) {
        super.persistElementProperties(ctx);
        if (this.parameters != null) {
            ctx.elementProperty(ELEMENT_PARAMETERS, this.parameters);
        }
    }

    @Override
    protected void restoreElementProperty(XQERestoreContext ctx, Element node, Element inputNode) {
        String pname = node.attributeValue("pname");
        if (pname.equals(ELEMENT_PARAMETERS)) {
            Object val = ctx.elementValue(node);
            this.parameters = (Parameter[])val;
        } else {
            super.restoreElementProperty(ctx, node, inputNode);
        }
    }

    private final class XParameterMapperResultSet
    extends XResultSetBase
    implements ITabularResultSet {
        private IHybridResultSet iResultSet;

        XParameterMapperResultSet(XDataContext context) {
            super(context, XParameterMapper.this.getId());
            for (Parameter parameter : XParameterMapper.this.parameters) {
                context.setParameter(parameter.getName(), parameter);
            }
            this.iResultSet = (IHybridResultSet)((IExecutable)((Object)XParameterMapper.this.getChild(0))).execute(this.getDataContext());
            super.setTabularRowsetInfo(this.iResultSet.getTabularRowsetInfo());
        }

        @Override
        public ITabularIterator getTabularIterator() {
            return new XParameterMapperIterator(this.getDataContext());
        }

        @Override
        public void releaseImpl() {
            if (this.iResultSet != null) {
                this.iResultSet.release();
                this.iResultSet = null;
            }
            this.rowsetInfo = null;
        }

        private final class XParameterMapperIterator
        extends XTabularIterator {
            private ITabularIterator tabIt;
            private IRow row;

            private XParameterMapperIterator(XDataContext context) {
                super(context, XParameterMapper.this.getId());
                for (Parameter parameter : XParameterMapper.this.parameters) {
                    context.setParameter(parameter.getName(), parameter);
                }
                try {
                    this.startTimer();
                    this.tabIt = XParameterMapperResultSet.this.iResultSet.getTabularIterator();
                }
                catch (RuntimeException e) {
                    this.release();
                    throw e;
                }
                finally {
                    this.stopTimer();
                }
            }

            @Override
            public Object nextImpl() {
                if (this.context.isCanceled()) {
                    throw new OperationCanceledException(this.context.getCancelSource());
                }
                this.row = (IRow)this.tabIt.next();
                if (this.row == null) {
                    return null;
                }
                for (Parameter parameter : XParameterMapper.this.parameters) {
                    parameter.clearParameterValueItems();
                    parameter.addValue(this.row.getColumn(parameter.getColumnNo()));
                }
                ++this.nRows;
                return this.row;
            }

            @Override
            public long getIndex() {
                return this.tabIt.getIndex();
            }

            @Override
            public void release() {
                if (this.tabIt != null) {
                    try {
                        this.tabIt.release();
                    }
                    catch (Exception ex) {
                        mErrorLogger.log(ex);
                    }
                    finally {
                        this.tabIt = null;
                    }
                }
                super.release();
            }
        }
    }
}

