/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.relational;

import com.cognos.xqe.ast.XQEPersistContext;
import com.cognos.xqe.ast.XQERestoreContext;
import com.cognos.xqe.bibushandler.OperationCanceledException;
import com.cognos.xqe.data.values.IRow;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.IDimension;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.metadata.provider.Cube;
import com.cognos.xqe.metadata.provider.Dimension;
import com.cognos.xqe.metadata.provider.Hierarchy;
import com.cognos.xqe.metadata.provider.Level;
import com.cognos.xqe.metadata.provider.Member;
import com.cognos.xqe.metadata.provider.SimpleModelDataSource;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.resultset.interfaces.ICell;
import com.cognos.xqe.resultset.interfaces.IColumnInfo;
import com.cognos.xqe.resultset.interfaces.IExecutable;
import com.cognos.xqe.resultset.interfaces.IHybridResultSet;
import com.cognos.xqe.resultset.interfaces.IRowsetInfo;
import com.cognos.xqe.resultset.interfaces.ITabularIterator;
import com.cognos.xqe.resultset.interfaces.ITuple;
import com.cognos.xqe.resultsets.md.CacheHints;
import com.cognos.xqe.resultsets.md.Cell;
import com.cognos.xqe.resultsets.md.CubeHybridResultSet;
import com.cognos.xqe.resultsets.md.SetBase;
import com.cognos.xqe.resultsets.md.Tuple;
import com.cognos.xqe.resultsets.md.XCellIterator;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.runtree.XIterator;
import com.cognos.xqe.runtree.XIteratorAdaptor;
import com.cognos.xqe.runtree.XNode;
import com.cognos.xqe.runtree.XScrollableCellIterator;
import com.cognos.xqe.runtree.XScrollableIterator;
import com.cognos.xqe.runtree.olap.XCubeResultSet;
import com.cognos.xqe.util.UniqueNameGenerator;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.dom4j.Attribute;
import org.dom4j.Element;

public class XPivot
extends XNode {
    private static final long serialVersionUID = 1L;
    private static final int N_CHILD_ELEMENTS = 4;
    private static final String ATTRIBUTE_COLUMNNO = "columnNo";
    private static final String MEASURES = "Measures";
    private static final String MEASURES_LEVEL = "MeasuresLevel";
    private static final String DOT_AMPERSAND = ".&";
    private static final String ELEMENT_GROUPING_COLUMNS = "groupingColumns";
    private static final String ELEMENT_PIVOT_COLUMNS = "pivotColumns";
    private static final String ATTRIBUTE_MEASURE_COLUMN = "measureColumn";
    private static final String ELEMENT_GROUPING_AGGREGATES = "groupingAggregates";
    private static final String ELEMENT_GROUPING_VALUES = "groupingValues";
    private int[] groupingColumns;
    private int[] pivotColumns;
    private int measureColumn;
    private int[] groupingAggregates;
    private int[] groupingValues;

    @Override
    public int getType() {
        return 501037;
    }

    @Override
    protected IValue executeImpl(XDataContext context) throws XQERuntimeException {
        IHybridResultSet iResultSet = (IHybridResultSet)((IExecutable)((Object)this.getChild(0))).execute(context);
        IHybridResultSet pValueResultSet = null;
        pValueResultSet = (IHybridResultSet)((IExecutable)((Object)this.getChild(1))).execute(context);
        return new CubeHybridResultSet(context, new XPivotCubeResult(context, iResultSet, pValueResultSet), this.getId(), CacheHints.cacheCellsAlways());
    }

    private Member buildMember(String name, Level level) {
        Member member = new Member(name);
        member.setLevel(level);
        member.setCaption(name);
        member.setUniqueName(level.getUniqueName() + DOT_AMPERSAND + UniqueNameGenerator.createUniqueName(name));
        return member;
    }

    private String buildSummaryMemberName(String name) {
        return "Total(" + name + ")";
    }

    @Override
    public void capture(PlanningEnvironment env, Element inputNode) {
        int i;
        Element child = (Element)inputNode.elements().get(0);
        List exprList = child.elements();
        this.groupingColumns = new int[exprList.size()];
        for (i = 0; i < exprList.size(); ++i) {
            child = (Element)exprList.get(i);
            this.groupingColumns[i] = Integer.valueOf(child.attributeValue(ATTRIBUTE_COLUMNNO));
        }
        child = (Element)inputNode.elements().get(1);
        exprList = child.elements();
        this.pivotColumns = new int[exprList.size()];
        for (i = 0; i < exprList.size(); ++i) {
            child = (Element)exprList.get(i);
            this.pivotColumns[i] = Integer.valueOf(child.attributeValue(ATTRIBUTE_COLUMNNO));
        }
        child = (Element)inputNode.elements().get(2);
        this.measureColumn = Integer.valueOf(child.attributeValue(ATTRIBUTE_COLUMNNO));
        child = (Element)inputNode.elements().get(3);
        if (child.getName().equals("GroupingAggregates")) {
            exprList = child.elements();
            this.groupingAggregates = new int[exprList.size()];
            this.groupingValues = new int[exprList.size()];
            for (i = 0; i < exprList.size(); ++i) {
                child = (Element)exprList.get(i);
                this.groupingAggregates[i] = Integer.valueOf(child.attributeValue(ATTRIBUTE_COLUMNNO));
            }
            super.capture(env, inputNode, 4);
        } else {
            this.groupingValues = new int[this.groupingColumns.length + this.pivotColumns.length];
            super.capture(env, inputNode, 3);
        }
    }

    public XScrollableCellIterator getScrollableCellIterator() {
        throw new UnsupportedOperationException();
    }

    public XScrollableIterator getScrollableAxisIterator(int axisNumber) {
        throw new UnsupportedOperationException();
    }

    public IDimension[] getDimensions(int axisNumber) {
        throw new UnsupportedOperationException();
    }

    public long getAxisSize(int axisNumber) {
        throw new UnsupportedOperationException();
    }

    public int getMeasureColumn() {
        return this.measureColumn;
    }

    public void setMeasureColumn(int theMeasureColumn) {
        this.measureColumn = theMeasureColumn;
    }

    @Override
    protected void persistAttributeProperties(XQEPersistContext ctx) {
        super.persistAttributeProperties(ctx);
        ctx.property(ATTRIBUTE_MEASURE_COLUMN, this.measureColumn);
    }

    @Override
    protected void persistElementProperties(XQEPersistContext ctx) {
        super.persistElementProperties(ctx);
        if (this.groupingColumns != null) {
            ctx.elementProperty(ELEMENT_GROUPING_COLUMNS, this.groupingColumns);
        }
        if (this.pivotColumns != null) {
            ctx.elementProperty(ELEMENT_PIVOT_COLUMNS, this.pivotColumns);
        }
        if (this.groupingAggregates != null) {
            ctx.elementProperty(ELEMENT_GROUPING_AGGREGATES, this.groupingAggregates);
        }
        if (this.groupingValues != null) {
            ctx.elementProperty(ELEMENT_GROUPING_VALUES, this.groupingValues);
        }
    }

    @Override
    protected void restoreAttributeProperty(XQERestoreContext ctx, Attribute att, Element inputNode) {
        String attname = att.getName();
        if (attname.equals(ATTRIBUTE_MEASURE_COLUMN)) {
            Object val = ctx.attributeValue(att);
            this.measureColumn = (Integer)val;
        } else {
            super.restoreAttributeProperty(ctx, att, inputNode);
        }
    }

    @Override
    protected void restoreElementProperty(XQERestoreContext ctx, Element node, Element inputNode) {
        String pname = node.attributeValue("pname");
        if (pname.equals(ELEMENT_GROUPING_COLUMNS)) {
            Object val = ctx.elementValue(node);
            this.groupingColumns = (int[])val;
        } else if (pname.equals(ELEMENT_PIVOT_COLUMNS)) {
            Object val = ctx.elementValue(node);
            this.pivotColumns = (int[])val;
        } else if (pname.equals(ELEMENT_GROUPING_AGGREGATES)) {
            Object val = ctx.elementValue(node);
            this.groupingAggregates = (int[])val;
        } else if (pname.equals(ELEMENT_GROUPING_VALUES)) {
            Object val = ctx.elementValue(node);
            this.groupingValues = (int[])val;
        } else {
            super.restoreElementProperty(ctx, node, inputNode);
        }
    }

    private class XPivotCubeResult
    extends XCubeResultSet {
        private transient SetBase[] axes;
        private transient SetBase slicer;
        private transient TreeSet<ICell> cells;
        private transient IHybridResultSet sourceResult;
        private IHybridResultSet columnHeaders;

        XPivotCubeResult(XDataContext dataContext, IHybridResultSet sourceResultSet, IHybridResultSet headers) {
            super(dataContext, sourceResultSet, XPivot.this.getId());
            this.cells = new TreeSet();
            this.sourceResult = sourceResultSet;
            this.columnHeaders = headers;
            this.generateCubeData();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void generateCubeData() {
            ArrayList<Tuple> tupleListForAxis0 = new ArrayList<Tuple>();
            ArrayList<Tuple> tupleListForAxis1 = new ArrayList<Tuple>();
            ITabularIterator input = this.sourceResult.getTabularIterator();
            try {
                IRow iValues;
                Member member;
                String name;
                IColumnInfo columnInfo;
                Level level;
                Hierarchy hierarchy;
                Dimension dimension;
                IRowsetInfo cRowsetInfo = this.sourceResult.getTabularRowsetInfo();
                ITabularIterator tabIt = this.columnHeaders.getTabularIterator();
                Cube cube = null;
                try {
                    IRow row;
                    SimpleModelDataSource dataSource = new SimpleModelDataSource("Transient Database");
                    cube = dataSource.addCube("Transient Cube");
                    cube.setInitialised();
                    dimension = new Dimension(XPivot.MEASURES);
                    cube.addDimension(dimension);
                    dimension.setInitialised();
                    hierarchy = dimension.addHierarchy(XPivot.MEASURES);
                    hierarchy.setInitialised();
                    hierarchy.setUniqueName(UniqueNameGenerator.createUniqueName(XPivot.MEASURES));
                    level = hierarchy.addLevel(XPivot.MEASURES_LEVEL);
                    level.setInitialised();
                    columnInfo = cRowsetInfo.getColumnInfo(XPivot.this.measureColumn);
                    Member measure = level.addMember(columnInfo.getName(), null);
                    measure.setCaption(columnInfo.getName());
                    measure.setUniqueName(UniqueNameGenerator.createUniqueName(XPivot.MEASURES, columnInfo.getName()));
                    this.slicer = new com.cognos.xqe.resultsets.md.Set(new Tuple(measure));
                    for (int i = 0; i < XPivot.this.pivotColumns.length; ++i) {
                        columnInfo = cRowsetInfo.getColumnInfo(XPivot.this.pivotColumns[i]);
                        dimension = new Dimension(columnInfo.getName());
                        cube.addDimension(dimension);
                        dimension.setInitialised();
                        hierarchy = dimension.addHierarchy(columnInfo.getName());
                        hierarchy.setUniqueName(UniqueNameGenerator.createUniqueName(columnInfo.getName()));
                        level = hierarchy.addLevel(columnInfo.getName());
                        level.setInitialised();
                    }
                    this.axes = new SetBase[2];
                    while ((row = (IRow)tabIt.next()) != null) {
                        name = row.getColumn(0).toString();
                        member = new Member(name);
                        member.setLevel(level);
                        member.setUniqueName(level.getUniqueName() + XPivot.DOT_AMPERSAND + UniqueNameGenerator.createUniqueName(name));
                        member.setCaption(name);
                        tupleListForAxis0.add(new Tuple(member));
                    }
                }
                finally {
                    tabIt.release();
                    tabIt = null;
                }
                int nPivotValuesOnAxis0 = tupleListForAxis0.size();
                Level[] levelsForAxis1 = new Level[XPivot.this.groupingColumns.length];
                for (int i = 0; i < XPivot.this.groupingColumns.length; ++i) {
                    columnInfo = cRowsetInfo.getColumnInfo(XPivot.this.groupingColumns[i]);
                    dimension = new Dimension(columnInfo.getName());
                    cube.addDimension(dimension);
                    dimension.setInitialised();
                    hierarchy = dimension.addHierarchy(columnInfo.getName());
                    hierarchy.setUniqueName(UniqueNameGenerator.createUniqueName(columnInfo.getName()));
                    levelsForAxis1[i] = hierarchy.addLevel(columnInfo.getName());
                    levelsForAxis1[i].setInitialised();
                }
                long baseOrdinal = 0L;
                long ordinal = 0L;
                long j = 0L;
                boolean firstTuple = true;
                IMember[] members = new Member[XPivot.this.groupingColumns.length];
                tupleListForAxis1.add(new Tuple(members));
                boolean[] controlBreak = new boolean[XPivot.this.groupingColumns.length];
                IValue[] kValues = new IValue[XPivot.this.groupingColumns.length];
                while ((iValues = (IRow)input.next()) != null) {
                    int i;
                    if (firstTuple) {
                        for (i = 0; i < XPivot.this.groupingColumns.length; ++i) {
                            members[i] = XPivot.this.buildMember(iValues.getColumn(XPivot.this.groupingColumns[i]).toString(), levelsForAxis1[i]);
                        }
                        firstTuple = false;
                    }
                    if (XPivot.this.groupingAggregates != null) {
                        for (i = 0; i < XPivot.this.groupingValues.length; ++i) {
                            Value gValue = (Value)iValues.getColumn(XPivot.this.groupingAggregates[i]);
                            ((XPivot)XPivot.this).groupingValues[i] = gValue.getInteger();
                        }
                    }
                    if (kValues[0] != null) {
                        for (i = 0; i < XPivot.this.groupingColumns.length; ++i) {
                            IValue iValue = iValues.getColumn(i);
                            controlBreak[i] = iValue.isNull() && kValues[i].isNull() ? false : (iValue.isNull() || kValues[i].isNull() ? true : kValues[i].compareTo(iValue) != 0);
                        }
                    }
                    if (controlBreak[0]) {
                        baseOrdinal += (long)tupleListForAxis0.size();
                        j = 0L;
                    }
                    if (XPivot.this.groupingValues[XPivot.this.groupingColumns.length] == 1) {
                        if (tupleListForAxis0.size() == nPivotValuesOnAxis0) {
                            columnInfo = cRowsetInfo.getColumnInfo(XPivot.this.pivotColumns[0]);
                            member = XPivot.this.buildMember(XPivot.this.buildSummaryMemberName(columnInfo.getName()), level);
                            tupleListForAxis0.add(new Tuple(member));
                        }
                        ordinal = baseOrdinal + (long)nPivotValuesOnAxis0;
                    } else {
                        ordinal = baseOrdinal + j++;
                    }
                    Cell cell = new Cell(ordinal, (IValue)iValues.getColumn(XPivot.this.measureColumn).copy());
                    this.cells.add(cell);
                    for (int i2 = 0; i2 < XPivot.this.groupingColumns.length; ++i2) {
                        kValues[i2] = (IValue)iValues.getColumn(i2).copy();
                    }
                    boolean generateTuple = false;
                    for (int i3 = 0; i3 < XPivot.this.groupingColumns.length && !generateTuple; ++i3) {
                        generateTuple = controlBreak[i3];
                    }
                    if (!generateTuple) continue;
                    IMember[] oldMembers = members;
                    members = new Member[XPivot.this.groupingColumns.length];
                    tupleListForAxis1.add(new Tuple(members));
                    for (int i4 = 0; i4 < XPivot.this.groupingColumns.length; ++i4) {
                        if (controlBreak[i4]) {
                            if (XPivot.this.groupingValues[i4] == 1) {
                                columnInfo = cRowsetInfo.getColumnInfo(XPivot.this.groupingColumns[i4]);
                                name = XPivot.this.buildSummaryMemberName(columnInfo.getName());
                            } else {
                                name = iValues.getColumn(XPivot.this.groupingColumns[i4]).toString();
                            }
                            members[i4] = XPivot.this.buildMember(name, levelsForAxis1[i4]);
                            continue;
                        }
                        members[i4] = oldMembers[i4];
                    }
                }
            }
            finally {
                input.release();
                input = null;
            }
            Tuple[] tuples = new Tuple[tupleListForAxis0.size()];
            tupleListForAxis0.toArray(tuples);
            this.axes[0] = new com.cognos.xqe.resultsets.md.Set(tuples);
            tuples = new Tuple[tupleListForAxis1.size()];
            tupleListForAxis1.toArray(tuples);
            this.axes[1] = new com.cognos.xqe.resultsets.md.Set(tuples);
        }

        @Override
        public XIterator getAxisIterator(int axisNumber) {
            if (axisNumber < 0 || axisNumber >= this.axes.length) {
                return null;
            }
            return new XIteratorAdaptor(this.getDataContext(), this.axes[axisNumber].iterator(), XPivot.this.getId());
        }

        @Override
        public XCellIterator getCellIterator() {
            return new XPivotCellIterator(this.getDataContext(), this.cells);
        }

        @Override
        public int getNumAxes() {
            return this.axes.length;
        }

        @Override
        public ITuple getSlicer() {
            return this.slicer.getTuple(0L);
        }

        @Override
        public void releaseImpl() {
            try {
                this.axes = null;
                if (this.cells != null) {
                    this.cells.clear();
                    this.cells = null;
                }
                this.slicer = null;
                if (this.columnHeaders != null) {
                    this.columnHeaders.release();
                    this.columnHeaders = null;
                }
            }
            finally {
                super.releaseImpl();
            }
        }
    }

    private class XPivotCellIterator
    extends XCellIterator {
        private Iterator<ICell> it;

        XPivotCellIterator(XDataContext context, Set<ICell> cells) {
            super(context, XPivot.this.getId());
            this.it = cells.iterator();
        }

        @Override
        public boolean hasNext() {
            return this.it.hasNext();
        }

        @Override
        public ICell nextImpl() {
            if (this.context.isCanceled()) {
                throw new OperationCanceledException(this.context.getCancelSource());
            }
            ICell result = this.it.next();
            if (null != result) {
                ++this.currentOrdinal;
            }
            return result;
        }

        @Override
        public void release() {
            super.release();
        }

        @Override
        public boolean hasPipelineIterator() {
            return false;
        }
    }
}

