/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.relational;

import com.cognos.xqe.ast.XQEBaseQueryNode;
import com.cognos.xqe.ast.XQEPersistContext;
import com.cognos.xqe.ast.XQERestoreContext;
import com.cognos.xqe.bibushandler.OperationCanceledException;
import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.data.values.DataValueFactory;
import com.cognos.xqe.data.values.IRow;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.query.engine.IPlanningEnvironment;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.resultset.interfaces.IExecutable;
import com.cognos.xqe.resultset.interfaces.IHybridResultSet;
import com.cognos.xqe.resultset.interfaces.IRowsetInfo;
import com.cognos.xqe.resultset.interfaces.IScrollableIterator;
import com.cognos.xqe.resultset.interfaces.ITabularIterator;
import com.cognos.xqe.resultset.interfaces.ITabularResultSet;
import com.cognos.xqe.resultsets.tabular.ColumnInfo;
import com.cognos.xqe.resultsets.tabular.RowsetInfo;
import com.cognos.xqe.resultsets.tabular.TabularHybridResultSet;
import com.cognos.xqe.runtree.IXExpression;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.runtree.XNode;
import com.cognos.xqe.runtree.XNodeFactory;
import com.cognos.xqe.runtree.XResultSetBase;
import com.cognos.xqe.runtree.XTabularIterator;
import com.cognos.xqe.runtree.XTabularResultSet;
import com.cognos.xqe.runtree.relational.XExpression;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqe.trace.XQELogger;
import com.cognos.xqe.trace.XQETrace;
import java.util.Iterator;
import java.util.List;
import org.dom4j.Element;

public class XProject
extends XTabularResultSet {
    private static final long serialVersionUID = 1L;
    private static final String ELEMENT_OUTPUTLIST = "OutputList";
    private static final String ATTRIBUTE_CONTEXTNO = "contextNo";
    private IXExpression[] outputList;
    private static XQELogger mErrorLogger = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "Exception", LogLevel.ERROR);

    @Override
    protected IValue executeImpl(XDataContext context) {
        return new TabularHybridResultSet(context, new XProjectResultSet(context), this.getId());
    }

    @Override
    public int getType() {
        return 501011;
    }

    public IExecutable[] getOutputList() {
        return this.outputList;
    }

    public void setOutputList(XExpression[] theOutputList) {
        this.outputList = theOutputList;
    }

    @Override
    public void clearPlanningEnvironment() {
        super.clearPlanningEnvironment();
        if (this.outputList != null && this.outputList.length != 0) {
            for (IXExpression outputNode : this.outputList) {
                ((XQEBaseQueryNode)((Object)outputNode)).clearPlanningEnvironment();
            }
        }
    }

    @Override
    public void recursiveSetPlanningEnvironment(IPlanningEnvironment planningEnvironment) {
        super.recursiveSetPlanningEnvironment(planningEnvironment);
        if (this.outputList != null && this.outputList.length != 0) {
            for (IXExpression outputNode : this.outputList) {
                ((XQEBaseQueryNode)((Object)outputNode)).recursiveSetPlanningEnvironment(planningEnvironment);
            }
        }
    }

    @Override
    public void dumpExtraInfo(XQETrace trace, boolean includeRuntimeSpecifics) {
        super.dumpExtraInfo(trace, includeRuntimeSpecifics);
        trace.attribute(ATTRIBUTE_CONTEXTNO, String.valueOf(this.contextNo));
        trace.beginElement(ELEMENT_OUTPUTLIST);
        for (int i = 0; i < this.outputList.length; ++i) {
            this.outputList[i].dump(trace);
        }
        trace.endElement();
    }

    @Override
    public void capture(PlanningEnvironment env, Element inputNode) {
        XNodeFactory nodeFactory = (XNodeFactory)env.getNodeFactory();
        List elements = inputNode.elements();
        Iterator it = elements.iterator();
        Element child = (Element)it.next();
        List exprList = child.elements();
        this.outputList = new IXExpression[exprList.size()];
        for (int i = 0; i < exprList.size(); ++i) {
            child = (Element)exprList.get(i);
            XNode xNode = (XNode)nodeFactory.createNodeByName(child.getName());
            xNode.capture(env, child);
            this.outputList[i] = (IXExpression)((Object)xNode);
        }
        this.capture(env, inputNode, elements.size() - 1);
    }

    @Override
    protected void persistElementProperties(XQEPersistContext ctx) {
        super.persistElementProperties(ctx);
        if (this.outputList != null) {
            ctx.elementProperty(ELEMENT_OUTPUTLIST, this.outputList);
        }
    }

    @Override
    protected void restoreElementProperty(XQERestoreContext ctx, Element node, Element inputNode) {
        String pname = node.attributeValue("pname");
        if (pname != null && pname.equals(ELEMENT_OUTPUTLIST)) {
            Object val = ctx.elementValue(node);
            this.outputList = (IXExpression[])val;
        } else {
            super.restoreElementProperty(ctx, node, inputNode);
        }
    }

    private final class XProjectResultSet
    extends XResultSetBase
    implements ITabularResultSet {
        private IHybridResultSet iResultSet;

        XProjectResultSet(XDataContext context) {
            super(context, XProject.this.getId());
            try {
                this.iResultSet = (IHybridResultSet)((IExecutable)((Object)XProject.this.getChild(0))).execute(context);
                this.rowsetInfo = new RowsetInfo();
                IRowsetInfo iRowsetInfo = this.iResultSet.getTabularRowsetInfo();
                for (int i = 0; i < XProject.this.outputList.length; ++i) {
                    IXExpression xExprNode = XProject.this.outputList[i];
                    String name = xExprNode.getName(iRowsetInfo, i);
                    IDataType dType = xExprNode.getDataType(iRowsetInfo, i);
                    this.rowsetInfo.addColumnInfo(new ColumnInfo(name, dType));
                }
                for (IXExpression xExpr : XProject.this.outputList) {
                    xExpr.open(context, iRowsetInfo);
                }
            }
            catch (RuntimeException e) {
                this.release();
                throw e;
            }
        }

        @Override
        public IScrollableIterator getScrollableTabularIterator() {
            throw new UnsupportedOperationException();
        }

        @Override
        public ITabularIterator getTabularIterator() {
            return new XProjectIterator(this.getDataContext(), this.iResultSet);
        }

        @Override
        public void releaseImpl() {
            if (this.iResultSet != null) {
                this.iResultSet.release();
                this.iResultSet = null;
            }
            for (IXExpression xExpr : XProject.this.outputList) {
                xExpr.close(this.getDataContext());
            }
            this.rowsetInfo = null;
        }

        private final class XProjectIterator
        extends XTabularIterator {
            private ITabularIterator tabIt;
            private IRow result;

            private XProjectIterator(XDataContext context, ITabularResultSet resultSet) {
                super(context, XProject.this.getId());
                try {
                    this.startTimer();
                    this.tabIt = resultSet.getTabularIterator();
                    this.result = DataValueFactory.createRowValue(new IValue[XProject.this.outputList.length]);
                }
                catch (RuntimeException e) {
                    this.release();
                    throw e;
                }
                finally {
                    this.stopTimer();
                }
            }

            @Override
            public Object nextImpl() {
                if (this.context.isCanceled()) {
                    throw new OperationCanceledException(this.context.getCancelSource());
                }
                IRow inputRow = (IRow)this.tabIt.next();
                if (inputRow == null) {
                    return null;
                }
                this.context.pushRow(XProject.this.contextNo, inputRow);
                for (int i = 0; i < XProject.this.outputList.length; ++i) {
                    this.result.setColumn(i, XProject.this.outputList[i].execute(this.context));
                }
                this.context.popRow();
                ++this.nRows;
                return this.result;
            }

            @Override
            public long getIndex() {
                return this.tabIt.getIndex();
            }

            @Override
            public void release() {
                if (this.tabIt != null) {
                    try {
                        this.tabIt.release();
                    }
                    catch (Exception ex) {
                        mErrorLogger.log(ex);
                    }
                    finally {
                        this.tabIt = null;
                    }
                }
                this.result = null;
                super.release();
            }
        }
    }
}

