/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.relational;

import com.cognos.xqe.ast.sql.SQLAbstractFunction;
import com.cognos.xqe.ast.sql.SQLQuantifier;
import com.cognos.xqe.data.model.IDataSource;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.data.values.BooleanValue;
import com.cognos.xqe.data.values.DataValueFactory;
import com.cognos.xqe.data.values.IRow;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.function.ComparisonFunction;
import com.cognos.xqe.function.FunctionManager;
import com.cognos.xqe.function.IParameterEvaluator;
import com.cognos.xqe.function.operator.GreaterThan;
import com.cognos.xqe.function.operator.GreaterThanOrEquals;
import com.cognos.xqe.function.operator.LessThan;
import com.cognos.xqe.function.operator.LessThanOrEquals;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.resultset.interfaces.IExecutable;
import com.cognos.xqe.resultset.interfaces.IRowsetInfo;
import com.cognos.xqe.resultset.interfaces.ITabularResultSet;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.runtree.relational.SubQueryState;
import com.cognos.xqe.runtree.relational.XExpression;
import com.cognos.xqe.runtree.relational.XSubQuery;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.util.IReleasable;
import org.dom4j.Element;

public class XQuantifiedPredicate
extends XSubQuery
implements IParameterEvaluator {
    private static final long serialVersionUID = 1L;
    private static final String ATTRIBUTE_FUNCTION = "function";
    private static final String ATTRIBUTE_SUBTYPE = "subtype";
    private ComparisonFunction function;
    private SQLQuantifier.SubType eSubtype = SQLQuantifier.SubType.ALL;
    private boolean bNulls = false;

    @Override
    public void open(XDataContext context, IRowsetInfo rowsetInfo) {
        context.setStateObject(this, new SubQueryState(context, this.getParameters()));
    }

    public void setSubType(SQLQuantifier.SubType val) {
        this.eSubtype = val;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected IValue executeImpl(XDataContext context) {
        IValue value;
        SubQueryState state = (SubQueryState)context.getStateObject(this);
        if (!state.isValid()) {
            this.lock.writeLock().lock();
            try {
                ITabularResultSet resultSet = null;
                IReleasable tabIt = null;
                try {
                    resultSet = (ITabularResultSet)((IExecutable)((Object)this.getChild(1))).execute(context);
                    tabIt = resultSet.getTabularIterator();
                    IRow row = (IRow)tabIt.next();
                    while (row != null && row.getColumn(0).isNull()) {
                        this.bNulls = true;
                        row = (IRow)tabIt.next();
                    }
                    if (row != null) {
                        if (this.getChild(0).getType() == 501051) {
                            state.setValue(row);
                        } else {
                            state.setValue(row.getColumn(0));
                        }
                    } else {
                        BooleanValue v = BooleanValue.UNKNOWN;
                        v.setNull();
                        state.setValue(v);
                    }
                }
                finally {
                    if (tabIt != null) {
                        tabIt.release();
                    }
                    if (resultSet != null) {
                        resultSet.release();
                    }
                }
            }
            finally {
                this.lock.writeLock().unlock();
            }
        }
        if ((value = (IValue)state.getValue()).isNull()) {
            if (this.bNulls) {
                return BooleanValue.UNKNOWN;
            }
            if (SQLQuantifier.SubType.ALL.equals((Object)this.eSubtype)) {
                return BooleanValue.TRUE;
            }
            return BooleanValue.FALSE;
        }
        BooleanValue output = DataValueFactory.createBooleanValue();
        this.function.execute(context, (IParameterEvaluator)this, output);
        if (this.bNulls) {
            if (SQLQuantifier.SubType.ALL.equals((Object)this.eSubtype) && BooleanValue.TRUE.equals(output)) {
                return BooleanValue.UNKNOWN;
            }
            if (!SQLQuantifier.SubType.ALL.equals((Object)this.eSubtype) && BooleanValue.FALSE.equals(output)) {
                return BooleanValue.UNKNOWN;
            }
        }
        return output;
    }

    @Override
    public void close(XDataContext context) {
        context.removeStateObject(this);
    }

    @Override
    public int getType() {
        return 501097;
    }

    @Override
    public void dumpExtraInfo(XQETrace trace, boolean includeRuntimeSpecifics) {
        trace.attribute(ATTRIBUTE_FUNCTION, this.function.toString());
        trace.attribute(ATTRIBUTE_SUBTYPE, this.eSubtype.key());
        super.dumpExtraInfo(trace, includeRuntimeSpecifics);
    }

    @Override
    public void capture(PlanningEnvironment env, Element inputNode) {
        this.setContextNo(Integer.parseInt(inputNode.attribute("contextNo").getValue()));
        String fName = inputNode.attribute(ATTRIBUTE_FUNCTION).getStringValue();
        ComparisonFunction theFunction = (ComparisonFunction)FunctionManager.getBuiltinFunction(fName);
        if (theFunction == null) {
            throw new UnsupportedOperationException(fName);
        }
        this.setFunction(theFunction);
        fName = inputNode.attribute(ATTRIBUTE_SUBTYPE).getStringValue();
        for (SQLQuantifier.SubType subType : SQLQuantifier.SubType.values()) {
            if (!subType.key().equals(fName)) continue;
            this.eSubtype = subType;
            break;
        }
        super.capture(env, inputNode);
    }

    public void setFunction(ComparisonFunction theFunction) {
        if (!(theFunction instanceof GreaterThan || theFunction instanceof GreaterThanOrEquals || theFunction instanceof LessThan || theFunction instanceof LessThanOrEquals)) {
            throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "Unsupported comparison function");
        }
        this.function = theFunction;
    }

    public ComparisonFunction getFunction() {
        return this.function;
    }

    @Override
    public IValue getParameter(XDataContext context, int index) {
        if (index == 0) {
            return ((XExpression)this.getChild(0)).execute(context);
        }
        return (IValue)((SubQueryState)context.getStateObject(this)).getValue();
    }

    @Override
    public IValue[] getParameters(XDataContext context) {
        return null;
    }

    @Override
    public int getParameterCount() {
        return 2;
    }

    @Override
    public String getParameterName(int index) {
        return null;
    }

    @Override
    public boolean isParameterLiteral(int index) {
        return false;
    }

    @Override
    public IDataType getParameterType(int index) {
        return null;
    }

    @Override
    public IDataSource getDataSource() {
        return null;
    }

    @Override
    public SQLAbstractFunction.OnErrorPolicy getOnErrorPolicy() {
        throw new UnsupportedOperationException();
    }
}

