/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.relational;

import com.cognos.xqe.ast.IValueExpression;
import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQEPersistContext;
import com.cognos.xqe.ast.XQERestoreContext;
import com.cognos.xqe.ast.sql.SQLAbstractFunction;
import com.cognos.xqe.ast.sql.SQLValueList;
import com.cognos.xqe.data.model.IDataSource;
import com.cognos.xqe.data.types.DataTypeFactory;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.function.FunctionManager;
import com.cognos.xqe.function.IFunction;
import com.cognos.xqe.function.IParameterEvaluator;
import com.cognos.xqe.function.ISetFunction;
import com.cognos.xqe.function.ISetFunctionState;
import com.cognos.xqe.function.udf.UDAggregateFunction;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.resultset.interfaces.IRowsetInfo;
import com.cognos.xqe.runtree.IXExpression;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.runtree.XNode;
import com.cognos.xqe.runtree.relational.XExpression;
import com.cognos.xqe.runtree.relational.XWindowFunction;
import com.cognos.xqe.trace.XQETrace;
import org.dom4j.Attribute;
import org.dom4j.Element;

public class XSetFunction
extends XNode
implements IParameterEvaluator,
IValueExpression,
IXExpression {
    private static final long serialVersionUID = 1L;
    private static final String ATTRIBUTE_FUNCTION = "function";
    private static final String ATTRIBUTE_DATATYPE = "dataType";
    private static final String ATTRIBUTE_DISTINCT = "distinct";
    private static final String ATTRIBUTE_ISUDF = "isUDF";
    private static final String ATTRIBUTE_ON_ERROR_POLICY = "onErrorPolicy";
    private static final String VALUE_TRUE = "true";
    protected ISetFunction function;
    protected IDataType dataType;
    protected SQLAbstractFunction.OnErrorPolicy onErrorPolicy;

    @Override
    public void open(XDataContext context, IRowsetInfo rowsetInfo) {
        for (IXQEQueryNode child : this.getChildren()) {
            if (!(child instanceof XExpression)) continue;
            ((IXExpression)((Object)child)).open(context, rowsetInfo);
        }
    }

    @Override
    public void close(XDataContext context) {
        for (IXQEQueryNode child : this.getChildren()) {
            ((IXExpression)((Object)child)).close(context);
        }
    }

    @Override
    public String getName(IRowsetInfo rowsetInfo, int index) {
        return this.function.toString() + index;
    }

    @Override
    public IDataType getDataType(IRowsetInfo rowsetInfo, int index) {
        if (this.dataType.getCCLTypeCode() != 22) {
            return this.dataType;
        }
        IDataType[] arguments = new IDataType[this.getNumberChildren()];
        for (int i = 0; i < this.getNumberChildren(); ++i) {
            arguments[i] = ((IXExpression)((Object)this.getChild(i))).getDataType(rowsetInfo, i);
        }
        this.dataType = this.getFunction().getResultDataType(arguments);
        return this.dataType;
    }

    public ISetFunctionState initialize(XDataContext context) {
        return this.function.initialize(context, this, this.dataType);
    }

    public void iterate(XDataContext context, ISetFunctionState state) {
        this.iterate(context, state, this);
    }

    public void iterate(XDataContext context, ISetFunctionState state, IParameterEvaluator pEvaluator) {
        this.function.iterate(context, state, pEvaluator);
    }

    public void remove(XDataContext context, ISetFunctionState state) {
        this.remove(context, state, this);
    }

    public void remove(XDataContext context, ISetFunctionState state, IParameterEvaluator pEvaluator) {
        this.function.remove(context, state, pEvaluator);
    }

    public void getResult(XDataContext context, ISetFunctionState state, IValue value) {
        this.function.getResult(context, state, value);
    }

    public void terminate(XDataContext context, ISetFunctionState state) {
        this.function.terminate(context, state);
    }

    public void setDataType(IDataType aDataType) {
        this.dataType = aDataType;
    }

    @Override
    public IDataType getDataType() {
        return this.dataType;
    }

    @Override
    public int getParameterCount() {
        return this.getNumberChildren();
    }

    @Override
    public IValue getParameter(XDataContext context, int index) {
        IValueExpression xnode = (IValueExpression)this.getChild(index);
        if (xnode instanceof XWindowFunction) {
            IXQEQueryNode xchild = xnode.getChild(0);
            return ((XExpression)xchild).execute(context);
        }
        return ((XExpression)xnode).execute(context);
    }

    @Override
    public IValue[] getParameters(XDataContext context) {
        if (this.getChild(0) instanceof SQLValueList) {
            int nChildren = this.getChild(0).getNumberChildren();
            IValueExpression xnode = (IValueExpression)this.getChild(0);
            IValue[] pValues = new IValue[nChildren];
            for (int i = 0; i < nChildren; ++i) {
                IXQEQueryNode xchild = xnode.getChild(i);
                pValues[i] = ((XExpression)xchild).execute(context);
            }
            return pValues;
        }
        int nChildren = this.getNumberChildren();
        IValue[] pValues = new IValue[nChildren];
        for (int i = 0; i < nChildren; ++i) {
            pValues[i] = this.getParameter(context, i);
        }
        return pValues;
    }

    @Override
    public String getParameterName(int index) {
        return this.function.toString() + index;
    }

    @Override
    public IDataType getParameterType(int index) {
        return ((XExpression)this.getChild(index)).getDataType();
    }

    @Override
    public int getType() {
        return 501038;
    }

    public String getName(int index) {
        return this.function.toString() + index;
    }

    @Override
    public boolean isParameterLiteral(int index) {
        return this.getChild(index).getType() == 501019;
    }

    public void setFunction(ISetFunction theFunction) {
        this.function = theFunction;
    }

    public IFunction getFunction() {
        return this.function;
    }

    @Override
    public void dumpExtraInfo(XQETrace trace, boolean includeRuntimeSpecifics) {
        trace.attribute(ATTRIBUTE_FUNCTION, this.function.toString());
        trace.attribute(ATTRIBUTE_DATATYPE, this.dataType.toString());
        trace.attribute(ATTRIBUTE_DISTINCT, Boolean.toString(this.function.isDistinct()));
        if (this.onErrorPolicy != null) {
            trace.attribute(ATTRIBUTE_ON_ERROR_POLICY, this.onErrorPolicy.getOnErrorPolicyValue());
        }
        if (this.function instanceof UDAggregateFunction) {
            trace.attribute(ATTRIBUTE_ISUDF, VALUE_TRUE);
        }
    }

    @Override
    public void capture(PlanningEnvironment env, Element inputNode) {
        this.setDataType(DataTypeFactory.getType(inputNode.attribute(ATTRIBUTE_DATATYPE).getValue()));
        boolean isUDF = false;
        Attribute isUDFattr = inputNode.attribute(ATTRIBUTE_ISUDF);
        if (isUDFattr != null) {
            isUDF = isUDFattr.getValue().equalsIgnoreCase(VALUE_TRUE);
        }
        super.capture(env, inputNode);
        String fname = inputNode.attribute(ATTRIBUTE_FUNCTION).getStringValue();
        if (isUDF) {
            IDataType[] argTypes = null;
            this.function = (ISetFunction)FunctionManager.getUserDefinedFunction(fname, argTypes);
        } else {
            this.function = (ISetFunction)FunctionManager.getBuiltinFunction(fname);
        }
        Attribute distinctAttr = inputNode.attribute(ATTRIBUTE_DISTINCT);
        if (distinctAttr != null) {
            this.function.setDistinct(distinctAttr.getValue().equalsIgnoreCase(VALUE_TRUE));
        }
        String onErrorPolicyValue = inputNode.attributeValue(ATTRIBUTE_ON_ERROR_POLICY);
        if (SQLAbstractFunction.OnErrorPolicy.ERROR.getOnErrorPolicyValue().equals(onErrorPolicyValue)) {
            this.onErrorPolicy = SQLAbstractFunction.OnErrorPolicy.ERROR;
        } else if (SQLAbstractFunction.OnErrorPolicy.NULL.getOnErrorPolicyValue().equals(onErrorPolicyValue)) {
            this.onErrorPolicy = SQLAbstractFunction.OnErrorPolicy.NULL;
        }
    }

    @Override
    public IDataSource getDataSource() {
        return null;
    }

    @Override
    protected void persistAttributeProperties(XQEPersistContext ctx) {
        super.persistAttributeProperties(ctx);
        ctx.property(ATTRIBUTE_DATATYPE, this.dataType);
        if (this.function != null) {
            ctx.property(ATTRIBUTE_FUNCTION, this.function.toString());
            ctx.property(ATTRIBUTE_DISTINCT, this.function.isDistinct());
            if (this.function instanceof UDAggregateFunction) {
                ctx.attribute(ATTRIBUTE_ISUDF, VALUE_TRUE);
            }
        }
    }

    @Override
    protected void restoreAttributeProperty(XQERestoreContext ctx, Attribute att, Element inputNode) {
        String attname = att.getName();
        if (attname.equals(ATTRIBUTE_DATATYPE)) {
            Object val = ctx.attributeValue(att);
            this.dataType = (IDataType)val;
        } else if (attname.equals(ATTRIBUTE_FUNCTION)) {
            boolean isUDF = false;
            Attribute isUDFattr = inputNode.attribute(ATTRIBUTE_ISUDF);
            if (isUDFattr != null) {
                isUDF = (Boolean)ctx.attributeValue(isUDFattr);
            }
            String fname = (String)ctx.attributeValue(att);
            if (isUDF) {
                IDataType[] argTypes = null;
                this.function = (ISetFunction)FunctionManager.getUserDefinedFunction(fname, argTypes);
            } else {
                this.function = (ISetFunction)FunctionManager.getBuiltinFunction(fname);
            }
            Attribute distinctAttr = inputNode.attribute(ATTRIBUTE_DISTINCT);
            if (distinctAttr != null) {
                boolean distinct = (Boolean)ctx.attributeValue(distinctAttr);
                this.function.setDistinct(distinct);
            }
        } else {
            super.restoreAttributeProperty(ctx, att, inputNode);
        }
    }

    @Override
    public SQLAbstractFunction.OnErrorPolicy getOnErrorPolicy() {
        return this.onErrorPolicy;
    }

    public void setOnErrorPolicy(SQLAbstractFunction.OnErrorPolicy oep) {
        this.onErrorPolicy = oep;
    }
}

