/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.relational;

import com.cognos.xqe.ast.XQEPersistContext;
import com.cognos.xqe.ast.XQERestoreContext;
import com.cognos.xqe.data.model.IDataSource;
import com.cognos.xqe.data.providers.ProviderManager;
import com.cognos.xqe.data.providers.relational.IRelationalDataProvider;
import com.cognos.xqe.data.providers.relational.SQLQueryArguments;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.exception.XQEException;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.query.engine.ExecutionEnvironment;
import com.cognos.xqe.query.engine.IExecutionEnvironment;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.resultset.interfaces.ITabularResultSet;
import com.cognos.xqe.resultsets.tabular.TabularHybridResultSet;
import com.cognos.xqe.runtree.IXDataSource;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.runtree.XNode;
import com.cognos.xqe.runtree.olap.OLAPXNodeRuntimeException;
import com.cognos.xqe.runtree.relational.vectorization.XVectorContext;
import com.cognos.xqe.trace.XQETrace;
import org.dom4j.Attribute;
import org.dom4j.Element;

public class XSparql
extends XNode
implements IXDataSource {
    private static final long serialVersionUID = 1L;
    private static final String ATTRIBUTE_DATASOURCE = "dataSource";
    private static final String ATTRIBUTE_DBTYPE = "dbType";
    private static final String ATTRIBUTE_IS_CACHEABLE = "isCacheable";
    private static final String ELEMENT_SPARQLTEXT = "SparqlText";
    private static final String ELEMENT_FORMATTED_SPARQLTEXT = "formattedSparqlText";
    private IDataSource dataSource;
    private String formattedSparqlText;
    private String sparqlText;
    private boolean isCacheable;

    @Override
    protected IValue executeImpl(XDataContext context) throws XQERuntimeException {
        String sparqlQuery = this.getSparqlText();
        IExecutionEnvironment execEnv = context.getEnvironment();
        SQLQueryArguments arguments = new SQLQueryArguments(this.dataSource, sparqlQuery, execEnv);
        IRelationalDataProvider provider = ProviderManager.getInstance().getRelationalProvider(this.dataSource.getType());
        if (provider == null) {
            throw new OLAPXNodeRuntimeException(XQEMessageKeys.EXE_DataProviderNotFound, this.dataSource.getType());
        }
        ITabularResultSet result = null;
        XDataContext subContext = execEnv.pushDataContext();
        subContext.setNodeId(this.getId());
        try {
            result = provider.query(subContext, arguments);
        }
        catch (XQEException e) {
            throw new XQERuntimeException(e);
        }
        finally {
            execEnv.popDataContext(subContext);
        }
        return new TabularHybridResultSet(context, this.vContext, result, this.getId());
    }

    @Override
    public int getType() {
        return 501140;
    }

    public String getSparqlText() {
        return this.sparqlText;
    }

    public String getFormattedSparqlText() {
        return this.formattedSparqlText;
    }

    public void setFormattedSparqlText(String theFormattedSparqlText) {
        this.formattedSparqlText = theFormattedSparqlText;
    }

    public void setSparqlText(String theSparqlText) {
        this.sparqlText = theSparqlText;
    }

    @Override
    public String getQueryText() {
        return this.getFormattedSparqlText();
    }

    public IDataSource getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(IDataSource theDataSource) {
        this.dataSource = theDataSource;
    }

    @Override
    public int isValidPlannedQuery() {
        return -1;
    }

    public void setCacheable(boolean cacheable) {
        this.isCacheable = cacheable;
    }

    public boolean isCacheable() {
        return this.isCacheable;
    }

    @Override
    public void dumpExtraInfo(XQETrace trace, boolean includeRuntimeSpecifics) {
        trace.attribute(ATTRIBUTE_DATASOURCE, this.dataSource.getName());
        trace.attribute(ATTRIBUTE_DBTYPE, this.dataSource.getType().toString());
        super.dumpExtraInfo(trace, includeRuntimeSpecifics);
        trace.beginElement(ELEMENT_SPARQLTEXT, -1);
        trace.data(this.sparqlText);
        trace.endElement();
    }

    @Override
    public void capture(PlanningEnvironment env, Element inputNode) {
        String dataSourceName = inputNode.attributeValue(ATTRIBUTE_DATASOURCE);
        IDataSource ds = ((ExecutionEnvironment)env.getExecutionEnvironment()).getDataSourceByModelName(dataSourceName);
        this.setDataSource(ds);
        Element child = (Element)inputNode.elements().get(0);
        this.setSparqlText(child.getStringValue());
        Attribute nodeIdAttribute = inputNode.attribute("id");
        if (nodeIdAttribute != null) {
            this.setNodeId(Integer.parseInt(nodeIdAttribute.getValue()));
        }
    }

    @Override
    protected void persistAttributeProperties(XQEPersistContext ctx) {
        super.persistAttributeProperties(ctx);
        ctx.property(ATTRIBUTE_IS_CACHEABLE, this.isCacheable);
    }

    @Override
    protected void persistElementProperties(XQEPersistContext ctx) {
        super.persistElementProperties(ctx);
        if (this.dataSource != null) {
            ctx.elementProperty(ATTRIBUTE_DATASOURCE, this.dataSource);
        }
        if (this.formattedSparqlText != null) {
            ctx.elementProperty(ELEMENT_FORMATTED_SPARQLTEXT, this.formattedSparqlText);
        }
        if (this.sparqlText != null) {
            ctx.elementProperty(ELEMENT_SPARQLTEXT, this.sparqlText);
        }
    }

    @Override
    protected void restoreAttributeProperty(XQERestoreContext ctx, Attribute att, Element inputNode) {
        String attname = att.getName();
        if (attname.equals(ATTRIBUTE_IS_CACHEABLE)) {
            Object val = ctx.attributeValue(att);
            this.isCacheable = (Boolean)val;
        } else {
            super.restoreAttributeProperty(ctx, att, inputNode);
        }
    }

    @Override
    protected void restoreElementProperty(XQERestoreContext ctx, Element node, Element inputNode) {
        String pname = node.attributeValue("pname");
        if (pname.equals(ATTRIBUTE_DATASOURCE)) {
            Object val = ctx.elementValue(node);
            this.dataSource = (IDataSource)val;
        } else if (pname.equals(ELEMENT_FORMATTED_SPARQLTEXT)) {
            Object val = ctx.elementValue(node);
            this.formattedSparqlText = (String)val;
        } else if (pname.equals(ELEMENT_SPARQLTEXT)) {
            Object val = ctx.elementValue(node);
            this.sparqlText = (String)val;
        } else {
            super.restoreElementProperty(ctx, node, inputNode);
        }
    }

    @Override
    public XVectorContext getVectorizationContext() {
        return this.vContext;
    }
}

