/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.relational;

import com.cognos.xqe.ast.IXQEPersist;
import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.QueryFormatter;
import com.cognos.xqe.ast.XQEIDGenerator;
import com.cognos.xqe.ast.XQEPersistContext;
import com.cognos.xqe.ast.XQERestoreContext;
import com.cognos.xqe.ast.sql.SQLCall;
import com.cognos.xqe.ast.sql.SQLNodeFactory;
import com.cognos.xqe.ast.sql.SQLParameter;
import com.cognos.xqe.ast.sql.SQLQueryNode;
import com.cognos.xqe.ast.sql.SQLSortKey;
import com.cognos.xqe.ast.sql.parser.ParseException;
import com.cognos.xqe.ast.sql.parser.SQLProcessor;
import com.cognos.xqe.ast.sql.util.SQLPlainQueryFormatter;
import com.cognos.xqe.data.model.IDataSource;
import com.cognos.xqe.data.providers.ProviderManager;
import com.cognos.xqe.data.providers.relational.IRelationalDataProvider;
import com.cognos.xqe.data.providers.relational.SQLQueryArguments;
import com.cognos.xqe.data.types.DataTypeFactory;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.exception.XQEException;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.query.engine.IExecutionEnvironment;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.parameters.BoundedRangeParameterValueItem;
import com.cognos.xqe.query.parameters.Parameter;
import com.cognos.xqe.query.parameters.ParameterInSQL;
import com.cognos.xqe.query.parameters.ParameterInfo;
import com.cognos.xqe.query.parameters.ParameterValueItem;
import com.cognos.xqe.query.parameters.ParameterValues;
import com.cognos.xqe.query.parameters.Parameters;
import com.cognos.xqe.resultset.interfaces.IRowsetInfo;
import com.cognos.xqe.resultset.interfaces.ITabularResultSet;
import com.cognos.xqe.resultsets.tabular.TabularHybridResultSet;
import com.cognos.xqe.runtree.IXDataSource;
import com.cognos.xqe.runtree.IXExpression;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.runtree.XNode;
import com.cognos.xqe.runtree.relational.SQLXNodeRuntimeException;
import com.cognos.xqe.runtree.relational.vectorization.XVectorContext;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.relational.binding.SQLBinderUtil;
import com.cognos.xqe.zipi.ZipiBridge;
import com.cognos.xqe.zipi.ZipiContext;
import com.ibm.cognos.pogo.zipi.ZipiTimer;
import java.util.ArrayList;
import java.util.List;
import org.dom4j.Attribute;
import org.dom4j.Element;

public class XSql
extends XNode
implements IXDataSource,
IXExpression {
    private static final long serialVersionUID = 1L;
    private static final String ATTRIBUTE_CMDATASOURCE = "cmDataSource";
    private static final String ATTRIBUTE_DATASOURCE = "dataSource";
    private static final String ATTRIBUTE_DATATYPE = "datatype";
    private static final String ATTRIBUTE_DBTYPE = "dbType";
    private static final String ATTRIBUTE_ISCACHEABLE = "isCacheable";
    private static final String ATTRIBUTE_MODE = "mode";
    private static final String ATTRIBUTE_NAME = "name";
    private static final String ATTRIBUTE_PREFIX = "prefix";
    private static final String ATTRIBUTE_SCHEMA = "schema";
    private static final String ATTRIBUTE_SUFFIX = "suffix";
    private static final String ATTRIBUTE_UPDATE = "update";
    private static final String ATTRIBUTE_USEPARAMETERIZEDSQL = "useParameterizedSQL";
    private static final char COLON = ':';
    private static final String DOUBLE_COLON = "::";
    private static final char SLASH = '/';
    private static final char ASTERISK = '*';
    private static final char HYPHEN = '-';
    private static final char SINGLE_QUOTE = '\'';
    private static final char DOUBLE_QUOTE = '\"';
    private static final char NEWLINE = '\n';
    private static final String ELEMENT_DBQUERYPLAN = "DBQueryPlan";
    private static final String ELEMENT_NAME = "StoredProcedureArgument";
    private static final String ELEMENT_PARAMETER = "Parameter";
    private static final String ELEMENT_PARAMETERS = "Parameters";
    private static final String ELEMENT_SQLCOLUMN = "SqlColumn";
    private static final String ELEMENT_SQLCOLUMNS = "SqlColumns";
    private static final String ELEMENT_SQLTEXT = "SqlText";
    private static final String ELMENT_STOREDPROCEDUREARGUMENTS = "StoredProcedureArguments";
    private static final String STRING_VALUE_TRUE = "true";
    private static final String ATTRIBUTE_SP_NAME = "spName";
    private static final String ATTRIBUTE_SP_SCHEMA = "spSchema";
    private static final String ATTRIBUTE_SP_CATALOG = "spCatalog";
    private static final String ATTRIBUTE_UPDATE_SUBJECT = "updateSubject";
    private static final String ATTRIBUTE_IS_CACHEABLE = "isCacheable";
    private static final String ATTRIBUTE_VALUE = "value";
    private static final String ELEMENT_PARAM_INFO_LIST_FOR_SUBSTITUTION = "paramInfoListForSubstitution";
    private static final String ELEMENT_DATASOURCE = "this.dataSource";
    private static final String ELEMENT_SQL_TEXT = "this.sqlText";
    private static final String ELEMENT_SQL_COMMENT_TEXT = "sqlCommentText";
    private static final String ELEMENT_SQL_AST = "sqlAst";
    private static final String ELEMENT_COLUMN_NAMES = "columnNames";
    private static final String ELEMENT_DB_PLAN = "dbPlan";
    private static final String ELEMENT_CALCULATED_ROWSET_INFO = "calculatedRowsetInfo";
    private static final String ELEMENT_DETAIL_QUERY_FILTER_NAME = "detailQueryFilterName";
    private static final String ELEMENT_QUERY_SPECIFICATION_SQL = "querySpecificationSQL";
    private static final String ELEMENT_NULL_ORDERING = "nullOrdering";
    private ArrayList<ParameterInfo> paramInfoListForSubstitution;
    private IDataSource dataSource;
    private String sqlText;
    private String sqlCommentText;
    private SQLQueryNode sqlAst;
    private List<StoredProcedureArgument> spArgs = null;
    private String spName = null;
    private String spSchema = null;
    private String spCatalog = null;
    private boolean updateSubject = false;
    private boolean overwriteDBType = false;
    private List<String> columnNames;
    private boolean isCacheable;
    private char quoteEscapeChar = (char)32;
    private String dbPlan;
    private IRowsetInfo calculatedRowsetInfo;
    private ArrayList<String> detailQueryFilterName = new ArrayList(5);
    private String querySpecificationSQL;
    private SQLSortKey.NullOrdering[] nullOrdering;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected IValue executeImpl(XDataContext context) throws XQERuntimeException {
        ZipiTimer zipiTimer = ZipiBridge.startTimer("DQExecuteRuntree", this.getNodeTypeName(), ZipiContext.getQRDName());
        try {
            IValue iValue = this.tryToExecute(context);
            return iValue;
        }
        finally {
            if (zipiTimer != null) {
                zipiTimer.stop();
            }
        }
    }

    private IValue tryToExecute(XDataContext context) throws XQERuntimeException {
        ArrayList<String> paramNameListForParamterizedSQL = new ArrayList<String>();
        String sqlTextToExecute = this.sqlText;
        if (this.paramInfoListForSubstitution != null) {
            ArrayList<String> pnames = new ArrayList<String>();
            int numOfValues = 0;
            for (int i = 0; i < this.paramInfoListForSubstitution.size(); ++i) {
                ParameterInfo paramInfo = this.paramInfoListForSubstitution.get(i);
                String paramName = paramInfo.getName();
                Parameter parameter = context.getParameter(paramName);
                if (parameter == null) {
                    XSql.throwInternalErrorXSqlParamDoesNotExist(paramName);
                }
                if (paramInfo.getUseParameterizedSQL()) {
                    paramNameListForParamterizedSQL.add(paramName);
                    if (!this.isUpdateSubject()) continue;
                    ParameterValues values = parameter.getParameterValueItems();
                    if (numOfValues != 0) {
                        if (values.size() == numOfValues) continue;
                        throw new XQERuntimeException(XQEMessageKeys.EXE_ParameterValuesMismatch, this.spName);
                    }
                    numOfValues = values.size();
                    continue;
                }
                if (parameter.isMasterDetailLinkParameter() && parameter.getParameterValueItems().isValueExplicitlyNotSupplied()) {
                    sqlTextToExecute = this.handleIsNullValueForMasterDetailParameter(sqlTextToExecute, paramName, parameter);
                    continue;
                }
                pnames.add(paramName);
            }
            List<ParameterInSQL> arrayParamInSQL = this.parseSqlForParameters(sqlTextToExecute, pnames);
            sqlTextToExecute = this.substituteParameterValuesInSqlText(context, sqlTextToExecute, arrayParamInSQL);
        }
        IExecutionEnvironment execEnv = context.getEnvironment();
        SQLQueryArguments arguments = new SQLQueryArguments(this.dataSource, sqlTextToExecute, execEnv);
        arguments.setParamNameListForParameterizedSQL(paramNameListForParamterizedSQL);
        arguments.setStoredProcedureArguments(this.spArgs);
        arguments.setStoredProcedureName(this.spName);
        arguments.setStoredProcedureSchema(this.spSchema);
        arguments.setStoredProcedureCatalog(this.spCatalog);
        arguments.setUpdateSubject(this.updateSubject);
        arguments.setParent(this);
        arguments.setCacheable(this.isCacheable);
        arguments.setSqlAST(this.sqlAst);
        arguments.setSQLComment(this.sqlCommentText);
        arguments.setVectorizationContext(this.vContext);
        arguments.setOverwriteDBType(this.overwriteDBType);
        IRelationalDataProvider provider = ProviderManager.getInstance().getRelationalProvider(this.dataSource.getType());
        if (provider == null) {
            throw new SQLXNodeRuntimeException(XQEMessageKeys.EXE_DataProviderNotFound, this.dataSource.getType());
        }
        ITabularResultSet result = null;
        XDataContext subContext = execEnv.pushDataContext();
        subContext.setNodeId(this.getId());
        subContext.setParameters(context.getParameters());
        subContext.setOptions(context.getOptions());
        arguments.setCalculatedRowsetInfo(this.getCalculatedRowsetInfo());
        try {
            result = provider.query(subContext, arguments);
        }
        catch (XQEException e) {
            throw new XQERuntimeException(e);
        }
        finally {
            execEnv.popDataContext(subContext);
        }
        if (this.updateSubject) {
            if (result != null) {
                result.release();
            }
            return null;
        }
        return new TabularHybridResultSet(context, this.vContext, result, this.getId());
    }

    @Override
    public IValue getJDBCTabularResultSet(XDataContext context) {
        return this.executeImpl(context);
    }

    private String substituteParameterValuesInSqlText(XDataContext context, String sqlTextToExecute, List<ParameterInSQL> arrayParamInSQL) {
        return XSql.substituteParameterValuesInSqlText(context, sqlTextToExecute, null, this.dataSource, this.paramInfoListForSubstitution, arrayParamInSQL, true);
    }

    public static String substituteParameterValuesInSqlText(String sqlTextToExecute, Parameters parameters, IDataSource dataSource, List<ParameterInfo> paramInfoListForSubstitution, List<ParameterInSQL> arrayParamInSQL, boolean bthrow) {
        return XSql.substituteParameterValuesInSqlText(null, sqlTextToExecute, parameters, dataSource, paramInfoListForSubstitution, arrayParamInSQL, bthrow);
    }

    public static String substituteParameterValuesInSqlText(XDataContext context, String sqlTextToExecute, Parameters parameters, IDataSource dataSource, List<ParameterInfo> paramInfoListForSubstitution, List<ParameterInSQL> arrayParamInSQL, boolean bthrow) {
        StringBuilder buf = new StringBuilder(sqlTextToExecute.length());
        int startIdx = 0;
        for (int j = 0; j < arrayParamInSQL.size(); ++j) {
            String valueLiteral;
            ParameterValues paramValues;
            Parameter parameter;
            ParameterInSQL paramInSQL = arrayParamInSQL.get(j);
            int paramIdx = paramInSQL.getPosition();
            buf.append(sqlTextToExecute.substring(startIdx, paramIdx));
            String curParamName = paramInSQL.getName();
            startIdx = paramIdx + XSql.generateSQLParameterMarkerString(curParamName).length();
            ParameterInfo paramInfo = null;
            if (paramInfoListForSubstitution != null) {
                if (paramInfoListForSubstitution.size() == arrayParamInSQL.size() && paramInfoListForSubstitution.get(j).getName().equals(curParamName)) {
                    paramInfo = paramInfoListForSubstitution.get(j);
                }
                if (paramInfo == null) {
                    for (ParameterInfo info : paramInfoListForSubstitution) {
                        if (!info.getName().equals(curParamName)) continue;
                        paramInfo = info;
                        break;
                    }
                }
            }
            if ((parameter = context != null ? context.getParameter(curParamName) : parameters.getParameter(curParamName)) == null) {
                if (bthrow) {
                    XSql.throwInternalErrorXSqlParamDoesNotExist(curParamName);
                } else {
                    return sqlTextToExecute;
                }
            }
            if ((paramValues = parameter.getParameterValueItems()) == null || paramValues.isEmpty()) {
                if (bthrow) {
                    XSql.throwInternalErrorXSqlParamDoesNotExist(curParamName);
                } else {
                    return sqlTextToExecute;
                }
            }
            String preFix = "";
            String sufFix = "";
            if (paramInfo != null) {
                preFix = paramInfo.getValuePrefix();
                sufFix = paramInfo.getValueSuffix();
            }
            boolean bIsParamDescendantOfLike = false;
            if (paramInfo != null) {
                bIsParamDescendantOfLike = paramInfo.getIsParamDescendantOfLike();
            }
            if ((valueLiteral = paramValues.getValueLiteral(preFix, sufFix, dataSource.getCapabilities(), bIsParamDescendantOfLike)).length() > 0) {
                buf.append(valueLiteral);
                continue;
            }
            ParameterValueItem paramValueItem = (ParameterValueItem)paramValues.get(0);
            if (!(paramValueItem instanceof BoundedRangeParameterValueItem)) continue;
            String startLiteral = ((BoundedRangeParameterValueItem)paramValueItem).getStartValueLiteral(preFix, sufFix, dataSource.getCapabilities());
            String endLiteral = ((BoundedRangeParameterValueItem)paramValueItem).getEndValueLiteral(preFix, sufFix, dataSource.getCapabilities());
            buf.append(startLiteral);
            paramInSQL = arrayParamInSQL.get(++j);
            paramIdx = paramInSQL.getPosition();
            buf.append(sqlTextToExecute.substring(startIdx, paramIdx));
            startIdx = paramIdx + curParamName.length() + 2;
            buf.append(endLiteral);
        }
        buf.append(sqlTextToExecute.substring(startIdx));
        return buf.toString();
    }

    private static void throwInternalErrorXSqlParamDoesNotExist(String paramName) {
        throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "XSql - parameter " + paramName + " doesn't exist.");
    }

    private static String generateSQLParameterMarkerString(String name) {
        return String.format(":%s:", name.replace(":", DOUBLE_COLON));
    }

    private String handleIsNullValueForMasterDetailParameter(String sqlTextToExecute, String paramName, Parameter parameter) {
        String[] unsupportedOperators;
        String formattedValueString = null;
        String paramMarker = XSql.generateSQLParameterMarkerString(paramName);
        String spaceParamMarker = " " + paramMarker;
        for (String op : unsupportedOperators = new String[]{">", "<", ">=", "<="}) {
            String paramMarkerIsNull = op + spaceParamMarker;
            if (!sqlTextToExecute.contains(paramMarkerIsNull)) continue;
            throw new XQERuntimeException(XQEMessageKeys.PLN_InvalidNullValueComparison, op);
        }
        boolean foundOperator = false;
        String[] supportedOperators = new String[]{"=", "<>", "IN"};
        formattedValueString = parameter.getParameterValueItems().getIsNullPattern(this.dataSource.getCapabilities());
        for (String type : supportedOperators) {
            String paramMarkerIsNull = type + spaceParamMarker;
            if (!sqlTextToExecute.contains(paramMarkerIsNull)) continue;
            foundOperator = true;
            sqlTextToExecute = sqlTextToExecute.replace(paramMarkerIsNull, formattedValueString);
        }
        if (!foundOperator) {
            formattedValueString = "null";
            sqlTextToExecute = sqlTextToExecute.replace(paramMarker, formattedValueString);
        }
        return sqlTextToExecute;
    }

    private static String findNameAtLocation(String str, int loc, ArrayList<String> pnames) {
        String pn;
        int i;
        for (i = 0; i < pnames.size(); ++i) {
            pn = pnames.get(i);
            if (!str.startsWith(pn, loc) || !str.startsWith(pn + ':', loc) || str.startsWith(pn + DOUBLE_COLON + ':', loc)) continue;
            return pn;
        }
        for (i = 0; i < pnames.size(); ++i) {
            pn = pnames.get(i);
            String pnDc = pn.replace(Character.toString(':'), DOUBLE_COLON) + ':';
            if (!str.startsWith(pnDc, loc) || str.startsWith(pnDc + DOUBLE_COLON, loc)) continue;
            return pn;
        }
        return null;
    }

    private List<ParameterInSQL> parseSqlForParameters(String sqlTextToExecute, ArrayList<String> pnames) {
        return XSql.parseSqlForParameters(sqlTextToExecute, pnames, this.quoteEscapeChar);
    }

    public static List<ParameterInSQL> parseSqlForParameters(String sqlTextToExecute, ArrayList<String> pnames, char quoteEscapeChar) {
        ArrayList<ParameterInSQL> arrayParamInSQL = new ArrayList<ParameterInSQL>();
        int len = sqlTextToExecute.length();
        char lookahead = '\u0000';
        block6: for (int i = 0; i < len; ++i) {
            char curChar = sqlTextToExecute.charAt(i);
            switch (curChar) {
                case '-': {
                    lookahead = sqlTextToExecute.charAt(++i);
                    if (lookahead == '-') {
                        while (++i < len && sqlTextToExecute.charAt(i) != '\n') {
                        }
                        continue block6;
                    }
                    --i;
                    continue block6;
                }
                case '/': {
                    lookahead = sqlTextToExecute.charAt(++i);
                    if (lookahead == '*') {
                        do {
                            lookahead = sqlTextToExecute.charAt(++i + 1);
                        } while (i < len && sqlTextToExecute.charAt(i) != '*' && lookahead != '/');
                        ++i;
                        continue block6;
                    }
                    --i;
                    continue block6;
                }
                case '\"': 
                case '\'': {
                    char quoteChar = curChar;
                    do {
                        if (' ' == quoteEscapeChar || sqlTextToExecute.charAt(++i) != quoteEscapeChar || i + 2 >= len) continue;
                        ++i;
                        ++i;
                    } while (sqlTextToExecute.charAt(i) != quoteChar);
                    continue block6;
                }
                case ':': {
                    int start = i++;
                    boolean checkViaParameterNames = true;
                    if (checkViaParameterNames) {
                        String n = XSql.findNameAtLocation(sqlTextToExecute, start + 1, pnames);
                        if (n == null) continue block6;
                        i = i + 2 + n.length();
                        ParameterInSQL paramInSQL = new ParameterInSQL(n, start);
                        arrayParamInSQL.add(paramInSQL);
                        continue block6;
                    }
                    boolean doneParsingParamName = false;
                    while (!doneParsingParamName) {
                        if (sqlTextToExecute.charAt(i) == ':') {
                            if (sqlTextToExecute.length() > i + 1 && sqlTextToExecute.charAt(i + 1) == ':') {
                                i += 2;
                                continue;
                            }
                            doneParsingParamName = true;
                            continue;
                        }
                        ++i;
                    }
                    String paramName = sqlTextToExecute.substring(start + 1, i);
                    paramName = paramName.replace(DOUBLE_COLON, Character.toString(':'));
                    ParameterInSQL paramInSQL = new ParameterInSQL(paramName, start);
                    arrayParamInSQL.add(paramInSQL);
                    continue block6;
                }
            }
        }
        return arrayParamInSQL;
    }

    @Override
    public int getType() {
        return 501013;
    }

    public String getSqlText() {
        if (this.sqlCommentText != null) {
            StringBuilder sql = new StringBuilder();
            sql.append(this.sqlCommentText);
            sql.append("\r\n");
            sql.append(this.sqlText);
            return sql.toString();
        }
        return this.sqlText;
    }

    public void setSqlText(String theSqlText) {
        this.sqlText = theSqlText;
    }

    public String getCommentText() {
        return this.sqlCommentText;
    }

    public void setCommentText(String theSqlCommentText) {
        this.sqlCommentText = theSqlCommentText;
    }

    public void setStoredProcedureName(String name) {
        this.spName = name;
    }

    public void setStoredProcedureSchema(String schema) {
        this.spSchema = schema;
    }

    public void setStoredProcedureCatalog(String catalog) {
        this.spCatalog = catalog;
    }

    public void setStoredProcedureArguments(List<StoredProcedureArgument> args) {
        this.spArgs = args;
    }

    public void setStoredProcedureArguments(IXQEQueryNode[] argNodeList) {
        ArrayList<StoredProcedureArgument> argumentList = new ArrayList<StoredProcedureArgument>();
        for (IXQEQueryNode child : argNodeList) {
            SQLPlainQueryFormatter argumentFormatter = new SQLPlainQueryFormatter();
            ((SQLQueryNode)child).accept(argumentFormatter, this.dataSource.getCapabilities());
            StoredProcedureArgument spArg = child instanceof SQLParameter ? new StoredProcedureArgument(((QueryFormatter)argumentFormatter).bufferToString(), ((SQLParameter)child).getInValue(), ((SQLParameter)child).getDataType(), ((SQLParameter)child).getMode()) : new StoredProcedureArgument(((QueryFormatter)argumentFormatter).bufferToString(), null, ((SQLQueryNode)child).getDataType(), null);
            argumentList.add(spArg);
        }
        this.setStoredProcedureArguments(argumentList);
    }

    public void setColumnNames(List<String> cNames) {
        this.columnNames = cNames;
    }

    public IDataSource getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(IDataSource theDataSource) {
        this.dataSource = theDataSource;
    }

    public void setParamInfoListForSubstitution(ArrayList<ParameterInfo> theParamInfoList) {
        this.paramInfoListForSubstitution = theParamInfoList;
    }

    public List<ParameterInfo> getParamInfoListForSubstitution() {
        return this.paramInfoListForSubstitution;
    }

    public void setUpdateSubject(boolean isUpdateSubject) {
        this.updateSubject = isUpdateSubject;
    }

    public boolean isUpdateSubject() {
        return this.updateSubject;
    }

    public void setOverwriteDBType(boolean bOverwriteDBType) {
        this.overwriteDBType = bOverwriteDBType;
    }

    public boolean getOverwriteDBType() {
        return this.overwriteDBType;
    }

    public String getDBQueryPlan() {
        return this.dbPlan;
    }

    public void setDBQueryPlan(String plan) {
        this.dbPlan = plan;
    }

    @Override
    public int isValidPlannedQuery() {
        return -1;
    }

    public void setCacheable(boolean cacheable) {
        this.isCacheable = cacheable;
    }

    public boolean isCacheable() {
        return this.isCacheable;
    }

    public char escapingQoute() {
        return this.quoteEscapeChar;
    }

    public void setQuoteEscape(char escapeChar) {
        this.quoteEscapeChar = escapeChar;
    }

    public SQLQueryNode getSQLAst() {
        return this.sqlAst;
    }

    public void setSQLAst(SQLQueryNode ast) {
        this.sqlAst = ast;
    }

    @Override
    public String getQueryText() {
        return this.getSqlText();
    }

    @Override
    public void dumpExtraInfo(XQETrace trace, boolean includeRuntimeSpecifics) {
        XQEIDGenerator nodeIDGenerator = this.getPlanningEnvironment().getNodeFactory().getNodeIdGenerator();
        trace.attribute(ATTRIBUTE_DATASOURCE, this.dataSource.getName());
        trace.attribute(ATTRIBUTE_CMDATASOURCE, this.dataSource.getCMDataSourceName());
        trace.attribute(ATTRIBUTE_DBTYPE, this.dataSource.getType().toString());
        String schema = (String)this.dataSource.getMetadataProperties().get(ATTRIBUTE_SCHEMA);
        if (schema != null) {
            trace.attribute(ATTRIBUTE_SCHEMA, schema);
        }
        trace.attribute("isCacheable", this.isCacheable);
        super.dumpExtraInfo(trace, includeRuntimeSpecifics);
        if (this.vContext != null) {
            this.vContext.dumpInfo(trace);
        }
        trace.beginElement(ELEMENT_SQLTEXT, -1);
        trace.data(this.sqlText);
        trace.endElement();
        if (this.columnNames != null) {
            trace.beginElement(ELEMENT_SQLCOLUMNS, -1);
            for (String cName : this.columnNames) {
                trace.beginElement(ELEMENT_SQLCOLUMN, -1);
                trace.attribute(ATTRIBUTE_NAME, cName);
                trace.endElement();
            }
            trace.endElement();
        }
        if (this.paramInfoListForSubstitution != null && this.paramInfoListForSubstitution.size() != 0) {
            trace.beginElement(ELEMENT_PARAMETERS, -1);
            for (ParameterInfo p : this.paramInfoListForSubstitution) {
                trace.beginElement(ELEMENT_PARAMETER, -1);
                trace.attribute(ATTRIBUTE_NAME, p.getName());
                if (p.getValuePrefix().length() > 0) {
                    trace.attribute(ATTRIBUTE_PREFIX, p.getValuePrefix());
                }
                if (p.getValueSuffix().length() > 0) {
                    trace.attribute(ATTRIBUTE_SUFFIX, p.getValueSuffix());
                }
                if (p.getUseParameterizedSQL()) {
                    trace.attribute(ATTRIBUTE_USEPARAMETERIZEDSQL, STRING_VALUE_TRUE);
                }
                trace.endElement();
            }
            trace.endElement();
        }
        if (this.spArgs != null && this.spArgs.size() > 0) {
            trace.beginElement(ELMENT_STOREDPROCEDUREARGUMENTS, -1);
            for (StoredProcedureArgument s : this.spArgs) {
                s.dump(trace);
            }
            trace.endElement();
        }
        if (this.dbPlan != null) {
            trace.beginElement(ELEMENT_DBQUERYPLAN, nodeIDGenerator.getNextID());
            trace.xml(this.dbPlan);
            trace.endElement();
        }
    }

    @Override
    public void capture(PlanningEnvironment env, Element inputNode) {
        Attribute nodeIdAttribute;
        Attribute attribute = inputNode.attribute(ATTRIBUTE_UPDATE);
        if (attribute != null) {
            this.setUpdateSubject(Boolean.valueOf(attribute.getText()));
        }
        String dataSourceName = inputNode.attributeValue(ATTRIBUTE_DATASOURCE);
        String cmName = inputNode.attributeValue(ATTRIBUTE_CMDATASOURCE);
        String schema = inputNode.attributeValue(ATTRIBUTE_SCHEMA);
        IDataSource ds = SQLBinderUtil.findOrCreateDataSource(env, null, dataSourceName, null, schema, cmName);
        this.setDataSource(ds);
        attribute = inputNode.attribute("isCacheable");
        if (attribute != null) {
            this.setCacheable(Boolean.valueOf(attribute.getText()));
        }
        List children = inputNode.elements();
        Element child = (Element)children.get(0);
        this.setSqlText(child.getStringValue());
        if (this.sqlText.startsWith("CALL")) {
            ArrayList<StoredProcedureArgument> capturedArgs = new ArrayList<StoredProcedureArgument>();
            for (Element c : children) {
                if (!c.getName().equals(ELMENT_STOREDPROCEDUREARGUMENTS)) continue;
                List args = c.elements();
                for (Element e : args) {
                    StoredProcedureArgument arg = new StoredProcedureArgument();
                    arg.capture(env, e);
                    capturedArgs.add(arg);
                }
            }
            SQLNodeFactory factory = new SQLNodeFactory();
            factory.setNodeIDGenerator(new XQEIDGenerator());
            factory.setPlanningEnvironment(env);
            SQLProcessor parser = new SQLProcessor(factory);
            try {
                SQLCall sqlCall = (SQLCall)parser.parseQuery(this.sqlText);
                this.setStoredProcedureArguments(sqlCall.getChildren());
                this.setStoredProcedureName(sqlCall.getName());
                this.setStoredProcedureSchema(sqlCall.getSchemaName());
                this.setStoredProcedureCatalog(sqlCall.getCatalogName());
            }
            catch (ParseException e) {
                throw new XQERuntimeException(e);
            }
            if (capturedArgs.size() == this.spArgs.size()) {
                this.setStoredProcedureArguments(capturedArgs);
            }
        }
        if ((nodeIdAttribute = inputNode.attribute("id")) != null) {
            this.setNodeId(Integer.parseInt(nodeIdAttribute.getValue()));
        }
        for (Element e : children) {
            if (!e.getName().equals(ELEMENT_PARAMETERS)) continue;
            this.paramInfoListForSubstitution = new ArrayList();
            List parms = e.elements();
            for (Element pe : parms) {
                ParameterInfo pInfo = new ParameterInfo(pe.attributeValue(ATTRIBUTE_NAME));
                String t = pe.attributeValue(ATTRIBUTE_PREFIX);
                if (t != null) {
                    pInfo.setValuePrefix(t);
                }
                if ((t = pe.attributeValue(ATTRIBUTE_SUFFIX)) != null) {
                    pInfo.setValueSuffix(t);
                }
                if ((t = pe.attributeValue(ATTRIBUTE_USEPARAMETERIZEDSQL)) != null) {
                    pInfo.setUseParameterizedSQL(STRING_VALUE_TRUE.equals(t));
                }
                this.paramInfoListForSubstitution.add(pInfo);
            }
        }
    }

    public void setCalculatedRowsetInfo(IRowsetInfo theCalculatedRowsetInfo) {
        this.calculatedRowsetInfo = theCalculatedRowsetInfo;
    }

    public IRowsetInfo getCalculatedRowsetInfo() {
        return this.calculatedRowsetInfo;
    }

    public void addDetailQueryFilterName(String parameterName) {
        this.detailQueryFilterName.add(parameterName);
    }

    public List<String> getDetailQueryFilterName() {
        return this.detailQueryFilterName;
    }

    @Override
    public void open(XDataContext context, IRowsetInfo rowsetInfo) {
    }

    @Override
    public void close(XDataContext context) {
    }

    @Override
    public IDataType getDataType() {
        return null;
    }

    @Override
    public IDataType getDataType(IRowsetInfo rowsetInfo, int index) {
        return null;
    }

    @Override
    public String getName(IRowsetInfo rowsetInfo, int index) {
        return null;
    }

    public String substituteParameterInNativeSQLWithLiteral(Parameters parameters) {
        String nativeSQL = this.sqlText;
        if (this.dataSource != null) {
            ArrayList<String> pnames = new ArrayList<String>();
            pnames.addAll(parameters.keySet());
            List<ParameterInSQL> arrayParamInSQL = this.parseSqlForParameters(nativeSQL, pnames);
            if (!arrayParamInSQL.isEmpty()) {
                nativeSQL = XSql.substituteParameterValuesInSqlText(nativeSQL, parameters, this.dataSource, this.paramInfoListForSubstitution, arrayParamInSQL, false);
            }
        }
        return nativeSQL;
    }

    public String getQuerySpecificationSQL() {
        return this.querySpecificationSQL;
    }

    public void setQuerySpecificationSQL(String pQuerySpecificationSQL) {
        this.querySpecificationSQL = pQuerySpecificationSQL;
    }

    @Override
    public SQLSortKey.NullOrdering[] getNullOrdering() {
        return this.nullOrdering;
    }

    public void setNullOrdering(SQLSortKey.NullOrdering[] nullValueOrdering) {
        this.nullOrdering = nullValueOrdering;
    }

    @Override
    protected void persistAttributeProperties(XQEPersistContext ctx) {
        super.persistAttributeProperties(ctx);
        if (this.spName != null) {
            ctx.property(ATTRIBUTE_SP_NAME, this.spName);
        }
        if (this.spSchema != null) {
            ctx.property(ATTRIBUTE_SP_SCHEMA, this.spSchema);
        }
        if (this.spCatalog != null) {
            ctx.property(ATTRIBUTE_SP_CATALOG, this.spSchema);
        }
        ctx.property(ATTRIBUTE_UPDATE_SUBJECT, this.updateSubject);
        ctx.property("isCacheable", this.isCacheable);
    }

    @Override
    protected void persistElementProperties(XQEPersistContext ctx) {
        super.persistElementProperties(ctx);
        if (this.paramInfoListForSubstitution != null) {
            ctx.elementProperty(ELEMENT_PARAM_INFO_LIST_FOR_SUBSTITUTION, this.paramInfoListForSubstitution);
        }
        if (this.dataSource != null) {
            ctx.elementProperty(ELEMENT_DATASOURCE, this.dataSource);
        }
        if (this.sqlText != null) {
            ctx.elementProperty(ELEMENT_SQL_TEXT, this.sqlText);
        }
        if (this.sqlCommentText != null) {
            ctx.elementProperty(ELEMENT_SQL_COMMENT_TEXT, this.sqlCommentText);
        }
        if (this.sqlAst != null) {
            ctx.elementProperty(ELEMENT_SQL_AST, this.sqlAst);
        }
        if (this.columnNames != null) {
            ctx.elementProperty(ELEMENT_COLUMN_NAMES, this.columnNames);
        }
        if (this.dbPlan != null) {
            ctx.elementProperty(ELEMENT_DB_PLAN, this.dbPlan);
        }
        if (this.calculatedRowsetInfo != null) {
            ctx.elementProperty(ELEMENT_CALCULATED_ROWSET_INFO, this.calculatedRowsetInfo);
        }
        if (this.detailQueryFilterName != null) {
            ctx.elementProperty(ELEMENT_DETAIL_QUERY_FILTER_NAME, this.detailQueryFilterName);
        }
        if (this.querySpecificationSQL != null) {
            ctx.elementProperty(ELEMENT_QUERY_SPECIFICATION_SQL, this.querySpecificationSQL);
        }
        if (this.nullOrdering != null) {
            ctx.elementProperty(ELEMENT_NULL_ORDERING, this.nullOrdering);
        }
    }

    @Override
    protected void restoreAttributeProperty(XQERestoreContext ctx, Attribute att, Element inputNode) {
        String attname = att.getName();
        if (attname.equals(ATTRIBUTE_SP_NAME)) {
            Object val = ctx.attributeValue(att);
            this.spName = (String)val;
        } else if (attname.equals(ATTRIBUTE_SP_SCHEMA)) {
            Object val = ctx.attributeValue(att);
            this.spSchema = (String)val;
        } else if (attname.equals(ATTRIBUTE_SP_CATALOG)) {
            Object val = ctx.attributeValue(att);
            this.spCatalog = (String)val;
        } else if (attname.equals(ATTRIBUTE_UPDATE_SUBJECT)) {
            Object val = ctx.attributeValue(att);
            this.updateSubject = (Boolean)val;
        } else if (attname.equals("isCacheable")) {
            Object val = ctx.attributeValue(att);
            this.isCacheable = (Boolean)val;
        } else {
            super.restoreAttributeProperty(ctx, att, inputNode);
        }
    }

    @Override
    protected void restoreElementProperty(XQERestoreContext ctx, Element node, Element inputNode) {
        String pname = node.attributeValue("pname");
        if (pname.equals(ELEMENT_PARAM_INFO_LIST_FOR_SUBSTITUTION)) {
            Object val = ctx.elementValue(node);
            this.paramInfoListForSubstitution = (ArrayList)val;
        } else if (pname.equals(ELEMENT_DATASOURCE)) {
            Object val = ctx.elementValue(node);
            this.dataSource = (IDataSource)val;
        } else if (pname.equals(ELEMENT_SQL_TEXT)) {
            Object val = ctx.elementValue(node);
            this.sqlText = (String)val;
        } else if (pname.equals(ELEMENT_SQL_COMMENT_TEXT)) {
            Object val = ctx.elementValue(node);
            this.sqlCommentText = (String)val;
        } else if (pname.equals(ELEMENT_SQL_AST)) {
            Object val = ctx.elementValue(node);
            this.sqlAst = (SQLQueryNode)val;
        } else if (pname.equals(ELEMENT_COLUMN_NAMES)) {
            Object val = ctx.elementValue(node);
            this.columnNames = (List)val;
        } else if (pname.equals(ELEMENT_DB_PLAN)) {
            Object val = ctx.elementValue(node);
            this.dbPlan = (String)val;
        } else if (pname.equals(ELEMENT_CALCULATED_ROWSET_INFO)) {
            Object val = ctx.elementValue(node);
            this.calculatedRowsetInfo = (IRowsetInfo)val;
        } else if (pname.equals(ELEMENT_DETAIL_QUERY_FILTER_NAME)) {
            Object val = ctx.elementValue(node);
            this.detailQueryFilterName = (ArrayList)val;
        } else if (pname.equals(ELEMENT_QUERY_SPECIFICATION_SQL)) {
            Object val = ctx.elementValue(node);
            this.querySpecificationSQL = (String)val;
        } else if (pname.equals(ELEMENT_NULL_ORDERING)) {
            Object val = ctx.elementValue(node);
            this.nullOrdering = (SQLSortKey.NullOrdering[])val;
        } else {
            super.restoreElementProperty(ctx, node, inputNode);
        }
    }

    @Override
    public XVectorContext getVectorizationContext() {
        return this.vContext;
    }

    public static class StoredProcedureArgument
    implements IXQEPersist {
        private String value;
        private String inValue;
        private IDataType dataType;
        private String mode;

        public StoredProcedureArgument() {
        }

        public StoredProcedureArgument(String aValue, String aInValue, IDataType aDataType, String aMode) {
            this.value = aValue;
            this.inValue = aInValue;
            this.dataType = aDataType;
            this.mode = aMode;
        }

        public final String getArgumentValue() {
            return this.value;
        }

        public final String getInValue() {
            return this.inValue;
        }

        public final IDataType getDataType() {
            return this.dataType;
        }

        public final String getMode() {
            return this.mode;
        }

        public void dump(XQETrace trace) {
            trace.beginElement(XSql.ELEMENT_NAME, -1);
            trace.attribute(XSql.ATTRIBUTE_MODE, this.getMode());
            trace.attribute(XSql.ATTRIBUTE_DATATYPE, this.getDataType().toString());
            trace.cdata(this.value);
            trace.endElement();
        }

        public void capture(PlanningEnvironment env, Element inputNode) {
            Attribute attribute = inputNode.attribute(XSql.ATTRIBUTE_MODE);
            if (attribute != null) {
                this.mode = attribute.getText();
            }
            if ((attribute = inputNode.attribute(XSql.ATTRIBUTE_DATATYPE)) != null) {
                this.dataType = DataTypeFactory.getType(attribute.getValue());
            }
            this.value = inputNode.getStringValue();
        }

        @Override
        public void persist(XQEPersistContext ctx, String optionalName) {
            if (ctx.beginElement(this, optionalName, -1)) {
                ctx.property(XSql.ATTRIBUTE_VALUE, this.value);
                ctx.property(XSql.ATTRIBUTE_DATATYPE, this.dataType);
                ctx.property(XSql.ATTRIBUTE_MODE, this.mode);
                ctx.endElement();
            }
        }

        @Override
        public void restore(XQERestoreContext ctx, Element node) {
            this.restoreAttributes(ctx, node);
        }

        public void restoreAttributes(XQERestoreContext ctx, Element node) {
            int size = node.attributeCount();
            for (int i = 0; i < size; ++i) {
                Object val;
                Attribute att = node.attribute(i);
                String attname = att.getName();
                if (attname.equals(XSql.ATTRIBUTE_VALUE)) {
                    val = ctx.attributeValue(att);
                    this.value = (String)val;
                    continue;
                }
                if (attname.equals(XSql.ATTRIBUTE_DATATYPE)) {
                    val = ctx.attributeValue(att);
                    this.dataType = (IDataType)val;
                    continue;
                }
                if (!attname.equals(XSql.ATTRIBUTE_MODE)) continue;
                val = ctx.attributeValue(att);
                this.mode = (String)val;
            }
        }
    }
}

