/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.relational;

import com.cognos.xqe.bibushandler.OperationCanceledException;
import com.cognos.xqe.data.values.DataValueFactory;
import com.cognos.xqe.data.values.IRow;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.resultset.interfaces.ITabularIterator;
import com.cognos.xqe.resultset.interfaces.ITabularResultSet;
import com.cognos.xqe.resultsets.tabular.TabularHybridResultSet;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.runtree.XTabularIterator;
import com.cognos.xqe.runtree.relational.XJoin;

public class XStitchJoin
extends XJoin {
    private static final long serialVersionUID = 1L;

    @Override
    protected IValue executeImpl(XDataContext context) {
        return new TabularHybridResultSet(context, new XStitchJoinResultSet(context), this.getId());
    }

    @Override
    public int getType() {
        return 501143;
    }

    private final class XStitchJoinResultSet
    extends XJoin.ResultSet
    implements ITabularResultSet {
        XStitchJoinResultSet(XDataContext context) {
            super(context, 2, XStitchJoin.this.getId());
        }

        @Override
        public ITabularIterator getTabularIterator() {
            return new XStitchJoinIterator(this.getDataContext());
        }

        private final class XStitchJoinIterator
        extends XTabularIterator {
            private XTabularIterator outerTabIt;
            private XTabularIterator innerTabIt;
            private IRow outerRow;
            private IRow innerRow;
            private IRow result;
            private XJoin.State state;

            private XStitchJoinIterator(XDataContext context) {
                super(context, XStitchJoin.this.getId());
                this.state = XJoin.State.EQUAL;
                try {
                    this.startTimer();
                    this.outerTabIt = (XTabularIterator)XStitchJoinResultSet.this.iResultSets[0].getTabularIterator();
                    this.innerTabIt = (XTabularIterator)XStitchJoinResultSet.this.iResultSets[1].getTabularIterator();
                    this.result = DataValueFactory.createRowValue(new IValue[XStitchJoinResultSet.this.rowsetInfo.getNumColumns()]);
                }
                catch (RuntimeException e) {
                    this.release();
                    throw e;
                }
                finally {
                    this.stopTimer();
                }
            }

            @Override
            public Object nextImpl() {
                if (this.context.isCanceled()) {
                    throw new OperationCanceledException(this.context.getCancelSource());
                }
                if ((this.state == XJoin.State.EQUAL || this.state == XJoin.State.LESS_THAN) && this.outerTabIt != null) {
                    this.outerRow = (IRow)this.outerTabIt.next();
                    if (this.outerRow == null) {
                        try {
                            this.outerTabIt.release();
                        }
                        catch (Exception e) {
                            mErrorLogger.log(e);
                        }
                        finally {
                            this.outerTabIt = null;
                        }
                        if (this.innerTabIt == null) {
                            return null;
                        }
                    }
                }
                if ((this.state == XJoin.State.EQUAL || this.state == XJoin.State.GREATER_THAN) && this.innerTabIt != null) {
                    this.innerRow = (IRow)this.innerTabIt.next();
                    if (this.innerRow == null) {
                        try {
                            this.innerTabIt.release();
                        }
                        catch (Exception e) {
                            mErrorLogger.log(e);
                        }
                        finally {
                            this.innerTabIt = null;
                        }
                        if (this.outerTabIt == null) {
                            return null;
                        }
                    }
                }
                if (this.outerTabIt == null) {
                    this.state = XJoin.State.GREATER_THAN;
                } else if (this.innerTabIt == null) {
                    this.state = XJoin.State.LESS_THAN;
                } else if (XStitchJoin.this.joins != null) {
                    this.state = XStitchJoinResultSet.this.compareValues(this.outerRow, this.innerRow);
                }
                XStitchJoinResultSet.this.combine(this.result, this.outerRow, this.innerRow, this.state);
                return this.result;
            }

            @Override
            public long getIndex() {
                return this.nRows;
            }

            @Override
            public void release() {
                if (this.outerTabIt != null) {
                    try {
                        this.outerTabIt.release();
                    }
                    catch (Exception e) {
                        mErrorLogger.log(e);
                    }
                    finally {
                        this.outerTabIt = null;
                    }
                }
                if (this.innerTabIt != null) {
                    try {
                        this.innerTabIt.release();
                    }
                    catch (Exception e) {
                        mErrorLogger.log(e);
                    }
                    finally {
                        this.innerTabIt = null;
                    }
                }
                super.release();
            }
        }
    }
}

