/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.relational;

import com.cognos.xqe.ast.XQEPersistContext;
import com.cognos.xqe.ast.XQERestoreContext;
import com.cognos.xqe.bibushandler.OperationCanceledException;
import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.data.values.IRow;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.resultset.interfaces.IExecutable;
import com.cognos.xqe.resultset.interfaces.ITabularIterator;
import com.cognos.xqe.resultset.interfaces.ITabularResultSet;
import com.cognos.xqe.resultsets.tabular.TabularHybridResultSet;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.runtree.XResultSetBase;
import com.cognos.xqe.runtree.XTabularIterator;
import com.cognos.xqe.runtree.XTabularResultSet;
import com.cognos.xqe.runtree.exception.XRuntimeException;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqe.trace.XQELogger;
import com.cognos.xqe.trace.XQETrace;
import org.dom4j.Attribute;
import org.dom4j.Element;

public class XTop
extends XTabularResultSet {
    private static final long serialVersionUID = 1L;
    private static final String ATTRIBUTE_CONTEXTNO = "contextNo";
    private static final String ATTRIBUTE_LIMIT = "limit";
    protected int rowLimit = 0;
    private static XQELogger mErrorLogger = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "Exception", LogLevel.ERROR);

    @Override
    protected IValue executeImpl(XDataContext context) throws XRuntimeException {
        return new TabularHybridResultSet(context, new XTopResultSet(context), this.getId());
    }

    @Override
    public int getType() {
        return 501104;
    }

    @Override
    public int getContextNo() {
        return this.contextNo;
    }

    @Override
    public void setContextNo(int theContextNo) {
        this.contextNo = theContextNo;
    }

    public int getRowlimit() {
        return this.rowLimit;
    }

    public void setRowlimit(int theRowlimit) {
        this.rowLimit = theRowlimit;
    }

    @Override
    public void dumpExtraInfo(XQETrace trace, boolean includeRuntimeSpecifics) {
        trace.attribute(ATTRIBUTE_LIMIT, this.getRowlimit());
        trace.attribute(ATTRIBUTE_CONTEXTNO, this.getContextNo());
        super.dumpExtraInfo(trace, includeRuntimeSpecifics);
    }

    @Override
    public void capture(PlanningEnvironment env, Element inputNode) {
        this.setContextNo(Integer.valueOf(inputNode.attribute(ATTRIBUTE_CONTEXTNO).getValue()));
        this.setRowlimit(Integer.valueOf(inputNode.attribute(ATTRIBUTE_LIMIT).getValue()));
        super.capture(env, inputNode);
    }

    @Override
    protected void persistAttributeProperties(XQEPersistContext ctx) {
        super.persistAttributeProperties(ctx);
        ctx.property(ATTRIBUTE_LIMIT, this.rowLimit);
    }

    @Override
    protected void restoreAttributeProperty(XQERestoreContext ctx, Attribute att, Element inputNode) {
        String attname = att.getName();
        if (attname.equals(ATTRIBUTE_LIMIT)) {
            Object val = ctx.attributeValue(att);
            this.rowLimit = (Integer)val;
        } else {
            super.restoreAttributeProperty(ctx, att, inputNode);
        }
    }

    private final class XTopResultSet
    extends XResultSetBase
    implements ITabularResultSet {
        private ITabularResultSet iResultSet;

        XTopResultSet(XDataContext theContext) {
            super(theContext, XTop.this.getId());
            this.iResultSet = (ITabularResultSet)((IExecutable)((Object)XTop.this.getChild(0))).execute(theContext);
            super.setTabularRowsetInfo(this.iResultSet.getTabularRowsetInfo());
        }

        @Override
        public ITabularIterator getTabularIterator() {
            return new XTopIterator(this.getDataContext());
        }

        @Override
        public void releaseImpl() {
            if (this.iResultSet != null) {
                this.iResultSet.release();
                this.iResultSet = null;
            }
            this.rowsetInfo = null;
        }

        private final class XTopIterator
        extends XTabularIterator {
            private ITabularIterator tableIt;

            private XTopIterator(XDataContext context) {
                super(context, XTop.this.getId());
                try {
                    this.startTimer();
                    XTop.this.contextNo = XTop.this.getContextNo();
                    this.tableIt = XTopResultSet.this.iResultSet.getTabularIterator();
                }
                catch (RuntimeException e) {
                    this.release();
                    throw e;
                }
                finally {
                    this.stopTimer();
                }
            }

            @Override
            public Object nextImpl() {
                if (this.context.isCanceled()) {
                    throw new OperationCanceledException(this.context.getCancelSource());
                }
                if (this.nRows == XTop.this.getRowlimit()) {
                    this.release();
                    return null;
                }
                IRow inputRow = (IRow)this.tableIt.next();
                if (inputRow != null) {
                    ++this.nRows;
                }
                return inputRow;
            }

            @Override
            public void release() {
                if (this.tableIt != null) {
                    try {
                        this.tableIt.release();
                    }
                    catch (Exception e) {
                        mErrorLogger.log(e);
                    }
                    finally {
                        this.tableIt = null;
                    }
                }
                super.release();
            }
        }
    }
}

