/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.relational;

import com.cognos.xqe.ast.XQEPersistContext;
import com.cognos.xqe.ast.XQERestoreContext;
import com.cognos.xqe.data.values.IRow;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.resultset.interfaces.IExecutable;
import com.cognos.xqe.resultset.interfaces.IHybridResultSet;
import com.cognos.xqe.resultset.interfaces.ITabularIterator;
import com.cognos.xqe.resultset.interfaces.ITabularResultSet;
import com.cognos.xqe.resultsets.tabular.TabularHybridResultSet;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.runtree.XNode;
import com.cognos.xqe.runtree.XNodeFactory;
import com.cognos.xqe.runtree.XResultSetBase;
import com.cognos.xqe.runtree.XTabularIterator;
import com.cognos.xqe.runtree.XTabularResultSet;
import com.cognos.xqe.runtree.relational.vectorization.IVectorContext;
import com.cognos.xqe.runtree.relational.vectorization.XVectorContext;
import com.cognos.xqe.trace.XQETrace;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.dom4j.Element;

public class XWith
extends XTabularResultSet {
    private static final long serialVersionUID = 1L;
    private static final String ATTRIBUTE_NAME = "name";
    private static final String ATTRIBUTE_NAMELIST = "nameList";
    private static final String STRING_COMMA = ",";
    private static final String STRING_COMMA_SPACE = ", ";
    private List<String> nameList = new ArrayList<String>();

    @Override
    protected IValue executeImpl(XDataContext context) throws XQERuntimeException {
        return new TabularHybridResultSet(context, new XWithResultSet(context), this.getId());
    }

    @Override
    public int getType() {
        return 501105;
    }

    @Override
    public XVectorContext getVectorizationContext() {
        return ((IVectorContext)((Object)this.getChild(this.getNumberChildren() - 1))).getVectorizationContext();
    }

    @Override
    public void dumpExtraInfo(XQETrace trace, boolean includeRuntimeSpecifics) {
        trace.attribute(ATTRIBUTE_NAMELIST, this.nameList.toString());
        super.dumpExtraInfo(trace, includeRuntimeSpecifics);
    }

    @Override
    public void capture(PlanningEnvironment env, Element inputNode) {
        String names = inputNode.attributeValue(ATTRIBUTE_NAMELIST);
        if (names != null) {
            names = names.substring(1, names.length() - 1);
            names = names.replaceAll(STRING_COMMA_SPACE, STRING_COMMA);
            Collections.addAll(this.nameList, names.split(STRING_COMMA));
            super.capture(env, inputNode);
        } else {
            XNodeFactory nodeFactory = (XNodeFactory)env.getNodeFactory();
            List children = inputNode.elements();
            int nChildren = children.size();
            children = ((Element)children.get(0)).elements();
            for (Element child : children) {
                this.addName(child.attributeValue(ATTRIBUTE_NAME));
                Element resultSet = (Element)child.elements().get(0);
                XNode xNode = (XNode)nodeFactory.createNodeByName(resultSet.getName());
                xNode.capture(env, resultSet);
                this.addChild(xNode);
            }
            super.capture(env, inputNode, nChildren - 1);
        }
    }

    public void addName(String name) {
        this.nameList.add(name);
    }

    public XNode getChild(String name) {
        int index = this.nameList.indexOf(name);
        if (index < 0) {
            return null;
        }
        return (XNode)this.getChild(index);
    }

    @Override
    protected void persistElementProperties(XQEPersistContext ctx) {
        super.persistElementProperties(ctx);
        if (this.nameList != null) {
            ctx.elementProperty(ATTRIBUTE_NAMELIST, this.nameList);
        }
    }

    @Override
    protected void restoreElementProperty(XQERestoreContext ctx, Element node, Element inputNode) {
        String pname = node.attributeValue("pname");
        if (pname.equals(ATTRIBUTE_NAMELIST)) {
            Object val = ctx.elementValue(node);
            this.nameList = (List)val;
        } else {
            super.restoreElementProperty(ctx, node, inputNode);
        }
    }

    private final class XWithResultSet
    extends XResultSetBase
    implements ITabularResultSet {
        private IHybridResultSet iResultSet;

        XWithResultSet(XDataContext context) {
            super(context, XWith.this.getId());
            IExecutable child = (IExecutable)((Object)XWith.this.getChild(XWith.this.getNumberChildren() - 1));
            this.iResultSet = (IHybridResultSet)child.execute(context);
            super.setTabularRowsetInfo(this.iResultSet.getTabularRowsetInfo());
        }

        @Override
        public ITabularIterator getTabularIterator() {
            return new XWithIterator(this.getDataContext());
        }

        @Override
        public void releaseImpl() {
            if (this.iResultSet != null) {
                this.iResultSet.release();
                this.iResultSet = null;
            }
        }

        private final class XWithIterator
        extends XTabularIterator {
            private ITabularIterator tabIt;

            private XWithIterator(XDataContext context) {
                super(context, XWith.this.getId());
                try {
                    this.startTimer();
                    this.tabIt = XWithResultSet.this.iResultSet.getTabularIterator();
                }
                catch (RuntimeException e) {
                    this.release();
                    throw e;
                }
                finally {
                    this.stopTimer();
                }
            }

            @Override
            public Object nextImpl() {
                return (IRow)this.tabIt.next();
            }

            @Override
            public Object nextBatch() {
                return this.tabIt.nextBatch();
            }

            @Override
            public long getIndex() {
                return this.tabIt.getIndex();
            }

            @Override
            public void release() {
                if (this.tabIt != null) {
                    this.tabIt.release();
                }
                super.release();
            }
        }
    }
}

