/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.relational.dataset.parquet;

import com.cognos.xqe.ast.sql.parser.ParseException;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.data.types.RowType;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.runtree.relational.dataset.parquet.ParquetDatasetReadSupport;
import com.cognos.xqe.runtree.relational.dataset.parquet.UTF8Decoder;
import com.cognos.xqe.runtree.relational.vectorization.TimestampColumnVector;
import java.math.BigDecimal;
import java.math.MathContext;
import java.nio.ByteBuffer;
import java.util.Map;
import org.apache.parquet.column.Dictionary;
import org.apache.parquet.io.api.Binary;
import org.apache.parquet.io.api.Converter;
import org.apache.parquet.io.api.GroupConverter;
import org.apache.parquet.io.api.PrimitiveConverter;
import org.apache.parquet.schema.DecimalMetadata;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.OriginalType;
import org.apache.parquet.schema.PrimitiveType;
import org.apache.parquet.schema.Type;

@Deprecated
public class ParquetDatasetRecordConverter
extends GroupConverter {
    private Converter[] converters;
    private Object[] currentRecord;

    public ParquetDatasetRecordConverter(MessageType schema, Map<String, String> extraMetadata) {
        RowType rowType;
        try {
            rowType = ParquetDatasetReadSupport.getRowType(extraMetadata);
        }
        catch (ParseException e) {
            throw new XQERuntimeException(e);
        }
        int schemaSize = schema.getFieldCount();
        this.converters = new Converter[schemaSize];
        int index = 0;
        for (Type field : schema.getFields()) {
            final int finalIndex = index;
            this.converters[index++] = ParquetDatasetRecordConverter.newConverter(field, rowType.getFieldDataType(field.getName()), new ParentValueContainer(){

                @Override
                void add(Object value) {
                    ParquetDatasetRecordConverter.this.put(finalIndex, value);
                }
            });
        }
    }

    public void end() {
    }

    public Converter getConverter(int index) {
        return this.converters[index];
    }

    public void start() {
        this.currentRecord = new Object[this.converters.length];
    }

    Object[] getCurrentRecord() {
        return this.currentRecord;
    }

    private static Converter newConverter(Type type, IDataType dataType, ParentValueContainer parent) {
        if (type.isPrimitive()) {
            PrimitiveType pType = type.asPrimitiveType();
            switch (pType.getPrimitiveTypeName()) {
                case BOOLEAN: {
                    return new FieldBooleanConverter(parent);
                }
                case INT32: {
                    return new FieldIntegerConverter(parent);
                }
                case INT64: {
                    return new FieldLongConverter(parent);
                }
                case FLOAT: {
                    return new FieldFloatConverter(parent);
                }
                case DOUBLE: {
                    return new FieldDoubleConverter(parent);
                }
                case BINARY: {
                    if (pType.getOriginalType() == OriginalType.DECIMAL) {
                        return new FieldDecimalConverter(parent, pType.getDecimalMetadata());
                    }
                    return new FieldStringConverter(parent, pType.getOriginalType() == OriginalType.UTF8);
                }
            }
            throw new IllegalArgumentException();
        }
        byte cclDType = dataType.getCCLTypeCode();
        switch (cclDType) {
            case 58: 
            case 59: {
                return new FieldTimestampConverter(cclDType, parent);
            }
            case 52: 
            case 53: {
                return new FieldTimestampWithTZConverter(cclDType, parent);
            }
        }
        throw new IllegalArgumentException();
    }

    private void put(int index, Object value) {
        this.currentRecord[index] = value;
    }

    static final class FieldStringConverter
    extends PrimitiveConverter {
        private final ParentValueContainer parent;
        private final boolean dictionarySupport;
        private final UTF8Decoder decoder;
        private String[] dict;

        FieldStringConverter(ParentValueContainer theParent, boolean dictSupport) {
            this.parent = theParent;
            this.dictionarySupport = dictSupport;
            this.decoder = new UTF8Decoder();
        }

        public void addBinary(Binary value) {
            this.parent.add(this.decoder.decode(value.toByteBuffer()));
        }

        public boolean hasDictionarySupport() {
            return this.dictionarySupport;
        }

        public void setDictionary(Dictionary dictionary) {
            this.dict = new String[dictionary.getMaxId() + 1];
            for (int i = 0; i <= dictionary.getMaxId(); ++i) {
                this.dict[i] = this.decoder.decode(dictionary.decodeToBinary(i).toByteBuffer());
            }
        }

        public void addValueFromDictionary(int dictionaryId) {
            this.parent.add(this.dict[dictionaryId]);
        }
    }

    static final class FieldTimestampWithTZConverter
    extends GroupConverter {
        private static final int N_CONVERTERS = 3;
        private final ParentValueContainer parent;
        private TimestampColumnVector.UnixTimestamp uxTimestamp;
        private Converter[] converters = new Converter[3];
        private byte dType;

        FieldTimestampWithTZConverter(byte cclDType, ParentValueContainer theParent) {
            this.parent = theParent;
            this.dType = cclDType;
            this.converters[0] = new FieldLongConverter(new ParentValueContainer(){

                @Override
                void add(Object value) {
                    ((FieldTimestampWithTZConverter)this).uxTimestamp.milliseconds = (Long)value;
                }
            });
            this.converters[1] = new FieldIntegerConverter(new ParentValueContainer(){

                @Override
                void add(Object value) {
                    ((FieldTimestampWithTZConverter)this).uxTimestamp.nanoseconds = (Integer)value;
                }
            });
            this.converters[2] = new FieldIntegerConverter(new ParentValueContainer(){

                @Override
                void add(Object value) {
                    ((FieldTimestampWithTZConverter)this).uxTimestamp.timeZoneOffset = (Integer)value;
                }
            });
        }

        public Converter getConverter(int fieldIndex) {
            return this.converters[fieldIndex];
        }

        public void start() {
            this.uxTimestamp = new TimestampColumnVector.UnixTimestamp(this.dType);
        }

        public void end() {
            this.parent.add(this.uxTimestamp);
        }
    }

    static final class FieldTimestampConverter
    extends GroupConverter {
        private final ParentValueContainer parent;
        private TimestampColumnVector.UnixTimestamp uxTimestamp;
        private Converter[] converters = new Converter[2];
        private byte dType;

        FieldTimestampConverter(byte cclDType, ParentValueContainer theParent) {
            this.dType = cclDType;
            this.parent = theParent;
            this.converters[0] = new FieldLongConverter(new ParentValueContainer(){

                @Override
                void add(Object value) {
                    ((FieldTimestampConverter)this).uxTimestamp.milliseconds = (Long)value;
                }
            });
            this.converters[1] = new FieldIntegerConverter(new ParentValueContainer(){

                @Override
                void add(Object value) {
                    ((FieldTimestampConverter)this).uxTimestamp.nanoseconds = (Integer)value;
                }
            });
        }

        public Converter getConverter(int fieldIndex) {
            return this.converters[fieldIndex];
        }

        public void start() {
            this.uxTimestamp = new TimestampColumnVector.UnixTimestamp(this.dType);
        }

        public void end() {
            this.parent.add(this.uxTimestamp);
        }
    }

    private static final class FieldBytesConverter
    extends PrimitiveConverter {
        private final ParentValueContainer parent;

        FieldBytesConverter(ParentValueContainer theParent) {
            this.parent = theParent;
        }

        public void addBinary(Binary value) {
            this.parent.add(ByteBuffer.wrap(value.getBytes()));
        }
    }

    private static final class FieldDecimalConverter
    extends PrimitiveConverter {
        private final ParentValueContainer parent;
        private final DecimalMetadata metadata;
        private final MathContext mc;

        FieldDecimalConverter(ParentValueContainer theParent, DecimalMetadata decimalMetadata) {
            this.parent = theParent;
            this.metadata = decimalMetadata;
            this.mc = new MathContext(this.metadata.getPrecision());
        }

        public void addBinary(Binary value) {
            this.parent.add(new BigDecimal(value.toStringUsingUTF8(), this.mc).setScale(this.metadata.getScale()));
        }
    }

    private static final class FieldDoubleConverter
    extends PrimitiveConverter {
        private final ParentValueContainer parent;

        FieldDoubleConverter(ParentValueContainer theParent) {
            this.parent = theParent;
        }

        public void addInt(int value) {
            this.parent.add(value);
        }

        public void addLong(long value) {
            this.parent.add(value);
        }

        public void addFloat(float value) {
            this.parent.add(value);
        }

        public void addDouble(double value) {
            this.parent.add(value);
        }
    }

    private static final class FieldFloatConverter
    extends PrimitiveConverter {
        private final ParentValueContainer parent;

        FieldFloatConverter(ParentValueContainer theParent) {
            this.parent = theParent;
        }

        public void addInt(int value) {
            this.parent.add(Float.valueOf(value));
        }

        public void addLong(long value) {
            this.parent.add(Float.valueOf(value));
        }

        public void addFloat(float value) {
            this.parent.add(Float.valueOf(value));
        }
    }

    private static final class FieldLongConverter
    extends PrimitiveConverter {
        private final ParentValueContainer parent;

        FieldLongConverter(ParentValueContainer theParent) {
            this.parent = theParent;
        }

        public void addInt(int value) {
            this.parent.add(value);
        }

        public void addLong(long value) {
            this.parent.add(value);
        }
    }

    private static final class FieldIntegerConverter
    extends PrimitiveConverter {
        private final ParentValueContainer parent;

        FieldIntegerConverter(ParentValueContainer theParent) {
            this.parent = theParent;
        }

        public void addInt(int value) {
            this.parent.add(value);
        }
    }

    private static final class FieldBooleanConverter
    extends PrimitiveConverter {
        private final ParentValueContainer parent;

        FieldBooleanConverter(ParentValueContainer theParent) {
            this.parent = theParent;
        }

        public void addBoolean(boolean value) {
            this.parent.add(value);
        }
    }

    static abstract class ParentValueContainer {
        ParentValueContainer() {
        }

        abstract void add(Object var1);
    }
}

