/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.relational.decoration;

import com.cognos.xqe.ast.IXQEPersist;
import com.cognos.xqe.ast.XQEPersistContext;
import com.cognos.xqe.ast.XQERestoreContext;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.resultsets.ContextBase;
import com.cognos.xqe.resultsets.ContextMember;
import com.cognos.xqe.resultsets.ContextValue;
import com.cognos.xqe.rsapi.RSAPIDataItem;
import com.cognos.xqe.rsapi.RSAPIDataset;
import com.cognos.xqe.rsapi.RSAPIDatasetContext;
import com.cognos.xqe.rsapi.RSAPIEdge;
import com.cognos.xqe.rsapi.RSAPIEdgeRowset;
import com.cognos.xqe.rsapi.RSAPIRowset;
import com.cognos.xqe.trace.XQETrace;
import org.dom4j.Attribute;
import org.dom4j.Element;

public class ValueDecorationRule
implements IXQEPersist {
    private static final String ATTRIBUTE_ROWSET_ID = "rowsetId";
    private static final String ATTRIBUTE_EDGE_ORDINAL = "edgeOrdinal";
    private static final String ATTRIBUTE_COLUMNNO = "columnNo";
    private static final String ATTRIBUTE_DATAITEMINDEX = "dataItemIndex";
    public static final String PROPERTY_DATAITEM_REF = "dataItemRef";
    private RSAPIRowset rowset;
    private int columnNo = -1;
    private int dataItemIndex = -1;

    public RSAPIRowset getRowset() {
        return this.rowset;
    }

    public void setRowset(RSAPIRowset theRowset) {
        this.rowset = theRowset;
    }

    public void setRowset(RSAPIRowset theRowset, RSAPIDataItem dataItem) {
        this.rowset = theRowset;
        this.columnNo = this.rowset.getDataItemOrdinal(dataItem);
    }

    public int getColumnNo() {
        return this.columnNo;
    }

    public void setColumnNo(int theColumnNo) {
        this.columnNo = theColumnNo;
    }

    public int getDataItemIndex() {
        return this.dataItemIndex;
    }

    public void setDataItemIndex(int theDataItemIndex) {
        this.dataItemIndex = theDataItemIndex;
    }

    public void capture(PlanningEnvironment env, Element inputNode, int edgeOrdinal) {
        Attribute attribute = inputNode.attribute(ATTRIBUTE_ROWSET_ID);
        if (attribute != null) {
            RSAPIRowset aRowset = ValueDecorationRule.getRowset(attribute.getStringValue(), edgeOrdinal);
            this.setRowset(aRowset);
        }
        if ((attribute = inputNode.attribute(ATTRIBUTE_COLUMNNO)) != null) {
            this.setColumnNo(Integer.parseInt(attribute.getValue()));
        }
        if ((attribute = inputNode.attribute(ATTRIBUTE_DATAITEMINDEX)) != null) {
            this.setDataItemIndex(Integer.parseInt(attribute.getValue()));
        }
    }

    protected static RSAPIRowset getRowset(String rowsetId, int edgeOrdinal) {
        RSAPIEdgeRowset aRowset;
        Integer rowsetIdAsInteger = new Integer(rowsetId);
        RSAPIDataset dataset = RSAPIDatasetContext.getDataset();
        if (dataset == null) {
            aRowset = new RSAPIEdgeRowset();
            aRowset.setRowsetId(rowsetIdAsInteger);
        } else {
            RSAPIEdge edge = dataset.getEdge(edgeOrdinal);
            aRowset = edge.getRowset(rowsetIdAsInteger);
        }
        return aRowset;
    }

    protected String getName() {
        String name = this.getClass().getName();
        return name.substring(name.lastIndexOf(46) + 1);
    }

    public void dump(XQETrace trace) {
        trace.beginElement(this.getName(), -1);
        trace.attribute(ATTRIBUTE_ROWSET_ID, this.getRowset().getRowsetId());
        if (this.getColumnNo() != -1) {
            trace.attribute(ATTRIBUTE_COLUMNNO, this.getColumnNo());
        }
        trace.attribute(ATTRIBUTE_DATAITEMINDEX, this.getDataItemIndex());
        trace.endElement();
    }

    protected IValue apply(IValue aValue) {
        if (aValue instanceof IMember) {
            ContextMember cxtMember = new ContextMember();
            cxtMember.setMember((IMember)aValue);
            cxtMember.setContextMember(null);
            aValue = cxtMember;
        }
        if (aValue instanceof ContextBase) {
            ((ContextBase)((Object)aValue)).setRowset(this.getRowset());
            ((ContextBase)((Object)aValue)).setDataItemIndex(this.getDataItemIndex());
            return aValue;
        }
        ContextValue aContextValue = new ContextValue(aValue);
        aContextValue.setRowset(this.getRowset());
        aContextValue.setDataItemIndex(this.getDataItemIndex());
        return aContextValue;
    }

    @Override
    public void persist(XQEPersistContext ctx, String optionalName) {
        if (ctx.beginElement(this, optionalName, -1)) {
            this.persistAttributeProperties(ctx);
            ctx.endElement();
        }
    }

    public void persistAttributeProperties(XQEPersistContext ctx) {
        if (this.getRowset() != null) {
            ctx.property(ATTRIBUTE_ROWSET_ID, this.getRowset().getRowsetId());
            if (this.getRowset().getEdge() != null) {
                ctx.property(ATTRIBUTE_EDGE_ORDINAL, this.getRowset().getEdge().getOrdinal());
            }
        }
        if (this.getColumnNo() != -1) {
            ctx.property(ATTRIBUTE_COLUMNNO, this.getColumnNo());
        }
        ctx.property(ATTRIBUTE_DATAITEMINDEX, this.getDataItemIndex());
    }

    @Override
    public void restore(XQERestoreContext ctx, Element node) {
        this.restoreAttributes(ctx, node);
    }

    public void restoreAttributes(XQERestoreContext ctx, Element node) {
        int size = node.attributeCount();
        for (int i = 0; i < size; ++i) {
            Attribute att = node.attribute(i);
            this.restoreAttributeProperty(ctx, att, node);
        }
    }

    protected void restoreAttributeProperty(XQERestoreContext ctx, Attribute att, Element node) {
        String attName = att.getName();
        if (attName.equals(ATTRIBUTE_ROWSET_ID)) {
            Object val = ctx.attributeValue(att);
            if (val != null) {
                RSAPIEdge edge;
                RSAPIDataset dataset;
                int rowsetId = (Integer)val;
                int edgeOrdinal = 0;
                Attribute edgeOrdinalAttr = node.attribute(ATTRIBUTE_EDGE_ORDINAL);
                if (edgeOrdinalAttr != null) {
                    edgeOrdinal = (Integer)ctx.attributeValue(edgeOrdinalAttr);
                }
                if ((dataset = ctx.getDataset()) != null && (edge = dataset.getEdge(edgeOrdinal)) != null) {
                    this.rowset = edge.getRowset(rowsetId);
                }
            }
        } else if (attName.equals(ATTRIBUTE_COLUMNNO)) {
            Object val = ctx.attributeValue(att);
            this.setColumnNo((Integer)val);
        } else if (attName.equals(ATTRIBUTE_DATAITEMINDEX)) {
            Object val = ctx.attributeValue(att);
            this.setDataItemIndex((Integer)val);
        }
    }
}

