/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.relational.decoration;

import com.cognos.xqe.ast.XQEPersistContext;
import com.cognos.xqe.ast.XQERestoreContext;
import com.cognos.xqe.ast.sql.SQLAlias;
import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.config.XQEConfiguration;
import com.cognos.xqe.config.XQEConfigurationManager;
import com.cognos.xqe.data.values.DataValueFactory;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.data.values.NullValue;
import com.cognos.xqe.data.values.RowValue;
import com.cognos.xqe.data.values.TextValue;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.TransformationEngine;
import com.cognos.xqe.resultset.interfaces.IExecutable;
import com.cognos.xqe.resultset.interfaces.IHybridResultSet;
import com.cognos.xqe.resultset.interfaces.IScrollableIterator;
import com.cognos.xqe.resultset.interfaces.ITabularIterator;
import com.cognos.xqe.resultset.interfaces.ITabularResultSet;
import com.cognos.xqe.resultsets.BaseIterator;
import com.cognos.xqe.resultsets.ContextValue;
import com.cognos.xqe.resultsets.caching.ForwardOnlyTabularCache;
import com.cognos.xqe.resultsets.tabular.RowsetInfo;
import com.cognos.xqe.resultsets.tabular.TabularHybridResultSet;
import com.cognos.xqe.rsapi.RSAPIEdgeRowset;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.runtree.XNode;
import com.cognos.xqe.runtree.XResultSetBase;
import com.cognos.xqe.runtree.XTabularIterator;
import com.cognos.xqe.runtree.XTabularResultSet;
import com.cognos.xqe.runtree.relational.decoration.ValueDecorationRule;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqe.trace.XQELogger;
import com.cognos.xqe.trace.XQETrace;
import com.ibm.icu.text.Collator;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.dom4j.Attribute;
import org.dom4j.Element;

public class XValueDecoration
extends XTabularResultSet {
    private static final long serialVersionUID = 1L;
    public static final String ATTRIBUTE_ALL_ROWS_DISABLED = "allRowsDisabled";
    public static final String ATTRIBUTE_LOCAL_PROCESSING = "localProcessing";
    public static final String ATTRIBUTE_LOCAL_CACHE_DISABLED = "localCacheDisabled";
    public static final String ELEMENT_RULES = "rules";
    public static final int CACHE_MEMORY = 5;
    private List<ValueDecorationRule> rules = new ArrayList<ValueDecorationRule>();
    private List<SQLAlias> aliasList;
    private boolean localCacheDisabled = false;
    private boolean allRowsDisabled = false;
    private static Boolean cacheResultSetsConfigValue = null;
    private static Boolean htmlHelperConfigValue = null;
    private boolean isVectorized;
    private boolean bForceCache = false;
    private static XQELogger infoLogger = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "InteractiveHtmlHelper", LogLevel.INFO);

    @Override
    protected IValue executeImpl(XDataContext context) {
        boolean caching = false;
        if (this.isAllRowsDisabled() && this.htmlHelperEnabledInConfig()) {
            caching = this.isLocalProcessing() || this.isLocalCacheDisabled() || !this.cacheResultSetsEnabledInConfig();
        }
        return new TabularHybridResultSet(context, new XValueDecorationResult(context, this.bForceCache || caching), TransformationEngine.DUMMY_NODEID);
    }

    private boolean cacheResultSetsEnabledInConfig() {
        if (cacheResultSetsConfigValue == null) {
            XQEConfiguration configuration = XQEConfigurationManager.getInstance().getConfiguration(ServiceEnumeration.XQE);
            cacheResultSetsConfigValue = configuration != null && configuration.getBooleanProperty("general.cacheResultSets[@enabled]", true) ? Boolean.TRUE : Boolean.FALSE;
        }
        return cacheResultSetsConfigValue;
    }

    private boolean htmlHelperEnabledInConfig() {
        if (htmlHelperConfigValue == null) {
            XQEConfiguration configuration = XQEConfigurationManager.getInstance().getConfiguration(ServiceEnumeration.XQE);
            htmlHelperConfigValue = configuration != null && configuration.getBooleanProperty("general.interactiveHTMLHelper[@enabled]", true) ? Boolean.TRUE : Boolean.FALSE;
        }
        return htmlHelperConfigValue;
    }

    @Override
    public int getType() {
        return 501043;
    }

    public void addRule(ValueDecorationRule theRule) {
        this.rules.add(theRule);
    }

    public List<ValueDecorationRule> getRules() {
        return this.rules;
    }

    public void setRules(List<ValueDecorationRule> theRules) {
        this.rules = theRules;
    }

    public int getNumberOfRules() {
        return this.rules.size();
    }

    @Override
    public void dump(XQETrace trace, boolean includeRuntimeSpecifics) {
        Integer nodeID = -1;
        if (includeRuntimeSpecifics) {
            nodeID = this.getId();
        }
        trace.beginElement(this.getNodeTypeName(), nodeID);
        this.dumpExtraInfo(trace, includeRuntimeSpecifics);
        this.dumpDecorationRules(trace);
        for (int i = 0; i < this.getNumberChildren(); ++i) {
            this.getChild(i).dump(trace, includeRuntimeSpecifics);
        }
        trace.endElement();
    }

    @Override
    public void dumpExtraInfo(XQETrace trace, boolean includeRuntimeSpecifics) {
        trace.attribute(ATTRIBUTE_ALL_ROWS_DISABLED, this.isAllRowsDisabled());
        trace.attribute(ATTRIBUTE_LOCAL_PROCESSING, this.isLocalProcessing());
        trace.attribute(ATTRIBUTE_LOCAL_CACHE_DISABLED, this.isLocalCacheDisabled());
        super.dumpExtraInfo(trace, includeRuntimeSpecifics);
    }

    protected void dumpDecorationRules(XQETrace trace) {
        for (ValueDecorationRule vDecorationrules : this.rules) {
            vDecorationrules.dump(trace);
        }
    }

    @Override
    public boolean hasDQPostProcessing() {
        return ((XNode)this.getChild(0)).getType() != 501013;
    }

    @Override
    public void capture(PlanningEnvironment env, Element inputNode) {
        Attribute attribute = inputNode.attribute(ATTRIBUTE_ALL_ROWS_DISABLED);
        if (attribute != null) {
            this.setAllRowsDisabled(Boolean.valueOf(attribute.getText()));
        }
        if ((attribute = inputNode.attribute(ATTRIBUTE_LOCAL_CACHE_DISABLED)) != null) {
            this.setLocalCacheDisabled(Boolean.valueOf(attribute.getText()));
        }
        List childList = inputNode.elements();
        for (int i = 0; i < childList.size() - 1; ++i) {
            Element child = (Element)childList.get(i);
            String elementName = child.getName();
            if (!"ValueDecorationRule".equals(elementName)) continue;
            ValueDecorationRule rule = new ValueDecorationRule();
            rule.capture(env, child, 0);
            this.rules.add(rule);
        }
        super.capture(env, inputNode, childList.size() - 1);
    }

    public List<SQLAlias> getAliasList() {
        return this.aliasList;
    }

    public void setAliasList(List<SQLAlias> theAliasList) {
        this.aliasList = theAliasList;
    }

    public void setLocalCacheDisabled(boolean theLocalCacheDisabled) {
        this.localCacheDisabled = theLocalCacheDisabled;
    }

    public boolean isLocalCacheDisabled() {
        return this.localCacheDisabled;
    }

    public boolean isLocalProcessing() {
        return this.getChild(0).getType() != 501013;
    }

    public void setAllRowsDisabled(boolean theDynamicHtml) {
        this.allRowsDisabled = theDynamicHtml;
    }

    public boolean isAllRowsDisabled() {
        return this.allRowsDisabled;
    }

    public void setVectorized(boolean vectorized) {
        this.isVectorized = vectorized;
    }

    public boolean isVectorized() {
        return this.isVectorized;
    }

    @Override
    protected void persistAttributeProperties(XQEPersistContext ctx) {
        super.persistAttributeProperties(ctx);
        ctx.property(ATTRIBUTE_ALL_ROWS_DISABLED, this.isAllRowsDisabled());
        ctx.property(ATTRIBUTE_LOCAL_PROCESSING, this.isLocalProcessing());
        ctx.property(ATTRIBUTE_LOCAL_CACHE_DISABLED, this.isLocalCacheDisabled());
    }

    @Override
    protected void persistElementProperties(XQEPersistContext ctx) {
        super.persistElementProperties(ctx);
        if (this.rules != null) {
            ctx.elementProperty(ELEMENT_RULES, this.rules);
        }
    }

    @Override
    protected void restoreAttributeProperty(XQERestoreContext ctx, Attribute att, Element inputNode) {
        String attname = att.getName();
        if (attname.equals(ATTRIBUTE_ALL_ROWS_DISABLED)) {
            Object val = ctx.attributeValue(att);
            this.allRowsDisabled = (Boolean)val;
        } else if (attname.equals(ATTRIBUTE_LOCAL_CACHE_DISABLED)) {
            Object val = ctx.attributeValue(att);
            this.localCacheDisabled = (Boolean)val;
        } else {
            super.restoreAttributeProperty(ctx, att, inputNode);
        }
    }

    @Override
    protected void restoreElementProperty(XQERestoreContext ctx, Element node, Element inputNode) {
        String pname = node.attributeValue("pname");
        if (pname.equals(ELEMENT_RULES)) {
            Object val = ctx.elementValue(node);
            this.rules = (List)val;
        } else {
            super.restoreElementProperty(ctx, node, inputNode);
        }
    }

    public void setForceCache(boolean b) {
        this.bForceCache = b;
    }

    private final class XValueDecorationResult
    extends XResultSetBase
    implements ITabularResultSet {
        private ITabularResultSet sourceResult;
        private ForwardOnlyTabularCache cache;

        XValueDecorationResult(XDataContext context, boolean caching) {
            super(context, TransformationEngine.DUMMY_NODEID);
            try {
                this.sourceResult = (IHybridResultSet)((IExecutable)((Object)XValueDecoration.this.getChild(0))).execute(context);
                this.rowsetInfo = (RowsetInfo)this.sourceResult.getTabularRowsetInfo();
                if (caching) {
                    this.cache = new ForwardOnlyTabularCache(context, this.sourceResult, XValueDecoration.this.getId(), 5);
                    this.sourceResult = null;
                    infoLogger.log(String.format("Creating interactive HTML helper [id=%1$d].", XValueDecoration.this.getId()));
                }
            }
            catch (XQERuntimeException e) {
                this.release();
                throw e;
            }
        }

        @Override
        public IScrollableIterator getScrollableTabularIterator() {
            throw new UnsupportedOperationException();
        }

        @Override
        public ITabularIterator getTabularIterator() {
            return new XValueDecorationIterator(this.getDataContext(), this.sourceResult, this.cache);
        }

        @Override
        public void releaseImpl() {
            if (this.cache != null) {
                this.cache.release();
                infoLogger.log(String.format("Releasing interactive HTML helper [id=%1$d].", XValueDecoration.this.getId()));
                this.cache = null;
            }
            if (this.sourceResult != null) {
                this.sourceResult.release();
                this.sourceResult = null;
            }
        }

        private final class XValueDecorationIterator
        extends XTabularIterator {
            private ITabularIterator tabIt;
            private RowValue result;
            private RowValue currentRow;
            private RowValue previousRow;
            private boolean[] computeBreaks;
            private RSAPIEdgeRowset[] rowsets;
            private boolean isGroupedResultset;
            private LinkedList<RSAPIEdgeRowset> rowsetQueue;
            private RowValue[] resultRowForRowset;
            private boolean[] isFooterConsumed;
            private boolean isEOD;
            private boolean firstRowProcessed;

            private XValueDecorationIterator(XDataContext context, ITabularResultSet iResultSet, ForwardOnlyTabularCache iCache) {
                super(context, XValueDecoration.this.getId());
                try {
                    this.startTimer();
                    this.tabIt = iCache == null ? iResultSet.getTabularIterator() : iCache.getTabularIterator(this.getDataContext());
                    this.rowsets = null;
                    IValue[] values = new IValue[XValueDecoration.this.rules.size()];
                    if (((ValueDecorationRule)XValueDecoration.this.rules.get(0)).getRowset().getEdge() == null) {
                        this.result = DataValueFactory.createRowValue(values);
                    } else {
                        this.rowsets = ((ValueDecorationRule)XValueDecoration.this.rules.get(0)).getRowset().getEdge().getRowsets();
                        this.rowsetQueue = new LinkedList();
                        this.computeBreaks = new boolean[this.rowsets.length];
                        this.initializeIsGroupedResultSet();
                        this.isFooterConsumed = new boolean[this.rowsets.length];
                        this.initializeResultRowForRowset();
                        this.previousRow = DataValueFactory.createRowValue(values);
                        this.currentRow = null;
                    }
                }
                catch (RuntimeException e) {
                    this.release();
                    throw e;
                }
                finally {
                    this.stopTimer();
                }
            }

            private void initializeResultRowForRowset() {
                this.resultRowForRowset = new RowValue[this.rowsets.length];
                for (int i = 0; i < this.rowsets.length; ++i) {
                    int numColumnsForRowset = this.rowsets[i].getNumColumns();
                    if (numColumnsForRowset == 0) {
                        numColumnsForRowset = 1;
                    }
                    if (this.rowsets[i].isDetailRowset() || this.rowsets[i].isFooterRowset() || this.rowsets[i].isHeaderRowset()) {
                        for (RSAPIEdgeRowset parentRowset = this.rowsets[i].getParentRowset(); parentRowset != null; parentRowset = parentRowset.getParentRowset()) {
                            numColumnsForRowset += parentRowset.getNumColumns();
                        }
                    }
                    IValue[] values = new IValue[numColumnsForRowset];
                    this.resultRowForRowset[i] = DataValueFactory.createRowValue(values);
                }
            }

            private void initializeIsGroupedResultSet() {
                this.isGroupedResultset = false;
                for (int i = 0; i < this.rowsets.length; ++i) {
                    if (this.rowsets[i].getRefDataItem() == null) continue;
                    this.isGroupedResultset = true;
                    break;
                }
            }

            @Override
            public Object nextImpl() {
                if (this.rowsets == null) {
                    return this.decoratedColumnsForTabularResult();
                }
                return this.decoratedColumnsForCurrentRowset();
            }

            private Object decoratedColumnsForCurrentRowset() {
                RSAPIEdgeRowset rowset = this.getNextRowset();
                if (rowset == null) {
                    return null;
                }
                return this.getRowValueForRowset(rowset);
            }

            private Object decoratedColumnsForTabularResult() {
                RowValue tmpRow = (RowValue)this.tabIt.next();
                if (tmpRow == null) {
                    return null;
                }
                for (int i = 0; i < XValueDecoration.this.rules.size(); ++i) {
                    ValueDecorationRule rule = (ValueDecorationRule)XValueDecoration.this.rules.get(i);
                    IValue value = null;
                    value = (IValue)tmpRow.getColumn(rule.getColumnNo()).copy();
                    this.result.setColumn(i, rule.apply(value));
                }
                return this.result;
            }

            private RSAPIEdgeRowset getNextRowset() {
                if (!this.rowsetQueue.isEmpty()) {
                    return this.rowsetQueue.removeFirst();
                }
                this.loadRowsetQueueFromNextRow();
                if (this.rowsetQueue.isEmpty()) {
                    return null;
                }
                return this.rowsetQueue.removeFirst();
            }

            private Object getRowValueForRowset(RSAPIEdgeRowset rowset) {
                int rowsetNumColumns = rowset.getNumColumns();
                if (rowsetNumColumns == 0) {
                    rowsetNumColumns = 1;
                }
                int startingColumnIndex = this.resultRowForRowset[rowset.getRowsetId()].getNumColumns() - rowsetNumColumns;
                this.getDecoratedColumnsForRowset(this.resultRowForRowset[rowset.getRowsetId()], rowset, startingColumnIndex, rowset);
                if (rowset.isDetailRowset() || rowset.isFooterRowset() || rowset.isHeaderRowset()) {
                    for (RSAPIEdgeRowset parentRowset = rowset.getParentRowset(); parentRowset != null; parentRowset = parentRowset.getParentRowset()) {
                        this.getDecoratedColumnsForRowset(this.resultRowForRowset[rowset.getRowsetId()], parentRowset, startingColumnIndex -= parentRowset.getNumColumns(), rowset);
                    }
                }
                return this.resultRowForRowset[rowset.getRowsetId()];
            }

            private void getDecoratedColumnsForRowset(RowValue resultRow, RSAPIEdgeRowset rowset, int startingColumnIndex, RSAPIEdgeRowset rowsetForResultRow) {
                int iRowsetColumn = startingColumnIndex;
                boolean bAddPseudoValueForEmptyRowset = true;
                for (int i = 0; i < XValueDecoration.this.rules.size(); ++i) {
                    ValueDecorationRule rule = (ValueDecorationRule)XValueDecoration.this.rules.get(i);
                    IValue value = null;
                    if (rule.getRowset() != rowset) continue;
                    value = rowsetForResultRow.isFooterRowset() ? (IValue)this.previousRow.getColumn(rule.getColumnNo()).copy() : (IValue)this.currentRow.getColumn(rule.getColumnNo()).copy();
                    bAddPseudoValueForEmptyRowset = false;
                    resultRow.setColumn(iRowsetColumn, rule.apply(value));
                    ++iRowsetColumn;
                }
                if (bAddPseudoValueForEmptyRowset && rowset.getRowsetId() == rowsetForResultRow.getRowsetId()) {
                    this.addPseudoValueForEmptyRowset(resultRow, rowsetForResultRow, startingColumnIndex);
                }
            }

            private void addPseudoValueForEmptyRowset(RowValue resultRow, RSAPIEdgeRowset rowsetForResultRow, int columnIndex) {
                IValue[] values = new IValue[]{NullValue.NULLVALUE};
                RowValue emptyRow = DataValueFactory.createRowValue(values);
                ContextValue pseudoValue = new ContextValue(emptyRow.getColumn(0));
                pseudoValue.setRowset(rowsetForResultRow);
                pseudoValue.setDataItemIndex(-2);
                resultRow.setColumn(columnIndex, pseudoValue);
            }

            private void loadRowsetQueueFromNextRow() {
                if (this.isEOD) {
                    return;
                }
                if (this.firstRowProcessed) {
                    this.copyCurrentRowToPrevious();
                }
                this.currentRow = (RowValue)this.tabIt.next();
                if (this.currentRow == null) {
                    this.populateRowsetQueueWithUnconsumedFooters();
                    this.isEOD = true;
                    return;
                }
                if (!this.firstRowProcessed) {
                    this.populateRowsetQueueWithHeaderRowsets();
                    this.populateRowsetQueueWithDetailRowsets();
                    this.copyCurrentRowToPrevious();
                    this.firstRowProcessed = true;
                } else if (this.isGroupedResultset) {
                    this.populateRowsetQueueBasedOnComputeBreaks();
                } else {
                    this.populateRowsetQueueWithDetailRowsets();
                }
            }

            private void populateRowsetQueueWithHeaderRowsets() {
                if (this.firstRowProcessed) {
                    return;
                }
                for (int i = 0; i < this.rowsets.length; ++i) {
                    if (!this.rowsets[i].isHeaderRowset()) continue;
                    this.rowsetQueue.add(this.rowsets[i]);
                }
            }

            private void populateRowsetQueueWithDetailRowsets() {
                for (int i = 0; i < this.rowsets.length; ++i) {
                    if (!this.rowsets[i].isDetailRowset()) continue;
                    this.rowsetQueue.add(this.rowsets[i]);
                }
            }

            private void populateRowsetQueueBasedOnComputeBreaks() {
                int i;
                for (i = 0; i < this.rowsets.length; ++i) {
                    this.computeBreaks[i] = false;
                    this.isFooterConsumed[i] = false;
                }
                this.determineComputeBreaks();
                for (i = 0; i < this.rowsets.length; ++i) {
                    if ((!this.computeBreaks[i] || this.rowsets[i].isFooterRowset() || this.rowsets[i].isHeaderRowset()) && !this.rowsets[i].isDetailRowset()) continue;
                    RSAPIEdgeRowset nestedFooterRowset = null;
                    RSAPIEdgeRowset nestedHeaderRowset = null;
                    if (this.rowsets[i].getNestedRowset() != null) {
                        nestedFooterRowset = this.rowsets[i].getNestedRowset().getFooterRowset();
                        if (nestedFooterRowset != null) {
                            this.rowsetQueue.add(0, nestedFooterRowset);
                            this.isFooterConsumed[nestedFooterRowset.getRowsetId()] = true;
                        }
                        if ((nestedHeaderRowset = this.rowsets[i].getNestedRowset().getHeaderRowset()) == null) continue;
                        this.rowsetQueue.add(nestedHeaderRowset);
                        continue;
                    }
                    this.rowsetQueue.add(this.rowsets[i]);
                }
            }

            private void determineComputeBreaks() {
                for (int i = 0; i < XValueDecoration.this.rules.size(); ++i) {
                    RSAPIEdgeRowset rowset = (RSAPIEdgeRowset)((ValueDecorationRule)XValueDecoration.this.rules.get(i)).getRowset();
                    if (this.computeBreaks[rowset.getRowsetId()] || rowset.getRefDataItem() == null || ((ValueDecorationRule)XValueDecoration.this.rules.get(i)).getDataItemIndex() != -1 || this.compareValue(this.previousRow.getColumn(i), this.currentRow.getColumn(i))) continue;
                    this.computeBreaks[rowset.getRowsetId()] = true;
                    while (rowset.getNestedRowset() != null) {
                        rowset = rowset.getNestedRowset();
                        this.computeBreaks[rowset.getRowsetId()] = true;
                    }
                }
            }

            private boolean compareValue(IValue column1, IValue column2) {
                if (column1 instanceof TextValue) {
                    return ((TextValue)column1).compareTo((Object)column2, (Collator)null) == 0;
                }
                return column1.compareTo(column2) == 0;
            }

            private void populateRowsetQueueWithUnconsumedFooters() {
                if (!this.firstRowProcessed) {
                    return;
                }
                for (int i = 0; i < this.rowsets.length; ++i) {
                    if (!this.rowsets[i].isFooterRowset()) continue;
                    this.rowsetQueue.add(0, this.rowsets[i]);
                }
            }

            private boolean needToCopyCurrentRowToPrevious(int pos) {
                RSAPIEdgeRowset rowset = (RSAPIEdgeRowset)((ValueDecorationRule)XValueDecoration.this.rules.get(pos)).getRowset();
                if (!this.firstRowProcessed) {
                    return true;
                }
                if (rowset.getRefDataItem() != null && this.computeBreaks[rowset.getRowsetId()]) {
                    return true;
                }
                if (rowset.isFooterRowset() && rowset.getParentRowset() != null && this.computeBreaks[rowset.getParentRowset().getRowsetId()]) {
                    return true;
                }
                if (rowset.isHeaderRowset() && rowset.getParentRowset() != null && this.computeBreaks[rowset.getParentRowset().getRowsetId()]) {
                    return true;
                }
                if (rowset.isFooterRowset()) {
                    return true;
                }
                return rowset.isHeaderRowset();
            }

            private void copyCurrentRowToPrevious() {
                if (this.currentRow != null) {
                    for (int i = 0; i < XValueDecoration.this.rules.size(); ++i) {
                        if (!this.needToCopyCurrentRowToPrevious(i)) continue;
                        this.previousRow.setColumn(i, (IValue)this.currentRow.getColumn(i).copy());
                    }
                }
            }

            @Override
            public long getIndex() {
                return this.tabIt.getIndex();
            }

            @Override
            public long positionOnRow(long detailRowNumber, boolean fromTop) {
                if (this.tabIt instanceof BaseIterator && !this.containsHeaderReturningFirstValue()) {
                    return ((BaseIterator)((Object)this.tabIt)).positionOnRow(detailRowNumber, fromTop);
                }
                return -1L;
            }

            private boolean containsHeaderReturningFirstValue() {
                if (this.rowsets != null) {
                    for (RSAPIEdgeRowset rowset : this.rowsets) {
                        if (!rowset.getContainsHeaderReturningFirstValue()) continue;
                        return true;
                    }
                }
                return false;
            }

            @Override
            public void release() {
                if (this.tabIt != null) {
                    try {
                        this.tabIt.release();
                    }
                    catch (Exception ex) {
                        mErrorLogger.log(ex);
                    }
                    finally {
                        this.tabIt = null;
                    }
                }
            }
        }
    }
}

