/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.relational.olapengine;

import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.runtree.IMemoryAllocator;
import com.cognos.xqe.runtree.relational.olapengine.IPageStorage;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqe.trace.XQELogger;
import com.cognos.xqe.util.IReleasable;
import com.cognos.xqe.util.io.TempFileUtil;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;

public class BufferedTemporaryFileStorage
implements IPageStorage,
IReleasable {
    static final int PAGE_SIZE = 1024;
    private int pageSize;
    private FileChannel channel;
    private File file;
    private int bufferCount;
    LinkedList<ByteBuffer> free = new LinkedList();
    ArrayList<ByteBuffer> stored = new ArrayList();
    IMemoryAllocator allocator;
    private static XQELogger mErrorLogger = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "Exception", LogLevel.ERROR);

    public BufferedTemporaryFileStorage(IMemoryAllocator theAllocator) {
        this(theAllocator, 1024);
    }

    public BufferedTemporaryFileStorage(IMemoryAllocator theAllocator, int thePageSize) {
        this.allocator = theAllocator;
        this.pageSize = thePageSize;
    }

    @Override
    public ByteBuffer acquire() {
        ByteBuffer buffer = this.free.isEmpty() ? ByteBuffer.allocate(this.pageSize) : this.free.remove();
        buffer.clear();
        return buffer;
    }

    @Override
    public long store(ByteBuffer buffer) throws IOException {
        long position;
        if (this.allocator != null && this.allocator.allocateMemory(this.pageSize, false)) {
            this.stored.add(buffer);
            position = -this.stored.size();
        } else {
            if (this.channel == null) {
                this.openTemporaryFile();
            }
            position = this.channel.position();
            buffer.flip();
            this.channel.write(buffer);
            buffer.clear();
            this.free.add(buffer);
        }
        ++this.bufferCount;
        return position;
    }

    @Override
    public ByteBuffer retrieve(long position) throws IOException {
        ByteBuffer buffer;
        if (this.bufferCount == 0) {
            throw new IOException("The storage is empty.");
        }
        if (position < 0L) {
            int index = (int)(-position) - 1;
            buffer = this.stored.get(index);
            this.stored.set(index, null);
        } else {
            buffer = this.free.isEmpty() ? ByteBuffer.allocate(this.pageSize) : this.free.remove();
            buffer.clear();
            this.channel.read(buffer, position);
        }
        buffer.flip();
        --this.bufferCount;
        if (this.bufferCount == 0) {
            if (this.channel != null) {
                this.channel.position(0L);
            }
            if (this.stored != null) {
                this.stored.clear();
            }
        }
        return buffer;
    }

    @Override
    public void free(ByteBuffer buffer) {
        this.free.add(buffer);
    }

    @Override
    public void release() {
        if (this.channel != null) {
            try {
                this.channel.close();
                this.file.delete();
                this.channel = null;
            }
            catch (IOException e) {
                mErrorLogger.log(e);
            }
        }
        if (this.allocator != null) {
            this.allocator.releaseMemory(this.free.size() * this.pageSize);
            if (this.stored != null) {
                Iterator<ByteBuffer> iterator = this.stored.iterator();
                while (iterator.hasNext()) {
                    if (iterator.next() == null) continue;
                    this.allocator.releaseMemory(this.pageSize);
                }
            }
        }
    }

    public File getFile() {
        return this.file;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public long getPosition() {
        try {
            return this.channel.position();
        }
        catch (IOException e) {
            throw new XQERuntimeException(e);
        }
    }

    private void openTemporaryFile() throws IOException {
        this.file = TempFileUtil.createTempFile(this.getClass().getSimpleName());
        RandomAccessFile ra = new RandomAccessFile(this.file, "rw");
        this.channel = ra.getChannel();
    }
}

