/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.relational.olapengine;

import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.runtree.relational.olapengine.ColumnStorageControl;
import com.cognos.xqe.runtree.relational.olapengine.CompressedColumnStorage;
import com.cognos.xqe.runtree.relational.olapengine.DirectTemporaryFileStorage;
import com.cognos.xqe.runtree.relational.olapengine.IColumnStorageFactory;
import com.cognos.xqe.runtree.relational.olapengine.ICompressedColumnStorage;
import com.cognos.xqe.runtree.relational.olapengine.IPageStorage;
import com.cognos.xqe.runtree.relational.olapengine.IPartitionColumnStorage;
import com.cognos.xqe.runtree.relational.olapengine.IPeerCounter;
import com.cognos.xqe.runtree.relational.olapengine.IPlainColumnStorage;
import com.cognos.xqe.runtree.relational.olapengine.MemoryAllocator;
import com.cognos.xqe.runtree.relational.olapengine.PartitionColumnStorage;
import com.cognos.xqe.runtree.relational.olapengine.PeerCounter;
import com.cognos.xqe.runtree.relational.olapengine.PlainColumnStorage;
import com.cognos.xqe.util.IReleasable;

public class ClassicColumnStorageFactory
implements IColumnStorageFactory {
    ColumnStorageControl control = null;

    public ClassicColumnStorageFactory(XDataContext context, int pageSize) {
        this.control = new ColumnStorageControl(context);
        this.control.setMemoryAllocator(new MemoryAllocator(context.getMemoryManager()));
        this.control.setPageStorage(new DirectTemporaryFileStorage(pageSize));
    }

    public ClassicColumnStorageFactory(XDataContext context, MemoryAllocator ma) {
        this.control = new ColumnStorageControl(context);
        this.control.setMemoryAllocator(ma);
        this.control.setPageStorage(new DirectTemporaryFileStorage());
    }

    @Override
    public IPlainColumnStorage createPlainColumnStorage() {
        return new PlainColumnStorage(this.control);
    }

    @Override
    public ICompressedColumnStorage createCompressedColumnStorage() {
        return new CompressedColumnStorage(this.control);
    }

    @Override
    public IPartitionColumnStorage createPartitionColumnStorage() {
        return new PartitionColumnStorage(this.control);
    }

    @Override
    public void release() {
        if (this.control != null && this.control.getPageStorage() != null) {
            try {
                ((IReleasable)((Object)this.control.getPageStorage())).release();
            }
            finally {
                this.control.setPageStorage(null);
            }
            this.control.getMemoryAllocator().releaseRemainingMemory();
        }
    }

    @Override
    public IPeerCounter createPeerCounter() {
        return new PeerCounter(this.control.getPageStorage());
    }

    public IPageStorage getPageStorage() {
        return this.control.getPageStorage();
    }
}

