/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.relational.olapengine;

import com.cognos.xqe.runtree.relational.olapengine.IPageStorage;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.LinkedList;
import java.util.Queue;

public class ColumnBuffer {
    static final int MASK = 255;
    IPageStorage storage;
    Queue<Long> index = null;
    ByteBuffer wbuffer;
    ByteBuffer rbuffer;

    public ColumnBuffer(IPageStorage theStorage) {
        this.storage = theStorage;
    }

    public void write(int b) throws IOException {
        if (this.wbuffer == null) {
            if (this.rbuffer != null && this.getNumBuffersStored() == 0) {
                this.wbuffer = this.rbuffer;
                this.rbuffer = null;
                this.wbuffer.compact();
            } else {
                this.wbuffer = this.storage.acquire();
            }
        }
        if (!this.wbuffer.hasRemaining()) {
            this.addPositionToIndex(this.storage.store(this.wbuffer));
            this.wbuffer = this.storage.acquire();
        }
        this.wbuffer.put((byte)b);
    }

    private void addPositionToIndex(long position) {
        if (this.index == null) {
            this.index = new LinkedList<Long>();
        }
        this.index.add(position);
    }

    int read() throws IOException {
        int x = 0;
        if (this.rbuffer == null || !this.rbuffer.hasRemaining()) {
            if (this.rbuffer != null) {
                this.storage.free(this.rbuffer);
            }
            if (this.wbuffer != null && this.getNumBuffersStored() == 0) {
                this.rbuffer = this.wbuffer;
                this.wbuffer = null;
                this.rbuffer.flip();
            } else {
                if (this.index == null || this.index.isEmpty()) {
                    throw new EOFException();
                }
                this.rbuffer = this.storage.retrieve(this.index.remove());
            }
        }
        x = 0xFF & this.rbuffer.get();
        return x;
    }

    private int getNumBuffersStored() {
        if (this.index != null) {
            return this.index.size();
        }
        return 0;
    }

    public DataInputStream getDataInputStream() {
        return new DataInputStream(new ColumnBufferInputStream(this));
    }

    public DataOutputStream getDataOutputStream() {
        return new DataOutputStream(new ColumnBufferOutputStream(this));
    }

    static class ColumnBufferOutputStream
    extends OutputStream {
        ColumnBuffer x;

        ColumnBufferOutputStream(ColumnBuffer theX) {
            this.x = theX;
        }

        @Override
        public void write(int b) throws IOException {
            this.x.write(b);
        }
    }

    static class ColumnBufferInputStream
    extends InputStream {
        ColumnBuffer x;

        ColumnBufferInputStream(ColumnBuffer theX) {
            this.x = theX;
        }

        @Override
        public int read() throws IOException {
            return this.x.read();
        }
    }
}

