/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.relational.olapengine;

import com.cognos.xqe.data.values.DataValueFactory;
import com.cognos.xqe.data.values.IRow;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.data.values.RowValue;
import com.cognos.xqe.runtree.relational.olapengine.IColumnStorageFactory;
import com.cognos.xqe.runtree.relational.olapengine.IPartitionColumnStorage;
import com.cognos.xqe.runtree.relational.olapengine.IPlainColumnStorage;

public class IntermediateRowStorage {
    private IPlainColumnStorage detailStorage = null;
    private IPartitionColumnStorage[] partitionStorage = null;
    private RowValue detailInputTransposed = null;
    private int keySetLength;
    private int[] inputToIntermediateMap;

    public void initialize(IColumnStorageFactory factory, IRow intermediateRow, int theKeySetLength, int[] theInputToIntermediateMap) {
        this.keySetLength = theKeySetLength;
        this.inputToIntermediateMap = theInputToIntermediateMap;
        this.partitionStorage = new IPartitionColumnStorage[this.keySetLength];
        for (int i = 0; i < this.keySetLength; ++i) {
            this.partitionStorage[i] = factory.createPartitionColumnStorage();
            this.partitionStorage[i].setBuffer(intermediateRow.getColumn(i));
        }
        int detailColLength = this.inputToIntermediateMap.length - this.keySetLength;
        IValue[] temp = new IValue[detailColLength];
        for (int i = 0; i < detailColLength; ++i) {
            temp[i] = intermediateRow.getColumn(this.keySetLength + i);
        }
        this.detailStorage = factory.createPlainColumnStorage();
        this.detailStorage.setBuffer(DataValueFactory.createRowValue(temp));
        this.detailInputTransposed = DataValueFactory.createRowValue(new IValue[detailColLength]);
    }

    public void store(IRow inputRow, int breakPointColumnNo) {
        int i;
        if (breakPointColumnNo == this.keySetLength) {
            for (i = 0; i < breakPointColumnNo; ++i) {
                this.partitionStorage[i].store();
            }
        } else {
            for (i = 0; i < breakPointColumnNo; ++i) {
                this.partitionStorage[i].store();
            }
            for (i = breakPointColumnNo; i < this.keySetLength; ++i) {
                IValue value = inputRow.getColumn(this.inputToIntermediateMap[i]);
                this.partitionStorage[i].store(value);
            }
        }
        int detailColLength = this.inputToIntermediateMap.length - this.keySetLength;
        for (int i2 = 0; i2 < detailColLength; ++i2) {
            IValue value = inputRow.getColumn(this.inputToIntermediateMap[this.keySetLength + i2]);
            this.detailInputTransposed.setColumn(i2, value);
        }
        this.detailStorage.store(this.detailInputTransposed);
    }

    public void retrieve() {
        for (int i = 0; i < this.keySetLength; ++i) {
            this.partitionStorage[i].retrieve();
        }
        this.detailStorage.retrieve();
    }

    public boolean hasRow() {
        return !this.detailStorage.isEmpty();
    }
}

