/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.relational.olapengine;

import com.cognos.xqe.data.values.IEncodable;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.runtree.relational.olapengine.AbstractColumnStorage;
import com.cognos.xqe.runtree.relational.olapengine.ColumnStorageControl;
import com.cognos.xqe.runtree.relational.olapengine.IPlainColumnStorage;
import java.io.EOFException;
import java.io.IOException;
import java.util.LinkedList;

public class PlainColumnStorage
extends AbstractColumnStorage
implements IPlainColumnStorage {
    protected boolean isLoaded;
    protected LinkedList<IValue> values = new LinkedList();
    protected State state;
    protected State stateInitial = new StateInitial();
    protected State stateInMemory = new StateInMemory();
    protected State stateOnDisk = new StateOnDisk();
    private int cutoff = 0;

    public PlainColumnStorage(ColumnStorageControl control) {
        super(control);
        this.state = this.stateInitial;
    }

    @Override
    public boolean retrieve() {
        if (this.valueCount == 0) {
            return false;
        }
        if (!this.isLoaded) {
            if (this.values.size() > 0) {
                IValue value = this.values.removeFirst();
                this.allocator.releaseMemory(value.sizeOf());
                this.buffer.copyFrom(value);
            } else {
                try {
                    ((IEncodable)((Object)this.buffer)).decode(this.context, this.iStream);
                }
                catch (IOException e) {
                    throw new XQERuntimeException(e);
                }
            }
        }
        --this.valueCount;
        this.isLoaded = false;
        if (this.valueCount == this.cutoff && this.cutoff > 0) {
            this.clear();
        }
        if (this.valueCount == 0) {
            this.state = this.stateInitial;
        }
        return true;
    }

    private void clear() {
        this.values.clear();
        if (this.state == this.stateOnDisk) {
            try {
                while (true) {
                    this.iStream.read();
                }
            }
            catch (EOFException eOFException) {
            }
            catch (IOException e) {
                throw new XQERuntimeException(e);
            }
        }
        this.cutoff = 0;
        this.valueCount = 0;
    }

    @Override
    public void store(IValue theValue) {
        this.state.store(theValue);
    }

    @Override
    public void clearlast(int n) {
        if (this.valueCount == n) {
            this.clear();
            this.state = this.stateInitial;
        } else {
            this.cutoff = n;
        }
    }

    private class StateOnDisk
    implements State {
        private StateOnDisk() {
        }

        @Override
        public void store(IValue theValue) {
            try {
                ((IEncodable)((Object)theValue)).encode(PlainColumnStorage.this.context, PlainColumnStorage.this.oStream);
                ++PlainColumnStorage.this.valueCount;
            }
            catch (IOException e) {
                throw new XQERuntimeException(e);
            }
        }
    }

    private class StateInMemory
    implements State {
        private StateInMemory() {
        }

        @Override
        public void store(IValue theValue) {
            if (PlainColumnStorage.this.allocator.allocateMemory(theValue.sizeOf())) {
                PlainColumnStorage.this.values.add((IValue)theValue.copy());
                ++PlainColumnStorage.this.valueCount;
            } else {
                PlainColumnStorage.this.state = PlainColumnStorage.this.stateOnDisk;
                PlainColumnStorage.this.state.store(theValue);
            }
        }
    }

    private class StateInitial
    implements State {
        private StateInitial() {
        }

        @Override
        public void store(IValue theValue) {
            PlainColumnStorage.this.buffer.copyFrom(theValue);
            PlainColumnStorage.this.isLoaded = true;
            ++PlainColumnStorage.this.valueCount;
            PlainColumnStorage.this.state = PlainColumnStorage.this.stateInMemory;
        }
    }

    private static interface State {
        public void store(IValue var1);
    }
}

