/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.relational.olapengine;

import com.cognos.xqe.ast.IXQEPersist;
import com.cognos.xqe.ast.XQEPersistContext;
import com.cognos.xqe.ast.XQERestoreContext;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.function.ISetFunction;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.runtree.relational.XSetFunction;
import com.cognos.xqe.runtree.relational.olapengine.IWindowProcessor;
import com.cognos.xqe.runtree.relational.olapengine.WindowProcessorExtended;
import com.cognos.xqe.runtree.relational.olapengine.WindowProcessorMoving;
import com.cognos.xqe.runtree.relational.olapengine.WindowProcessorOther;
import com.cognos.xqe.runtree.relational.olapengine.WindowProcessorRunning;
import com.cognos.xqe.trace.XQETrace;
import org.dom4j.Attribute;
import org.dom4j.Element;

public class WindowDescriptor
implements IXQEPersist {
    protected static final String ATTRIBUTE_PARTITIONBYLENGTH = "PartitionByLength";
    protected static final String ATTRIBUTE_ORDERBYLENGTH = "OrderByLength";
    protected static final String ATTRIBUTE_ATLISTLENGTH = "AtListLength";
    private static final String ATTRIBUTE_WINDOW_START = "WindowStart";
    private static final String ATTRIBUTE_WINDOW_END = "WindowEnd";
    private static final String ATTRIBUTE_FUNCTION_REF = "FunctionRef";
    private int function;
    private int partitionByLength;
    private int orderByLength;
    private int atListLength;
    private int windowStart;
    private int windowEnd;

    public void dumpExtraInfo(XQETrace trace) {
        trace.attribute(ATTRIBUTE_FUNCTION_REF, Integer.toString(this.getFunction()));
        trace.attribute(ATTRIBUTE_PARTITIONBYLENGTH, Integer.toString(this.getPartitionByLength()));
        trace.attribute(ATTRIBUTE_ORDERBYLENGTH, Integer.toString(this.getOrderByLength()));
        trace.attribute(ATTRIBUTE_ATLISTLENGTH, Integer.toString(this.getAtListLength()));
        trace.attribute(ATTRIBUTE_WINDOW_START, Integer.toString(this.getWindowStart()));
        trace.attribute(ATTRIBUTE_WINDOW_END, Integer.toString(this.getWindowEnd()));
    }

    public void capture(PlanningEnvironment env, Element inputNode) {
        Attribute tempAttr = inputNode.attribute(ATTRIBUTE_FUNCTION_REF);
        this.setFunction(Integer.valueOf(tempAttr.getValue()));
        tempAttr = inputNode.attribute(ATTRIBUTE_PARTITIONBYLENGTH);
        if (tempAttr != null) {
            this.setPartitionByLength(Integer.valueOf(tempAttr.getValue()));
        } else {
            this.setPartitionByLength(0);
        }
        tempAttr = inputNode.attribute(ATTRIBUTE_ORDERBYLENGTH);
        if (tempAttr != null) {
            this.setOrderByLength(Integer.valueOf(tempAttr.getValue()));
        } else {
            this.setOrderByLength(0);
        }
        tempAttr = inputNode.attribute(ATTRIBUTE_ATLISTLENGTH);
        if (tempAttr != null) {
            this.setAtListLength(Integer.valueOf(tempAttr.getValue()));
        } else {
            this.setAtListLength(0);
        }
        tempAttr = inputNode.attribute(ATTRIBUTE_WINDOW_START);
        if (tempAttr != null) {
            this.setWindowStart(Integer.valueOf(tempAttr.getValue()));
        } else {
            this.setWindowStart(Integer.MIN_VALUE);
        }
        tempAttr = inputNode.attribute(ATTRIBUTE_WINDOW_END);
        if (tempAttr != null) {
            this.setWindowEnd(Integer.valueOf(tempAttr.getValue()));
        } else {
            this.setWindowEnd(Integer.MAX_VALUE);
        }
    }

    public void setFunction(int theFunction) {
        this.function = theFunction;
    }

    public int getFunction() {
        return this.function;
    }

    public void setPartitionByLength(int thePartitionByLength) {
        this.partitionByLength = thePartitionByLength;
    }

    public int getPartitionByLength() {
        return this.partitionByLength;
    }

    public void setWindowStart(int theWindowStart) {
        this.windowStart = theWindowStart;
    }

    public int getWindowStart() {
        return this.windowStart;
    }

    public void setWindowEnd(int theWindowEnd) {
        this.windowEnd = theWindowEnd;
    }

    public int getWindowEnd() {
        return this.windowEnd;
    }

    public void setOrderByLength(int theOrderByLength) {
        this.orderByLength = theOrderByLength;
    }

    public int getOrderByLength() {
        return this.orderByLength;
    }

    public void setAtListLength(int theAtListLength) {
        this.atListLength = theAtListLength;
    }

    public int getAtListLength() {
        return this.atListLength;
    }

    public IWindowProcessor createWindowProcessor(XDataContext context, XSetFunction[] functionList) {
        ISetFunction f = (ISetFunction)functionList[this.getFunction()].getFunction();
        if (!f.isAggregate()) {
            WindowProcessorOther wp = new WindowProcessorOther(this, context, functionList[this.getFunction()]);
            if (f.isTwoPass()) {
                wp.setTwoPass(true);
            }
            return wp;
        }
        if (this.getWindowStart() == Integer.MIN_VALUE && this.getWindowEnd() != Integer.MAX_VALUE) {
            return new WindowProcessorRunning(this, context, functionList[this.getFunction()]);
        }
        if (this.getWindowStart() != Integer.MIN_VALUE && this.getWindowStart() != Integer.MAX_VALUE) {
            return new WindowProcessorMoving(this, context, functionList[this.getFunction()]);
        }
        if (this.getWindowStart() == Integer.MIN_VALUE && this.getWindowEnd() == Integer.MAX_VALUE) {
            return new WindowProcessorExtended(this, context, functionList[this.getFunction()]);
        }
        if (this.getWindowStart() == Integer.MAX_VALUE && this.getWindowEnd() == Integer.MAX_VALUE) {
            if (this.getOrderByLength() > 0) {
                return new WindowProcessorRunning(this, context, functionList[this.getFunction()]);
            }
            return new WindowProcessorExtended(this, context, functionList[this.getFunction()]);
        }
        throw new XQERuntimeException(XQEMessageKeys.PLN_UnsupportedWindowFrame);
    }

    protected void persistAttributeProperties(XQEPersistContext ctx) {
        ctx.property(ATTRIBUTE_FUNCTION_REF, this.getFunction());
        ctx.property(ATTRIBUTE_PARTITIONBYLENGTH, this.getPartitionByLength());
        ctx.property(ATTRIBUTE_ORDERBYLENGTH, this.getOrderByLength());
        ctx.property(ATTRIBUTE_ATLISTLENGTH, this.getAtListLength());
        ctx.property(ATTRIBUTE_WINDOW_START, this.getWindowStart());
        ctx.property(ATTRIBUTE_WINDOW_END, this.getWindowEnd());
    }

    @Override
    public void persist(XQEPersistContext ctx, String optionalName) {
        if (ctx.beginElement(this, optionalName, -1)) {
            this.persistAttributeProperties(ctx);
            ctx.endElement();
        }
    }

    @Override
    public void restore(XQERestoreContext ctx, Element node) {
        this.restoreAttributes(ctx, node);
    }

    public void restoreAttributes(XQERestoreContext ctx, Element node) {
        int size = node.attributeCount();
        for (int i = 0; i < size; ++i) {
            Attribute att = node.attribute(i);
            this.restoreAttributeProperty(ctx, att, node);
        }
    }

    protected void restoreAttributeProperty(XQERestoreContext ctx, Attribute att, Element node) {
        String attName = att.getName();
        if (attName.equals(ATTRIBUTE_FUNCTION_REF)) {
            Object val = ctx.attributeValue(att);
            this.function = (Integer)val;
        } else if (attName.equals(ATTRIBUTE_PARTITIONBYLENGTH)) {
            Object val = ctx.attributeValue(att);
            this.partitionByLength = (Integer)val;
        } else if (attName.equals(ATTRIBUTE_ORDERBYLENGTH)) {
            Object val = ctx.attributeValue(att);
            this.orderByLength = (Integer)val;
        } else if (attName.equals(ATTRIBUTE_ATLISTLENGTH)) {
            Object val = ctx.attributeValue(att);
            this.atListLength = (Integer)val;
        } else if (attName.equals(ATTRIBUTE_WINDOW_START)) {
            Object val = ctx.attributeValue(att);
            this.windowStart = (Integer)val;
        } else if (attName.equals(ATTRIBUTE_WINDOW_END)) {
            Object val = ctx.attributeValue(att);
            this.windowEnd = (Integer)val;
        }
    }
}

