/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.relational.olapengine;

import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.function.ISetFunctionState;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.runtree.relational.XSetFunction;
import com.cognos.xqe.runtree.relational.olapengine.IColumnStorage;
import com.cognos.xqe.runtree.relational.olapengine.IColumnStorageFactory;
import com.cognos.xqe.runtree.relational.olapengine.IPlainColumnStorage;
import com.cognos.xqe.runtree.relational.olapengine.IWindowProcessor;
import com.cognos.xqe.runtree.relational.olapengine.WindowDescriptor;

public class WindowProcessorRunning
implements IWindowProcessor {
    private XSetFunction xFunction;
    private ISetFunctionState state;
    private int partitionByLength;
    private int atListLength;
    private int orderByLength;
    private boolean iterate;
    XDataContext context;
    IPlainColumnStorage columnStorage;
    boolean rowsframe = false;
    int peerCounter = 0;
    int frameEndOffset = 0;
    int currentOffset = 0;

    public WindowProcessorRunning(WindowDescriptor wd, XDataContext theContext, XSetFunction function) {
        this.xFunction = function;
        this.partitionByLength = wd.getPartitionByLength();
        this.orderByLength = wd.getOrderByLength();
        this.atListLength = wd.getAtListLength();
        this.context = theContext;
        this.state = this.xFunction.initialize(this.context);
        this.iterate = true;
        if (wd.getWindowEnd() != Integer.MAX_VALUE) {
            this.rowsframe = true;
            this.currentOffset = this.frameEndOffset = wd.getWindowEnd();
        }
    }

    @Override
    public void iterate() {
        if (this.iterate) {
            this.xFunction.iterate(this.context, this.state);
            if (this.atListLength > 0) {
                this.iterate = false;
            }
        }
        if (this.rowsframe) {
            if (this.currentOffset > 0) {
                --this.currentOffset;
            } else {
                Value theValue;
                if (this.currentOffset < 0) {
                    while (this.currentOffset < 0) {
                        theValue = (Value)this.xFunction.getDataType().createValue(this.context.getLocalCollator());
                        theValue.setNull();
                        this.columnStorage.store(theValue);
                        ++this.currentOffset;
                    }
                }
                theValue = (Value)this.xFunction.getDataType().createValue(this.context.getLocalCollator());
                this.xFunction.getResult(this.context, this.state, theValue);
                this.columnStorage.store(theValue);
            }
        } else {
            ++this.peerCounter;
        }
    }

    @Override
    public void processBreak(int breakpointColumn) {
        Value theValue;
        if (this.atListLength > 0 && breakpointColumn < this.atListLength) {
            this.iterate = true;
        }
        if (!this.rowsframe && breakpointColumn < this.partitionByLength + this.orderByLength) {
            theValue = (Value)this.xFunction.getDataType().createValue(this.context.getLocalCollator());
            this.xFunction.getResult(this.context, this.state, theValue);
            this.columnStorage.store(theValue);
            --this.peerCounter;
            while (this.peerCounter > 0) {
                theValue = (Value)theValue.copy();
                this.columnStorage.store(theValue);
                --this.peerCounter;
            }
        }
        if (breakpointColumn < this.partitionByLength) {
            if (this.frameEndOffset > 0) {
                while (this.currentOffset < this.frameEndOffset) {
                    theValue = (Value)this.xFunction.getDataType().createValue(this.context.getLocalCollator());
                    this.xFunction.getResult(this.context, this.state, theValue);
                    this.columnStorage.store(theValue);
                    ++this.currentOffset;
                }
            } else if (this.frameEndOffset < 0) {
                this.columnStorage.clearlast(-this.frameEndOffset);
                this.currentOffset = this.frameEndOffset;
            }
            this.xFunction.terminate(this.context, this.state);
            this.state = this.xFunction.initialize(this.context);
        }
    }

    @Override
    public IColumnStorage createColumnStorage(IColumnStorageFactory csf) {
        if (this.columnStorage == null) {
            this.columnStorage = csf.createPlainColumnStorage();
        }
        return this.columnStorage;
    }
}

